import StiJson from "../system/StiJson";
export default class StiRectangleGeometry {
    constructor(width = 0, height = 0, changesInterceptor) {
        this._x = 0;
        this._y = 0;
        this._minWidth = 0;
        this._minHeight = 0;
        this._maxWidth = 10000000;
        this._maxHeight = 10000000;
        this.width = width;
        this.height = height;
        this._minWidth = 5;
        this._minHeight = height;
        this.changesInterceptor = changesInterceptor;
    }
    isChanged() {
        return this.savedGeometry == null || !this.savedGeometry.equals(this);
    }
    resetChanged() {
        this.savedGeometry = this.clone();
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyNumber("X", this.x);
        json.addPropertyNumber("Y", this.y);
        json.addPropertyNumber("Width", this.width);
        json.addPropertyNumber("Height", this.height);
        json.addPropertyNumber("MinWidth", this.minWidth);
        json.addPropertyNumber("MinHeight", this.minHeight);
        json.addPropertyNumber("MaxWidth", this.width);
        json.addPropertyNumber("MaxHeight", this.height);
        return json;
    }
    equals(geometry) {
        return (this.x == geometry.x &&
            this.y == geometry.y &&
            this.width == geometry.width &&
            this.height == geometry.height &&
            this.minHeight == geometry.minHeight &&
            this.minWidth == geometry.minWidth);
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "X":
                    this._x = property.value;
                    break;
                case "Y":
                    this._y = property.value;
                    break;
                case "Width":
                    this._width = property.value;
                    break;
                case "Height":
                    this._height = property.value;
                    break;
                case "MinWidth":
                    this._minWidth = property.value;
                    break;
                case "MinHeight":
                    this._minHeight = property.value;
                    break;
                case "MaxWidth":
                    this._maxWidth = property.value;
                    break;
                case "MaxHeight":
                    //this._minHeight = property.value;
                    break;
            }
        }
    }
    clone() {
        let result = new StiRectangleGeometry(this.width, this.height);
        result._x = this.x;
        result._y = this.y;
        result._minWidth = this.minWidth;
        result._minHeight = this.minHeight;
        return result;
    }
    get x() {
        return this._x;
    }
    set x(value) {
        this._x = value;
    }
    get y() {
        return this._y;
    }
    set y(value) {
        this._y = value;
    }
    get width() {
        return this._width;
    }
    set width(value) {
        let oldGeometry = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._width;
        this._width = Math.max(value, this._minWidth);
        if (this.changesInterceptor && oldValue != this._width) {
            this.changesInterceptor.propertyChanged("geometry.width", value, oldGeometry);
        }
    }
    get height() {
        return this._height;
    }
    set height(value) {
        let oldGeometry = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._height;
        this._height = Math.max(value, this.minHeight);
        if (this.changesInterceptor && oldValue != this._height) {
            this.changesInterceptor.propertyChanged("geometry.height", value, oldGeometry);
        }
    }
    get minWidth() {
        return this._minWidth;
    }
    set minWidth(value) {
        let oldGeometry = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._minWidth;
        this._minWidth = Math.min(value, this._maxWidth);
        this._width = Math.max(this._minWidth, this._width);
        if (this.changesInterceptor && oldValue != this._minWidth) {
            this.changesInterceptor.propertyChanged("geometry.minWidth", value, oldGeometry);
        }
    }
    get minHeight() {
        return this._minHeight;
    }
    set minHeight(value) {
        let oldValue = this._minHeight;
        let oldGeometry = this.changesInterceptor ? this.clone() : null;
        this._minHeight = Math.min(value, this._maxHeight);
        this._height = Math.max(this._minHeight, this._height);
        if (this.changesInterceptor && oldValue != this._minHeight) {
            this.changesInterceptor.propertyChanged("geometry.minHeight", value, oldGeometry);
        }
    }
    /*public get maxWidth(): number {
      return this._maxWidth;
    }
  
    public set maxWidth(value: number) {
      let oldValue = this._maxWidth;
      this._maxWidth = Math.max(value, this._minWidth);
      this._width = Math.min(this._maxWidth, this.width);
      if (this.changesInterceptor && oldValue != this._maxWidth) {
        this.changesInterceptor.propertyChanged("geometry.maxWidth", value);
      }
    }
  
    public get maxHeight(): number {
      return this._maxHeight;
    }
  
    public set maxHeight(value: number) {
      let oldValue = this._maxHeight;
      this._maxHeight = Math.max(value, this._minHeight);
      this._height = Math.min(this._maxHeight, this.height);
      if (this.changesInterceptor && oldValue != this._maxHeight) {
        this.changesInterceptor.propertyChanged("geometry.maxHeight", value);
      }
    }*/
    get right() {
        return this._x + this._width;
    }
    get bottom() {
        return this._y + this._height;
    }
    get centerX() {
        return this._x + this._width / 2;
    }
    get centerY() {
        return this._y + this._height / 2;
    }
    withY(newY) {
        let copy = this.clone();
        copy.y = newY;
        return copy;
    }
    xProjectionIntersectsWith(other) {
        return (this.x < other.right &&
            this.right > other.x &&
            Math.abs(this.right - other.x) > StiRectangleGeometry.DELTA &&
            Math.abs(this.x - other.right) > StiRectangleGeometry.DELTA);
    }
    intersectWith(geometry) {
        let aLeftOfB = geometry.right - StiRectangleGeometry.DELTA < this.x;
        let aRightOfB = geometry.x > this.right - StiRectangleGeometry.DELTA;
        let aAboveB = geometry.y > this.bottom - StiRectangleGeometry.DELTA;
        let aBelowB = geometry.bottom - StiRectangleGeometry.DELTA < this.y;
        return !(aLeftOfB || aRightOfB || aAboveB || aBelowB);
    }
}
StiRectangleGeometry.DELTA = 1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RpUmVjdGFuZ2xlR2VvbWV0cnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LWZvcm1zL3NyYy9saWIvcHJvcGVydGllcy9TdGlSZWN0YW5nbGVHZW9tZXRyeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFDQSxPQUFPLE9BQU8sTUFBTSxtQkFBbUIsQ0FBQztBQUV4QyxNQUFNLENBQUMsT0FBTyxPQUFPLG9CQUFvQjtJQXVNdkMsWUFBWSxRQUFnQixDQUFDLEVBQUUsU0FBaUIsQ0FBQyxFQUFFLGtCQUEwQztRQXBNckYsT0FBRSxHQUFXLENBQUMsQ0FBQztRQUNmLE9BQUUsR0FBVyxDQUFDLENBQUM7UUFHaEIsY0FBUyxHQUFXLENBQUMsQ0FBQztRQUN0QixlQUFVLEdBQVcsQ0FBQyxDQUFDO1FBQ3ZCLGNBQVMsR0FBVyxRQUFRLENBQUM7UUFDN0IsZUFBVSxHQUFXLFFBQVEsQ0FBQztRQThMbkMsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUM7UUFDckIsSUFBSSxDQUFDLFNBQVMsR0FBRyxDQUFDLENBQUM7UUFDbkIsSUFBSSxDQUFDLFVBQVUsR0FBRyxNQUFNLENBQUM7UUFDekIsSUFBSSxDQUFDLGtCQUFrQixHQUFHLGtCQUFrQixDQUFDO0lBQy9DLENBQUM7SUE5TE0sU0FBUztRQUNkLE9BQU8sSUFBSSxDQUFDLGFBQWEsSUFBSSxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN4RSxDQUFDO0lBRU0sWUFBWTtRQUNqQixJQUFJLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQztJQUNwQyxDQUFDO0lBRU0sZ0JBQWdCLENBQUMsT0FBWTtRQUNsQyxJQUFJLElBQUksR0FBRyxJQUFJLE9BQU8sRUFBRSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxHQUFHLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxHQUFHLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzVDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQzlDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ2xELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQ3BELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQy9DLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ2pELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVNLE1BQU0sQ0FBQyxRQUE4QjtRQUMxQyxPQUFPLENBQ0wsSUFBSSxDQUFDLENBQUMsSUFBSSxRQUFRLENBQUMsQ0FBQztZQUNwQixJQUFJLENBQUMsQ0FBQyxJQUFJLFFBQVEsQ0FBQyxDQUFDO1lBQ3BCLElBQUksQ0FBQyxLQUFLLElBQUksUUFBUSxDQUFDLEtBQUs7WUFDNUIsSUFBSSxDQUFDLE1BQU0sSUFBSSxRQUFRLENBQUMsTUFBTTtZQUM5QixJQUFJLENBQUMsU0FBUyxJQUFJLFFBQVEsQ0FBQyxTQUFTO1lBQ3BDLElBQUksQ0FBQyxRQUFRLElBQUksUUFBUSxDQUFDLFFBQVEsQ0FDbkMsQ0FBQztJQUNKLENBQUM7SUFFTSxrQkFBa0IsQ0FBQyxJQUFhO1FBQ3JDLEtBQUssSUFBSSxRQUFRLElBQUksSUFBSSxDQUFDLFVBQVUsRUFBRSxFQUFFO1lBQ3RDLFFBQVEsUUFBUSxDQUFDLElBQUksRUFBRTtnQkFDckIsS0FBSyxHQUFHO29CQUNOLElBQUksQ0FBQyxFQUFFLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDekIsTUFBTTtnQkFDUixLQUFLLEdBQUc7b0JBQ04sSUFBSSxDQUFDLEVBQUUsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUN6QixNQUFNO2dCQUNSLEtBQUssT0FBTztvQkFDVixJQUFJLENBQUMsTUFBTSxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQzdCLE1BQU07Z0JBQ1IsS0FBSyxRQUFRO29CQUNYLElBQUksQ0FBQyxPQUFPLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDOUIsTUFBTTtnQkFDUixLQUFLLFVBQVU7b0JBQ2IsSUFBSSxDQUFDLFNBQVMsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUNoQyxNQUFNO2dCQUNSLEtBQUssV0FBVztvQkFDZCxJQUFJLENBQUMsVUFBVSxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQ2pDLE1BQU07Z0JBQ1IsS0FBSyxVQUFVO29CQUNiLElBQUksQ0FBQyxTQUFTLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDaEMsTUFBTTtnQkFDUixLQUFLLFdBQVc7b0JBQ2QsbUNBQW1DO29CQUNuQyxNQUFNO2FBQ1Q7U0FDRjtJQUNILENBQUM7SUFFTSxLQUFLO1FBQ1YsSUFBSSxNQUFNLEdBQUcsSUFBSSxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUMvRCxNQUFNLENBQUMsRUFBRSxHQUFHLElBQUksQ0FBQyxDQUFDLENBQUM7UUFDbkIsTUFBTSxDQUFDLEVBQUUsR0FBRyxJQUFJLENBQUMsQ0FBQyxDQUFDO1FBQ25CLE1BQU0sQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQztRQUNqQyxNQUFNLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUM7UUFDbkMsT0FBTyxNQUFNLENBQUM7SUFDaEIsQ0FBQztJQUVELElBQVcsQ0FBQztRQUNWLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQztJQUNqQixDQUFDO0lBRUQsSUFBVyxDQUFDLENBQUMsS0FBYTtRQUN4QixJQUFJLENBQUMsRUFBRSxHQUFHLEtBQUssQ0FBQztJQUNsQixDQUFDO0lBRUQsSUFBVyxDQUFDO1FBQ1YsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDO0lBQ2pCLENBQUM7SUFFRCxJQUFXLENBQUMsQ0FBQyxLQUFhO1FBQ3hCLElBQUksQ0FBQyxFQUFFLEdBQUcsS0FBSyxDQUFDO0lBQ2xCLENBQUM7SUFFRCxJQUFXLEtBQUs7UUFDZCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDckIsQ0FBQztJQUVELElBQVcsS0FBSyxDQUFDLEtBQWE7UUFDNUIsSUFBSSxXQUFXLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQztRQUNoRSxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDO1FBQzNCLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQzlDLElBQUksSUFBSSxDQUFDLGtCQUFrQixJQUFJLFFBQVEsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFO1lBQ3RELElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsZ0JBQWdCLEVBQUUsS0FBSyxFQUFFLFdBQVcsQ0FBQyxDQUFDO1NBQy9FO0lBQ0gsQ0FBQztJQUVELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBRUQsSUFBVyxNQUFNLENBQUMsS0FBYTtRQUM3QixJQUFJLFdBQVcsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQ2hFLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7UUFDNUIsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7UUFDL0MsSUFBSSxJQUFJLENBQUMsa0JBQWtCLElBQUksUUFBUSxJQUFJLElBQUksQ0FBQyxPQUFPLEVBQUU7WUFDdkQsSUFBSSxDQUFDLGtCQUFrQixDQUFDLGVBQWUsQ0FBQyxpQkFBaUIsRUFBRSxLQUFLLEVBQUUsV0FBVyxDQUFDLENBQUM7U0FDaEY7SUFDSCxDQUFDO0lBRUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBRUQsSUFBVyxRQUFRLENBQUMsS0FBYTtRQUMvQixJQUFJLFdBQVcsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQ2hFLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUM7UUFDOUIsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7UUFDakQsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3BELElBQUksSUFBSSxDQUFDLGtCQUFrQixJQUFJLFFBQVEsSUFBSSxJQUFJLENBQUMsU0FBUyxFQUFFO1lBQ3pELElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsbUJBQW1CLEVBQUUsS0FBSyxFQUFFLFdBQVcsQ0FBQyxDQUFDO1NBQ2xGO0lBQ0gsQ0FBQztJQUVELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUVELElBQVcsU0FBUyxDQUFDLEtBQWE7UUFDaEMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQztRQUMvQixJQUFJLFdBQVcsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1FBQ2hFLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ25ELElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN2RCxJQUFJLElBQUksQ0FBQyxrQkFBa0IsSUFBSSxRQUFRLElBQUksSUFBSSxDQUFDLFVBQVUsRUFBRTtZQUMxRCxJQUFJLENBQUMsa0JBQWtCLENBQUMsZUFBZSxDQUFDLG9CQUFvQixFQUFFLEtBQUssRUFBRSxXQUFXLENBQUMsQ0FBQztTQUNuRjtJQUNILENBQUM7SUFFRDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O09Bd0JHO0lBRUgsSUFBVyxLQUFLO1FBQ2QsT0FBTyxJQUFJLENBQUMsRUFBRSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDL0IsQ0FBQztJQUVELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLEVBQUUsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ2hDLENBQUM7SUFFRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsRUFBRSxHQUFHLElBQUksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFFRCxJQUFXLE9BQU87UUFDaEIsT0FBTyxJQUFJLENBQUMsRUFBRSxHQUFHLElBQUksQ0FBQyxPQUFPLEdBQUcsQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFVTSxLQUFLLENBQUMsSUFBWTtRQUN2QixJQUFJLElBQUksR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDeEIsSUFBSSxDQUFDLENBQUMsR0FBRyxJQUFJLENBQUM7UUFDZCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFTSx5QkFBeUIsQ0FBQyxLQUEyQjtRQUMxRCxPQUFPLENBQ0wsSUFBSSxDQUFDLENBQUMsR0FBRyxLQUFLLENBQUMsS0FBSztZQUNwQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxDQUFDO1lBQ3BCLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsQ0FBQyxDQUFDLEdBQUcsb0JBQW9CLENBQUMsS0FBSztZQUMzRCxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFDLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQyxHQUFHLG9CQUFvQixDQUFDLEtBQUssQ0FDNUQsQ0FBQztJQUNKLENBQUM7SUFFTSxhQUFhLENBQUMsUUFBOEI7UUFDakQsSUFBSSxRQUFRLEdBQUcsUUFBUSxDQUFDLEtBQUssR0FBRyxvQkFBb0IsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLENBQUMsQ0FBQztRQUNwRSxJQUFJLFNBQVMsR0FBRyxRQUFRLENBQUMsQ0FBQyxHQUFHLElBQUksQ0FBQyxLQUFLLEdBQUcsb0JBQW9CLENBQUMsS0FBSyxDQUFDO1FBQ3JFLElBQUksT0FBTyxHQUFHLFFBQVEsQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDLE1BQU0sR0FBRyxvQkFBb0IsQ0FBQyxLQUFLLENBQUM7UUFDcEUsSUFBSSxPQUFPLEdBQUcsUUFBUSxDQUFDLE1BQU0sR0FBRyxvQkFBb0IsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLENBQUMsQ0FBQztRQUVwRSxPQUFPLENBQUMsQ0FBQyxRQUFRLElBQUksU0FBUyxJQUFJLE9BQU8sSUFBSSxPQUFPLENBQUMsQ0FBQztJQUN4RCxDQUFDOztBQXBPYSwwQkFBSyxHQUFHLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFN0aUNoYW5nZXNJbnRlcmNlcHRvciB9IGZyb20gXCIuLi9zeXN0ZW0vaW50ZXJmYWNlc1wiO1xyXG5pbXBvcnQgU3RpSnNvbiBmcm9tIFwiLi4vc3lzdGVtL1N0aUpzb25cIjtcclxuXHJcbmV4cG9ydCBkZWZhdWx0IGNsYXNzIFN0aVJlY3RhbmdsZUdlb21ldHJ5IHtcclxuICBwdWJsaWMgc3RhdGljIERFTFRBID0gMTtcclxuXHJcbiAgcHJpdmF0ZSBfeDogbnVtYmVyID0gMDtcclxuICBwcml2YXRlIF95OiBudW1iZXIgPSAwO1xyXG4gIHByaXZhdGUgX3dpZHRoOiBudW1iZXI7XHJcbiAgcHJpdmF0ZSBfaGVpZ2h0OiBudW1iZXI7XHJcbiAgcHVibGljIF9taW5XaWR0aDogbnVtYmVyID0gMDtcclxuICBwdWJsaWMgX21pbkhlaWdodDogbnVtYmVyID0gMDtcclxuICBwdWJsaWMgX21heFdpZHRoOiBudW1iZXIgPSAxMDAwMDAwMDtcclxuICBwdWJsaWMgX21heEhlaWdodDogbnVtYmVyID0gMTAwMDAwMDA7XHJcbiAgcHVibGljIGNoYW5nZXNJbnRlcmNlcHRvcjogU3RpQ2hhbmdlc0ludGVyY2VwdG9yO1xyXG5cclxuICBwcml2YXRlIHNhdmVkR2VvbWV0cnk6IFN0aVJlY3RhbmdsZUdlb21ldHJ5O1xyXG5cclxuICBwdWJsaWMgaXNDaGFuZ2VkKCk6IGJvb2xlYW4ge1xyXG4gICAgcmV0dXJuIHRoaXMuc2F2ZWRHZW9tZXRyeSA9PSBudWxsIHx8ICF0aGlzLnNhdmVkR2VvbWV0cnkuZXF1YWxzKHRoaXMpO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHJlc2V0Q2hhbmdlZCgpIHtcclxuICAgIHRoaXMuc2F2ZWRHZW9tZXRyeSA9IHRoaXMuY2xvbmUoKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzYXZlVG9Kc29uT2JqZWN0KG9wdGlvbnM6IGFueSk6IFN0aUpzb24ge1xyXG4gICAgbGV0IGpzb24gPSBuZXcgU3RpSnNvbigpO1xyXG4gICAganNvbi5hZGRQcm9wZXJ0eU51bWJlcihcIlhcIiwgdGhpcy54KTtcclxuICAgIGpzb24uYWRkUHJvcGVydHlOdW1iZXIoXCJZXCIsIHRoaXMueSk7XHJcbiAgICBqc29uLmFkZFByb3BlcnR5TnVtYmVyKFwiV2lkdGhcIiwgdGhpcy53aWR0aCk7XHJcbiAgICBqc29uLmFkZFByb3BlcnR5TnVtYmVyKFwiSGVpZ2h0XCIsIHRoaXMuaGVpZ2h0KTtcclxuICAgIGpzb24uYWRkUHJvcGVydHlOdW1iZXIoXCJNaW5XaWR0aFwiLCB0aGlzLm1pbldpZHRoKTtcclxuICAgIGpzb24uYWRkUHJvcGVydHlOdW1iZXIoXCJNaW5IZWlnaHRcIiwgdGhpcy5taW5IZWlnaHQpO1xyXG4gICAganNvbi5hZGRQcm9wZXJ0eU51bWJlcihcIk1heFdpZHRoXCIsIHRoaXMud2lkdGgpO1xyXG4gICAganNvbi5hZGRQcm9wZXJ0eU51bWJlcihcIk1heEhlaWdodFwiLCB0aGlzLmhlaWdodCk7XHJcbiAgICByZXR1cm4ganNvbjtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBlcXVhbHMoZ2VvbWV0cnk6IFN0aVJlY3RhbmdsZUdlb21ldHJ5KTogYm9vbGVhbiB7XHJcbiAgICByZXR1cm4gKFxyXG4gICAgICB0aGlzLnggPT0gZ2VvbWV0cnkueCAmJlxyXG4gICAgICB0aGlzLnkgPT0gZ2VvbWV0cnkueSAmJlxyXG4gICAgICB0aGlzLndpZHRoID09IGdlb21ldHJ5LndpZHRoICYmXHJcbiAgICAgIHRoaXMuaGVpZ2h0ID09IGdlb21ldHJ5LmhlaWdodCAmJlxyXG4gICAgICB0aGlzLm1pbkhlaWdodCA9PSBnZW9tZXRyeS5taW5IZWlnaHQgJiZcclxuICAgICAgdGhpcy5taW5XaWR0aCA9PSBnZW9tZXRyeS5taW5XaWR0aFxyXG4gICAgKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBsb2FkRnJvbUpzb25PYmplY3QoanNvbjogU3RpSnNvbikge1xyXG4gICAgZm9yIChsZXQgcHJvcGVydHkgb2YganNvbi5wcm9wZXJ0aWVzKCkpIHtcclxuICAgICAgc3dpdGNoIChwcm9wZXJ0eS5uYW1lKSB7XHJcbiAgICAgICAgY2FzZSBcIlhcIjpcclxuICAgICAgICAgIHRoaXMuX3ggPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJZXCI6XHJcbiAgICAgICAgICB0aGlzLl95ID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiV2lkdGhcIjpcclxuICAgICAgICAgIHRoaXMuX3dpZHRoID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiSGVpZ2h0XCI6XHJcbiAgICAgICAgICB0aGlzLl9oZWlnaHQgPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJNaW5XaWR0aFwiOlxyXG4gICAgICAgICAgdGhpcy5fbWluV2lkdGggPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJNaW5IZWlnaHRcIjpcclxuICAgICAgICAgIHRoaXMuX21pbkhlaWdodCA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIk1heFdpZHRoXCI6XHJcbiAgICAgICAgICB0aGlzLl9tYXhXaWR0aCA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIk1heEhlaWdodFwiOlxyXG4gICAgICAgICAgLy90aGlzLl9taW5IZWlnaHQgPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgY2xvbmUoKTogU3RpUmVjdGFuZ2xlR2VvbWV0cnkge1xyXG4gICAgbGV0IHJlc3VsdCA9IG5ldyBTdGlSZWN0YW5nbGVHZW9tZXRyeSh0aGlzLndpZHRoLCB0aGlzLmhlaWdodCk7XHJcbiAgICByZXN1bHQuX3ggPSB0aGlzLng7XHJcbiAgICByZXN1bHQuX3kgPSB0aGlzLnk7XHJcbiAgICByZXN1bHQuX21pbldpZHRoID0gdGhpcy5taW5XaWR0aDtcclxuICAgIHJlc3VsdC5fbWluSGVpZ2h0ID0gdGhpcy5taW5IZWlnaHQ7XHJcbiAgICByZXR1cm4gcmVzdWx0O1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCB4KCkge1xyXG4gICAgcmV0dXJuIHRoaXMuX3g7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IHgodmFsdWU6IG51bWJlcikge1xyXG4gICAgdGhpcy5feCA9IHZhbHVlO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCB5KCkge1xyXG4gICAgcmV0dXJuIHRoaXMuX3k7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IHkodmFsdWU6IG51bWJlcikge1xyXG4gICAgdGhpcy5feSA9IHZhbHVlO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCB3aWR0aCgpIHtcclxuICAgIHJldHVybiB0aGlzLl93aWR0aDtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgd2lkdGgodmFsdWU6IG51bWJlcikge1xyXG4gICAgbGV0IG9sZEdlb21ldHJ5ID0gdGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IgPyB0aGlzLmNsb25lKCkgOiBudWxsO1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fd2lkdGg7XHJcbiAgICB0aGlzLl93aWR0aCA9IE1hdGgubWF4KHZhbHVlLCB0aGlzLl9taW5XaWR0aCk7XHJcbiAgICBpZiAodGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IgJiYgb2xkVmFsdWUgIT0gdGhpcy5fd2lkdGgpIHtcclxuICAgICAgdGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IucHJvcGVydHlDaGFuZ2VkKFwiZ2VvbWV0cnkud2lkdGhcIiwgdmFsdWUsIG9sZEdlb21ldHJ5KTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgaGVpZ2h0KCkge1xyXG4gICAgcmV0dXJuIHRoaXMuX2hlaWdodDtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgaGVpZ2h0KHZhbHVlOiBudW1iZXIpIHtcclxuICAgIGxldCBvbGRHZW9tZXRyeSA9IHRoaXMuY2hhbmdlc0ludGVyY2VwdG9yID8gdGhpcy5jbG9uZSgpIDogbnVsbDtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2hlaWdodDtcclxuICAgIHRoaXMuX2hlaWdodCA9IE1hdGgubWF4KHZhbHVlLCB0aGlzLm1pbkhlaWdodCk7XHJcbiAgICBpZiAodGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IgJiYgb2xkVmFsdWUgIT0gdGhpcy5faGVpZ2h0KSB7XHJcbiAgICAgIHRoaXMuY2hhbmdlc0ludGVyY2VwdG9yLnByb3BlcnR5Q2hhbmdlZChcImdlb21ldHJ5LmhlaWdodFwiLCB2YWx1ZSwgb2xkR2VvbWV0cnkpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBtaW5XaWR0aCgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMuX21pbldpZHRoO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBtaW5XaWR0aCh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBsZXQgb2xkR2VvbWV0cnkgPSB0aGlzLmNoYW5nZXNJbnRlcmNlcHRvciA/IHRoaXMuY2xvbmUoKSA6IG51bGw7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9taW5XaWR0aDtcclxuICAgIHRoaXMuX21pbldpZHRoID0gTWF0aC5taW4odmFsdWUsIHRoaXMuX21heFdpZHRoKTtcclxuICAgIHRoaXMuX3dpZHRoID0gTWF0aC5tYXgodGhpcy5fbWluV2lkdGgsIHRoaXMuX3dpZHRoKTtcclxuICAgIGlmICh0aGlzLmNoYW5nZXNJbnRlcmNlcHRvciAmJiBvbGRWYWx1ZSAhPSB0aGlzLl9taW5XaWR0aCkge1xyXG4gICAgICB0aGlzLmNoYW5nZXNJbnRlcmNlcHRvci5wcm9wZXJ0eUNoYW5nZWQoXCJnZW9tZXRyeS5taW5XaWR0aFwiLCB2YWx1ZSwgb2xkR2VvbWV0cnkpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBtaW5IZWlnaHQoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9taW5IZWlnaHQ7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IG1pbkhlaWdodCh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9taW5IZWlnaHQ7XHJcbiAgICBsZXQgb2xkR2VvbWV0cnkgPSB0aGlzLmNoYW5nZXNJbnRlcmNlcHRvciA/IHRoaXMuY2xvbmUoKSA6IG51bGw7XHJcbiAgICB0aGlzLl9taW5IZWlnaHQgPSBNYXRoLm1pbih2YWx1ZSwgdGhpcy5fbWF4SGVpZ2h0KTtcclxuICAgIHRoaXMuX2hlaWdodCA9IE1hdGgubWF4KHRoaXMuX21pbkhlaWdodCwgdGhpcy5faGVpZ2h0KTtcclxuICAgIGlmICh0aGlzLmNoYW5nZXNJbnRlcmNlcHRvciAmJiBvbGRWYWx1ZSAhPSB0aGlzLl9taW5IZWlnaHQpIHtcclxuICAgICAgdGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IucHJvcGVydHlDaGFuZ2VkKFwiZ2VvbWV0cnkubWluSGVpZ2h0XCIsIHZhbHVlLCBvbGRHZW9tZXRyeSk7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICAvKnB1YmxpYyBnZXQgbWF4V2lkdGgoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9tYXhXaWR0aDtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgbWF4V2lkdGgodmFsdWU6IG51bWJlcikge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fbWF4V2lkdGg7XHJcbiAgICB0aGlzLl9tYXhXaWR0aCA9IE1hdGgubWF4KHZhbHVlLCB0aGlzLl9taW5XaWR0aCk7XHJcbiAgICB0aGlzLl93aWR0aCA9IE1hdGgubWluKHRoaXMuX21heFdpZHRoLCB0aGlzLndpZHRoKTtcclxuICAgIGlmICh0aGlzLmNoYW5nZXNJbnRlcmNlcHRvciAmJiBvbGRWYWx1ZSAhPSB0aGlzLl9tYXhXaWR0aCkge1xyXG4gICAgICB0aGlzLmNoYW5nZXNJbnRlcmNlcHRvci5wcm9wZXJ0eUNoYW5nZWQoXCJnZW9tZXRyeS5tYXhXaWR0aFwiLCB2YWx1ZSk7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IG1heEhlaWdodCgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMuX21heEhlaWdodDtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgbWF4SGVpZ2h0KHZhbHVlOiBudW1iZXIpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX21heEhlaWdodDtcclxuICAgIHRoaXMuX21heEhlaWdodCA9IE1hdGgubWF4KHZhbHVlLCB0aGlzLl9taW5IZWlnaHQpO1xyXG4gICAgdGhpcy5faGVpZ2h0ID0gTWF0aC5taW4odGhpcy5fbWF4SGVpZ2h0LCB0aGlzLmhlaWdodCk7XHJcbiAgICBpZiAodGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IgJiYgb2xkVmFsdWUgIT0gdGhpcy5fbWF4SGVpZ2h0KSB7XHJcbiAgICAgIHRoaXMuY2hhbmdlc0ludGVyY2VwdG9yLnByb3BlcnR5Q2hhbmdlZChcImdlb21ldHJ5Lm1heEhlaWdodFwiLCB2YWx1ZSk7XHJcbiAgICB9XHJcbiAgfSovXHJcblxyXG4gIHB1YmxpYyBnZXQgcmlnaHQoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl94ICsgdGhpcy5fd2lkdGg7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IGJvdHRvbSgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMuX3kgKyB0aGlzLl9oZWlnaHQ7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IGNlbnRlclgoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl94ICsgdGhpcy5fd2lkdGggLyAyO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBjZW50ZXJZKCk6IG51bWJlciB7XHJcbiAgICByZXR1cm4gdGhpcy5feSArIHRoaXMuX2hlaWdodCAvIDI7XHJcbiAgfVxyXG5cclxuICBjb25zdHJ1Y3Rvcih3aWR0aDogbnVtYmVyID0gMCwgaGVpZ2h0OiBudW1iZXIgPSAwLCBjaGFuZ2VzSW50ZXJjZXB0b3I/OiBTdGlDaGFuZ2VzSW50ZXJjZXB0b3IpIHtcclxuICAgIHRoaXMud2lkdGggPSB3aWR0aDtcclxuICAgIHRoaXMuaGVpZ2h0ID0gaGVpZ2h0O1xyXG4gICAgdGhpcy5fbWluV2lkdGggPSA1O1xyXG4gICAgdGhpcy5fbWluSGVpZ2h0ID0gaGVpZ2h0O1xyXG4gICAgdGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IgPSBjaGFuZ2VzSW50ZXJjZXB0b3I7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgd2l0aFkobmV3WTogbnVtYmVyKTogU3RpUmVjdGFuZ2xlR2VvbWV0cnkge1xyXG4gICAgbGV0IGNvcHkgPSB0aGlzLmNsb25lKCk7XHJcbiAgICBjb3B5LnkgPSBuZXdZO1xyXG4gICAgcmV0dXJuIGNvcHk7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgeFByb2plY3Rpb25JbnRlcnNlY3RzV2l0aChvdGhlcjogU3RpUmVjdGFuZ2xlR2VvbWV0cnkpOiBib29sZWFuIHtcclxuICAgIHJldHVybiAoXHJcbiAgICAgIHRoaXMueCA8IG90aGVyLnJpZ2h0ICYmXHJcbiAgICAgIHRoaXMucmlnaHQgPiBvdGhlci54ICYmXHJcbiAgICAgIE1hdGguYWJzKHRoaXMucmlnaHQgLSBvdGhlci54KSA+IFN0aVJlY3RhbmdsZUdlb21ldHJ5LkRFTFRBICYmXHJcbiAgICAgIE1hdGguYWJzKHRoaXMueCAtIG90aGVyLnJpZ2h0KSA+IFN0aVJlY3RhbmdsZUdlb21ldHJ5LkRFTFRBXHJcbiAgICApO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGludGVyc2VjdFdpdGgoZ2VvbWV0cnk6IFN0aVJlY3RhbmdsZUdlb21ldHJ5KSB7XHJcbiAgICBsZXQgYUxlZnRPZkIgPSBnZW9tZXRyeS5yaWdodCAtIFN0aVJlY3RhbmdsZUdlb21ldHJ5LkRFTFRBIDwgdGhpcy54O1xyXG4gICAgbGV0IGFSaWdodE9mQiA9IGdlb21ldHJ5LnggPiB0aGlzLnJpZ2h0IC0gU3RpUmVjdGFuZ2xlR2VvbWV0cnkuREVMVEE7XHJcbiAgICBsZXQgYUFib3ZlQiA9IGdlb21ldHJ5LnkgPiB0aGlzLmJvdHRvbSAtIFN0aVJlY3RhbmdsZUdlb21ldHJ5LkRFTFRBO1xyXG4gICAgbGV0IGFCZWxvd0IgPSBnZW9tZXRyeS5ib3R0b20gLSBTdGlSZWN0YW5nbGVHZW9tZXRyeS5ERUxUQSA8IHRoaXMueTtcclxuXHJcbiAgICByZXR1cm4gIShhTGVmdE9mQiB8fCBhUmlnaHRPZkIgfHwgYUFib3ZlQiB8fCBhQmVsb3dCKTtcclxuICB9XHJcbn1cclxuIl19