import Color from "../system/Color";
import { Enum } from "../system/Enum";
import { StiPenStyle } from "../system/enums";
import StiJson from "../system/StiJson";
export class StiPen {
    constructor(color, style = StiPenStyle.Solid, width = 1) {
        this.color = color;
        this.style = style;
        this.width = width;
    }
    static dimGraySolid() {
        return new StiPen(Color.dimGray(), StiPenStyle.Solid, 1);
    }
    get width() {
        return this._width;
    }
    set width(value) {
        if (value <= 0) {
            this._width = 0;
        }
        else if (value >= 395) {
            this._width = 395;
        }
        else {
            this._width = value;
        }
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyColor("Color", this.color);
        json.addPropertyEnum("Style", StiPenStyle, this.style);
        json.addPropertyNumber("Width", this.width);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Color":
                    this.color = new Color();
                    this.color.deserializeFromString(property.value);
                    break;
                case "Style":
                    this.style = Enum.parse(StiPenStyle, property.value);
                    break;
                case "Width":
                    this.width = property.value;
                    break;
            }
        }
    }
    toHtmlBorder() {
        return `${this.width}px ${this.getHtmlStyle()} ${this.color.toHtmlColor()}`;
    }
    getHtmlStyle() {
        switch (this.style) {
            case StiPenStyle.Solid:
                return "solid";
            case StiPenStyle.Dash:
                return "dashed";
            case StiPenStyle.Dot:
                return "dotted";
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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