import StiFormObject from "../elements/base/StiFormObject";
import { Enum } from "../system/Enum";
import { PaperKind } from "../system/enums";
export default class StiPagePaperKind extends StiFormObject {
    constructor(name, kind, width, height) {
        super();
        this.name = name;
        this.kind = kind;
        this._width = width;
        this._height = height;
    }
    get width() {
        return this._width;
    }
    set width(value) {
        this._width = value;
        this.updatePaperKind();
    }
    get height() {
        return this._height;
    }
    set height(value) {
        this._height = value;
        this.updatePaperKind();
    }
    updatePaperKind() {
        this.kind =
            StiPagePaperKind.availableStandardKinds().find((k) => k.height == this.height && k.width == this.width)?.kind ??
                PaperKind.Custom;
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyEnum("Kind", PaperKind, this.kind);
        if (this.kind == PaperKind.Custom) {
            jObject.addPropertyNumber("Width", this.width);
            jObject.addPropertyNumber("Height", this.height);
        }
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Kind":
                    this.kind = Enum.parse(PaperKind, property.value);
                    break;
                case "Width":
                    this.width = property.value;
                    break;
                case "Height":
                    this.height = property.value;
                    break;
            }
        }
    }
    clone() {
        return new StiPagePaperKind(this.name, this.kind, this.width, this.height);
    }
    static availableStandardKinds() {
        if (this._availableStandardKinds.length == 0) {
            this._availableStandardKinds.push(new StiPagePaperKind("Custom", PaperKind.Custom, 794, 1123));
            this._availableStandardKinds.push(new StiPagePaperKind("Letter", PaperKind.Letter, 816, 1056));
            this._availableStandardKinds.push(new StiPagePaperKind("Tabloid", PaperKind.Tabloid, 1056, 1632));
            this._availableStandardKinds.push(new StiPagePaperKind("Legal", PaperKind.Legal, 816, 1344));
            this._availableStandardKinds.push(new StiPagePaperKind("Statement", PaperKind.Statement, 528, 816));
            this._availableStandardKinds.push(new StiPagePaperKind("Executive", PaperKind.Executive, 696, 1008));
            this._availableStandardKinds.push(new StiPagePaperKind("A3", PaperKind.A3, 1123, 1587));
            this._availableStandardKinds.push(new StiPagePaperKind("A4", PaperKind.A4, 794, 1123));
            this._availableStandardKinds.push(new StiPagePaperKind("A5", PaperKind.A5, 559, 794));
            this._availableStandardKinds.push(new StiPagePaperKind("B4", PaperKind.B4, 971, 1376));
            this._availableStandardKinds.push(new StiPagePaperKind("B5", PaperKind.B5, 688, 971));
        }
        return this._availableStandardKinds;
    }
    static fromStandardPaperKind(standardPaperKind) {
        if (standardPaperKind == PaperKind.Custom) {
            return null;
        }
        return this.availableStandardKinds().filter((k) => k.kind === standardPaperKind)[0].clone();
    }
}
StiPagePaperKind._availableStandardKinds = [];
//# sourceMappingURL=data:application/json;base64,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