import StiJson from "../system/StiJson";
export default class StiPadding {
    constructor(left = 0, top = 0, right = 0, bottom = 0, changesInterceptor) {
        this._left = 0;
        this._right = 0;
        this._top = 0;
        this._bottom = 0;
        this._left = left;
        this._right = right;
        this._top = top;
        this._bottom = bottom;
        this.changesInterceptor = changesInterceptor;
    }
    get left() {
        return this._left;
    }
    set left(value) {
        let oldPadding = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._left;
        this._left = value;
        if (this.changesInterceptor && oldValue != value) {
            this.changesInterceptor.propertyChanged("padding.left", value, oldPadding);
        }
    }
    get right() {
        return this._right;
    }
    set right(value) {
        let oldPadding = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._right;
        this._right = value;
        if (this.changesInterceptor && oldValue != value) {
            this.changesInterceptor.propertyChanged("padding.right", value, oldPadding);
        }
    }
    get top() {
        return this._top;
    }
    set top(value) {
        let oldPadding = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._top;
        this._top = value;
        if (this.changesInterceptor && oldValue != value) {
            this.changesInterceptor.propertyChanged("padding.top", value, oldPadding);
        }
    }
    get bottom() {
        return this._bottom;
    }
    set bottom(value) {
        let oldPadding = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._bottom;
        this._bottom = value;
        if (this.changesInterceptor && oldValue != value) {
            this.changesInterceptor.propertyChanged("padding.bottom", value, oldPadding);
        }
    }
    isChanged() {
        return this.savedPadding == null || !this.savedPadding.equals(this);
    }
    resetChanged() {
        this.savedPadding = this.clone();
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyNumber("Left", this.left);
        json.addPropertyNumber("Top", this.top);
        json.addPropertyNumber("Right", this.right);
        json.addPropertyNumber("Bottom", this.bottom);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Left":
                    this.left = property.value;
                    break;
                case "Top":
                    this.top = property.value;
                    break;
                case "Right":
                    this.right = property.value;
                    break;
                case "Bottom":
                    this.bottom = property.value;
                    break;
            }
        }
    }
    clone() {
        return new StiPadding(this.left, this.top, this.right, this.bottom);
    }
    equals(padding) {
        return (this.left == padding.left &&
            this.top == padding.top &&
            this.right == padding.right &&
            this.bottom == padding.bottom);
    }
}
//# sourceMappingURL=data:application/json;base64,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