import StiJson from "../system/StiJson";
import { StiPen } from "./StiPen";
export default class StiInnerBorder {
    constructor(pen, drawHorizontal, drawVertical) {
        this.pen = pen;
        this.drawHorizontal = drawHorizontal;
        this.drawVertical = drawVertical;
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyJObject("Pen", this.pen?.saveToJsonObject(options));
        json.addPropertyBool("DrawHorizontal", this.drawHorizontal);
        json.addPropertyBool("DrawVertical", this.drawVertical);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Pen":
                    this.pen = new StiPen();
                    this.pen.loadFromJsonObject(property.value);
                    break;
                case "DrawHorizontal":
                    this.drawHorizontal = property.value;
                    break;
                case "DrawVertical":
                    this.drawVertical = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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