import StiJson from "../system/StiJson";
import { StiPen } from "./StiPen";
export class StiBorder {
    constructor(pen, drawLeft, drawTop, drawRight, drawBottom) {
        this.pen = pen;
        this.drawLeft = drawLeft;
        this.drawTop = drawTop;
        this.drawRight = drawRight;
        this.drawBottom = drawBottom;
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyJObject("Pen", this.pen.saveToJsonObject(options));
        json.addPropertyBool("DrawLeft", this.drawLeft);
        json.addPropertyBool("DrawTop", this.drawTop);
        json.addPropertyBool("DrawRight", this.drawRight);
        json.addPropertyBool("DrawBottom", this.drawBottom);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Pen":
                    this.pen = new StiPen();
                    this.pen.loadFromJsonObject(property.value);
                    break;
                case "DrawLeft":
                    this.drawLeft = property.value;
                    break;
                case "DrawTop":
                    this.drawTop = property.value;
                    break;
                case "DrawBottom":
                    this.drawBottom = property.value;
                    break;
                case "DrawRight":
                    this.drawRight = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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