import Color from "../../system/Color";
import { Enum } from "../../system/Enum";
import { StiHorizontalAlignment } from "../../system/enums";
import { Font } from "../../system/Font";
import StiJson from "../../system/StiJson";
export class StiTextItem {
    constructor(value = "", font = new Font("Segoe UI", 9), color = Color.black(), backgroundColor, horizontalAlignment) {
        this.font = font;
        this.color = color;
        this.backgroundColor = backgroundColor;
        this.horizontalAlignment = horizontalAlignment;
        this._isChanged = true;
        this._value = value;
    }
    get eValue() {
        return this.value;
    }
    set eValue(value) {
        this.value = value;
    }
    get eFont() {
        return this.font;
    }
    set eFont(value) {
        this.font = value;
    }
    get eColor() {
        return this.color;
    }
    set eColor(value) {
        this.color = value;
    }
    get eBackgroundColor() {
        return this.backgroundColor;
    }
    set eBackgroundColor(value) {
        this.backgroundColor = value;
    }
    get value() {
        return this._value;
    }
    set value(value) {
        this._value = value;
        this._isChanged = true;
    }
    isChanged() {
        return this._isChanged || this.font?.isChanged || this.color?.isChanged() || this.backgroundColor?.isChanged();
    }
    setProperty(propName, value, oldObject) {
        if (propName.startsWith("font") && (oldObject === null || this.font.equals(oldObject))) {
            this.font.setProperty(propName.replace("font.", ""), value);
        }
        else if (propName == "color" && (oldObject === null || this.color.equals(oldObject))) {
            this.color = value.clone();
        }
    }
    resetChanged() {
        this._isChanged = false;
        this.font?.resetChanged();
        this.color?.resetChanged();
        this.backgroundColor?.resetChanged();
    }
    haveBackgoundColor() {
        return this.backgroundColor ? true : false;
    }
    haveVerticalAlignment() {
        return false;
    }
    get eContentAlignment() {
        return this.horizontalAlignment;
    }
    set eContentAlignment(value) {
        this.horizontalAlignment = value;
    }
    haveContentAlignment() {
        return this.horizontalAlignment ? true : false;
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyStringNullOrEmpty("Value", this.value);
        json.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        json.addPropertyColor("Color", this.color);
        if (this.horizontalAlignment) {
            json.addPropertyEnum("HorizontalAlignment", StiHorizontalAlignment, this.horizontalAlignment);
        }
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Value":
                    this.value = property.value;
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
                case "Color":
                    this.color = new Color();
                    this.color.deserializeFromString(property.value);
                    break;
                case "HorizontalAlignment":
                    this.horizontalAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
            }
        }
    }
    htmlStyle() {
        return `${this.font.htmlStyle()};color:${this.color.toHtmlColor()}`;
    }
}
//# sourceMappingURL=data:application/json;base64,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