import Color from "../../system/Color";
import { Enum } from "../../system/Enum";
import { StiLabelAlignment, StiVerticalAlignment } from "../../system/enums";
import { Font } from "../../system/Font";
import { StiTextItem } from "./StiTextItem";
export class StiLabelItem extends StiTextItem {
    constructor(parent, value = "", font = new Font("Segoe UI", 10), color = Color.black(), alignment = StiLabelAlignment.Left, verticalAlignment = StiVerticalAlignment.Top, width = 150) {
        super(value, font, color, null);
        this.font = font;
        this.color = color;
        this.alignment = alignment;
        this.eVerticalAlignment = verticalAlignment;
        this.width = width;
        this.eParent = parent;
    }
    get alignment() {
        return this._alignment;
    }
    set alignment(value) {
        this._alignment = value;
        this._isChanged = true;
        if (this.eParent?.fitTable) {
            this.eParent?.fitTable();
        }
    }
    get eVerticalAlignment() {
        return this._verticalAlignment;
    }
    set eVerticalAlignment(value) {
        this._verticalAlignment = value;
        this._isChanged = true;
    }
    get verticalAlignment() {
        return this.isUnchangedVAlign() ? StiVerticalAlignment.Center : this.eVerticalAlignment;
    }
    set verticalAlignment(value) {
        this.eVerticalAlignment = value;
    }
    get width() {
        return this._width;
    }
    set width(value) {
        if (value <= 0) {
            this._width = 0;
        }
        else {
            this._width = value;
        }
        this._isChanged = true;
    }
    haveContentAlignment() {
        return false;
    }
    haveVerticalAlignment() {
        return true;
    }
    setProperty(propName, value, oldObject) {
        super.setProperty(propName, value, oldObject);
        if (this[propName] && (oldObject === null || this[propName] == oldObject)) {
            this[propName] = value.clone ? value.clone() : value;
        }
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyEnum("Alignment", StiLabelAlignment, this.alignment);
        json.addPropertyEnum("VerticalAlignment", StiVerticalAlignment, this.isUnchangedVAlign() ? StiVerticalAlignment.Center : this.eVerticalAlignment);
        if (this.width != null) {
            json.addPropertyNumber("Width", this.width);
        }
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Alignment":
                    this.alignment = Enum.parse(StiLabelAlignment, property.value);
                    break;
                case "Width":
                    this.width = property.value;
                    break;
                case "VerticalAlignment":
                    this._verticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
            }
        }
    }
    htmlStyle() {
        return `${super.htmlStyle()};text-align:${this.alignment == StiLabelAlignment.Top ? "Center" : Enum.getName(StiLabelAlignment, this.alignment)}`;
    }
    isUnchangedVAlign() {
        return (this.eParent.type == "Text_BoxElement" ||
            this.eParent.type == "Number_BoxElement" ||
            this.eParent.type == "Combo_BoxElement" ||
            this.eParent.type == "Check_BoxElement" ||
            this.eParent.type == "DateTime_BoxElement");
    }
}
//# sourceMappingURL=data:application/json;base64,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