import Color from "../../system/Color";
import { Font } from "../../system/Font";
import { StiTextItem } from "./StiTextItem";
export class StiBackgroundedTextItem extends StiTextItem {
    constructor(value = "", font = new Font("Segoe UI", 9), color = Color.black(), backgroundColor = Color.white()) {
        super(value, font, color, backgroundColor);
        this.font = font;
        this.color = color;
        this.backgroundColor = backgroundColor;
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyColor("BackgroundColor", this.backgroundColor);
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
            }
        }
    }
    getBackgroundColor() {
        return this.backgroundColor;
    }
    haveContentAlignment() {
        return false;
    }
    haveBackgoundColor() {
        return true;
    }
}
//# sourceMappingURL=data:application/json;base64,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