import Color from "../../system/Color";
import { Enum } from "../../system/Enum";
import { StiHorizontalAlignment, StiVerticalAlignment } from "../../system/enums";
import { Font } from "../../system/Font";
import { StiBackgroundedTextItem } from "./StiBackgroundedTextItem";
export class StiBackgroundedAlignedTextItem extends StiBackgroundedTextItem {
    constructor(value = "", font = new Font("Segoe UI", 15), color = Color.black(), backgroundColor = Color.white(), horizontalAlignment = StiHorizontalAlignment.Center, verticalAlignment = StiVerticalAlignment.Center) {
        super(value, font, color, backgroundColor);
        this.font = font;
        this.color = color;
        this.backgroundColor = backgroundColor;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
    }
    get eContentAlignment() {
        return this.horizontalAlignment;
    }
    set eContentAlignment(value) {
        this.horizontalAlignment = value;
    }
    get eVerticalAlignment() {
        return this.verticalAlignment;
    }
    set eVerticalAlignment(value) {
        this.verticalAlignment = value;
    }
    haveVerticalAlignment() {
        return true;
    }
    haveContentAlignment() {
        return true;
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyEnum("HorizontalAlignment", StiHorizontalAlignment, this.horizontalAlignment);
        json.addPropertyEnum("VerticalAlignment", StiVerticalAlignment, this.verticalAlignment);
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "HorizontalAlignment":
                    this.horizontalAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "VerticalAlignment":
                    this.verticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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