import { StiRadioButtonCellItem } from "../cells/StiRadioButtonCellItem";
import { StiColumnItem } from "../StiColumnItem";
export class StiRadioButtonColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this.type = "RadioButtonColumn";
        this.cells = [];
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c.isChecked));
        return result;
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell.isChecked = false;
        });
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        jObject.addPropertyString("Name", this.name);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Cells":
                    this.cells = [];
                    for (let cellJson of property.value.value) {
                        let cell = new StiRadioButtonCellItem();
                        cell.loadFromJsonObject(cellJson);
                        this.cells.push(cell);
                    }
                    break;
                case "Name":
                    this.name = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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