import { Enum } from "../../../system/Enum";
import { StiDisplayCurrencyAs, StiHorizontalAlignment, StiNumberType, StiThousandSeparator, StiUnitAlignment, } from "../../../system/enums";
import { StiNumberBoxCellItem } from "../cells/StiNumberBoxCellItem";
import { StiColumnItem } from "../StiColumnItem";
export class StiNumberBoxColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this._decimalDigits = 2;
        this.type = "NumberBoxColumn";
        this.unitLabel = "";
        this.cells = [];
        this.thousandSeparator = StiThousandSeparator.None;
        this.numberType = StiNumberType.Decimal;
        this.unitAlignment = StiUnitAlignment.Suffix;
        this.currencyLabelFormat = StiDisplayCurrencyAs.Code;
        this.currency = "USD";
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell.number = 0;
        });
    }
    get decimalDigits() {
        return this._decimalDigits;
    }
    set decimalDigits(value) {
        if (value <= 0) {
            this._decimalDigits = 0;
        }
        else {
            this._decimalDigits = value;
        }
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c.number));
        return result;
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        jObject.addPropertyEnum("CurrencyLabelFormat", StiDisplayCurrencyAs, this.currencyLabelFormat);
        jObject.addPropertyString("Currency", this.currency);
        jObject.addPropertyString("UnitLabel", this.unitLabel);
        jObject.addPropertyEnum("UnitAlignment", StiUnitAlignment, this.unitAlignment);
        jObject.addPropertyEnum("NumberType", StiNumberType, this.numberType);
        jObject.addPropertyEnum("ThousandSeparator", StiThousandSeparator, this.thousandSeparator);
        jObject.addPropertyNumber("DecimalDigits", this.decimalDigits);
        return jObject;
    }
    htmlStyle() {
        if (this.eParent) {
            return super.htmlStyle();
        }
        else
            return `${this.eParent ? super.htmlStyle() + ";" : ""}color:${this.cellForeColor?.toHtmlColor()};text-align:${Enum.getName(StiHorizontalAlignment, this.cellAlignment)}`;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Cells":
                    this.cells = [];
                    for (let cellJson of property.value.value) {
                        let cell = new StiNumberBoxCellItem("", 0);
                        cell.loadFromJsonObject(cellJson);
                        this.cells.push(cell);
                    }
                    break;
                case "NumberType":
                    this.numberType = Enum.parse(StiNumberType, property.value);
                    break;
                case "ThousandSeparator":
                    this.thousandSeparator = Enum.parse(StiThousandSeparator, property.value);
                    break;
                case "DecimalDigits":
                    this.decimalDigits = property.value;
                    break;
                case "UnitLabel":
                    this.unitLabel = property.value;
                    break;
                case "UnitAlignment":
                    this.unitAlignment = Enum.parse(StiUnitAlignment, property.value);
                    break;
                case "CurrencyLabelFormat":
                    this.currencyLabelFormat = Enum.parse(StiDisplayCurrencyAs, property.value);
                    break;
                case "Currency":
                    this.currency = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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