import { Enum } from "../../../system/Enum";
import { StiThousandSeparator } from "../../../system/enums";
import { StiColumnItem } from "../StiColumnItem";
export class StiLabelColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this._decimalDigits = 2;
        this.type = "LabelColumn";
        this.expression = "";
        this.prefix = "";
        this.suffix = "";
        this.cells = [];
        this.thousandSeparator = StiThousandSeparator.None;
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell = "";
        });
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c));
        return result;
    }
    set value(value) { }
    get decimalDigits() {
        return this._decimalDigits;
    }
    set decimalDigits(value) {
        this._decimalDigits = Math.max(0, Math.min(value, 10));
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        jObject.addPropertyString("Expression", this.expression);
        jObject.addPropertyString("Prefix", this.prefix);
        jObject.addPropertyString("Suffix", this.suffix);
        jObject.addPropertyNumber("DecimalDigits", this.decimalDigits);
        jObject.addPropertyEnum("ThousandSeparator", StiThousandSeparator, this.thousandSeparator);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Expression":
                    this.expression = property.value;
                    break;
                case "Cells":
                    this.cells = [];
                    property.value.properties().forEach((p) => this.cells.push(p.value));
                    break;
                case "ThousandSeparator":
                    this.thousandSeparator = Enum.parse(StiThousandSeparator, property.value);
                    break;
                case "DecimalDigits":
                    this.decimalDigits = property.value;
                    break;
                case "Prefix":
                    this.prefix = property.value;
                    break;
                case "Suffix":
                    this.suffix = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RpTGFiZWxDb2x1bW5JdGVtLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2VsZW1lbnRzL3RhYmxlL2NvbHVtbnMvU3RpTGFiZWxDb2x1bW5JdGVtLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUNBLE9BQU8sRUFBRSxJQUFJLEVBQUUsTUFBTSxzQkFBc0IsQ0FBQztBQUM1QyxPQUFPLEVBQUUsb0JBQW9CLEVBQW9CLE1BQU0sdUJBQXVCLENBQUM7QUFHL0UsT0FBTyxFQUFFLGFBQWEsRUFBRSxNQUFNLGtCQUFrQixDQUFDO0FBRWpELE1BQU0sT0FBTyxrQkFBbUIsU0FBUSxhQUFhO0lBQXJEOztRQUNVLG1CQUFjLEdBQVcsQ0FBQyxDQUFDO1FBRTVCLFNBQUksR0FBRyxhQUFhLENBQUM7UUFDckIsZUFBVSxHQUFXLEVBQUUsQ0FBQztRQUN4QixXQUFNLEdBQVcsRUFBRSxDQUFDO1FBQ3BCLFdBQU0sR0FBVyxFQUFFLENBQUM7UUFDcEIsVUFBSyxHQUFHLEVBQUUsQ0FBQztRQUNYLHNCQUFpQixHQUF5QixvQkFBb0IsQ0FBQyxJQUFJLENBQUM7SUEyRDdFLENBQUM7SUExREMsZ0JBQWdCO1FBQ2QsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRTtZQUMxQixJQUFJLEdBQUcsRUFBRSxDQUFDO1FBQ1osQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBQ0QsSUFBVyxLQUFLO1FBQ2QsSUFBSSxNQUFNLEdBQUcsRUFBRSxDQUFDO1FBQ2hCLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDMUMsT0FBTyxNQUFNLENBQUM7SUFDaEIsQ0FBQztJQUVELElBQVcsS0FBSyxDQUFDLEtBQVUsSUFBRyxDQUFDO0lBRS9CLElBQUksYUFBYTtRQUNmLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDO0lBQ0QsSUFBSSxhQUFhLENBQUMsS0FBYTtRQUM3QixJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDekQsQ0FBQztJQUVELGdCQUFnQixDQUFDLE9BQVk7UUFDM0IsSUFBSSxPQUFPLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQzlDLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzlDLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3pELE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ2pELE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ2pELE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxlQUFlLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQy9ELE9BQU8sQ0FBQyxlQUFlLENBQUMsbUJBQW1CLEVBQUUsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFFM0YsT0FBTyxPQUFPLENBQUM7SUFDakIsQ0FBQztJQUVNLGtCQUFrQixDQUFDLElBQWE7UUFDckMsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxDQUFDO1FBQy9CLEtBQUssSUFBSSxRQUFRLElBQUksSUFBSSxDQUFDLFVBQVUsRUFBRSxFQUFFO1lBQ3RDLFFBQVEsUUFBUSxDQUFDLElBQUksRUFBRTtnQkFDckIsS0FBSyxZQUFZO29CQUNmLElBQUksQ0FBQyxVQUFVLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDakMsTUFBTTtnQkFDUixLQUFLLE9BQU87b0JBQ1YsSUFBSSxDQUFDLEtBQUssR0FBRyxFQUFFLENBQUM7b0JBQ2YsUUFBUSxDQUFDLEtBQWlCLENBQUMsVUFBVSxFQUFFLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztvQkFDbEYsTUFBTTtnQkFDUixLQUFLLG1CQUFtQjtvQkFDdEIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsb0JBQW9CLEVBQUUsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUMxRSxNQUFNO2dCQUNSLEtBQUssZUFBZTtvQkFDbEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUNwQyxNQUFNO2dCQUNSLEtBQUssUUFBUTtvQkFDWCxJQUFJLENBQUMsTUFBTSxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQzdCLE1BQU07Z0JBQ1IsS0FBSyxRQUFRO29CQUNYLElBQUksQ0FBQyxNQUFNLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDN0IsTUFBTTthQUNUO1NBQ0Y7SUFDSCxDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTdGlNb2RlbFNlcnZpY2UgfSBmcm9tIFwiLi4vLi4vLi4vc2VydmljZXMvbW9kZWwuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBFbnVtIH0gZnJvbSBcIi4uLy4uLy4uL3N5c3RlbS9FbnVtXCI7XHJcbmltcG9ydCB7IFN0aVRob3VzYW5kU2VwYXJhdG9yLCBTdGlVbml0QWxpZ25tZW50IH0gZnJvbSBcIi4uLy4uLy4uL3N5c3RlbS9lbnVtc1wiO1xyXG5pbXBvcnQgeyBTdGlGb3JtYXR0ZWRFbGVtZW50LCBTdGlWYWx1ZUVsZW1lbnQgfSBmcm9tIFwiLi4vLi4vLi4vc3lzdGVtL2ludGVyZmFjZXNcIjtcclxuaW1wb3J0IFN0aUpzb24gZnJvbSBcIi4uLy4uLy4uL3N5c3RlbS9TdGlKc29uXCI7XHJcbmltcG9ydCB7IFN0aUNvbHVtbkl0ZW0gfSBmcm9tIFwiLi4vU3RpQ29sdW1uSXRlbVwiO1xyXG5cclxuZXhwb3J0IGNsYXNzIFN0aUxhYmVsQ29sdW1uSXRlbSBleHRlbmRzIFN0aUNvbHVtbkl0ZW0gaW1wbGVtZW50cyBTdGlWYWx1ZUVsZW1lbnQsIFN0aUZvcm1hdHRlZEVsZW1lbnQge1xyXG4gIHByaXZhdGUgX2RlY2ltYWxEaWdpdHM6IG51bWJlciA9IDI7XHJcblxyXG4gIHB1YmxpYyB0eXBlID0gXCJMYWJlbENvbHVtblwiO1xyXG4gIHB1YmxpYyBleHByZXNzaW9uOiBzdHJpbmcgPSBcIlwiO1xyXG4gIHB1YmxpYyBwcmVmaXg6IHN0cmluZyA9IFwiXCI7XHJcbiAgcHVibGljIHN1ZmZpeDogc3RyaW5nID0gXCJcIjtcclxuICBwdWJsaWMgY2VsbHMgPSBbXTtcclxuICBwdWJsaWMgdGhvdXNhbmRTZXBhcmF0b3I6IFN0aVRob3VzYW5kU2VwYXJhdG9yID0gU3RpVGhvdXNhbmRTZXBhcmF0b3IuTm9uZTtcclxuICBzZXREZWZhdWx0VmFsdWVzKCkge1xyXG4gICAgdGhpcy5jZWxscy5mb3JFYWNoKChjZWxsKSA9PiB7XHJcbiAgICAgIGNlbGwgPSBcIlwiO1xyXG4gICAgfSk7XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXQgdmFsdWUoKTogYW55IHtcclxuICAgIGxldCByZXN1bHQgPSBbXTtcclxuICAgIHRoaXMuY2VsbHMuZm9yRWFjaCgoYykgPT4gcmVzdWx0LnB1c2goYykpO1xyXG4gICAgcmV0dXJuIHJlc3VsdDtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgdmFsdWUodmFsdWU6IGFueSkge31cclxuXHJcbiAgZ2V0IGRlY2ltYWxEaWdpdHMoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5fZGVjaW1hbERpZ2l0cztcclxuICB9XHJcbiAgc2V0IGRlY2ltYWxEaWdpdHModmFsdWU6IG51bWJlcikge1xyXG4gICAgdGhpcy5fZGVjaW1hbERpZ2l0cyA9IE1hdGgubWF4KDAsIE1hdGgubWluKHZhbHVlLCAxMCkpO1xyXG4gIH1cclxuXHJcbiAgc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zOiBhbnkpOiBTdGlKc29uIHtcclxuICAgIGxldCBqT2JqZWN0ID0gc3VwZXIuc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlBcnJheShcIkNlbGxzXCIsIHRoaXMuY2VsbHMpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eVN0cmluZyhcIkV4cHJlc3Npb25cIiwgdGhpcy5leHByZXNzaW9uKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlTdHJpbmcoXCJQcmVmaXhcIiwgdGhpcy5wcmVmaXgpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eVN0cmluZyhcIlN1ZmZpeFwiLCB0aGlzLnN1ZmZpeCk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5TnVtYmVyKFwiRGVjaW1hbERpZ2l0c1wiLCB0aGlzLmRlY2ltYWxEaWdpdHMpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUVudW0oXCJUaG91c2FuZFNlcGFyYXRvclwiLCBTdGlUaG91c2FuZFNlcGFyYXRvciwgdGhpcy50aG91c2FuZFNlcGFyYXRvcik7XHJcblxyXG4gICAgcmV0dXJuIGpPYmplY3Q7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgbG9hZEZyb21Kc29uT2JqZWN0KGpzb246IFN0aUpzb24pIHtcclxuICAgIHN1cGVyLmxvYWRGcm9tSnNvbk9iamVjdChqc29uKTtcclxuICAgIGZvciAobGV0IHByb3BlcnR5IG9mIGpzb24ucHJvcGVydGllcygpKSB7XHJcbiAgICAgIHN3aXRjaCAocHJvcGVydHkubmFtZSkge1xyXG4gICAgICAgIGNhc2UgXCJFeHByZXNzaW9uXCI6XHJcbiAgICAgICAgICB0aGlzLmV4cHJlc3Npb24gPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJDZWxsc1wiOlxyXG4gICAgICAgICAgdGhpcy5jZWxscyA9IFtdO1xyXG4gICAgICAgICAgKHByb3BlcnR5LnZhbHVlIGFzIFN0aUpzb24pLnByb3BlcnRpZXMoKS5mb3JFYWNoKChwKSA9PiB0aGlzLmNlbGxzLnB1c2gocC52YWx1ZSkpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlRob3VzYW5kU2VwYXJhdG9yXCI6XHJcbiAgICAgICAgICB0aGlzLnRob3VzYW5kU2VwYXJhdG9yID0gRW51bS5wYXJzZShTdGlUaG91c2FuZFNlcGFyYXRvciwgcHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkRlY2ltYWxEaWdpdHNcIjpcclxuICAgICAgICAgIHRoaXMuZGVjaW1hbERpZ2l0cyA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlByZWZpeFwiOlxyXG4gICAgICAgICAgdGhpcy5wcmVmaXggPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJTdWZmaXhcIjpcclxuICAgICAgICAgIHRoaXMuc3VmZml4ID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxufVxyXG4iXX0=