import { StiComboBoxCellItem } from "../cells/StiComboBoxCellItem";
import { StiColumnItem } from "../StiColumnItem";
export class StiComboBoxColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this.type = "ComboBoxColumn";
        this.cells = [];
        this.comboBoxOptions = [];
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c.selectedIndex > 0 && this.comboBoxOptions.length < c.selectedIndex
            ? this.comboBoxOptions[c.selectedIndex]
            : null));
        return result;
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell.selectedIndex = 0;
        });
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        jObject.addPropertyArray("ComboBoxOptions", this.comboBoxOptions);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Cells":
                    this.cells = [];
                    for (let cellJson of property.value.value) {
                        let cell = new StiComboBoxCellItem();
                        cell.loadFromJsonObject(cellJson);
                        this.cells.push(cell);
                    }
                    break;
                case "ComboBoxOptions":
                    this.comboBoxOptions = [];
                    property.value.properties().forEach((p) => this.comboBoxOptions.push(p.value));
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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