import { StiCheckBoxCellItem } from "../cells/StiCheckBoxCellItem";
import { StiColumnItem } from "../StiColumnItem";
export class StiCheckBoxColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this.type = "CheckBoxColumn";
        this.cells = [];
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        return jObject;
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell.isChecked = false;
        });
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c.isChecked));
        return result;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Cells":
                    this.cells = [];
                    for (let cellJson of property.value.value) {
                        let cell = new StiCheckBoxCellItem();
                        cell.loadFromJsonObject(cellJson);
                        this.cells.push(cell);
                    }
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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