import StiJson from "../../../system/StiJson";
export class StiComboBoxCellItem {
    constructor(name, selectedIndex) {
        this.name = name;
        this.selectedIndex = selectedIndex;
    }
    saveToJsonObject(options) {
        let jObject = new StiJson();
        jObject.addPropertyString("Name", this.name);
        jObject.addPropertyNumber("SelectedIndex", this.selectedIndex);
        return jObject;
    }
    get value() {
        return this.selectedIndex ? this.selectedIndex : 0;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Name":
                    this.name = property.value;
                    break;
                case "SelectedIndex":
                    this.selectedIndex = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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