import Color from "../../system/Color";
import { Enum } from "../../system/Enum";
import { StiHorizontalAlignment, StiThousandSeparator } from "../../system/enums";
import StiFormObject from "../base/StiFormObject";
export class StiTotalsFieldItem extends StiFormObject {
    constructor(header, expression, headerAlignment = StiHorizontalAlignment.Right, headerColor = Color.black(), valueAlignment = StiHorizontalAlignment.Right) {
        super();
        this.header = header;
        this.expression = expression;
        this.headerAlignment = headerAlignment;
        this.headerColor = headerColor;
        this.valueAlignment = valueAlignment;
        this._decimalDigits = 2;
        this.prefix = "";
        this.suffix = "";
        this.thousandSeparator = StiThousandSeparator.None;
        this.name = "";
    }
    setDefaultValues() {
        this.value = 0;
    }
    get value() {
        return this._value !== undefined ? this._value : this.expression;
    }
    set value(value) {
        this._value = value;
    }
    get decimalDigits() {
        return this._decimalDigits;
    }
    set decimalDigits(value) {
        if (value <= 0) {
            this._decimalDigits = 0;
        }
        else {
            this._decimalDigits = value;
        }
    }
    get eValue() {
        return this.header;
    }
    set eValue(value) {
        this.header = value;
    }
    get eFont() {
        return this.eParent.font;
    }
    set eFont(value) {
        this.eParent.font = value;
    }
    get eColor() {
        return this.headerColor;
    }
    set eColor(value) {
        this.headerColor = value;
    }
    haveBackgoundColor() {
        return false;
    }
    get eContentAlignment() {
        return this.headerAlignment;
    }
    set eContentAlignment(value) {
        this.headerAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    haveVerticalAlignment() {
        return false;
    }
    htmlStyle() {
        return this.eParent ? `${this.eFont.htmlStyle()};color:${this.eColor.toHtmlColor()}` : "";
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyString("Header", this.header);
        jObject.addPropertyString("Name", this.name);
        jObject.addPropertyEnum("HeaderAlignment", StiHorizontalAlignment, this.headerAlignment);
        jObject.addPropertyEnum("ValueAlignment", StiHorizontalAlignment, this.valueAlignment);
        jObject.addPropertyColor("HeaderColor", this.headerColor);
        jObject.addPropertyString("Expression", this.expression);
        jObject.addPropertyString("Prefix", this.prefix);
        jObject.addPropertyString("Suffix", this.suffix);
        jObject.addPropertyNumber("DecimalDigits", this.decimalDigits);
        jObject.addPropertyEnum("ThousandSeparator", StiThousandSeparator, this.thousandSeparator);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Header":
                    this.header = property.value;
                    break;
                case "HeaderAlignment":
                    this.headerAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "ValueAlignment":
                    this.valueAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "HeaderColor":
                    this.headerColor = new Color();
                    this.headerColor.deserializeFromString(property.value);
                    break;
                case "Expression":
                    this.expression = property.value;
                    break;
                case "ThousandSeparator":
                    this.thousandSeparator = Enum.parse(StiThousandSeparator, property.value);
                    break;
                case "DecimalDigits":
                    this.decimalDigits = property.value;
                    break;
                case "Prefix":
                    this.prefix = property.value;
                    break;
                case "Suffix":
                    this.suffix = property.value;
                    break;
                case "Name":
                    this.name = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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