export class StiRowLabel {
    constructor(value, table, index) {
        this.table = table;
        this.index = index;
        this._value = value;
    }
    get eFont() {
        return this.table.font;
    }
    set eFont(value) {
        this.table.font = value;
    }
    get eColor() {
        return this.table.rowHeadersColor;
    }
    set eColor(value) {
        this.table.rowHeadersColor = value;
    }
    get eBackgroundColor() {
        return this.table.rowHeadersBackground;
    }
    set eBackgroundColor(value) {
        this.table.rowHeadersBackground = value;
    }
    get expression() {
        return this.value;
    }
    haveBackgoundColor() {
        return true;
    }
    get eContentAlignment() {
        return this.table.rowLabelsHorizontalAlignment;
    }
    set eContentAlignment(value) {
        this.table.rowLabelsHorizontalAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    haveVerticalAlignment() {
        return false;
    }
    getDefaultEditableContent() {
        return this;
    }
    htmlStyle() {
        return this.table ? `${this.eFont.htmlStyle()};color: inherit` : "";
    }
    set value(value) {
        this._value = value;
        this.table.nativeRowLabels[this.index] = value;
    }
    get value() {
        return this._value;
    }
    set eValue(value) {
        this.value = value;
    }
    get eValue() {
        return this.value;
    }
}
//# sourceMappingURL=data:application/json;base64,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