import Color from "../../system/Color";
import { Enum } from "../../system/Enum";
import { StiHorizontalAlignment } from "../../system/enums";
import { Font } from "../../system/Font";
import StiFormObject from "../base/StiFormObject";
export class StiColumnItem extends StiFormObject {
    constructor(label) {
        super();
        this.label = label;
        this.headerAlignment = StiHorizontalAlignment.Left;
        this.cellAlignment = StiHorizontalAlignment.Left;
        this.headerForeColor = Color.black();
        this.headerBackColor = Color.transparent();
        this.backgroundColor = Color.transparent();
        this.cellBackColor = Color.white();
        this.cellForeColor = Color.black();
        this.cellBorderColor = Color.lightGray();
        this.font = new Font("Segoe UI", 10);
        this.useWordWrap = false;
    }
    setDefaultValues() { }
    get eValue() {
        return this.label;
    }
    set eValue(value) {
        this.label = value;
    }
    get eFont() {
        return this.font;
    }
    set eFont(value) {
        this.font = value;
    }
    get eColor() {
        return this.headerForeColor;
    }
    set eColor(value) {
        this.headerForeColor = value;
    }
    get eBackgroundColor() {
        return this.headerBackColor;
    }
    set eBackgroundColor(value) {
        this.headerBackColor = value;
    }
    get eContentAlignment() {
        return this.headerAlignment;
    }
    set eContentAlignment(value) {
        this.headerAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    haveVerticalAlignment() {
        return false;
    }
    haveBackgoundColor() {
        return true;
    }
    htmlStyle() {
        return this.eParent
            ? `${this.eFont.htmlStyle()};color:${this.eColor.toHtmlColor()};text-align:${Enum.getName(StiHorizontalAlignment, this.cellAlignment)}`
            : "";
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyString("Label", this.label);
        jObject.addPropertyEnum("HeaderAlignment", StiHorizontalAlignment, this.headerAlignment);
        jObject.addPropertyEnum("CellAlignment", StiHorizontalAlignment, this.cellAlignment);
        jObject.addPropertyColor("HeaderBackColor", this.headerBackColor);
        jObject.addPropertyColor("HeaderForeColor", this.headerForeColor);
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyColor("CellBackColor", this.cellBackColor);
        jObject.addPropertyColor("CellForeColor", this.cellForeColor);
        jObject.addPropertyColor("CellBorderColor", this.cellBorderColor);
        jObject.addPropertyBool("UseWordWrap", this.useWordWrap);
        jObject.addPropertyNumber("Width", this.width);
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = property.value;
                    break;
                case "Width":
                    this.width = property.value;
                    break;
                case "UseWordWrap":
                    this.useWordWrap = property.value;
                    break;
                case "HeaderAlignment":
                    this.headerAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "CellAlignment":
                    this.cellAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "HeaderBackColor":
                    this.headerBackColor = new Color();
                    this.headerBackColor.deserializeFromString(property.value);
                    break;
                case "HeaderForeColor":
                    this.headerForeColor = new Color();
                    this.headerForeColor.deserializeFromString(property.value);
                    break;
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "CellBackColor":
                    this.cellBackColor = new Color();
                    this.cellBackColor.deserializeFromString(property.value);
                    break;
                case "CellForeColor":
                    this.cellForeColor = new Color();
                    this.cellForeColor.deserializeFromString(property.value);
                    break;
                case "CellBorderColor":
                    this.cellBorderColor = new Color();
                    this.cellBorderColor.deserializeFromString(property.value);
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
            }
        }
        if (!json.properties().find((property) => property.name == "Font")) {
            this.font = this.eParent.font.clone();
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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