import { Enum } from "../../system/Enum";
import { StiAlgorithmExpression } from "../../system/enums";
import StiJson from "../../system/StiJson";
export class StiCalculationAlgorithm {
    constructor(expression = StiAlgorithmExpression.Constant, rowIndex, columntIndex, value) {
        this.expression = expression;
        this.rowIndex = rowIndex;
        this.columntIndex = columntIndex;
        this.value = value;
    }
    saveToJsonObject(options) {
        let jObject = new StiJson();
        jObject.addPropertyEnum("Expression", StiAlgorithmExpression, this.expression);
        jObject.addPropertyNumberNotNull("RowIndex", this.rowIndex);
        jObject.addPropertyNumberNotNull("ColumnIndex", this.columntIndex);
        jObject.addPropertyNumberNotNull("Value", this.value);
        return jObject;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Expression":
                    this.expression = Enum.parse(StiAlgorithmExpression, property.value);
                    break;
                case "RowIndex":
                    this.rowIndex = property.value;
                    break;
                case "ColumnIndex":
                    this.columntIndex = property.value;
                    break;
                case "Value":
                    this.value = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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