import Color from "../../system/Color";
import { Enum } from "../../system/Enum";
import { StiLabelAlignment, StiVerticalAlignment } from "../../system/enums";
import { Font } from "../../system/Font";
import { StiDescriptionSettings } from "./StiDescriptionSettings";
export class StiLabelSettings extends StiDescriptionSettings {
    constructor(changesInterceptor) {
        super(changesInterceptor);
        this.changesInterceptor = changesInterceptor;
        this._alignment = StiLabelAlignment.Left;
        this._verticalAlignment = StiVerticalAlignment.Center;
        this._width = 150;
        this._font = new Font("Segoe UI", 10, [], this);
        this._color = Color.black();
        this._color.changesInterceptor = this;
    }
    propertyChanged(propName, value, oldObject) {
        this.changesInterceptor.propertyChanged(`label.${propName}`, value, oldObject);
    }
    get alignment() {
        return this._alignment;
    }
    set alignment(value) {
        let oldValue = this._alignment;
        this._alignment = value;
        if (oldValue != value) {
            this.propertyChanged("alignment", value, oldValue);
        }
    }
    get verticalAlignment() {
        return this._verticalAlignment;
    }
    set verticalAlignment(value) {
        let oldValue = this._verticalAlignment;
        this._verticalAlignment = value;
        if (oldValue != value) {
            this.propertyChanged("verticalAlignment", value, oldValue);
        }
    }
    get width() {
        return this._width;
    }
    set width(value) {
        let oldValue = this._width;
        this._width = value;
        if (oldValue != value) {
            this.propertyChanged("width", value, oldValue);
        }
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyEnum("Alignment", StiLabelAlignment, this.alignment);
        json.addPropertyEnum("VerticalAlignment", StiVerticalAlignment, this.verticalAlignment);
        json.addPropertyNumber("Width", this.width);
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Alignment":
                    this._alignment = Enum.parse(StiLabelAlignment, property.value);
                    break;
                case "VerticalAlignment":
                    this._verticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
                case "Width":
                    this._width = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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