import Color from "../../system/Color";
import { Enum } from "../../system/Enum";
import { StiHorizontalAlignment, StiLineWeight } from "../../system/enums";
import { StiDescriptionSettings } from "./StiDescriptionSettings";
export class StiInnerTextSettings extends StiDescriptionSettings {
    constructor(changesInterceptor) {
        super(changesInterceptor);
        this.changesInterceptor = changesInterceptor;
        this._borderWeight = StiLineWeight.Thin;
        this._contentAlignment = StiHorizontalAlignment.Left;
        this._backgroundColor = Color.white();
        this._backgroundColor.changesInterceptor = this;
        this._backgroundColor.propertyName = "backgroundColor";
        this._borderColor = Color.lightGray();
        this._borderColor.changesInterceptor = this;
        this._borderColor.propertyName = "borderColor";
        this._checkColor = Color.black();
        this._checkColor.changesInterceptor = this;
        this._checkColor.propertyName = "checkColor";
        this._color = Color.black();
        this._color.changesInterceptor = this;
        this._font._size = 10;
    }
    propertyChanged(propName, value, oldObject) {
        this.changesInterceptor.propertyChanged(`innerText.${propName}`, value, oldObject);
    }
    get backgroundColor() {
        return this._backgroundColor;
    }
    set backgroundColor(value) {
        let oldValue = this._backgroundColor.clone();
        this._backgroundColor = value;
        this._backgroundColor.changesInterceptor = this;
        if (oldValue && !oldValue.equals(value)) {
            this.propertyChanged("backgroundColor", value, oldValue);
        }
    }
    get borderColor() {
        return this._borderColor;
    }
    set borderColor(value) {
        let oldValue = this._borderColor.clone();
        this._borderColor = value;
        this._borderColor.changesInterceptor = this;
        if (oldValue && !oldValue.equals(value)) {
            this.propertyChanged("borderColor", value, oldValue);
        }
    }
    get checkColor() {
        return this._checkColor;
    }
    set checkColor(value) {
        let oldValue = this._checkColor.clone();
        this._checkColor = value;
        this._checkColor.changesInterceptor = this;
        if (oldValue && !oldValue.equals(value)) {
            this.propertyChanged("checkColor", value, oldValue);
        }
    }
    get borderWeight() {
        return this._borderWeight;
    }
    set borderWeight(value) {
        let oldValue = this._borderWeight;
        this._borderWeight = value;
        if (oldValue != value) {
            this.propertyChanged("borderWeight", value, oldValue);
        }
    }
    get contentAlignment() {
        return this._contentAlignment;
    }
    set contentAlignment(value) {
        let oldValue = this._contentAlignment;
        this._contentAlignment = value;
        if (oldValue != value) {
            this.propertyChanged("contentAlignment", value, oldValue);
        }
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyColor("BackgroundColor", this.backgroundColor);
        json.addPropertyColor("BorderColor", this.borderColor);
        json.addPropertyColor("CheckColor", this.checkColor);
        json.addPropertyEnum("BorderWeight", StiLineWeight, this.borderWeight);
        json.addPropertyEnum("ContentAlignment", StiHorizontalAlignment, this.contentAlignment);
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "BackgroundColor":
                case "BackColor":
                    this._backgroundColor = new Color();
                    this._backgroundColor.changesInterceptor = this;
                    this._backgroundColor.propertyName = "backgroundColor";
                    this._backgroundColor.deserializeFromString(property.value);
                    break;
                case "BorderColor":
                    this._borderColor = new Color();
                    this._borderColor.changesInterceptor = this;
                    this._borderColor.propertyName = "borderColor";
                    this._borderColor.deserializeFromString(property.value);
                    break;
                case "CheckColor":
                    this._checkColor = new Color();
                    this._checkColor.changesInterceptor = this;
                    this._checkColor.propertyName = "checkColor";
                    this._checkColor.deserializeFromString(property.value);
                    break;
                case "BorderWeight":
                    this._borderWeight = Enum.parse(StiLineWeight, property.value);
                    break;
                case "contentAlignment":
                case "ContentAlignment":
                    this._contentAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RpSW5uZXJUZXh0U2V0dGluZ3MuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LWZvcm1zL3NyYy9saWIvZWxlbWVudHMvc2V0dGluZ3MvU3RpSW5uZXJUZXh0U2V0dGluZ3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxLQUFLLE1BQU0sb0JBQW9CLENBQUM7QUFDdkMsT0FBTyxFQUFFLElBQUksRUFBRSxNQUFNLG1CQUFtQixDQUFDO0FBQ3pDLE9BQU8sRUFBRSxzQkFBc0IsRUFBRSxhQUFhLEVBQUUsTUFBTSxvQkFBb0IsQ0FBQztBQUczRSxPQUFPLEVBQUUsc0JBQXNCLEVBQUUsTUFBTSwwQkFBMEIsQ0FBQztBQUVsRSxNQUFNLE9BQU8sb0JBQXFCLFNBQVEsc0JBQXNCO0lBTzlELFlBQW1CLGtCQUF5QztRQUMxRCxLQUFLLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQURULHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBdUI7UUFIbEQsa0JBQWEsR0FBa0IsYUFBYSxDQUFDLElBQUksQ0FBQztRQUNsRCxzQkFBaUIsR0FBMkIsc0JBQXNCLENBQUMsSUFBSSxDQUFDO1FBSWhGLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDdEMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztRQUNoRCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsWUFBWSxHQUFHLGlCQUFpQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFNBQVMsRUFBRSxDQUFDO1FBQ3RDLElBQUksQ0FBQyxZQUFZLENBQUMsa0JBQWtCLEdBQUcsSUFBSSxDQUFDO1FBQzVDLElBQUksQ0FBQyxZQUFZLENBQUMsWUFBWSxHQUFHLGFBQWEsQ0FBQztRQUMvQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUNqQyxJQUFJLENBQUMsV0FBVyxDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztRQUMzQyxJQUFJLENBQUMsV0FBVyxDQUFDLFlBQVksR0FBRyxZQUFZLENBQUM7UUFDN0MsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDNUIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7UUFDdEMsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLEdBQUcsRUFBRSxDQUFDO0lBQ3hCLENBQUM7SUFFRCxlQUFlLENBQUMsUUFBZ0IsRUFBRSxLQUFVLEVBQUUsU0FBYztRQUMxRCxJQUFJLENBQUMsa0JBQWtCLENBQUMsZUFBZSxDQUFDLGFBQWEsUUFBUSxFQUFFLEVBQUUsS0FBSyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0lBQ3JGLENBQUM7SUFFRCxJQUFJLGVBQWU7UUFDakIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUVELElBQUksZUFBZSxDQUFDLEtBQVk7UUFDOUIsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEtBQUssRUFBRSxDQUFDO1FBQzdDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUM7UUFDOUIsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztRQUNoRCxJQUFJLFFBQVEsSUFBSSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDdkMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxpQkFBaUIsRUFBRSxLQUFLLEVBQUUsUUFBUSxDQUFDLENBQUM7U0FDMUQ7SUFDSCxDQUFDO0lBRUQsSUFBSSxXQUFXO1FBQ2IsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFFRCxJQUFJLFdBQVcsQ0FBQyxLQUFZO1FBQzFCLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDekMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7UUFDMUIsSUFBSSxDQUFDLFlBQVksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7UUFDNUMsSUFBSSxRQUFRLElBQUksQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ3ZDLElBQUksQ0FBQyxlQUFlLENBQUMsYUFBYSxFQUFFLEtBQUssRUFBRSxRQUFRLENBQUMsQ0FBQztTQUN0RDtJQUNILENBQUM7SUFFRCxJQUFJLFVBQVU7UUFDWixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUVELElBQUksVUFBVSxDQUFDLEtBQVk7UUFDekIsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUN4QyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztRQUN6QixJQUFJLENBQUMsV0FBVyxDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztRQUMzQyxJQUFJLFFBQVEsSUFBSSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDdkMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxZQUFZLEVBQUUsS0FBSyxFQUFFLFFBQVEsQ0FBQyxDQUFDO1NBQ3JEO0lBQ0gsQ0FBQztJQUVELElBQUksWUFBWTtRQUNkLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQztJQUM1QixDQUFDO0lBRUQsSUFBSSxZQUFZLENBQUMsS0FBb0I7UUFDbkMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUNsQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztRQUMzQixJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxjQUFjLEVBQUUsS0FBSyxFQUFFLFFBQVEsQ0FBQyxDQUFDO1NBQ3ZEO0lBQ0gsQ0FBQztJQUNELElBQUksZ0JBQWdCO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFFRCxJQUFJLGdCQUFnQixDQUFDLEtBQTZCO1FBQ2hELElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztRQUN0QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDO1FBQy9CLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRTtZQUNyQixJQUFJLENBQUMsZUFBZSxDQUFDLGtCQUFrQixFQUFFLEtBQUssRUFBRSxRQUFRLENBQUMsQ0FBQztTQUMzRDtJQUNILENBQUM7SUFFTSxnQkFBZ0IsQ0FBQyxPQUFZO1FBQ2xDLElBQUksSUFBSSxHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUMzQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQy9ELElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQ3ZELElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3JELElBQUksQ0FBQyxlQUFlLENBQUMsY0FBYyxFQUFFLGFBQWEsRUFBRSxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDdkUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxrQkFBa0IsRUFBRSxzQkFBc0IsRUFBRSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztRQUN4RixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFTSxrQkFBa0IsQ0FBQyxJQUFhO1FBQ3JDLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMvQixLQUFLLElBQUksUUFBUSxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUUsRUFBRTtZQUN0QyxRQUFRLFFBQVEsQ0FBQyxJQUFJLEVBQUU7Z0JBQ3JCLEtBQUssaUJBQWlCLENBQUM7Z0JBQ3ZCLEtBQUssV0FBVztvQkFDZCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDcEMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztvQkFDaEQsSUFBSSxDQUFDLGdCQUFnQixDQUFDLFlBQVksR0FBRyxpQkFBaUIsQ0FBQztvQkFDdkQsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDNUQsTUFBTTtnQkFDUixLQUFLLGFBQWE7b0JBQ2hCLElBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDaEMsSUFBSSxDQUFDLFlBQVksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7b0JBQzVDLElBQUksQ0FBQyxZQUFZLENBQUMsWUFBWSxHQUFHLGFBQWEsQ0FBQztvQkFDL0MsSUFBSSxDQUFDLFlBQVksQ0FBQyxxQkFBcUIsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ3hELE1BQU07Z0JBQ1IsS0FBSyxZQUFZO29CQUNmLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDL0IsSUFBSSxDQUFDLFdBQVcsQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7b0JBQzNDLElBQUksQ0FBQyxXQUFXLENBQUMsWUFBWSxHQUFHLFlBQVksQ0FBQztvQkFDN0MsSUFBSSxDQUFDLFdBQVcsQ0FBQyxxQkFBcUIsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ3ZELE1BQU07Z0JBQ1IsS0FBSyxjQUFjO29CQUNqQixJQUFJLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxFQUFFLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDL0QsTUFBTTtnQkFDUixLQUFLLGtCQUFrQixDQUFDO2dCQUN4QixLQUFLLGtCQUFrQjtvQkFDckIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsc0JBQXNCLEVBQUUsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUM1RSxNQUFNO2FBQ1Q7U0FDRjtJQUNILENBQUM7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBDb2xvciBmcm9tIFwiLi4vLi4vc3lzdGVtL0NvbG9yXCI7XHJcbmltcG9ydCB7IEVudW0gfSBmcm9tIFwiLi4vLi4vc3lzdGVtL0VudW1cIjtcclxuaW1wb3J0IHsgU3RpSG9yaXpvbnRhbEFsaWdubWVudCwgU3RpTGluZVdlaWdodCB9IGZyb20gXCIuLi8uLi9zeXN0ZW0vZW51bXNcIjtcclxuaW1wb3J0IHsgU3RpQ2hhbmdlc0ludGVyY2VwdG9yIH0gZnJvbSBcIi4uLy4uL3N5c3RlbS9pbnRlcmZhY2VzXCI7XHJcbmltcG9ydCBTdGlKc29uIGZyb20gXCIuLi8uLi9zeXN0ZW0vU3RpSnNvblwiO1xyXG5pbXBvcnQgeyBTdGlEZXNjcmlwdGlvblNldHRpbmdzIH0gZnJvbSBcIi4vU3RpRGVzY3JpcHRpb25TZXR0aW5nc1wiO1xyXG5cclxuZXhwb3J0IGNsYXNzIFN0aUlubmVyVGV4dFNldHRpbmdzIGV4dGVuZHMgU3RpRGVzY3JpcHRpb25TZXR0aW5ncyB7XHJcbiAgcHJvdGVjdGVkIF9iYWNrZ3JvdW5kQ29sb3I6IENvbG9yO1xyXG4gIHByb3RlY3RlZCBfYm9yZGVyQ29sb3I6IENvbG9yO1xyXG4gIHByb3RlY3RlZCBfY2hlY2tDb2xvcjogQ29sb3I7XHJcbiAgcHJvdGVjdGVkIF9ib3JkZXJXZWlnaHQ6IFN0aUxpbmVXZWlnaHQgPSBTdGlMaW5lV2VpZ2h0LlRoaW47XHJcbiAgcHJvdGVjdGVkIF9jb250ZW50QWxpZ25tZW50OiBTdGlIb3Jpem9udGFsQWxpZ25tZW50ID0gU3RpSG9yaXpvbnRhbEFsaWdubWVudC5MZWZ0O1xyXG5cclxuICBjb25zdHJ1Y3RvcihwdWJsaWMgY2hhbmdlc0ludGVyY2VwdG9yOiBTdGlDaGFuZ2VzSW50ZXJjZXB0b3IpIHtcclxuICAgIHN1cGVyKGNoYW5nZXNJbnRlcmNlcHRvcik7XHJcbiAgICB0aGlzLl9iYWNrZ3JvdW5kQ29sb3IgPSBDb2xvci53aGl0ZSgpO1xyXG4gICAgdGhpcy5fYmFja2dyb3VuZENvbG9yLmNoYW5nZXNJbnRlcmNlcHRvciA9IHRoaXM7XHJcbiAgICB0aGlzLl9iYWNrZ3JvdW5kQ29sb3IucHJvcGVydHlOYW1lID0gXCJiYWNrZ3JvdW5kQ29sb3JcIjtcclxuICAgIHRoaXMuX2JvcmRlckNvbG9yID0gQ29sb3IubGlnaHRHcmF5KCk7XHJcbiAgICB0aGlzLl9ib3JkZXJDb2xvci5jaGFuZ2VzSW50ZXJjZXB0b3IgPSB0aGlzO1xyXG4gICAgdGhpcy5fYm9yZGVyQ29sb3IucHJvcGVydHlOYW1lID0gXCJib3JkZXJDb2xvclwiO1xyXG4gICAgdGhpcy5fY2hlY2tDb2xvciA9IENvbG9yLmJsYWNrKCk7XHJcbiAgICB0aGlzLl9jaGVja0NvbG9yLmNoYW5nZXNJbnRlcmNlcHRvciA9IHRoaXM7XHJcbiAgICB0aGlzLl9jaGVja0NvbG9yLnByb3BlcnR5TmFtZSA9IFwiY2hlY2tDb2xvclwiO1xyXG4gICAgdGhpcy5fY29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gICAgdGhpcy5fY29sb3IuY2hhbmdlc0ludGVyY2VwdG9yID0gdGhpcztcclxuICAgIHRoaXMuX2ZvbnQuX3NpemUgPSAxMDtcclxuICB9XHJcblxyXG4gIHByb3BlcnR5Q2hhbmdlZChwcm9wTmFtZTogc3RyaW5nLCB2YWx1ZTogYW55LCBvbGRPYmplY3Q6IGFueSkge1xyXG4gICAgdGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IucHJvcGVydHlDaGFuZ2VkKGBpbm5lclRleHQuJHtwcm9wTmFtZX1gLCB2YWx1ZSwgb2xkT2JqZWN0KTtcclxuICB9XHJcblxyXG4gIGdldCBiYWNrZ3JvdW5kQ29sb3IoKTogQ29sb3Ige1xyXG4gICAgcmV0dXJuIHRoaXMuX2JhY2tncm91bmRDb2xvcjtcclxuICB9XHJcblxyXG4gIHNldCBiYWNrZ3JvdW5kQ29sb3IodmFsdWU6IENvbG9yKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9iYWNrZ3JvdW5kQ29sb3IuY2xvbmUoKTtcclxuICAgIHRoaXMuX2JhY2tncm91bmRDb2xvciA9IHZhbHVlO1xyXG4gICAgdGhpcy5fYmFja2dyb3VuZENvbG9yLmNoYW5nZXNJbnRlcmNlcHRvciA9IHRoaXM7XHJcbiAgICBpZiAob2xkVmFsdWUgJiYgIW9sZFZhbHVlLmVxdWFscyh2YWx1ZSkpIHtcclxuICAgICAgdGhpcy5wcm9wZXJ0eUNoYW5nZWQoXCJiYWNrZ3JvdW5kQ29sb3JcIiwgdmFsdWUsIG9sZFZhbHVlKTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIGdldCBib3JkZXJDb2xvcigpOiBDb2xvciB7XHJcbiAgICByZXR1cm4gdGhpcy5fYm9yZGVyQ29sb3I7XHJcbiAgfVxyXG5cclxuICBzZXQgYm9yZGVyQ29sb3IodmFsdWU6IENvbG9yKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9ib3JkZXJDb2xvci5jbG9uZSgpO1xyXG4gICAgdGhpcy5fYm9yZGVyQ29sb3IgPSB2YWx1ZTtcclxuICAgIHRoaXMuX2JvcmRlckNvbG9yLmNoYW5nZXNJbnRlcmNlcHRvciA9IHRoaXM7XHJcbiAgICBpZiAob2xkVmFsdWUgJiYgIW9sZFZhbHVlLmVxdWFscyh2YWx1ZSkpIHtcclxuICAgICAgdGhpcy5wcm9wZXJ0eUNoYW5nZWQoXCJib3JkZXJDb2xvclwiLCB2YWx1ZSwgb2xkVmFsdWUpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgZ2V0IGNoZWNrQ29sb3IoKTogQ29sb3Ige1xyXG4gICAgcmV0dXJuIHRoaXMuX2NoZWNrQ29sb3I7XHJcbiAgfVxyXG5cclxuICBzZXQgY2hlY2tDb2xvcih2YWx1ZTogQ29sb3IpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2NoZWNrQ29sb3IuY2xvbmUoKTtcclxuICAgIHRoaXMuX2NoZWNrQ29sb3IgPSB2YWx1ZTtcclxuICAgIHRoaXMuX2NoZWNrQ29sb3IuY2hhbmdlc0ludGVyY2VwdG9yID0gdGhpcztcclxuICAgIGlmIChvbGRWYWx1ZSAmJiAhb2xkVmFsdWUuZXF1YWxzKHZhbHVlKSkge1xyXG4gICAgICB0aGlzLnByb3BlcnR5Q2hhbmdlZChcImNoZWNrQ29sb3JcIiwgdmFsdWUsIG9sZFZhbHVlKTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIGdldCBib3JkZXJXZWlnaHQoKTogU3RpTGluZVdlaWdodCB7XHJcbiAgICByZXR1cm4gdGhpcy5fYm9yZGVyV2VpZ2h0O1xyXG4gIH1cclxuXHJcbiAgc2V0IGJvcmRlcldlaWdodCh2YWx1ZTogU3RpTGluZVdlaWdodCkge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fYm9yZGVyV2VpZ2h0O1xyXG4gICAgdGhpcy5fYm9yZGVyV2VpZ2h0ID0gdmFsdWU7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5wcm9wZXJ0eUNoYW5nZWQoXCJib3JkZXJXZWlnaHRcIiwgdmFsdWUsIG9sZFZhbHVlKTtcclxuICAgIH1cclxuICB9XHJcbiAgZ2V0IGNvbnRlbnRBbGlnbm1lbnQoKTogU3RpSG9yaXpvbnRhbEFsaWdubWVudCB7XHJcbiAgICByZXR1cm4gdGhpcy5fY29udGVudEFsaWdubWVudDtcclxuICB9XHJcblxyXG4gIHNldCBjb250ZW50QWxpZ25tZW50KHZhbHVlOiBTdGlIb3Jpem9udGFsQWxpZ25tZW50KSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9jb250ZW50QWxpZ25tZW50O1xyXG4gICAgdGhpcy5fY29udGVudEFsaWdubWVudCA9IHZhbHVlO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMucHJvcGVydHlDaGFuZ2VkKFwiY29udGVudEFsaWdubWVudFwiLCB2YWx1ZSwgb2xkVmFsdWUpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIHNhdmVUb0pzb25PYmplY3Qob3B0aW9uczogYW55KTogU3RpSnNvbiB7XHJcbiAgICBsZXQganNvbiA9IHN1cGVyLnNhdmVUb0pzb25PYmplY3Qob3B0aW9ucyk7XHJcbiAgICBqc29uLmFkZFByb3BlcnR5Q29sb3IoXCJCYWNrZ3JvdW5kQ29sb3JcIiwgdGhpcy5iYWNrZ3JvdW5kQ29sb3IpO1xyXG4gICAganNvbi5hZGRQcm9wZXJ0eUNvbG9yKFwiQm9yZGVyQ29sb3JcIiwgdGhpcy5ib3JkZXJDb2xvcik7XHJcbiAgICBqc29uLmFkZFByb3BlcnR5Q29sb3IoXCJDaGVja0NvbG9yXCIsIHRoaXMuY2hlY2tDb2xvcik7XHJcbiAgICBqc29uLmFkZFByb3BlcnR5RW51bShcIkJvcmRlcldlaWdodFwiLCBTdGlMaW5lV2VpZ2h0LCB0aGlzLmJvcmRlcldlaWdodCk7XHJcbiAgICBqc29uLmFkZFByb3BlcnR5RW51bShcIkNvbnRlbnRBbGlnbm1lbnRcIiwgU3RpSG9yaXpvbnRhbEFsaWdubWVudCwgdGhpcy5jb250ZW50QWxpZ25tZW50KTtcclxuICAgIHJldHVybiBqc29uO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGxvYWRGcm9tSnNvbk9iamVjdChqc29uOiBTdGlKc29uKSB7XHJcbiAgICBzdXBlci5sb2FkRnJvbUpzb25PYmplY3QoanNvbik7XHJcbiAgICBmb3IgKGxldCBwcm9wZXJ0eSBvZiBqc29uLnByb3BlcnRpZXMoKSkge1xyXG4gICAgICBzd2l0Y2ggKHByb3BlcnR5Lm5hbWUpIHtcclxuICAgICAgICBjYXNlIFwiQmFja2dyb3VuZENvbG9yXCI6XHJcbiAgICAgICAgY2FzZSBcIkJhY2tDb2xvclwiOlxyXG4gICAgICAgICAgdGhpcy5fYmFja2dyb3VuZENvbG9yID0gbmV3IENvbG9yKCk7XHJcbiAgICAgICAgICB0aGlzLl9iYWNrZ3JvdW5kQ29sb3IuY2hhbmdlc0ludGVyY2VwdG9yID0gdGhpcztcclxuICAgICAgICAgIHRoaXMuX2JhY2tncm91bmRDb2xvci5wcm9wZXJ0eU5hbWUgPSBcImJhY2tncm91bmRDb2xvclwiO1xyXG4gICAgICAgICAgdGhpcy5fYmFja2dyb3VuZENvbG9yLmRlc2VyaWFsaXplRnJvbVN0cmluZyhwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiQm9yZGVyQ29sb3JcIjpcclxuICAgICAgICAgIHRoaXMuX2JvcmRlckNvbG9yID0gbmV3IENvbG9yKCk7XHJcbiAgICAgICAgICB0aGlzLl9ib3JkZXJDb2xvci5jaGFuZ2VzSW50ZXJjZXB0b3IgPSB0aGlzO1xyXG4gICAgICAgICAgdGhpcy5fYm9yZGVyQ29sb3IucHJvcGVydHlOYW1lID0gXCJib3JkZXJDb2xvclwiO1xyXG4gICAgICAgICAgdGhpcy5fYm9yZGVyQ29sb3IuZGVzZXJpYWxpemVGcm9tU3RyaW5nKHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJDaGVja0NvbG9yXCI6XHJcbiAgICAgICAgICB0aGlzLl9jaGVja0NvbG9yID0gbmV3IENvbG9yKCk7XHJcbiAgICAgICAgICB0aGlzLl9jaGVja0NvbG9yLmNoYW5nZXNJbnRlcmNlcHRvciA9IHRoaXM7XHJcbiAgICAgICAgICB0aGlzLl9jaGVja0NvbG9yLnByb3BlcnR5TmFtZSA9IFwiY2hlY2tDb2xvclwiO1xyXG4gICAgICAgICAgdGhpcy5fY2hlY2tDb2xvci5kZXNlcmlhbGl6ZUZyb21TdHJpbmcocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkJvcmRlcldlaWdodFwiOlxyXG4gICAgICAgICAgdGhpcy5fYm9yZGVyV2VpZ2h0ID0gRW51bS5wYXJzZShTdGlMaW5lV2VpZ2h0LCBwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiY29udGVudEFsaWdubWVudFwiOlxyXG4gICAgICAgIGNhc2UgXCJDb250ZW50QWxpZ25tZW50XCI6XHJcbiAgICAgICAgICB0aGlzLl9jb250ZW50QWxpZ25tZW50ID0gRW51bS5wYXJzZShTdGlIb3Jpem9udGFsQWxpZ25tZW50LCBwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxufVxyXG4iXX0=