import Color from "../../system/Color";
import { Font } from "../../system/Font";
import StiJson from "../../system/StiJson";
export class StiDescriptionSettings {
    constructor(changesInterceptor) {
        this.changesInterceptor = changesInterceptor;
        this._font = new Font("Segoe UI", 9, [], this);
        this._color = Color.gray();
        this._color.changesInterceptor = this;
    }
    propertyChanged(propName, value, oldObject) {
        this.changesInterceptor.propertyChanged(`description.${propName}`, value, oldObject);
    }
    get color() {
        return this._color;
    }
    set color(value) {
        let oldValue = this._color.clone();
        this._color = value;
        value.changesInterceptor = this;
        if (oldValue && !oldValue.equals(value)) {
            this.propertyChanged("color", value, oldValue);
        }
    }
    get font() {
        return this._font;
    }
    set font(value) {
        let oldValue = this._font;
        this._font = value;
        if (oldValue && oldValue.equals(oldValue)) {
            this._font.changesInterceptor = this;
        }
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        json.addPropertyColor("Color", this.color);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Font":
                    this._font = new Font("Segoe UI", 9, [], this);
                    this._font.loadFromJsonObject(property.value);
                    break;
                case "Color":
                    this._color = new Color();
                    this._color.changesInterceptor = this;
                    this._color.deserializeFromString(property.value);
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RpRGVzY3JpcHRpb25TZXR0aW5ncy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9lbGVtZW50cy9zZXR0aW5ncy9TdGlEZXNjcmlwdGlvblNldHRpbmdzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sS0FBSyxNQUFNLG9CQUFvQixDQUFDO0FBQ3ZDLE9BQU8sRUFBRSxJQUFJLEVBQUUsTUFBTSxtQkFBbUIsQ0FBQztBQUV6QyxPQUFPLE9BQU8sTUFBTSxzQkFBc0IsQ0FBQztBQUUzQyxNQUFNLE9BQU8sc0JBQXNCO0lBSWpDLFlBQW1CLGtCQUF5QztRQUF6Qyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQXVCO1FBSGxELFVBQUssR0FBUyxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQyxFQUFFLEVBQUUsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUl4RCxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQyxJQUFJLEVBQUUsQ0FBQztRQUMzQixJQUFJLENBQUMsTUFBTSxDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztJQUN4QyxDQUFDO0lBRUQsZUFBZSxDQUFDLFFBQWdCLEVBQUUsS0FBVSxFQUFFLFNBQWM7UUFDMUQsSUFBSSxDQUFDLGtCQUFrQixDQUFDLGVBQWUsQ0FBQyxlQUFlLFFBQVEsRUFBRSxFQUFFLEtBQUssRUFBRSxTQUFTLENBQUMsQ0FBQztJQUN2RixDQUFDO0lBRUQsSUFBSSxLQUFLO1FBQ1AsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDO0lBQ3JCLENBQUM7SUFFRCxJQUFJLEtBQUssQ0FBQyxLQUFZO1FBQ3BCLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDbkMsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUM7UUFDcEIsS0FBSyxDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztRQUNoQyxJQUFJLFFBQVEsSUFBSSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDdkMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxPQUFPLEVBQUUsS0FBSyxFQUFFLFFBQVEsQ0FBQyxDQUFDO1NBQ2hEO0lBQ0gsQ0FBQztJQUVELElBQUksSUFBSTtRQUNOLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBRUQsSUFBSSxJQUFJLENBQUMsS0FBVztRQUNsQixJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1FBQzFCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksUUFBUSxJQUFJLFFBQVEsQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLEVBQUU7WUFDekMsSUFBSSxDQUFDLEtBQUssQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7U0FDdEM7SUFDSCxDQUFDO0lBRU0sZ0JBQWdCLENBQUMsT0FBWTtRQUNsQyxJQUFJLElBQUksR0FBRyxJQUFJLE9BQU8sRUFBRSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1FBQ3JFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzNDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVNLGtCQUFrQixDQUFDLElBQWE7UUFDckMsS0FBSyxJQUFJLFFBQVEsSUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFLEVBQUU7WUFDdEMsUUFBUSxRQUFRLENBQUMsSUFBSSxFQUFFO2dCQUNyQixLQUFLLE1BQU07b0JBQ1QsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQyxFQUFFLEVBQUUsRUFBRSxJQUFJLENBQUMsQ0FBQztvQkFDL0MsSUFBSSxDQUFDLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQzlDLE1BQU07Z0JBQ1IsS0FBSyxPQUFPO29CQUNWLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDMUIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7b0JBQ3RDLElBQUksQ0FBQyxNQUFNLENBQUMscUJBQXFCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUNsRCxNQUFNO2FBQ1Q7U0FDRjtJQUNILENBQUM7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBDb2xvciBmcm9tIFwiLi4vLi4vc3lzdGVtL0NvbG9yXCI7XHJcbmltcG9ydCB7IEZvbnQgfSBmcm9tIFwiLi4vLi4vc3lzdGVtL0ZvbnRcIjtcclxuaW1wb3J0IHsgU3RpQ2hhbmdlc0ludGVyY2VwdG9yIH0gZnJvbSBcIi4uLy4uL3N5c3RlbS9pbnRlcmZhY2VzXCI7XHJcbmltcG9ydCBTdGlKc29uIGZyb20gXCIuLi8uLi9zeXN0ZW0vU3RpSnNvblwiO1xyXG5cclxuZXhwb3J0IGNsYXNzIFN0aURlc2NyaXB0aW9uU2V0dGluZ3MgaW1wbGVtZW50cyBTdGlDaGFuZ2VzSW50ZXJjZXB0b3Ige1xyXG4gIHByb3RlY3RlZCBfZm9udDogRm9udCA9IG5ldyBGb250KFwiU2Vnb2UgVUlcIiwgOSwgW10sIHRoaXMpO1xyXG4gIHByb3RlY3RlZCBfY29sb3I6IENvbG9yO1xyXG5cclxuICBjb25zdHJ1Y3RvcihwdWJsaWMgY2hhbmdlc0ludGVyY2VwdG9yOiBTdGlDaGFuZ2VzSW50ZXJjZXB0b3IpIHtcclxuICAgIHRoaXMuX2NvbG9yID0gQ29sb3IuZ3JheSgpO1xyXG4gICAgdGhpcy5fY29sb3IuY2hhbmdlc0ludGVyY2VwdG9yID0gdGhpcztcclxuICB9XHJcblxyXG4gIHByb3BlcnR5Q2hhbmdlZChwcm9wTmFtZTogc3RyaW5nLCB2YWx1ZTogYW55LCBvbGRPYmplY3Q6IGFueSkge1xyXG4gICAgdGhpcy5jaGFuZ2VzSW50ZXJjZXB0b3IucHJvcGVydHlDaGFuZ2VkKGBkZXNjcmlwdGlvbi4ke3Byb3BOYW1lfWAsIHZhbHVlLCBvbGRPYmplY3QpO1xyXG4gIH1cclxuXHJcbiAgZ2V0IGNvbG9yKCk6IENvbG9yIHtcclxuICAgIHJldHVybiB0aGlzLl9jb2xvcjtcclxuICB9XHJcblxyXG4gIHNldCBjb2xvcih2YWx1ZTogQ29sb3IpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2NvbG9yLmNsb25lKCk7XHJcbiAgICB0aGlzLl9jb2xvciA9IHZhbHVlO1xyXG4gICAgdmFsdWUuY2hhbmdlc0ludGVyY2VwdG9yID0gdGhpcztcclxuICAgIGlmIChvbGRWYWx1ZSAmJiAhb2xkVmFsdWUuZXF1YWxzKHZhbHVlKSkge1xyXG4gICAgICB0aGlzLnByb3BlcnR5Q2hhbmdlZChcImNvbG9yXCIsIHZhbHVlLCBvbGRWYWx1ZSk7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBnZXQgZm9udCgpOiBGb250IHtcclxuICAgIHJldHVybiB0aGlzLl9mb250O1xyXG4gIH1cclxuXHJcbiAgc2V0IGZvbnQodmFsdWU6IEZvbnQpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2ZvbnQ7XHJcbiAgICB0aGlzLl9mb250ID0gdmFsdWU7XHJcbiAgICBpZiAob2xkVmFsdWUgJiYgb2xkVmFsdWUuZXF1YWxzKG9sZFZhbHVlKSkge1xyXG4gICAgICB0aGlzLl9mb250LmNoYW5nZXNJbnRlcmNlcHRvciA9IHRoaXM7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zOiBhbnkpOiBTdGlKc29uIHtcclxuICAgIGxldCBqc29uID0gbmV3IFN0aUpzb24oKTtcclxuICAgIGpzb24uYWRkUHJvcGVydHlKT2JqZWN0KFwiRm9udFwiLCB0aGlzLmZvbnQuc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zKSk7XHJcbiAgICBqc29uLmFkZFByb3BlcnR5Q29sb3IoXCJDb2xvclwiLCB0aGlzLmNvbG9yKTtcclxuICAgIHJldHVybiBqc29uO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGxvYWRGcm9tSnNvbk9iamVjdChqc29uOiBTdGlKc29uKSB7XHJcbiAgICBmb3IgKGxldCBwcm9wZXJ0eSBvZiBqc29uLnByb3BlcnRpZXMoKSkge1xyXG4gICAgICBzd2l0Y2ggKHByb3BlcnR5Lm5hbWUpIHtcclxuICAgICAgICBjYXNlIFwiRm9udFwiOlxyXG4gICAgICAgICAgdGhpcy5fZm9udCA9IG5ldyBGb250KFwiU2Vnb2UgVUlcIiwgOSwgW10sIHRoaXMpO1xyXG4gICAgICAgICAgdGhpcy5fZm9udC5sb2FkRnJvbUpzb25PYmplY3QocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkNvbG9yXCI6XHJcbiAgICAgICAgICB0aGlzLl9jb2xvciA9IG5ldyBDb2xvcigpO1xyXG4gICAgICAgICAgdGhpcy5fY29sb3IuY2hhbmdlc0ludGVyY2VwdG9yID0gdGhpcztcclxuICAgICAgICAgIHRoaXMuX2NvbG9yLmRlc2VyaWFsaXplRnJvbVN0cmluZyhwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgfVxyXG4gICAgfVxyXG4gIH1cclxufVxyXG4iXX0=