import { StiBorder } from "../properties/StiBorder";
import { StiPen } from "../properties/StiPen";
import StiRectangleGeometry from "../properties/StiRectangleGeometry";
import Color from "../system/Color";
import { Enum } from "../system/Enum";
import { StiTextHorAlignment, StiHorizontalAlignment } from "../system/enums";
import { StiFormElement } from "./base/StiFormElement";
export class StiTextElement extends StiFormElement {
    constructor() {
        super();
        this.type = "TextElement";
        this.htmlTextString = "";
        this.textColor = Color.black();
        this.textHorizontalAlignment = StiTextHorAlignment.Left;
        this.border = new StiBorder(StiPen.dimGraySolid(), false, false, false, false);
        this.showBorderEditor = true;
        this.geometry = new StiRectangleGeometry(100, 35);
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyString("HtmlTextString", this.htmlTextString);
        jObject.addPropertyEnum("TextHorizontalAlignment", StiTextHorAlignment, this.textHorizontalAlignment);
        jObject.addPropertyJObject("Border", this.border.saveToJsonObject(options));
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "HtmlTextString":
                    this.htmlTextString = property.value;
                    break;
                case "TextHorizontalAlignment":
                    this.textHorizontalAlignment = Enum.parse(StiTextHorAlignment, property.value);
                    break;
                case "Border":
                    this.border = new StiBorder();
                    this.border.loadFromJsonObject(property.value);
                    break;
            }
        }
        this.isAdded = true;
    }
    htmlStyle() {
        return `color:${this.textColor.toHtmlColor()};text-align:${Enum.getName(StiHorizontalAlignment, this.textHorizontalAlignment)}`;
    }
}
//# sourceMappingURL=data:application/json;base64,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