import StiInnerBorder from "../properties/StiInnerBorder";
import { StiBorder } from "../properties/StiBorder";
import { StiPen } from "../properties/StiPen";
import StiRectangleGeometry from "../properties/StiRectangleGeometry";
import { StiLocalizationService } from "../services/sti-localization.service";
import Color from "../system/Color";
import { Enum } from "../system/Enum";
import { StiHorizontalAlignment, StiVerticalAlignment, StiLabelAlignment, } from "../system/enums";
import { Font } from "../system/Font";
import { StiFormElement } from "./base/StiFormElement";
import { StiCheckBoxCellItem } from "./table/cells/StiCheckBoxCellItem";
import { StiComboBoxCellItem } from "./table/cells/StiComboBoxCellItem";
import { StiNumberBoxCellItem } from "./table/cells/StiNumberBoxCellItem";
import { StiRadioButtonCellItem } from "./table/cells/StiRadioButtonCellItem";
import { StiTextBoxCellItem } from "./table/cells/StiTextBoxCellItem";
import { StiCheckBoxColumnItem } from "./table/columns/StiCheckBoxColumnItem";
import { StiComboBoxColumnItem } from "./table/columns/StiComboBoxColumnItem";
import { StiLabelColumnItem } from "./table/columns/StiLabelColumnItem";
import { StiNumberBoxColumnItem } from "./table/columns/StiNumberBoxColumnItem";
import { StiRadioButtonColumnItem } from "./table/columns/StiRadioButtonColumnItem";
import { StiTextBoxColumnItem } from "./table/columns/StiTextBoxColumnItem";
import { StiColumnItem } from "./table/StiColumnItem";
import { StiRowLabel } from "./table/StiRowLabel";
import { StiTotalsFieldItem } from "./table/StiTotalsFieldItem";
import { StiTotalsRowHeaderEditableContent } from "./table/StiTotalsRowHeaderEditableContent";
import { StiLabelItem } from "./text/StiLabelItem";
import { StiTextItem } from "./text/StiTextItem";
import { StiInputTextItem } from "../helper/StiInputTextItem";
export class StiTableElement extends StiFormElement {
    constructor() {
        super();
        this.type = "TableElement";
        this.description = new StiTextItem();
        this.font = new Font("Segoe UI", 10);
        this.border = new StiBorder(StiPen.dimGraySolid(), true, true, true, true);
        this.gridLines = new StiInnerBorder(StiPen.dimGraySolid(), true, true);
        this.backgroundColor = Color.transparent();
        this.alternateRowColors = false;
        this.evenRowsStyle = Color.fromArgb(0xff, 0xf9, 0xf9, 0xf9);
        this.evenRowsTextColor = Color.black();
        this.oddRowsStyle = Color.fromArgb(0xff, 0xf3, 0xf3, 0xf3);
        this.oddRowsTextColor = Color.black();
        this.tableHeaderText = "";
        this.tableHeaderAlignment = StiHorizontalAlignment.Left;
        this.tableHeaderColor = Color.black();
        this.tableHeaderHeight = 0;
        this.tableHeaderBackgroundColor = Color.transparent();
        this.rowLabelsWidth = 100;
        this._showRowLabels = true;
        this.dynamicRows = false;
        this.useWordWrap = false;
        this.rowLabelsContentEditable = [];
        this.rowLabelsHorizontalAlignment = StiHorizontalAlignment.Left;
        this.rowHeadersBackground = Color.transparent();
        this.rowHeadersColor = Color.black();
        this.rowHeadersBorder = new StiBorder(StiPen.dimGraySolid(), true, true, true, true);
        this.columnHeadersBorder = new StiBorder(StiPen.dimGraySolid(), true, true, true, true);
        this._columns = [];
        this.useTotals = true;
        this.totalsRowHeader = StiLocalizationService.get("PropertyMain", "Totals");
        this.totalsRowHeaderHorizontalAlignment = StiHorizontalAlignment.Left;
        this.totalsRowHeaderVerticalAlignment = StiVerticalAlignment.Top;
        this.totalsRowHeaderColor = Color.black();
        this._totalsValuesWidth = 100;
        this._totalsHeadersWidth = 100;
        this.totalsFields = [];
        this.showBorderEditor = false;
        this.showGridLinesEditor = false;
        this._showHeaderEditor = true;
        this._showColumnsEditor = false;
        this._showRowsEditor = false;
        this._showTotalsEditor = false;
        this.stopFit = false;
        this.showColumnsBorderEditor = true;
        this.showRowsBorderEditor = false;
        this.minColumnWidth = 40;
        this.totalsRowHeaderEditableContent = new StiTotalsRowHeaderEditableContent(this);
        this.geometry = new StiRectangleGeometry(320, 245);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Components", "StiTable"));
        this.columns = [];
        this.columns.push(new StiCheckBoxColumnItem(StiLocalizationService.get("PropertyMain", "First")));
        this.columns.push(new StiComboBoxColumnItem(StiLocalizationService.get("PropertyMain", "Second")));
        this.columns.push(new StiRadioButtonColumnItem(StiLocalizationService.get("PropertyMain", "Third")));
        this.columns.push(new StiTextBoxColumnItem(StiLocalizationService.get("PropertyMain", "Fourth")));
        this.columns.push(new StiNumberBoxColumnItem(StiLocalizationService.get("PropertyMain", "Fifth")));
        this.columns.push(new StiLabelColumnItem(StiLocalizationService.get("PropertyMain", "Labels")));
        this.rowLabels = [];
        this.rowLabels.push(StiLocalizationService.get("PropertyMain", "First"));
        this.rowLabels.push(StiLocalizationService.get("PropertyMain", "Second"));
        this.rowLabels.push(StiLocalizationService.get("PropertyMain", "Third"));
        this.totalsFields.push(new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "First"), "{Cell(5,1)}"));
        this.totalsFields.push(new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "Maximum"), "{Max(Col(5))}"));
        this.totalsFields.push(new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "Summary"), "{Sum(Col(5))}"));
        this.totalsFields.push(new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "Count"), "{Count(Col(5))}"));
        this.columns.forEach((column) => {
            if (column.type == "CheckBoxColumn" && column instanceof StiCheckBoxColumnItem) {
                this.rowLabels.forEach((row) => {
                    column.cells.push(new StiCheckBoxCellItem("", false));
                });
            }
            else if (column.type == "ComboBoxColumn" && column instanceof StiComboBoxColumnItem) {
                column.comboBoxOptions.push("yes");
                column.comboBoxOptions.push("no");
                this.rowLabels.forEach((row) => {
                    column.cells.push(new StiComboBoxCellItem("", 0));
                });
            }
            else if (column.type == "RadioButtonColumn" && column instanceof StiRadioButtonColumnItem) {
                this.rowLabels.forEach((row) => {
                    column.cells.push(new StiRadioButtonCellItem("", false));
                });
            }
            else if (column.type == "TextBoxColumn" && column instanceof StiTextBoxColumnItem) {
                this.rowLabels.forEach((row) => {
                    column.cells.push(new StiTextBoxCellItem("", ""));
                });
            }
            else if (column.type == "NumberBoxColumn" && column instanceof StiNumberBoxColumnItem) {
                this.rowLabels.forEach((row) => {
                    column.cells.push(new StiNumberBoxCellItem("", 0));
                });
            }
            else if (column.type == "LabelColumn" && column instanceof StiLabelColumnItem) {
                this.rowLabels.forEach((row) => {
                    column.cells.push("");
                });
            }
        });
    }
    get showRowLabels() {
        return this._showRowLabels;
    }
    set showRowLabels(value) {
        let previousValue = this._showRowLabels;
        if (previousValue != value) {
            this._showRowLabels = value;
            this.fitTable();
        }
    }
    get showHeaderEditor() {
        return this._showHeaderEditor;
    }
    set showHeaderEditor(value) {
        this._showHeaderEditor = value;
        if (value == true) {
            this._showColumnsEditor = false;
            this._showRowsEditor = false;
            this._showTotalsEditor = false;
        }
    }
    get totalsValuesWidth() {
        return this._totalsValuesWidth;
    }
    set totalsValuesWidth(value) {
        if (value > 0) {
            this._totalsValuesWidth = value;
        }
        else {
            this._totalsValuesWidth = 0;
        }
    }
    get totalsHeadersWidth() {
        return this._totalsHeadersWidth;
    }
    set totalsHeadersWidth(value) {
        if (value > 0) {
            this._totalsHeadersWidth = value;
        }
        else {
            this._totalsHeadersWidth = 0;
        }
    }
    get showColumnsEditor() {
        return this._showColumnsEditor;
    }
    set showColumnsEditor(value) {
        this._showColumnsEditor = value;
        if (value == true) {
            this._showHeaderEditor = false;
            this._showRowsEditor = false;
            this._showTotalsEditor = false;
        }
    }
    get showRowsEditor() {
        return this._showRowsEditor;
    }
    set showRowsEditor(value) {
        this._showRowsEditor = value;
        if (value == true) {
            this._showHeaderEditor = false;
            this._showColumnsEditor = false;
            this._showTotalsEditor = false;
        }
    }
    get showTotalsEditor() {
        return this._showTotalsEditor;
    }
    set showTotalsEditor(value) {
        this._showTotalsEditor = value;
        if (value == true) {
            this._showHeaderEditor = false;
            this._showColumnsEditor = false;
            this._showRowsEditor = false;
        }
    }
    getDefaultEditableContent() {
        let textItem = new StiInputTextItem("", this.font);
        textItem.element = this;
        return textItem;
    }
    setTabIndex(value) {
        this.tabIndex = value;
        return value + (this.columns?.length * this._rowLabels?.length ?? 0);
    }
    get maxTableWidth() {
        return (this.width -
            this.padding.left -
            this.padding.right -
            (this.label.alignment != StiLabelAlignment.Top && this.label.value.length > 0 ? this.label.width : 0));
    }
    set rowLabels(value) {
        this.nativeRowLabels = value;
        let this_ = this;
        this._rowLabels = new Proxy(value, {
            deleteProperty: function (target, property) {
                setTimeout(() => {
                    this_.updateRowLabelsContentEditable();
                }, 0);
                return true;
            },
            set: function (target, property, value, receiver) {
                target[property] = value;
                this_.updateRowLabelsContentEditable();
                return true;
            },
        });
        this.updateRowLabelsContentEditable();
    }
    get rowLabels() {
        return this._rowLabels;
    }
    setDefaultValues() {
        this.columns.forEach((column) => {
            column.setDefaultValues();
        });
        this.totalsFields.forEach((total) => {
            total.setDefaultValues();
        });
    }
    set columns(value) {
        let this_ = this;
        this._columns = new Proxy(value, {
            deleteProperty: function (target, property) {
                setTimeout(() => {
                    this_.fitTable();
                }, 0);
                return true;
            },
            set: function (target, property, value, receiver) {
                target[property] = value;
                let column = value;
                if (column instanceof StiColumnItem && !column.width) {
                    column.width = this_.maxTableWidth / (this_.columns.length + (this_.showRowLabels ? 1 : 0));
                }
                if (!target.stopFit) {
                    this_.fitTable();
                }
                return true;
            },
        });
        this_.fitTable();
    }
    fitTable() {
        if (this.stopFit) {
            return;
        }
        let currentWidth = this.showRowLabels ? this.rowLabelsWidth : 0;
        this.columns.forEach((c) => (currentWidth += c.width));
        let pc = this.maxTableWidth / currentWidth;
        if (currentWidth != 0 && currentWidth && pc) {
            if (this.showRowLabels) {
                this.rowLabelsWidth *= pc;
            }
            this.columns.forEach((c) => (c.width *= pc));
        }
        pc = this.maxTableWidth / (this.totalsHeadersWidth + this.totalsValuesWidth);
        if (pc < 1) {
            this.totalsHeadersWidth *= pc;
            this.totalsValuesWidth *= pc;
        }
    }
    deleteLastRow() {
        this.rowLabels.splice(this.rowLabels.length - 1, 1);
    }
    deleteLastColumn() {
        this.columns.splice(this.columns.length - 1, 1);
    }
    addColumn() {
        let newColumnWidth = (this.maxTableWidth - this.rowLabelsWidth) / (this.columns.length + 1);
        let maxChangeableWidth = 0;
        if (this.columns.length > 0) {
            this.columns.forEach((column) => {
                if (column.width > this.minColumnWidth) {
                    maxChangeableWidth += column.width - this.minColumnWidth;
                }
            });
        }
        else {
            maxChangeableWidth = this.maxTableWidth - this.rowLabelsWidth;
        }
        if (newColumnWidth <= maxChangeableWidth) {
            let lastColumn = this.columns[this.columns.length - 1];
            if (lastColumn) {
                if (lastColumn.type == "CheckBoxColumn") {
                    this.columns.push(new StiCheckBoxColumnItem(""));
                }
                else if (lastColumn.type == "ComboBoxColumn") {
                    this.columns.push(new StiComboBoxColumnItem(""));
                }
                else if (lastColumn.type == "NumberBoxColumn") {
                    this.columns.push(new StiNumberBoxColumnItem(""));
                }
                else if (lastColumn.type == "RadioButtonColumn") {
                    this.columns.push(new StiRadioButtonColumnItem(""));
                }
                else if (lastColumn.type == "TextBoxColumn") {
                    this.columns.push(new StiTextBoxColumnItem(""));
                }
                else if (lastColumn.type == "LabelColumn") {
                    this.columns.push(new StiLabelColumnItem(""));
                }
            }
            else {
                this.columns.push(new StiCheckBoxColumnItem(""));
            }
            let newColumn = this.columns[this.columns.length - 1];
            this.rowLabels.forEach(() => {
                if (newColumn.type == "CheckBoxColumn" && newColumn instanceof StiCheckBoxColumnItem) {
                    newColumn.cells.push(new StiCheckBoxCellItem("", false));
                }
                else if (newColumn.type == "ComboBoxColumn" && newColumn instanceof StiComboBoxColumnItem) {
                    newColumn.cells.push(new StiComboBoxCellItem("", 0));
                }
                else if (newColumn.type == "RadioButtonColumn" && newColumn instanceof StiRadioButtonColumnItem) {
                    newColumn.cells.push(new StiRadioButtonCellItem("", false));
                }
                else if (newColumn.type == "TextBoxColumn" && newColumn instanceof StiTextBoxColumnItem) {
                    newColumn.cells.push(new StiTextBoxCellItem("", ""));
                }
                else if (newColumn.type == "NumberBoxColumn" && newColumn instanceof StiNumberBoxColumnItem) {
                    newColumn.cells.push(new StiNumberBoxCellItem("", 0));
                }
                else if (newColumn.type == "LabelColumn" && newColumn instanceof StiLabelColumnItem) {
                    newColumn.cells.push("");
                }
            });
            if (lastColumn) {
                this.setColumnProperty(lastColumn, newColumn);
            }
        }
    }
    setColumnProperty(lastColumn, newColumn) {
        newColumn.horizontalAlignment = Enum.parse(StiHorizontalAlignment, lastColumn.horizontalAlignment);
        newColumn.backgroundColor = lastColumn.backgroundColor.clone();
        newColumn.cellBackColor = lastColumn.cellBackColor.clone();
        newColumn.cellForeColor = lastColumn.cellForeColor.clone();
        newColumn.cellBorderColor = lastColumn.cellBorderColor.clone();
    }
    addRow() {
        this.rowLabels.push(StiLocalizationService.get("PropertyMain", ""));
        this.columns.forEach((column) => {
            if (column.type == "CheckBoxColumn" && column instanceof StiCheckBoxColumnItem) {
                column.cells.push(new StiCheckBoxCellItem("", false));
            }
            else if (column.type == "ComboBoxColumn" && column instanceof StiComboBoxColumnItem) {
                column.cells.push(new StiComboBoxCellItem("", 0));
            }
            else if (column.type == "RadioButtonColumn" && column instanceof StiRadioButtonColumnItem) {
                column.cells.push(new StiRadioButtonCellItem("", false));
            }
            else if (column.type == "TextBoxColumn" && column instanceof StiTextBoxColumnItem) {
                column.cells.push(new StiTextBoxCellItem("", ""));
            }
            else if (column.type == "NumberBoxColumn" && column instanceof StiNumberBoxColumnItem) {
                column.cells.push(new StiNumberBoxCellItem("", 0));
            }
            else if (column.type == "LabelColumn" && column instanceof StiLabelColumnItem) {
                column.cells.push("");
            }
        });
    }
    setProperty(propName, value, oldValue) {
        super.setProperty(propName, value, oldValue);
        if (propName == "thousandSeparator") {
            this.columns.forEach((column) => {
                if ((column instanceof StiNumberBoxColumnItem || column instanceof StiLabelColumnItem) &&
                    (oldValue === null || column.thousandSeparator == oldValue)) {
                    column.thousandSeparator = value;
                }
            });
            this.totalsFields.forEach((field) => {
                if (oldValue === null || oldValue == field.thousandSeparator) {
                    field.thousandSeparator = value;
                }
            });
        }
        else if (propName == "decimalDigits") {
            this.columns.forEach((column) => {
                if ((column instanceof StiNumberBoxColumnItem || column instanceof StiLabelColumnItem) &&
                    (oldValue === null || column.decimalDigits == oldValue)) {
                    column.decimalDigits = value;
                }
            });
            this.totalsFields.forEach((field) => {
                if (oldValue === null || oldValue == field.decimalDigits) {
                    field.decimalDigits = value;
                }
            });
        }
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.font.family, this.arrayOfStylesToString(this.font.style), this.font.size);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    propertyChanged(propName) {
        this.fitTable();
    }
    get columns() {
        return this._columns;
    }
    get eValue() {
        return this.tableHeaderText;
    }
    set eValue(value) {
        this.tableHeaderText = value;
    }
    get eFont() {
        return this.font;
    }
    set eFont(value) {
        this.font = value;
    }
    get eColor() {
        return this.tableHeaderColor;
    }
    set eColor(value) {
        this.tableHeaderColor = value;
    }
    get eBackgroundColor() {
        return this.tableHeaderBackgroundColor;
    }
    set eBackgroundColor(value) {
        this.tableHeaderBackgroundColor = value;
    }
    haveBackgoundColor() {
        return true;
    }
    get eContentAlignment() {
        return this.tableHeaderAlignment;
    }
    set eContentAlignment(value) {
        this.tableHeaderAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    haveVerticalAlignment() {
        return false;
    }
    htmlStyle() {
        return `${this.eFont.htmlStyle()};color:${this.eColor.toHtmlColor()};`;
    }
    updateRowLabelsContentEditable() {
        this.rowLabelsContentEditable = [];
        this.rowLabels.forEach((l, index) => this.rowLabelsContentEditable.push(new StiRowLabel(l, this, index)));
    }
    set width(value) {
        let needToFit = this.geometry.width != value;
        this.geometry.width = value;
        if (needToFit) {
            this.fitTable();
        }
    }
    get width() {
        return this.geometry.width;
    }
    saveToJsonObject(options) {
        this.tableHeaderHeight = this.element?.nativeElement?.offsetHeight;
        this.columns?.forEach((column) => {
            if (column["cells"] && column["cells"].length != this.rowLabels.length) {
                column["cells"].splice(this.rowLabels.length, column["cells"].length);
            }
        });
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        jObject.addPropertyJObject("Border", this.border.saveToJsonObject(options));
        jObject.addPropertyJObject("GridLines", this.gridLines.saveToJsonObject(options));
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyBool("AlternateRowColors", this.alternateRowColors);
        jObject.addPropertyColor("EvenRowsStyle", this.evenRowsStyle);
        jObject.addPropertyColor("EvenRowsTextColor", this.evenRowsTextColor);
        jObject.addPropertyColor("OddRowsStyle", this.oddRowsStyle);
        jObject.addPropertyColor("OddRowsTextColor", this.oddRowsTextColor);
        jObject.addPropertyNumber("TableHeaderHeight", this.tableHeaderHeight);
        jObject.addPropertyString("TableHeaderText", this.tableHeaderText);
        jObject.addPropertyEnum("TableHeaderAlignment", StiHorizontalAlignment, this.tableHeaderAlignment);
        jObject.addPropertyColor("TableHeaderColor", this.tableHeaderColor);
        jObject.addPropertyColor("TableHeaderBackgroundColor", this.tableHeaderBackgroundColor);
        jObject.addPropertyBool("ShowRowLabels", this.showRowLabels);
        jObject.addPropertyArray("RowLabels", this.rowLabels);
        jObject.addPropertyEnum("RowLabelsHorizontalAlignment", StiHorizontalAlignment, this.rowLabelsHorizontalAlignment);
        jObject.addPropertyColor("RowHeadersBackground", this.rowHeadersBackground);
        jObject.addPropertyColor("RowHeadersColor", this.rowHeadersColor);
        jObject.addPropertyJObject("RowHeadersBorder", this.rowHeadersBorder.saveToJsonObject(options));
        jObject.addPropertyJObject("ColumnHeadersBorder", this.columnHeadersBorder.saveToJsonObject(options));
        jObject.addPropertyArray("Columns", this.columns);
        jObject.addPropertyBool("UseTotals", this.useTotals);
        // jObject.addPropertyBool("DynamicRows", this.dynamicRows);
        jObject.addPropertyBool("UseWordWrap", this.useWordWrap);
        jObject.addPropertyString("TotalsRowHeader", this.totalsRowHeader);
        jObject.addPropertyNumber("RowLabelsWidth", this.rowLabelsWidth);
        jObject.addPropertyEnum("TotalsRowHeaderHorizontalAlignment", StiHorizontalAlignment, this.totalsRowHeaderHorizontalAlignment);
        jObject.addPropertyEnum("TotalsRowHeaderVerticalAlignment", StiVerticalAlignment, this.totalsRowHeaderVerticalAlignment);
        jObject.addPropertyColor("TotalsRowHeaderColor", this.totalsRowHeaderColor);
        jObject.addPropertyNumber("TotalsValuesWidth", this.totalsValuesWidth);
        jObject.addPropertyNumber("TotalsHeadersWidth", this.totalsHeadersWidth);
        jObject.addPropertyArray("TotalsFields", this.totalsFields);
        return jObject;
    }
    loadFromJsonObject(json) {
        this.stopFit = true;
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
                case "Border":
                    this.border = new StiBorder();
                    this.border.loadFromJsonObject(property.value);
                    break;
                case "GridLines":
                    this.gridLines = new StiInnerBorder();
                    this.gridLines.loadFromJsonObject(property.value);
                    break;
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "AlternateRowColors":
                    this.alternateRowColors = property.value;
                    break;
                case "EvenRowsStyle":
                    this.evenRowsStyle = new Color();
                    this.evenRowsStyle.deserializeFromString(property.value);
                    break;
                case "EvenRowsTextColor":
                    this.evenRowsTextColor = new Color();
                    this.evenRowsTextColor.deserializeFromString(property.value);
                    break;
                case "OddRowsStyle":
                    this.oddRowsStyle = new Color();
                    this.oddRowsStyle.deserializeFromString(property.value);
                    break;
                case "OddRowsTextColor":
                    this.oddRowsTextColor = new Color();
                    this.oddRowsTextColor.deserializeFromString(property.value);
                    break;
                case "TableHeaderText":
                    this.tableHeaderText = property.value;
                    break;
                case "TableHeaderAlignment":
                    this.tableHeaderAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "TableHeaderColor":
                    this.tableHeaderColor = new Color();
                    this.tableHeaderColor.deserializeFromString(property.value);
                    break;
                case "TableHeaderBackgroundColor":
                    this.tableHeaderBackgroundColor = new Color();
                    this.tableHeaderBackgroundColor.deserializeFromString(property.value);
                    break;
                case "ShowRowLabels":
                    this.showRowLabels = property.value;
                    break;
                /* case "DynamicRows":
                  this.dynamicRows = property.value;
                  break; */
                case "RowLabels":
                    this.rowLabels = [];
                    property.value.properties().forEach((p) => this.rowLabels.push(p.value));
                    break;
                case "RowLabelsHorizontalAlignment":
                    this.rowLabelsHorizontalAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "RowLabelsWidth":
                    this.rowLabelsWidth = property.value;
                    break;
                case "RowHeadersBackground":
                    this.rowHeadersBackground = new Color();
                    this.rowHeadersBackground.deserializeFromString(property.value);
                    break;
                case "RowHeadersColor":
                    this.rowHeadersColor = new Color();
                    this.rowHeadersColor.deserializeFromString(property.value);
                    break;
                case "RowHeadersBorder":
                    this.rowHeadersBorder = new StiBorder();
                    this.rowHeadersBorder.loadFromJsonObject(property.value);
                    break;
                case "ColumnHeadersBorder":
                    this.columnHeadersBorder = new StiBorder();
                    this.columnHeadersBorder.loadFromJsonObject(property.value);
                    break;
                case "Columns":
                case "ColumnCollection":
                    this.columns = [];
                    for (let colJson of property.value.value) {
                        let column;
                        let type = colJson.properties().find((p) => p.name == "Type").value;
                        switch (type) {
                            case "NumberBoxColumn":
                                column = new StiNumberBoxColumnItem();
                                column.eParent = this;
                                break;
                            case "CheckBoxColumn":
                                column = new StiCheckBoxColumnItem();
                                column.eParent = this;
                                break;
                            case "ComboBoxColumn":
                                column = new StiComboBoxColumnItem();
                                column.eParent = this;
                                break;
                            case "RadioButtonColumn":
                                column = new StiRadioButtonColumnItem();
                                column.eParent = this;
                                break;
                            case "TextBoxColumn":
                                column = new StiTextBoxColumnItem();
                                column.eParent = this;
                                break;
                            case "LabelColumn":
                                column = new StiLabelColumnItem();
                                column.eParent = this;
                                break;
                        }
                        column.loadFromJsonObject(colJson);
                        this.columns.push(column);
                    }
                    break;
                case "UseTotals":
                    this.useTotals = property.value;
                    break;
                case "UseWordWrap":
                    this.useWordWrap = property.value;
                    break;
                case "TotalsRowHeader":
                    this.totalsRowHeader = property.value;
                    break;
                case "TotalsRowHeaderHorizontalAlignment":
                    this.totalsRowHeaderHorizontalAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "TotalsRowHeaderVerticalAlignment":
                    this.totalsRowHeaderVerticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
                case "TotalsRowHeaderColor":
                    this.totalsRowHeaderColor = new Color();
                    this.totalsRowHeaderColor.deserializeFromString(property.value);
                    break;
                case "TotalsValuesWidth":
                    this.totalsValuesWidth = property.value;
                    break;
                case "TotalsHeadersWidth":
                    this.totalsHeadersWidth = property.value;
                    break;
                case "TotalsFields":
                    this.totalsFields = [];
                    for (let totalJson of property.value.value) {
                        let total = new StiTotalsFieldItem();
                        total.loadFromJsonObject(totalJson);
                        this.totalsFields.push(total);
                    }
                    break;
            }
        }
        this.stopFit = false;
        this.fitTable();
    }
}
//# sourceMappingURL=data:application/json;base64,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