import { StiBorder } from "../properties/StiBorder";
import StiPadding from "../properties/StiPadding";
import { StiPen } from "../properties/StiPen";
import StiRectangleGeometry from "../properties/StiRectangleGeometry";
import Color from "../system/Color";
import { StiLabelAlignment } from "../system/enums";
import { StiFormElement } from "./base/StiFormElement";
import { StiAddressElement } from "./StiAddressElement";
import { StiBarcodeElement } from "./StiBarcodeElement";
import { StiButtonElement } from "./StiButtonElement";
import { StiCheckBoxElement } from "./StiCheckBoxElement";
import { StiComboBoxElement } from "./StiComboBoxElement";
import { StiDateTimeBoxElement } from "./StiDateTimeBoxElement";
import { StiImageElement } from "./StiImageElement";
import { StiLabelElement } from "./StiLabelElement";
import StiLineElement from "./StiLineElement";
import { StiListBoxElement } from "./StiListBoxElement";
import { StiMultipleSelectionElement } from "./StiMultipleSelectionElement";
import { StiNumberBoxElement } from "./StiNumberBoxElement";
import { StiPDFSignatureElement } from "./StiPDFSignatureElement";
import { StiSignatureElement } from "./StiSignatureElement";
import { StiSingleSelectionElement } from "./StiSingleSelectionElement";
import { StiTableElement } from "./StiTableElement";
import { StiTextBoxElement } from "./StiTextBoxElement";
import { StiTextElement } from "./StiTextElement";
import { StiLabelItem } from "./text/StiLabelItem";
import { StiTextItem } from "./text/StiTextItem";
export class StiPanelElement extends StiFormElement {
    constructor() {
        super();
        this.type = "PanelElement";
        this.description = new StiTextItem();
        this.Width = 0; //TODO
        this.Height = 0; //TODO
        this.backgroundColor = Color.transparent();
        this.border = new StiBorder(StiPen.dimGraySolid(), true, true, true, true);
        this.showBorderEditor = true;
        this.elements = new Array();
        this.geometry = new StiRectangleGeometry(150, 120);
        this.label = new StiLabelItem(this, "");
        this.padding = new StiPadding(0, 0, 0, 0, this);
        this.label.alignment = StiLabelAlignment.Top;
        this.geometry.minWidth = 150;
        this.geometry.minHeight = 90;
    }
    canUpdateProperty(propName) {
        return !(propName.indexOf("padding") >= 0 || propName == "label.alignment");
    }
    get contentAreaWidth() {
        if (this.label.alignment != StiLabelAlignment.Top) {
            return this.width - (this.label.value.length > 0 ? this.label.width : 0) - this.padding.right - this.padding.left;
        }
        else {
            return this.width - this.padding.right - this.padding.left;
        }
    }
    get contentAreaHeight() {
        if (this.label.alignment != StiLabelAlignment.Top) {
            return this.height - this.padding.top - this.padding.bottom;
        }
        else {
            if (this.element?.nativeElement) {
                if (this.element.nativeElement.offsetHeight > 0) {
                    return this.element.nativeElement.offsetHeight + this.padding.bottom;
                }
            }
            else {
                return this.height - this.padding.top - this.padding.bottom - 35;
            }
        }
    }
    getColumnWidth(columnsCount) {
        return Number((this.contentAreaWidth / columnsCount).toFixed(2));
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    get allElements() {
        let elements = [];
        this.getAllElements(elements);
        return elements;
    }
    getAllElements(elements) {
        this.elements.forEach((element) => {
            if (element instanceof StiPanelElement) {
                element.getAllElements(elements);
            }
            elements.push(element);
        });
    }
    saveToJsonObject(options) {
        if (this.element?.nativeElement) {
            if (this.label.alignment != StiLabelAlignment.Top) {
                this.Width = this.width - (this.label.value.length > 0 ? this.label.width + this.padding.left : 0);
                this.Height = this.height;
            }
            else {
                this.Width = this.width;
                if (this.element.nativeElement.offsetHeight > 0) {
                    this.Height = this.element.nativeElement.offsetHeight + this.padding.bottom;
                }
            }
        }
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyNumber("Width", this.Width);
        jObject.addPropertyNumber("Height", this.Height);
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyArray("Elements", this.elements);
        jObject.addPropertyJObject("Border", this.border.saveToJsonObject(options));
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Width":
                    this.Width = property.value;
                    break;
                case "Height":
                    this.Height = property.value;
                    break;
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "Elements":
                    this.elements = this.deserializeCollection(property.value);
                    break;
                case "Border":
                    this.border = new StiBorder();
                    this.border.loadFromJsonObject(property.value);
                    break;
            }
        }
    }
    createElementClass(type) {
        type = type.toLowerCase();
        if (type == "textelement" || type == "textelement") {
            return new StiTextElement();
        }
        else if (type == "text_boxelement" || type == "textboxelement") {
            return new StiTextBoxElement();
        }
        else if (type == "tableelement" || type == "tableelement") {
            return new StiTableElement();
        }
        else if (type == "single_selectionelement" || type == "singleselectionelement") {
            return new StiSingleSelectionElement();
        }
        else if (type == "signatureelement" || type == "signatureelement") {
            return new StiSignatureElement();
        }
        else if (type == "pdfsignatureelement" || type == "pdfsignatureelement") {
            return new StiPDFSignatureElement();
        }
        else if (type == "panelelement" || type == "panelelement") {
            return new StiPanelElement();
        }
        else if (type == "number_boxelement" || type == "numberboxelement") {
            return new StiNumberBoxElement();
        }
        else if (type == "multiple_selectionelement" || type == "multipleselectionelement") {
            return new StiMultipleSelectionElement();
        }
        else if (type == "list_boxelement" || type == "listboxelement") {
            return new StiListBoxElement();
        }
        else if (type == "lineelement" || type == "lineelement") {
            return new StiLineElement();
        }
        else if (type == "labelelement" || type == "labelelement") {
            return new StiLabelElement();
        }
        else if (type == "imageelement" || type == "imageelement") {
            return new StiImageElement();
        }
        else if (type == "datetime_boxelement" || type == "datetimeboxelement") {
            return new StiDateTimeBoxElement();
        }
        else if (type == "combo_boxelement" || type == "comboboxelement") {
            return new StiComboBoxElement();
        }
        else if (type == "check_boxelement" || type == "checkboxelement") {
            return new StiCheckBoxElement();
        }
        else if (type == "buttonelement" || type == "buttonelement") {
            return new StiButtonElement();
        }
        else if (type == "barcodeelement" || type == "barcodeelement") {
            return new StiBarcodeElement();
        }
        else if (type == "addresselement" || type == "addresselement") {
            return new StiAddressElement();
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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