import { StiBorder } from "../properties/StiBorder";
import { StiExceedMargins } from "../properties/StiExceedMargins";
import StiPadding from "../properties/StiPadding";
import { StiPen } from "../properties/StiPen";
import StiRectangleGeometry from "../properties/StiRectangleGeometry";
import Color from "../system/Color";
import { Enum } from "../system/Enum";
import { StiHorizontalAlignment, StiVerticalAlignment } from "../system/enums";
import { Font } from "../system/Font";
import { StiFormElement } from "./base/StiFormElement";
import { StiBackgroundedAlignedTextItem } from "./text/StiBackgroundedAlignedTextItem";
export class StiLabelElement extends StiFormElement {
    constructor() {
        super();
        this.type = "LabelElement";
        this.exceedMargins = new StiExceedMargins(false, false, false, false);
        this.text = new StiBackgroundedAlignedTextItem("", new Font("Segoe UI", 9), Color.black(), Color.transparent());
        this.border = new StiBorder(StiPen.dimGraySolid(), false, false, false, false);
        this.showBorderEditor = true;
        this.hyperlink = "";
        this.geometry = new StiRectangleGeometry(100, 40);
        this.padding = new StiPadding(0, 0, 0, 0, this);
    }
    get expression() {
        return this.text?.value;
    }
    canUpdateProperty(propName) {
        return !(propName.indexOf("padding") >= 0);
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.text.font.family, this.arrayOfStylesToString(this.text.font.style), this.text.font.size);
    }
    setProperty(propName, value, oldObject) {
        super.setProperty(propName, value, oldObject);
        if (propName == "innerText.backgroundColor") {
            //this.text.backgroundColor = value.clone();
        }
        else if (propName == "innerText.contentAlignment") {
            //this.text.horizontalAlignment = value;
        }
        else if (propName.startsWith("label.font") || propName == "label.color") {
            this.text.setProperty(propName.replace("label.", ""), value.clone ? value.clone() : value, oldObject);
        }
    }
    getDefaultEditableContent() {
        return this.text;
    }
    htmlStyle() {
        return `${this.text.font.htmlStyle()};color:${this.text.color.toHtmlColor()};justify-content:${Enum.getName(StiHorizontalAlignment, this.text.horizontalAlignment)};align-items:${Enum.getName(StiVerticalAlignment, this.text.verticalAlignment)}`;
    }
    saveToJsonObject(options) {
        let states = [];
        if (this.exceedMargins.drawTop &&
            this.exceedMargins.drawBottom &&
            this.exceedMargins.drawLeft &&
            this.exceedMargins.drawRight) {
            states.push("All");
        }
        else if (!this.exceedMargins.drawTop &&
            !this.exceedMargins.drawBottom &&
            !this.exceedMargins.drawLeft &&
            !this.exceedMargins.drawRight) {
            states.push("None");
        }
        else {
            if (this.exceedMargins.drawTop) {
                states.push("Top");
            }
            if (this.exceedMargins.drawLeft) {
                states.push("Left");
            }
            if (this.exceedMargins.drawRight) {
                states.push("Right");
            }
            if (this.exceedMargins.drawBottom) {
                states.push("Bottom");
            }
        }
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Text", this.text.saveToJsonObject(options));
        jObject.addPropertyJObject("Border", this.border.saveToJsonObject(options));
        jObject.addPropertyString("ExceededMargins", states.join());
        jObject.addPropertyStringNullOrEmpty("Hyperlink", this.hyperlink);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Hyperlink":
                    this.hyperlink = property.value;
                    break;
                case "Text":
                    this.text = new StiBackgroundedAlignedTextItem();
                    this.text.loadFromJsonObject(property.value);
                    break;
                case "Border":
                    this.border = new StiBorder();
                    this.border.loadFromJsonObject(property.value);
                    break;
                case "ExceededMargins":
                    let string = property.value;
                    this.exceedMargins.drawBottom = false;
                    this.exceedMargins.drawLeft = false;
                    this.exceedMargins.drawRight = false;
                    this.exceedMargins.drawTop = false;
                    if (string.indexOf("All") >= 0) {
                        this.exceedMargins.drawBottom = true;
                        this.exceedMargins.drawLeft = true;
                        this.exceedMargins.drawRight = true;
                        this.exceedMargins.drawTop = true;
                    }
                    else {
                        if (string.indexOf("Top") >= 0) {
                            this.exceedMargins.drawTop = true;
                        }
                        if (string.indexOf("Left") >= 0) {
                            this.exceedMargins.drawLeft = true;
                        }
                        if (string.indexOf("Right") >= 0) {
                            this.exceedMargins.drawRight = true;
                        }
                        if (string.indexOf("Bottom") >= 0) {
                            this.exceedMargins.drawBottom = true;
                        }
                    }
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RpTGFiZWxFbGVtZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2VsZW1lbnRzL1N0aUxhYmVsRWxlbWVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLE1BQU0seUJBQXlCLENBQUM7QUFDcEQsT0FBTyxFQUFFLGdCQUFnQixFQUFFLE1BQU0sZ0NBQWdDLENBQUM7QUFDbEUsT0FBTyxVQUFVLE1BQU0sMEJBQTBCLENBQUM7QUFDbEQsT0FBTyxFQUFFLE1BQU0sRUFBRSxNQUFNLHNCQUFzQixDQUFDO0FBQzlDLE9BQU8sb0JBQW9CLE1BQU0sb0NBQW9DLENBQUM7QUFFdEUsT0FBTyxLQUFLLE1BQU0saUJBQWlCLENBQUM7QUFDcEMsT0FBTyxFQUFFLElBQUksRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBQ3RDLE9BQU8sRUFBRSxzQkFBc0IsRUFBRSxvQkFBb0IsRUFBRSxNQUFNLGlCQUFpQixDQUFDO0FBQy9FLE9BQU8sRUFBRSxJQUFJLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUd0QyxPQUFPLEVBQUUsY0FBYyxFQUFFLE1BQU0sdUJBQXVCLENBQUM7QUFDdkQsT0FBTyxFQUFFLDhCQUE4QixFQUFFLE1BQU0sdUNBQXVDLENBQUM7QUFFdkYsTUFBTSxPQUFPLGVBQWdCLFNBQVEsY0FBYztJQWVqRDtRQUNFLEtBQUssRUFBRSxDQUFDO1FBZkgsU0FBSSxHQUFXLGNBQWMsQ0FBQztRQUM5QixrQkFBYSxHQUFxQixJQUFJLGdCQUFnQixDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQ25GLFNBQUksR0FBbUMsSUFBSSw4QkFBOEIsQ0FDOUUsRUFBRSxFQUNGLElBQUksSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUMsRUFDdkIsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUNiLEtBQUssQ0FBQyxXQUFXLEVBQUUsQ0FDcEIsQ0FBQztRQUNLLFdBQU0sR0FBYyxJQUFJLFNBQVMsQ0FBQyxNQUFNLENBQUMsWUFBWSxFQUFFLEVBQUUsS0FBSyxFQUFFLEtBQUssRUFBRSxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDckYscUJBQWdCLEdBQVksSUFBSSxDQUFDO1FBR2pDLGNBQVMsR0FBVyxFQUFFLENBQUM7UUFJNUIsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLG9CQUFvQixDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNsRCxJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksVUFBVSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxJQUFJLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBRUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUM7SUFDMUIsQ0FBQztJQUVNLGlCQUFpQixDQUFDLFFBQWdCO1FBQ3ZDLE9BQU8sQ0FBQyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVNLFlBQVksQ0FBQyxTQUEyQjtRQUM3QyxLQUFLLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQzlCLFNBQVMsQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUM5RyxDQUFDO0lBRUQsV0FBVyxDQUFDLFFBQWdCLEVBQUUsS0FBVSxFQUFFLFNBQWM7UUFDdEQsS0FBSyxDQUFDLFdBQVcsQ0FBQyxRQUFRLEVBQUUsS0FBSyxFQUFFLFNBQVMsQ0FBQyxDQUFDO1FBQzlDLElBQUksUUFBUSxJQUFJLDJCQUEyQixFQUFFO1lBQzNDLDRDQUE0QztTQUM3QzthQUFNLElBQUksUUFBUSxJQUFJLDRCQUE0QixFQUFFO1lBQ25ELHdDQUF3QztTQUN6QzthQUFNLElBQUksUUFBUSxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsSUFBSSxRQUFRLElBQUksYUFBYSxFQUFFO1lBQ3pFLElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFLEVBQUUsQ0FBQyxFQUFFLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDLENBQUMsS0FBSyxFQUFFLFNBQVMsQ0FBQyxDQUFDO1NBQ3ZHO0lBQ0gsQ0FBQztJQUVNLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxJQUFJLENBQUM7SUFDbkIsQ0FBQztJQUNELFNBQVM7UUFDUCxPQUFPLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFVBQVUsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxFQUFFLG9CQUFvQixJQUFJLENBQUMsT0FBTyxDQUN6RyxzQkFBc0IsRUFDdEIsSUFBSSxDQUFDLElBQUksQ0FBQyxtQkFBbUIsQ0FDOUIsZ0JBQWdCLElBQUksQ0FBQyxPQUFPLENBQUMsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxFQUFFLENBQUM7SUFDckYsQ0FBQztJQUNELGdCQUFnQixDQUFDLE9BQVk7UUFDM0IsSUFBSSxNQUFNLEdBQUcsRUFBRSxDQUFDO1FBQ2hCLElBQ0UsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPO1lBQzFCLElBQUksQ0FBQyxhQUFhLENBQUMsVUFBVTtZQUM3QixJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVE7WUFDM0IsSUFBSSxDQUFDLGFBQWEsQ0FBQyxTQUFTLEVBQzVCO1lBQ0EsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztTQUNwQjthQUFNLElBQ0wsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLE9BQU87WUFDM0IsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFVBQVU7WUFDOUIsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVE7WUFDNUIsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFNBQVMsRUFDN0I7WUFDQSxNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1NBQ3JCO2FBQU07WUFDTCxJQUFJLElBQUksQ0FBQyxhQUFhLENBQUMsT0FBTyxFQUFFO2dCQUM5QixNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO2FBQ3BCO1lBQ0QsSUFBSSxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsRUFBRTtnQkFDL0IsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQzthQUNyQjtZQUNELElBQUksSUFBSSxDQUFDLGFBQWEsQ0FBQyxTQUFTLEVBQUU7Z0JBQ2hDLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7YUFDdEI7WUFDRCxJQUFJLElBQUksQ0FBQyxhQUFhLENBQUMsVUFBVSxFQUFFO2dCQUNqQyxNQUFNLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO2FBQ3ZCO1NBQ0Y7UUFDRCxJQUFJLE9BQU8sR0FBRyxLQUFLLENBQUMsZ0JBQWdCLENBQUMsT0FBTyxDQUFDLENBQUM7UUFDOUMsT0FBTyxDQUFDLGtCQUFrQixDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7UUFDeEUsT0FBTyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7UUFDNUUsT0FBTyxDQUFDLGlCQUFpQixDQUFDLGlCQUFpQixFQUFFLE1BQU0sQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDO1FBQzVELE9BQU8sQ0FBQyw0QkFBNEIsQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQ2xFLE9BQU8sT0FBTyxDQUFDO0lBQ2pCLENBQUM7SUFFTSxrQkFBa0IsQ0FBQyxJQUFhO1FBQ3JDLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMvQixLQUFLLElBQUksUUFBUSxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUUsRUFBRTtZQUN0QyxRQUFRLFFBQVEsQ0FBQyxJQUFJLEVBQUU7Z0JBQ3JCLEtBQUssV0FBVztvQkFDZCxJQUFJLENBQUMsU0FBUyxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQ2hDLE1BQU07Z0JBQ1IsS0FBSyxNQUFNO29CQUNULElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSw4QkFBOEIsRUFBRSxDQUFDO29CQUNqRCxJQUFJLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDN0MsTUFBTTtnQkFDUixLQUFLLFFBQVE7b0JBQ1gsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLFNBQVMsRUFBRSxDQUFDO29CQUM5QixJQUFJLENBQUMsTUFBTSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDL0MsTUFBTTtnQkFDUixLQUFLLGlCQUFpQjtvQkFDcEIsSUFBSSxNQUFNLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDNUIsSUFBSSxDQUFDLGFBQWEsQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO29CQUN0QyxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7b0JBQ3BDLElBQUksQ0FBQyxhQUFhLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztvQkFDckMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO29CQUNuQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxFQUFFO3dCQUM5QixJQUFJLENBQUMsYUFBYSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7d0JBQ3JDLElBQUksQ0FBQyxhQUFhLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQzt3QkFDbkMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDO3dCQUNwQyxJQUFJLENBQUMsYUFBYSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUM7cUJBQ25DO3lCQUFNO3dCQUNMLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEVBQUU7NEJBQzlCLElBQUksQ0FBQyxhQUFhLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQzt5QkFDbkM7d0JBQ0QsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsRUFBRTs0QkFDL0IsSUFBSSxDQUFDLGFBQWEsQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO3lCQUNwQzt3QkFDRCxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxFQUFFOzRCQUNoQyxJQUFJLENBQUMsYUFBYSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUM7eUJBQ3JDO3dCQUNELElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEVBQUU7NEJBQ2pDLElBQUksQ0FBQyxhQUFhLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQzt5QkFDdEM7cUJBQ0Y7b0JBQ0QsTUFBTTthQUNUO1NBQ0Y7SUFDSCxDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTdGlCb3JkZXIgfSBmcm9tIFwiLi4vcHJvcGVydGllcy9TdGlCb3JkZXJcIjtcclxuaW1wb3J0IHsgU3RpRXhjZWVkTWFyZ2lucyB9IGZyb20gXCIuLi9wcm9wZXJ0aWVzL1N0aUV4Y2VlZE1hcmdpbnNcIjtcclxuaW1wb3J0IFN0aVBhZGRpbmcgZnJvbSBcIi4uL3Byb3BlcnRpZXMvU3RpUGFkZGluZ1wiO1xyXG5pbXBvcnQgeyBTdGlQZW4gfSBmcm9tIFwiLi4vcHJvcGVydGllcy9TdGlQZW5cIjtcclxuaW1wb3J0IFN0aVJlY3RhbmdsZUdlb21ldHJ5IGZyb20gXCIuLi9wcm9wZXJ0aWVzL1N0aVJlY3RhbmdsZUdlb21ldHJ5XCI7XHJcbmltcG9ydCB7IFN0aVVzZWRGb250c0xpc3QgfSBmcm9tIFwiLi4vc2VydmljZXMvb2JqZWN0c1wiO1xyXG5pbXBvcnQgQ29sb3IgZnJvbSBcIi4uL3N5c3RlbS9Db2xvclwiO1xyXG5pbXBvcnQgeyBFbnVtIH0gZnJvbSBcIi4uL3N5c3RlbS9FbnVtXCI7XHJcbmltcG9ydCB7IFN0aUhvcml6b250YWxBbGlnbm1lbnQsIFN0aVZlcnRpY2FsQWxpZ25tZW50IH0gZnJvbSBcIi4uL3N5c3RlbS9lbnVtc1wiO1xyXG5pbXBvcnQgeyBGb250IH0gZnJvbSBcIi4uL3N5c3RlbS9Gb250XCI7XHJcbmltcG9ydCB7IFN0aUVkaXRhYmxlQ29udGVudCwgU3RpVmFsdWVFbGVtZW50IH0gZnJvbSBcIi4uL3N5c3RlbS9pbnRlcmZhY2VzXCI7XHJcbmltcG9ydCBTdGlKc29uIGZyb20gXCIuLi9zeXN0ZW0vU3RpSnNvblwiO1xyXG5pbXBvcnQgeyBTdGlGb3JtRWxlbWVudCB9IGZyb20gXCIuL2Jhc2UvU3RpRm9ybUVsZW1lbnRcIjtcclxuaW1wb3J0IHsgU3RpQmFja2dyb3VuZGVkQWxpZ25lZFRleHRJdGVtIH0gZnJvbSBcIi4vdGV4dC9TdGlCYWNrZ3JvdW5kZWRBbGlnbmVkVGV4dEl0ZW1cIjtcclxuXHJcbmV4cG9ydCBjbGFzcyBTdGlMYWJlbEVsZW1lbnQgZXh0ZW5kcyBTdGlGb3JtRWxlbWVudCBpbXBsZW1lbnRzIFN0aVZhbHVlRWxlbWVudCB7XHJcbiAgcHVibGljIHR5cGU6IHN0cmluZyA9IFwiTGFiZWxFbGVtZW50XCI7XHJcbiAgcHVibGljIGV4Y2VlZE1hcmdpbnM6IFN0aUV4Y2VlZE1hcmdpbnMgPSBuZXcgU3RpRXhjZWVkTWFyZ2lucyhmYWxzZSwgZmFsc2UsIGZhbHNlLCBmYWxzZSk7XHJcbiAgcHVibGljIHRleHQ6IFN0aUJhY2tncm91bmRlZEFsaWduZWRUZXh0SXRlbSA9IG5ldyBTdGlCYWNrZ3JvdW5kZWRBbGlnbmVkVGV4dEl0ZW0oXHJcbiAgICBcIlwiLFxyXG4gICAgbmV3IEZvbnQoXCJTZWdvZSBVSVwiLCA5KSxcclxuICAgIENvbG9yLmJsYWNrKCksXHJcbiAgICBDb2xvci50cmFuc3BhcmVudCgpXHJcbiAgKTtcclxuICBwdWJsaWMgYm9yZGVyOiBTdGlCb3JkZXIgPSBuZXcgU3RpQm9yZGVyKFN0aVBlbi5kaW1HcmF5U29saWQoKSwgZmFsc2UsIGZhbHNlLCBmYWxzZSwgZmFsc2UpO1xyXG4gIHB1YmxpYyBzaG93Qm9yZGVyRWRpdG9yOiBib29sZWFuID0gdHJ1ZTtcclxuICBwdWJsaWMgZGlzcGxheVZhbHVlOiBzdHJpbmc7XHJcbiAgcHVibGljIHZhbHVlOiBhbnk7XHJcbiAgcHVibGljIGh5cGVybGluazogc3RyaW5nID0gXCJcIjtcclxuXHJcbiAgY29uc3RydWN0b3IoKSB7XHJcbiAgICBzdXBlcigpO1xyXG4gICAgdGhpcy5nZW9tZXRyeSA9IG5ldyBTdGlSZWN0YW5nbGVHZW9tZXRyeSgxMDAsIDQwKTtcclxuICAgIHRoaXMucGFkZGluZyA9IG5ldyBTdGlQYWRkaW5nKDAsIDAsIDAsIDAsIHRoaXMpO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBleHByZXNzaW9uKCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gdGhpcy50ZXh0Py52YWx1ZTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBjYW5VcGRhdGVQcm9wZXJ0eShwcm9wTmFtZTogc3RyaW5nKSB7XHJcbiAgICByZXR1cm4gIShwcm9wTmFtZS5pbmRleE9mKFwicGFkZGluZ1wiKSA+PSAwKTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXRVc2VkRm9udHModXNlZEZvbnRzOiBTdGlVc2VkRm9udHNMaXN0KSB7XHJcbiAgICBzdXBlci5nZXRVc2VkRm9udHModXNlZEZvbnRzKTtcclxuICAgIHVzZWRGb250cy5hZGQodGhpcy50ZXh0LmZvbnQuZmFtaWx5LCB0aGlzLmFycmF5T2ZTdHlsZXNUb1N0cmluZyh0aGlzLnRleHQuZm9udC5zdHlsZSksIHRoaXMudGV4dC5mb250LnNpemUpO1xyXG4gIH1cclxuXHJcbiAgc2V0UHJvcGVydHkocHJvcE5hbWU6IHN0cmluZywgdmFsdWU6IGFueSwgb2xkT2JqZWN0OiBhbnkpIHtcclxuICAgIHN1cGVyLnNldFByb3BlcnR5KHByb3BOYW1lLCB2YWx1ZSwgb2xkT2JqZWN0KTtcclxuICAgIGlmIChwcm9wTmFtZSA9PSBcImlubmVyVGV4dC5iYWNrZ3JvdW5kQ29sb3JcIikge1xyXG4gICAgICAvL3RoaXMudGV4dC5iYWNrZ3JvdW5kQ29sb3IgPSB2YWx1ZS5jbG9uZSgpO1xyXG4gICAgfSBlbHNlIGlmIChwcm9wTmFtZSA9PSBcImlubmVyVGV4dC5jb250ZW50QWxpZ25tZW50XCIpIHtcclxuICAgICAgLy90aGlzLnRleHQuaG9yaXpvbnRhbEFsaWdubWVudCA9IHZhbHVlO1xyXG4gICAgfSBlbHNlIGlmIChwcm9wTmFtZS5zdGFydHNXaXRoKFwibGFiZWwuZm9udFwiKSB8fCBwcm9wTmFtZSA9PSBcImxhYmVsLmNvbG9yXCIpIHtcclxuICAgICAgdGhpcy50ZXh0LnNldFByb3BlcnR5KHByb3BOYW1lLnJlcGxhY2UoXCJsYWJlbC5cIiwgXCJcIiksIHZhbHVlLmNsb25lID8gdmFsdWUuY2xvbmUoKSA6IHZhbHVlLCBvbGRPYmplY3QpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldERlZmF1bHRFZGl0YWJsZUNvbnRlbnQoKTogU3RpRWRpdGFibGVDb250ZW50IHtcclxuICAgIHJldHVybiB0aGlzLnRleHQ7XHJcbiAgfVxyXG4gIGh0bWxTdHlsZSgpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIGAke3RoaXMudGV4dC5mb250Lmh0bWxTdHlsZSgpfTtjb2xvcjoke3RoaXMudGV4dC5jb2xvci50b0h0bWxDb2xvcigpfTtqdXN0aWZ5LWNvbnRlbnQ6JHtFbnVtLmdldE5hbWUoXHJcbiAgICAgIFN0aUhvcml6b250YWxBbGlnbm1lbnQsXHJcbiAgICAgIHRoaXMudGV4dC5ob3Jpem9udGFsQWxpZ25tZW50XHJcbiAgICApfTthbGlnbi1pdGVtczoke0VudW0uZ2V0TmFtZShTdGlWZXJ0aWNhbEFsaWdubWVudCwgdGhpcy50ZXh0LnZlcnRpY2FsQWxpZ25tZW50KX1gO1xyXG4gIH1cclxuICBzYXZlVG9Kc29uT2JqZWN0KG9wdGlvbnM6IGFueSk6IFN0aUpzb24ge1xyXG4gICAgbGV0IHN0YXRlcyA9IFtdO1xyXG4gICAgaWYgKFxyXG4gICAgICB0aGlzLmV4Y2VlZE1hcmdpbnMuZHJhd1RvcCAmJlxyXG4gICAgICB0aGlzLmV4Y2VlZE1hcmdpbnMuZHJhd0JvdHRvbSAmJlxyXG4gICAgICB0aGlzLmV4Y2VlZE1hcmdpbnMuZHJhd0xlZnQgJiZcclxuICAgICAgdGhpcy5leGNlZWRNYXJnaW5zLmRyYXdSaWdodFxyXG4gICAgKSB7XHJcbiAgICAgIHN0YXRlcy5wdXNoKFwiQWxsXCIpO1xyXG4gICAgfSBlbHNlIGlmIChcclxuICAgICAgIXRoaXMuZXhjZWVkTWFyZ2lucy5kcmF3VG9wICYmXHJcbiAgICAgICF0aGlzLmV4Y2VlZE1hcmdpbnMuZHJhd0JvdHRvbSAmJlxyXG4gICAgICAhdGhpcy5leGNlZWRNYXJnaW5zLmRyYXdMZWZ0ICYmXHJcbiAgICAgICF0aGlzLmV4Y2VlZE1hcmdpbnMuZHJhd1JpZ2h0XHJcbiAgICApIHtcclxuICAgICAgc3RhdGVzLnB1c2goXCJOb25lXCIpO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgaWYgKHRoaXMuZXhjZWVkTWFyZ2lucy5kcmF3VG9wKSB7XHJcbiAgICAgICAgc3RhdGVzLnB1c2goXCJUb3BcIik7XHJcbiAgICAgIH1cclxuICAgICAgaWYgKHRoaXMuZXhjZWVkTWFyZ2lucy5kcmF3TGVmdCkge1xyXG4gICAgICAgIHN0YXRlcy5wdXNoKFwiTGVmdFwiKTtcclxuICAgICAgfVxyXG4gICAgICBpZiAodGhpcy5leGNlZWRNYXJnaW5zLmRyYXdSaWdodCkge1xyXG4gICAgICAgIHN0YXRlcy5wdXNoKFwiUmlnaHRcIik7XHJcbiAgICAgIH1cclxuICAgICAgaWYgKHRoaXMuZXhjZWVkTWFyZ2lucy5kcmF3Qm90dG9tKSB7XHJcbiAgICAgICAgc3RhdGVzLnB1c2goXCJCb3R0b21cIik7XHJcbiAgICAgIH1cclxuICAgIH1cclxuICAgIGxldCBqT2JqZWN0ID0gc3VwZXIuc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlKT2JqZWN0KFwiVGV4dFwiLCB0aGlzLnRleHQuc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zKSk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5Sk9iamVjdChcIkJvcmRlclwiLCB0aGlzLmJvcmRlci5zYXZlVG9Kc29uT2JqZWN0KG9wdGlvbnMpKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlTdHJpbmcoXCJFeGNlZWRlZE1hcmdpbnNcIiwgc3RhdGVzLmpvaW4oKSk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5U3RyaW5nTnVsbE9yRW1wdHkoXCJIeXBlcmxpbmtcIiwgdGhpcy5oeXBlcmxpbmspO1xyXG4gICAgcmV0dXJuIGpPYmplY3Q7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgbG9hZEZyb21Kc29uT2JqZWN0KGpzb246IFN0aUpzb24pIHtcclxuICAgIHN1cGVyLmxvYWRGcm9tSnNvbk9iamVjdChqc29uKTtcclxuICAgIGZvciAobGV0IHByb3BlcnR5IG9mIGpzb24ucHJvcGVydGllcygpKSB7XHJcbiAgICAgIHN3aXRjaCAocHJvcGVydHkubmFtZSkge1xyXG4gICAgICAgIGNhc2UgXCJIeXBlcmxpbmtcIjpcclxuICAgICAgICAgIHRoaXMuaHlwZXJsaW5rID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiVGV4dFwiOlxyXG4gICAgICAgICAgdGhpcy50ZXh0ID0gbmV3IFN0aUJhY2tncm91bmRlZEFsaWduZWRUZXh0SXRlbSgpO1xyXG4gICAgICAgICAgdGhpcy50ZXh0LmxvYWRGcm9tSnNvbk9iamVjdChwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiQm9yZGVyXCI6XHJcbiAgICAgICAgICB0aGlzLmJvcmRlciA9IG5ldyBTdGlCb3JkZXIoKTtcclxuICAgICAgICAgIHRoaXMuYm9yZGVyLmxvYWRGcm9tSnNvbk9iamVjdChwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiRXhjZWVkZWRNYXJnaW5zXCI6XHJcbiAgICAgICAgICBsZXQgc3RyaW5nID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICB0aGlzLmV4Y2VlZE1hcmdpbnMuZHJhd0JvdHRvbSA9IGZhbHNlO1xyXG4gICAgICAgICAgdGhpcy5leGNlZWRNYXJnaW5zLmRyYXdMZWZ0ID0gZmFsc2U7XHJcbiAgICAgICAgICB0aGlzLmV4Y2VlZE1hcmdpbnMuZHJhd1JpZ2h0ID0gZmFsc2U7XHJcbiAgICAgICAgICB0aGlzLmV4Y2VlZE1hcmdpbnMuZHJhd1RvcCA9IGZhbHNlO1xyXG4gICAgICAgICAgaWYgKHN0cmluZy5pbmRleE9mKFwiQWxsXCIpID49IDApIHtcclxuICAgICAgICAgICAgdGhpcy5leGNlZWRNYXJnaW5zLmRyYXdCb3R0b20gPSB0cnVlO1xyXG4gICAgICAgICAgICB0aGlzLmV4Y2VlZE1hcmdpbnMuZHJhd0xlZnQgPSB0cnVlO1xyXG4gICAgICAgICAgICB0aGlzLmV4Y2VlZE1hcmdpbnMuZHJhd1JpZ2h0ID0gdHJ1ZTtcclxuICAgICAgICAgICAgdGhpcy5leGNlZWRNYXJnaW5zLmRyYXdUb3AgPSB0cnVlO1xyXG4gICAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgICAgaWYgKHN0cmluZy5pbmRleE9mKFwiVG9wXCIpID49IDApIHtcclxuICAgICAgICAgICAgICB0aGlzLmV4Y2VlZE1hcmdpbnMuZHJhd1RvcCA9IHRydWU7XHJcbiAgICAgICAgICAgIH1cclxuICAgICAgICAgICAgaWYgKHN0cmluZy5pbmRleE9mKFwiTGVmdFwiKSA+PSAwKSB7XHJcbiAgICAgICAgICAgICAgdGhpcy5leGNlZWRNYXJnaW5zLmRyYXdMZWZ0ID0gdHJ1ZTtcclxuICAgICAgICAgICAgfVxyXG4gICAgICAgICAgICBpZiAoc3RyaW5nLmluZGV4T2YoXCJSaWdodFwiKSA+PSAwKSB7XHJcbiAgICAgICAgICAgICAgdGhpcy5leGNlZWRNYXJnaW5zLmRyYXdSaWdodCA9IHRydWU7XHJcbiAgICAgICAgICAgIH1cclxuICAgICAgICAgICAgaWYgKHN0cmluZy5pbmRleE9mKFwiQm90dG9tXCIpID49IDApIHtcclxuICAgICAgICAgICAgICB0aGlzLmV4Y2VlZE1hcmdpbnMuZHJhd0JvdHRvbSA9IHRydWU7XHJcbiAgICAgICAgICAgIH1cclxuICAgICAgICAgIH1cclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgfVxyXG59XHJcbiJdfQ==