import StiPadding from "../properties/StiPadding";
import StiPagePaperKind from "../properties/StiPagePaperKind";
import StiFormObject from "./base/StiFormObject";
import { StiPanelElement } from "./StiPanelElement";
import { StiBarcodeElement } from "./StiBarcodeElement";
import { StiButtonElement } from "./StiButtonElement";
import { StiCheckBoxElement } from "./StiCheckBoxElement";
import { StiComboBoxElement } from "./StiComboBoxElement";
import { StiDateTimeBoxElement } from "./StiDateTimeBoxElement";
import { StiImageElement } from "./StiImageElement";
import { StiLabelElement } from "./StiLabelElement";
import StiLineElement from "./StiLineElement";
import { StiListBoxElement } from "./StiListBoxElement";
import { StiMultipleSelectionElement } from "./StiMultipleSelectionElement";
import { StiSignatureElement } from "./StiSignatureElement";
import { StiSingleSelectionElement } from "./StiSingleSelectionElement";
import { StiTableElement } from "./StiTableElement";
import { StiTextBoxElement } from "./StiTextBoxElement";
import { StiTextElement } from "./StiTextElement";
import { StiNumberBoxElement } from "./StiNumberBoxElement";
import Color from "../system/Color";
import { PaperKind } from "../system/enums";
import { StiAddressElement } from "./StiAddressElement";
import { StiPDFSignatureElement } from "./StiPDFSignatureElement";
export class StiFormPageElement extends StiFormObject {
    constructor() {
        super();
        this.type = "StiPageElement";
        this.elements = new Array();
        this.visible = true;
        this.padding = new StiPadding(39, 39, 39, 39);
        this.paperKind = StiPagePaperKind.fromStandardPaperKind(PaperKind.A4);
        this.backgroundColor = Color.white();
    }
    get width() {
        return this.paperKind.width;
    }
    get height() {
        return this.paperKind.height;
    }
    set width(value) {
        this.paperKind.width = Number(value);
    }
    set height(value) {
        this.paperKind.height = Number(value);
    }
    get contentAreaWidth() {
        let padding = this.padding;
        return this.width - padding.left - padding.right;
    }
    get contentAreaHeight() {
        let padding = this.padding;
        return this.height - padding.top - padding.bottom;
    }
    get allElements() {
        let elements = [];
        this.elements.forEach((element) => {
            if (element instanceof StiPanelElement) {
                element.getAllElements(elements);
            }
            elements.push(element);
        });
        return elements;
    }
    getColumnWidth(columnsCount) {
        return Number((this.contentAreaWidth / columnsCount).toFixed(2));
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.removeProperty(StiFormObject.TYPE_PROPERTY_NAME);
        jObject.addPropertyJObject("Margins", this.padding.saveToJsonObject(options));
        jObject.addPropertyJObject("PaperKind", this.paperKind.saveToJsonObject(options));
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyBool("Visible", this.visible);
        if (!(options && options["notSerializeImages"])) {
            jObject.addPropertyString("BackgroundImage", this.backgroundImage?.substring(this.backgroundImage.indexOf(",") + 1));
        }
        jObject.addPropertyArray("Elements", this.elements);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Visible":
                    this.visible = property.value;
                    break;
                case "Margins":
                    this.padding.loadFromJsonObject(property.value);
                    break;
                case "PaperKind":
                    this.paperKind.loadFromJsonObject(property.value);
                    break;
                case "BackgroundColor":
                    this.backgroundColor.deserializeFromString(property.value);
                    this.backgroundColor.a = 255;
                    break;
                case "BackgroundImage":
                    if (property.value) {
                        this.backgroundImage = "data:image/png;base64," + property.value;
                    }
                    break;
                case "Elements":
                    this.elements = this.deserializeCollection(property.value);
                    break;
            }
        }
    }
    createElementClass(type) {
        type = type.toLowerCase();
        if (type == "textelement" || type == "textelement") {
            return new StiTextElement();
        }
        else if (type == "text_boxelement" || type == "textboxelement") {
            return new StiTextBoxElement();
        }
        else if (type == "tableelement" || type == "tableelement") {
            return new StiTableElement();
        }
        else if (type == "single_selectionelement" || type == "singleselectionelement") {
            return new StiSingleSelectionElement();
        }
        else if (type == "signatureelement" || type == "signatureelement") {
            return new StiSignatureElement();
        }
        else if (type == "pdfsignatureelement" || type == "pdfsignatureelement") {
            return new StiPDFSignatureElement();
        }
        else if (type == "panelelement" || type == "panelelement") {
            return new StiPanelElement();
        }
        else if (type == "number_boxelement" || type == "numberboxelement") {
            return new StiNumberBoxElement();
        }
        else if (type == "multiple_selectionelement" || type == "multipleselectionelement") {
            return new StiMultipleSelectionElement();
        }
        else if (type == "list_boxelement" || type == "listboxelement") {
            return new StiListBoxElement();
        }
        else if (type == "lineelement" || type == "lineelement") {
            return new StiLineElement();
        }
        else if (type == "labelelement" || type == "labelelement") {
            return new StiLabelElement();
        }
        else if (type == "imageelement" || type == "imageelement") {
            return new StiImageElement();
        }
        else if (type == "datetime_boxelement" || type == "datetimeboxelement") {
            return new StiDateTimeBoxElement();
        }
        else if (type == "combo_boxelement" || type == "comboboxelement") {
            return new StiComboBoxElement();
        }
        else if (type == "check_boxelement" || type == "checkboxelement") {
            return new StiCheckBoxElement();
        }
        else if (type == "buttonelement" || type == "buttonelement") {
            return new StiButtonElement();
        }
        else if (type == "barcodeelement" || type == "barcodeelement") {
            return new StiBarcodeElement();
        }
        else if (type == "addresselement" || type == "addresselement") {
            return new StiAddressElement();
        }
    }
}
StiFormPageElement.PAGE_ELEMENTS = [
    StiBarcodeElement,
    StiButtonElement,
    StiCheckBoxElement,
    StiComboBoxElement,
    StiDateTimeBoxElement,
    StiImageElement,
    StiLabelElement,
    StiLineElement,
    StiListBoxElement,
    StiMultipleSelectionElement,
    StiSignatureElement,
    StiPDFSignatureElement,
    StiSingleSelectionElement,
    StiTableElement,
    StiTextBoxElement,
    StiTextElement,
    StiNumberBoxElement,
    StiPanelElement,
    StiAddressElement,
];
//# sourceMappingURL=data:application/json;base64,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