import { Subject } from "rxjs";
import { StiStaticHelperService } from "../services/sti-static-helper.service";
import Guid from "../system/Guid";
import StiJson from "../system/StiJson";
import { StiFormSettings } from "./settings/StiFormSettings";
import { StiBarcodeElement } from "./StiBarcodeElement";
import { StiCheckBoxElement } from "./StiCheckBoxElement";
import { StiComboBoxElement } from "./StiComboBoxElement";
import { StiDateTimeBoxElement } from "./StiDateTimeBoxElement";
import { StiFormPageElement } from "./StiFormPageElement";
import { StiImageElement } from "./StiImageElement";
import { StiLabelElement } from "./StiLabelElement";
import { StiListBoxElement } from "./StiListBoxElement";
import { StiMultipleSelectionElement } from "./StiMultipleSelectionElement";
import { StiNumberBoxElement } from "./StiNumberBoxElement";
import { StiSingleSelectionElement } from "./StiSingleSelectionElement";
import { StiTextBoxElement } from "./StiTextBoxElement";
import { StiCheckBoxColumnItem } from "./table/columns/StiCheckBoxColumnItem";
import { StiComboBoxColumnItem } from "./table/columns/StiComboBoxColumnItem";
import { StiLabelColumnItem } from "./table/columns/StiLabelColumnItem";
import { StiNumberBoxColumnItem } from "./table/columns/StiNumberBoxColumnItem";
import { StiRadioButtonColumnItem } from "./table/columns/StiRadioButtonColumnItem";
import { StiTextBoxColumnItem } from "./table/columns/StiTextBoxColumnItem";
import { StiAdditionalField } from "./StiAdditionalFieldItem";
export class StiForm {
    constructor() {
        this.pages = [];
        this.formEvents = new Subject();
        this._guid = Guid.newGuid().toString();
        this._settings = new StiFormSettings(this);
        this._reportVersion = "";
        this._reportName = "";
        this._reportGuid = "";
        this._reportAlias = "";
        this._reportCreated = "";
        this._reportChanged = "";
        this._reportImage = "";
        this._versionKey = "";
        this._userId = "";
        this._formName = "Form";
        this._additionalFormFields = new Array();
        this.pages.push(new StiFormPageElement());
        this.reportCreated = StiStaticHelperService.dateToJsonDate(new Date());
    }
    get guid() {
        return this._guid;
    }
    get settings() {
        return this._settings;
    }
    set settings(value) {
        this._settings = value;
    }
    addField(name, value) {
        let field = new StiAdditionalField();
        field.key = name;
        field.value = value;
        this._additionalFormFields.push(field);
    }
    clearAdditionalFields() {
        this._additionalFormFields = [];
    }
    get additionalFormFields() {
        return this._additionalFormFields;
    }
    get allElements() {
        let elements = [];
        this.pages.forEach((page) => {
            elements.push(page.allElements);
        });
        elements = elements.reduce((a, b) => a.concat(b), []);
        return elements;
    }
    get formName() {
        return this._formName;
    }
    set formName(value) {
        this._formName = value;
    }
    get reportVersion() {
        return this._reportVersion;
    }
    set reportVersion(value) {
        this._reportVersion = value;
    }
    get reportName() {
        return this._reportName;
    }
    set reportName(value) {
        this._reportName = value;
    }
    get reportGuid() {
        return this._reportGuid;
    }
    set reportGuid(value) {
        this._reportGuid = value;
    }
    get reportAlias() {
        return this._reportAlias;
    }
    set reportAlias(value) {
        this._reportAlias = value;
    }
    get reportCreated() {
        return this._reportCreated;
    }
    set reportCreated(value) {
        this._reportCreated = value;
    }
    get reportChanged() {
        return this._reportChanged;
    }
    set reportChanged(value) {
        this._reportChanged = value;
    }
    get reportImage() {
        return this._reportImage;
    }
    set reportImage(value) {
        this._reportImage = value;
    }
    get versionKey() {
        return this._versionKey;
    }
    set versionKey(value) {
        this._versionKey = value;
    }
    get userId() {
        return this._userId;
    }
    set userId(value) {
        this._userId = value;
    }
    createTestValues() {
        let jObject = new StiJson();
        jObject.addPropertyString("TextBox", "Hello");
        jObject.addPropertyNumberNotNull("NumberBox", 1);
        jObject.addPropertyBool("Table.Cell-0-0", false);
        jObject.addPropertyBool("Table.Cell-0-1", true);
        return jObject;
    }
    setFormValues(json) {
        let element;
        for (let property of json.properties()) {
            element = { name: property.name, value: property.value };
            this.fillElement(element);
        }
    }
    fillElement(element) {
        let elem;
        let name;
        let isTable = false;
        if (element.name.indexOf(".") != -1) {
            name = element.name.slice(0, element.name.indexOf("."));
            isTable = true;
        }
        else {
            name = element.name;
        }
        this.pages.forEach((page) => {
            elem = page.allElements.find((elem) => elem.name == name);
        });
        if (elem) {
            if (isTable) {
                let cell = element.name.slice(element.name.indexOf(".") + 1, element.name.length);
                this.setTableValue(elem, cell, element.value);
            }
            else {
                this.setValue(elem, element.value);
            }
        }
    }
    setValue(element, value) {
        if (element instanceof StiTextBoxElement) {
            element.text = value;
        }
        else if (element instanceof StiNumberBoxElement) {
            element.value = value;
        }
        else if (element instanceof StiComboBoxElement) {
            element.selectedOption = value;
        }
        else if (element instanceof StiListBoxElement) {
            element.selectedOptions = value;
        }
        else if (element instanceof StiSingleSelectionElement) {
            element.selectedOption = value;
        }
        else if (element instanceof StiMultipleSelectionElement) {
            element.selectedOptions = value;
        }
        else if (element instanceof StiCheckBoxElement) {
            element.isChecked = value;
        } /* else if (element instanceof StiSignatureElement) {
          return { name: element.name ?? element.guid, value: element.contentImage };
        }  */
        else if (element instanceof StiDateTimeBoxElement) {
            element.dateValue = value;
        }
        else if (element instanceof StiImageElement) {
            element.image = value;
        }
        else if (element instanceof StiBarcodeElement) {
            element.img = value;
        }
        else if (element instanceof StiLabelElement) {
            element.text.value = value;
        }
    }
    setTableValue(element, cellPath, value) {
        let column = cellPath.split("-")[1];
        let cell = cellPath.split("-")[2];
        let tableColumn = element.columns[column];
        if (tableColumn instanceof StiTextBoxColumnItem) {
            tableColumn.cells[cell].text = value;
        }
        else if (tableColumn instanceof StiNumberBoxColumnItem) {
            tableColumn.cells[cell].value = value;
        }
        else if (tableColumn instanceof StiComboBoxColumnItem) {
            tableColumn.cells[cell].selectedIndex = value;
        }
        else if (tableColumn instanceof StiCheckBoxColumnItem) {
            tableColumn.cells[cell].isChecked = value;
        }
        else if (tableColumn instanceof StiLabelColumnItem) {
            tableColumn.cells[cell] = value;
        }
        else if (tableColumn instanceof StiRadioButtonColumnItem) {
            tableColumn.cells[cell].isChecked = value;
        }
    }
    getElementByName(elementName) {
        let finded;
        this.pages.forEach((page) => {
            if (!finded) {
                finded = page.allElements.find((e) => e.name == elementName);
            }
        });
        return finded;
    }
    saveToJsonObject(options = {}) {
        let rootJsonObject = new StiJson("", null, false, options);
        rootJsonObject.addPropertyArray("Pages", this.pages);
        rootJsonObject.addPropertyJObject("Settings", this.settings.saveToJsonObject(options));
        rootJsonObject.addPropertyString("Guid", this.guid);
        rootJsonObject.addPropertyString("FormName", this.formName);
        rootJsonObject.addPropertyString("VersionKey", this.versionKey);
        rootJsonObject.addPropertyString("UserId", this.userId);
        rootJsonObject.addPropertyArray("AdditionalFields", this.additionalFormFields);
        return rootJsonObject;
    }
    saveToReportJsonObject(options = {}) {
        let formJson = this.saveToJsonObject(options);
        let root = new StiJson();
        let pages = new StiJson();
        let formContainer = new StiJson();
        formContainer.addPropertyString("Ident", "StiFormContainer");
        formContainer.addPropertyJObject("Content", formJson);
        pages.addPropertyJObject("0", formContainer);
        root.addPropertyString("ReportVersion", this.reportVersion);
        root.addPropertyString("ReportGuid", this.reportGuid);
        root.addPropertyString("ReportName", this.reportName);
        root.addPropertyString("ReportAlias", this.reportAlias);
        root.addPropertyString("ReportCreated", this.reportCreated);
        root.addPropertyString("ReportChanged", this.reportChanged);
        root.addPropertyString("ReportImage", this.reportImage);
        root.addPropertyJObject("Pages", pages);
        return root;
    }
    loadFormJsonString(text) {
        let jObject = new StiJson();
        jObject.deserialize(text);
        this.loadFromJson(jObject);
    }
    loadFromJson(jObject) {
        var key;
        for (let property of jObject.properties()) {
            if (property.name == "ReportVersion") {
                this.reportVersion = property.value;
            }
            else if (property.name == "ReportGuid") {
                this.reportGuid = property.value;
            }
            else if (property.name == "ReportName") {
                this.reportName = property.value;
            }
            else if (property.name == "ReportAlias") {
                this.reportAlias = property.value;
            }
            else if (property.name == "ReportCreated") {
                this.reportCreated = property.value;
            }
            else if (property.name == "ReportChanged") {
                this.reportChanged = property.value;
            }
            else if (property.name == "ReportImage") {
                this.reportImage = property.value;
            }
            else if (property.name == "Script" && property.value && property.value.length < 40) {
                key = property.value;
            }
        }
        try {
            let formContainer = jObject
                .properties()
                .find((p) => p.name == "Pages")
                .properties()[0]
                .properties();
            if (formContainer.find((p) => p.name == "Ident").value == "StiFormContainer") {
                jObject = formContainer.find((p) => p.name == "Content").value;
            }
        }
        catch { }
        for (let property of jObject.properties()) {
            if (property.name == "Pages") {
                this.pages = this.deserializePages(property.value);
            }
            else if (property.name == "Settings" || property.name == "FormSettings") {
                this._settings = new StiFormSettings(this);
                this._settings.loadFromJsonObject(property.value);
            }
            else if (property.name == "Guid") {
                this._guid = property.value;
            }
            else if (property.name == "FormName") {
                this._formName = property.value;
            }
            else if (property.name == "VersionKey") {
                this._versionKey = property.value;
            }
            else if (property.name == "UserId") {
                this._userId = property.value;
            }
            else if (property.name == "AdditionalFields") {
                this._additionalFormFields = this.deserializeFields(property.value);
            }
        }
        if (key && key.length > 0) {
            this._versionKey = key;
        }
    }
    deserializePages(jObject) {
        let result = [];
        for (let property of jObject.properties()) {
            let page = new StiFormPageElement();
            page.loadFromJsonObject(property.value);
            result.push(page);
        }
        return result;
    }
    deserializeFields(jObject) {
        let result = [];
        for (let property of jObject.properties()) {
            let field = new StiAdditionalField();
            field.loadFromJsonObject(property.value);
            result.push(field);
        }
        return result;
    }
}
//# sourceMappingURL=data:application/json;base64,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