import StiPadding from "../properties/StiPadding";
import StiRectangleGeometry from "../properties/StiRectangleGeometry";
import { StiLocalizationService } from "../services/sti-localization.service";
import Color from "../system/Color";
import { Enum } from "../system/Enum";
import { StiButtonType, StiButtonSendType } from "../system/enums";
import { Font } from "../system/Font";
import { StiFormElement } from "./base/StiFormElement";
import { StiBackgroundedTextItem } from "./text/StiBackgroundedTextItem";
export class StiButtonElement extends StiFormElement {
    constructor() {
        super();
        this.type = "ButtonElement";
        this.tooltip = "";
        this.submissionMessage = "Thank you! Your submission has been sent.";
        this.text = new StiBackgroundedTextItem(StiLocalizationService.get("Buttons", "Submit"), new Font("Segoe UI", 14), Color.black(), Color.lightGray());
        this.buttonType = StiButtonType.SendForm;
        this.formSendURL = "";
        this.buttonSendType = StiButtonSendType.XFDF;
        this.geometry = new StiRectangleGeometry(100, 40);
        this.padding = new StiPadding(4, 0, 4, 0, this);
    }
    canUpdateProperty(propName) {
        return !(propName.indexOf("padding") >= 0);
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.text.font.family, this.arrayOfStylesToString(this.text.font.style), this.text.font.size);
    }
    getDefaultEditableContent() {
        return this.text;
    }
    setProperty(propName, value, oldObject) {
        super.setProperty(propName, value, oldObject);
        if (propName.startsWith("label.font") || propName == "label.color") {
            this.text.setProperty(propName.replace("label.", ""), value.clone ? value.clone() : value, oldObject);
        }
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyJObject("Text", this.text.saveToJsonObject(options));
        jObject.addPropertyEnum("ButtonType", StiButtonType, this.buttonType);
        jObject.addPropertyString("FormSendURL", this.formSendURL);
        jObject.addPropertyEnum("ButtonSendType", StiButtonSendType, this.buttonSendType);
        jObject.addPropertyString("SubmissionMessage", this.submissionMessage);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Text":
                    this.text = new StiBackgroundedTextItem();
                    this.text.loadFromJsonObject(property.value);
                    break;
                case "Tooltip":
                    this.tooltip = property.value;
                    break;
                case "ButtonType":
                    this.buttonType = Enum.parse(StiButtonType, property.value);
                    break;
                case "FormSendURL":
                    this.formSendURL = property.value;
                    break;
                case "ButtonSendType":
                    this.buttonSendType = Enum.parse(StiButtonSendType, property.value);
                    break;
                case "SubmissionMessage":
                    this.submissionMessage = property.value;
                    break;
            }
        }
    }
    htmlStyle() {
        return `${this.text.htmlStyle()};
    )}`;
    }
}
//# sourceMappingURL=data:application/json;base64,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