import StiRectangleGeometry from "../properties/StiRectangleGeometry";
import { StiLocalizationService } from "../services/sti-localization.service";
import Color from "../system/Color";
import { Enum } from "../system/Enum";
import { HatchStyle, StiBarcodeType, StiBodyBrush, StiQRCodeBodyShapeType, StiQRCodeErrorCorrectionLevel, StiQRCodeEyeBallShapeType, StiQRCodeEyeFrameShapeType, StiQRCodeSize, } from "../system/enums";
import { StiFormElement } from "./base/StiFormElement";
import { StiLabelItem } from "./text/StiLabelItem";
import { StiTextItem } from "./text/StiTextItem";
export class StiBarcodeElement extends StiFormElement {
    constructor() {
        super();
        this.type = "BarCodeElement";
        this.tooltip = "";
        this._description = new StiTextItem();
        this._barcodeType = StiBarcodeType.QRCode;
        this._matrixSize = StiQRCodeSize.Automatic;
        this._errorCorrectionLevel = StiQRCodeErrorCorrectionLevel.Level1;
        this._bodyBrushType = StiBodyBrush.Solid;
        this._bodyBrushColor = Color.black();
        this._startBodyBrushColor = Color.black();
        this._endBodyBrushColor = Color.black();
        this._bodyBrushBackColor = Color.transparent();
        this._bodyBrushForeColor = Color.black();
        this._bodyShapeType = StiQRCodeBodyShapeType.Square;
        this._bodyBrushAngle = 0;
        this._bodyBrushHatchStyle = HatchStyle.Horizontal;
        this._bodyBrushFocus = 0.5;
        this._bodyBrushBlend = 0.2;
        this._bodyBrushDrawHatch = false;
        this._eyeBallBrushType = StiBodyBrush.Solid;
        this._eyeBallBrushColor = Color.black();
        this._startEyeBallBrushColor = Color.black();
        this._endEyeBallBrushColor = Color.black();
        this._eyeBallBrushBackColor = Color.transparent();
        this._eyeBallBrushForeColor = Color.black();
        this._eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
        this._eyeBallBrushAngle = 0;
        this._eyeBallBrushHatchStyle = HatchStyle.Horizontal;
        this._eyeBallBrushFocus = 0.5;
        this._eyeBallBrushBlend = 0.2;
        this._eyeBallBrushDrawHatch = false;
        this._eyeFrameBrushType = StiBodyBrush.Solid;
        this._eyeFrameBrushColor = Color.black();
        this._startEyeFrameBrushColor = Color.black();
        this._endEyeFrameBrushColor = Color.black();
        this._eyeFrameBrushBackColor = Color.transparent();
        this._eyeFrameBrushForeColor = Color.black();
        this._eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
        this._eyeFrameBrushAngle = 0;
        this._eyeFrameBrushHatchStyle = HatchStyle.Horizontal;
        this._eyeFrameBrushFocus = 0.5;
        this._eyeFrameBrushBlend = 0.2;
        this._eyeFrameBrushDrawHatch = false;
        this._codeString = StiLocalizationService.get("Components", "StiBarCode");
        this._width = 90;
        this._height = 90;
        this._style = 1;
        this._backColor = Color.transparent();
        this._foreColor = Color.black();
        this.showProgress = false;
        this.showBodyBrushEditor = false;
        this.showEyeBallBrushEditor = false;
        this.showEyeFrameBrushEditor = false;
        this.geometry = new StiRectangleGeometry(170, 110);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Components", "StiBarCode"));
        this.backColor = Color.transparent();
        this.foreColor = Color.black();
        this.bodyBrushColor = Color.black();
        this.startBodyBrushColor = Color.black();
        this.endBodyBrushColor = Color.black();
        this.bodyBrushBackColor = Color.transparent();
        this.bodyBrushForeColor = Color.black();
        this.eyeBallBrushColor = Color.black();
        this.startEyeBallBrushColor = Color.black();
        this.endEyeBallBrushColor = Color.black();
        this.eyeBallBrushBackColor = Color.transparent();
        this.eyeBallBrushForeColor = Color.black();
        this.eyeFrameBrushColor = Color.black();
        this.startEyeFrameBrushColor = Color.black();
        this.endEyeFrameBrushColor = Color.black();
        this.eyeFrameBrushBackColor = Color.transparent();
        this.eyeFrameBrushForeColor = Color.black();
    }
    propertyChanged(propName) {
        this._isChanged = true;
    }
    get backColor() {
        return this._backColor;
    }
    set backColor(value) {
        let oldValue = this._backColor;
        if (oldValue != value) {
            this._backColor = value;
            this._backColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get foreColor() {
        return this._foreColor;
    }
    set foreColor(value) {
        let oldValue = this._foreColor;
        if (oldValue != value) {
            this._foreColor = value;
            value.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get style() {
        return this._style;
    }
    set style(value) {
        let oldValue = this._style;
        if (oldValue != value) {
            this._style = value;
            this.setStyle(value);
            this._isChanged = true;
        }
    }
    get Width() {
        return this._width;
    }
    set Width(value) {
        let oldValue = this._width;
        if (oldValue != value) {
            this._width = value;
            this._isChanged = true;
        }
    }
    get Height() {
        return this._height;
    }
    set Height(value) {
        let oldValue = this._height;
        if (oldValue != value) {
            this._height = value;
            this._isChanged = true;
        }
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    isChanged() {
        return super.isChanged() || this.label?.isChanged() || this.description?.isChanged();
    }
    setStyle(value) {
        switch (value) {
            case 1:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Solid;
                this.bodyBrushColor = Color.black();
                this.bodyShapeType = StiQRCodeBodyShapeType.Square;
                this.eyeBallBrushType = StiBodyBrush.Solid;
                this.eyeBallBrushColor = Color.black();
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Solid;
                this.eyeFrameBrushColor = Color.black();
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 2:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Solid;
                this.bodyBrushColor = Color.fromArgb(96, 75, 117);
                this.bodyShapeType = StiQRCodeBodyShapeType.Diamond;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(3, 152, 152);
                this.endEyeBallBrushColor = Color.fromArgb(44, 110, 154);
                this.eyeBallBrushAngle = 30;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Round1;
                this.eyeFrameBrushType = StiBodyBrush.Glass;
                this.eyeFrameBrushColor = Color.fromArgb(118, 202, 226);
                this.eyeFrameBrushDrawHatch = false;
                this.eyeFrameBrushBlend = 0.2;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round1;
                break;
            case 3:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Solid;
                this.bodyBrushColor = Color.fromArgb(85, 85, 85);
                this.bodyShapeType = StiQRCodeBodyShapeType.Circle;
                this.eyeBallBrushType = StiBodyBrush.Glare;
                this.startEyeBallBrushColor = Color.fromArgb(100, 115, 53);
                this.endEyeBallBrushColor = Color.fromArgb(137, 73, 106);
                this.eyeBallBrushAngle = 5;
                this.eyeBallBrushFocus = 0.5;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Circle;
                this.eyeFrameBrushType = StiBodyBrush.Glass;
                this.eyeFrameBrushColor = Color.fromArgb(57, 94, 133);
                this.eyeFrameBrushDrawHatch = false;
                this.eyeFrameBrushBlend = 0.2;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Circle;
                break;
            case 4:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(116, 46, 44);
                this.endBodyBrushColor = Color.fromArgb(33, 77, 132);
                this.bodyBrushAngle = 7;
                this.bodyBrushFocus = 0.9;
                this.bodyShapeType = StiQRCodeBodyShapeType.RoundedSquare;
                this.eyeBallBrushType = StiBodyBrush.Hatch;
                this.eyeBallBrushHatchStyle = HatchStyle.LargeCheckerBoard;
                this.eyeBallBrushForeColor = Color.fromArgb(120, 57, 72);
                this.eyeBallBrushBackColor = Color.fromArgb(105, 82, 137);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Round;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(90, 1, 179);
                this.endEyeFrameBrushColor = Color.fromArgb(59, 73, 144);
                this.eyeFrameBrushAngle = 30;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round;
                break;
            case 5:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(184, 5, 8);
                this.endBodyBrushColor = Color.fromArgb(48, 117, 132);
                this.bodyBrushAngle = 3;
                this.bodyBrushFocus = 0.5;
                this.bodyShapeType = StiQRCodeBodyShapeType.ZebraCross1;
                this.eyeBallBrushType = StiBodyBrush.Solid;
                this.eyeBallBrushColor = Color.fromArgb(12, 172, 172);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Circle;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(191, 0, 178);
                this.endEyeFrameBrushColor = Color.fromArgb(193, 0, 64);
                this.eyeFrameBrushAngle = 10;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round1;
                break;
            case 6:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(73, 57, 99);
                this.endBodyBrushColor = Color.fromArgb(1, 123, 46);
                this.bodyBrushAngle = 3;
                this.bodyBrushFocus = 0.5;
                this.bodyShapeType = StiQRCodeBodyShapeType.Dot;
                this.eyeBallBrushType = StiBodyBrush.Solid;
                this.eyeBallBrushColor = Color.fromArgb(36, 82, 143);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Dots;
                this.eyeFrameBrushType = StiBodyBrush.Glare;
                this.startEyeFrameBrushColor = Color.fromArgb(179, 1, 166);
                this.endEyeFrameBrushColor = Color.fromArgb(49, 53, 28);
                this.eyeFrameBrushAngle = 10;
                this.eyeFrameBrushFocus = 0.8;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Dots;
                break;
            case 7:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Hatch;
                this.bodyBrushHatchStyle = HatchStyle.DashedHorizontal;
                this.bodyBrushForeColor = Color.fromArgb(216, 238, 243);
                this.bodyBrushBackColor = Color.fromArgb(229, 185, 183);
                this.bodyShapeType = StiQRCodeBodyShapeType.Square;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(242, 242, 242);
                this.endEyeBallBrushColor = Color.fromArgb(255, 147, 147);
                this.eyeBallBrushAngle = 4;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Glare;
                this.startEyeFrameBrushColor = Color.fromArgb(178, 161, 199);
                this.endEyeFrameBrushColor = Color.fromArgb(253, 234, 218);
                this.eyeFrameBrushAngle = 4;
                this.eyeFrameBrushFocus = 0.5;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 8:
                this.backColor = Color.fromArgb(87, 118, 157);
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(219, 238, 243);
                this.endBodyBrushColor = Color.fromArgb(203, 184, 168);
                this.bodyBrushAngle = 5;
                this.bodyShapeType = StiQRCodeBodyShapeType.Dot;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(219, 238, 243);
                this.endEyeBallBrushColor = Color.fromArgb(203, 184, 168);
                this.eyeBallBrushAngle = 5;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(219, 238, 243);
                this.endEyeFrameBrushColor = Color.fromArgb(203, 184, 168);
                this.eyeFrameBrushAngle = 5;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 9:
                this.backColor = Color.fromArgb(144, 60, 57);
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(219, 238, 243);
                this.endBodyBrushColor = Color.fromArgb(251, 213, 181);
                this.bodyBrushAngle = 3;
                this.bodyShapeType = StiQRCodeBodyShapeType.Square;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(219, 238, 243);
                this.endEyeBallBrushColor = Color.fromArgb(251, 213, 181);
                this.eyeBallBrushAngle = 3;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(219, 238, 243);
                this.endEyeFrameBrushColor = Color.fromArgb(251, 213, 181);
                this.eyeFrameBrushAngle = 3;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 10:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Hatch;
                this.bodyBrushHatchStyle = HatchStyle.DashedHorizontal;
                this.bodyBrushForeColor = Color.fromArgb(219, 238, 243);
                this.bodyBrushBackColor = Color.fromArgb(229, 185, 183);
                this.bodyShapeType = StiQRCodeBodyShapeType.Square;
                this.eyeBallBrushType = StiBodyBrush.Hatch;
                this.eyeBallBrushHatchStyle = HatchStyle.DashedHorizontal;
                this.eyeBallBrushForeColor = Color.fromArgb(219, 238, 243);
                this.eyeBallBrushBackColor = Color.fromArgb(229, 185, 183);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Hatch;
                this.eyeFrameBrushHatchStyle = HatchStyle.DashedHorizontal;
                this.eyeFrameBrushForeColor = Color.fromArgb(219, 238, 243);
                this.eyeFrameBrushBackColor = Color.fromArgb(229, 185, 183);
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 11:
                this.foreColor = Color.fromArgb(191, 178, 205);
                this.backColor = Color.fromArgb(38, 38, 38);
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(254, 243, 255);
                this.endBodyBrushColor = Color.fromArgb(154, 143, 167);
                this.bodyBrushAngle = 1;
                this.bodyShapeType = StiQRCodeBodyShapeType.Diamond;
                this.eyeBallBrushType = StiBodyBrush.Empty;
                this.startEyeBallBrushColor = Color.fromArgb(254, 243, 255);
                this.endEyeBallBrushColor = Color.fromArgb(154, 143, 167);
                this.eyeBallBrushAngle = 3;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Empty;
                this.startEyeFrameBrushColor = Color.fromArgb(254, 243, 255);
                this.endEyeFrameBrushColor = Color.fromArgb(154, 143, 16);
                this.eyeFrameBrushAngle = 1;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 12:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(178, 161, 199);
                this.endBodyBrushColor = Color.fromArgb(0, 255, 120);
                this.bodyBrushAngle = 3;
                this.bodyBrushFocus = 0.5;
                this.bodyShapeType = StiQRCodeBodyShapeType.Dot;
                this.eyeBallBrushType = StiBodyBrush.Solid;
                this.eyeBallBrushColor = Color.fromArgb(141, 179, 226);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Dots;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(255, 147, 251);
                this.endEyeFrameBrushColor = Color.fromArgb(146, 208, 80);
                this.eyeFrameBrushAngle = 4;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Dots;
                break;
            case 13:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Solid;
                this.bodyBrushColor = Color.fromArgb(28, 125, 138);
                this.bodyShapeType = StiQRCodeBodyShapeType.ZebraVertical;
                this.eyeBallBrushType = StiBodyBrush.Solid;
                this.eyeBallBrushColor = Color.fromArgb(211, 136, 84);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.ZebraHorizontal;
                this.eyeFrameBrushType = StiBodyBrush.Solid;
                this.eyeFrameBrushColor = Color.fromArgb(88, 66, 111);
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round;
                break;
            case 14:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Solid;
                this.bodyBrushColor = Color.fromArgb(34, 82, 94);
                this.bodyShapeType = StiQRCodeBodyShapeType.RoundedSquare;
                this.eyeBallBrushType = StiBodyBrush.Solid;
                this.eyeBallBrushColor = Color.fromArgb(34, 82, 94);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Solid;
                this.eyeFrameBrushColor = Color.fromArgb(34, 82, 94);
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 15:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Hatch;
                this.bodyBrushHatchStyle = HatchStyle.DarkHorizontal;
                this.bodyBrushForeColor = Color.fromArgb(176, 71, 67);
                this.bodyBrushBackColor = Color.fromArgb(91, 139, 150);
                this.bodyShapeType = StiQRCodeBodyShapeType.Square;
                this.eyeBallBrushType = StiBodyBrush.Glare;
                this.startEyeBallBrushColor = Color.fromArgb(191, 183, 184);
                this.endEyeBallBrushColor = Color.fromArgb(199, 29, 28);
                this.eyeBallBrushAngle = 30;
                this.eyeBallBrushFocus = 0.5;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Glare;
                this.startEyeFrameBrushColor = Color.fromArgb(102, 79, 128);
                this.endEyeFrameBrushColor = Color.fromArgb(189, 95, 32);
                this.eyeFrameBrushAngle = 0;
                this.eyeFrameBrushFocus = 0;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 16:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(147, 60, 53);
                this.endBodyBrushColor = Color.fromArgb(122, 106, 66);
                this.bodyBrushAngle = 3;
                this.bodyShapeType = StiQRCodeBodyShapeType.ZebraCross2;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(147, 60, 53);
                this.endEyeBallBrushColor = Color.fromArgb(122, 106, 66);
                this.eyeBallBrushAngle = 3;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(147, 60, 53);
                this.endEyeFrameBrushColor = Color.fromArgb(122, 106, 66);
                this.eyeFrameBrushAngle = 3;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 17:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(203, 7, 203);
                this.endBodyBrushColor = Color.fromArgb(18, 158, 177);
                this.bodyBrushAngle = 5;
                this.bodyShapeType = StiQRCodeBodyShapeType.Square;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(203, 7, 203);
                this.endEyeBallBrushColor = Color.fromArgb(18, 158, 177);
                this.eyeBallBrushAngle = 5;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(203, 7, 203);
                this.endEyeFrameBrushColor = Color.fromArgb(18, 158, 177);
                this.eyeFrameBrushAngle = 5;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 18:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(138, 57, 0);
                this.endBodyBrushColor = Color.fromArgb(137, 3, 15);
                this.bodyBrushAngle = 3;
                this.bodyShapeType = StiQRCodeBodyShapeType.Star;
                this.eyeBallBrushType = StiBodyBrush.Hatch;
                this.eyeBallBrushHatchStyle = HatchStyle.Plaid;
                this.eyeBallBrushForeColor = Color.fromArgb(81, 68, 115);
                this.eyeBallBrushBackColor = Color.fromArgb(125, 42, 35);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Round3;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(131, 50, 49);
                this.endEyeFrameBrushColor = Color.fromArgb(42, 82, 92);
                this.eyeFrameBrushAngle = 8;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round3;
                break;
            case 19:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(0, 226, 120);
                this.endBodyBrushColor = Color.yellow();
                this.bodyBrushAngle = 3;
                this.bodyBrushFocus = 0.5;
                this.bodyShapeType = StiQRCodeBodyShapeType.ZebraCross1;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(178, 161, 199);
                this.endEyeBallBrushColor = Color.white();
                this.eyeBallBrushAngle = 4;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.ZebraVertical;
                this.eyeFrameBrushType = StiBodyBrush.Hatch;
                this.eyeFrameBrushHatchStyle = HatchStyle.DarkVertical;
                this.eyeFrameBrushForeColor = Color.fromArgb(253, 234, 218);
                this.eyeFrameBrushBackColor = Color.fromArgb(198, 217, 240);
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Dots;
                break;
            case 20:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(255, 147, 147);
                this.endBodyBrushColor = Color.fromArgb(219, 238, 243);
                this.bodyBrushAngle = 0;
                this.bodyBrushFocus = 0.5;
                this.bodyShapeType = StiQRCodeBodyShapeType.ZebraCross2;
                this.eyeBallBrushType = StiBodyBrush.Glass;
                this.eyeBallBrushColor = Color.fromArgb(147, 255, 255);
                this.eyeBallBrushDrawHatch = false;
                this.eyeBallBrushBlend = 0.2;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Circle;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(255, 147, 251);
                this.endEyeFrameBrushColor = Color.fromArgb(255, 147, 14);
                this.eyeFrameBrushAngle = 5;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round1;
                break;
            case 21:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.white();
                this.endBodyBrushColor = Color.fromArgb(165, 165, 165);
                this.bodyBrushAngle = 3;
                this.bodyShapeType = StiQRCodeBodyShapeType.Circle;
                this.eyeBallBrushType = StiBodyBrush.Glare;
                this.startEyeBallBrushColor = Color.fromArgb(215, 227, 188);
                this.endEyeBallBrushColor = Color.fromArgb(255, 147, 251);
                this.eyeBallBrushAngle = 5;
                this.eyeBallBrushFocus = 0.5;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Circle;
                this.eyeFrameBrushType = StiBodyBrush.Glass;
                this.eyeFrameBrushColor = Color.fromArgb(219, 229, 241);
                this.eyeFrameBrushDrawHatch = false;
                this.eyeFrameBrushBlend = 0.2;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Circle;
                break;
            case 22:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(229, 182, 183);
                this.endBodyBrushColor = Color.fromArgb(141, 179, 226);
                this.bodyBrushAngle = 7;
                this.bodyBrushFocus = 0.9;
                this.bodyShapeType = StiQRCodeBodyShapeType.RoundedSquare;
                this.eyeBallBrushType = StiBodyBrush.Hatch;
                this.eyeBallBrushHatchStyle = HatchStyle.LargeCheckerBoard;
                this.eyeBallBrushForeColor = Color.fromArgb(204, 193, 217);
                this.eyeBallBrushBackColor = Color.fromArgb(242, 220, 219);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Round;
                this.eyeFrameBrushType = StiBodyBrush.Glare;
                this.startEyeFrameBrushColor = Color.fromArgb(201, 147, 255);
                this.endEyeFrameBrushColor = Color.fromArgb(219, 229, 241);
                this.eyeFrameBrushAngle = 5;
                this.eyeFrameBrushFocus = 0.5;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round;
                break;
            case 23:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(165, 165, 165);
                this.endBodyBrushColor = Color.white();
                this.bodyBrushAngle = 3;
                this.bodyShapeType = StiQRCodeBodyShapeType.Diamond;
                this.eyeBallBrushType = StiBodyBrush.Glare;
                this.startEyeBallBrushColor = Color.fromArgb(147, 255, 255);
                this.endEyeBallBrushColor = Color.fromArgb(112, 48, 160);
                this.eyeBallBrushAngle = 5;
                this.eyeBallBrushFocus = 0.5;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Round1;
                this.eyeFrameBrushType = StiBodyBrush.Glass;
                this.eyeFrameBrushColor = Color.fromArgb(216, 238, 243);
                this.eyeFrameBrushDrawHatch = false;
                this.eyeFrameBrushBlend = 0.2;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round1;
                break;
            case 24:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(255, 40, 100);
                this.endBodyBrushColor = Color.fromArgb(146, 215, 80);
                this.bodyBrushAngle = 3;
                this.bodyBrushFocus = 0.5;
                this.bodyShapeType = StiQRCodeBodyShapeType.ZebraHorizontal;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(0, 176, 240);
                this.endEyeBallBrushColor = Color.fromArgb(229, 224, 236);
                this.eyeBallBrushAngle = 0;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Star;
                this.eyeFrameBrushType = StiBodyBrush.Hatch;
                this.eyeFrameBrushHatchStyle = HatchStyle.DashedUpwardDiagonal;
                this.eyeFrameBrushForeColor = Color.fromArgb(184, 204, 228);
                this.eyeFrameBrushBackColor = Color.fromArgb(178, 161, 199);
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Circle;
                break;
        }
    }
    resetChanged() {
        super.resetChanged();
        if (this.label != null) {
            this.label.resetChanged();
        }
        if (this.description != null) {
            this.description.resetChanged();
        }
    }
    get description() {
        return this._description;
    }
    set description(value) {
        let oldValue = this._description;
        if (oldValue != value) {
            this._description = value;
            this._isChanged = true;
        }
    }
    get barcodeType() {
        return this._barcodeType;
    }
    set barcodeType(value) {
        let oldValue = this._barcodeType;
        if (oldValue != value) {
            this._barcodeType = value;
            this._isChanged = true;
        }
    }
    get matrixSize() {
        return this._matrixSize;
    }
    set matrixSize(value) {
        let oldValue = this._matrixSize;
        if (oldValue != value) {
            this._matrixSize = value;
            this._isChanged = true;
        }
    }
    get errorCorrectionLevel() {
        return this._errorCorrectionLevel;
    }
    set errorCorrectionLevel(value) {
        let oldValue = this._errorCorrectionLevel;
        if (oldValue != value) {
            this._errorCorrectionLevel = value;
            this._isChanged = true;
        }
    }
    get codeString() {
        return this._codeString;
    }
    set codeString(value) {
        let oldValue = this._codeString;
        if (oldValue != value) {
            this._codeString = value;
            this._isChanged = true;
        }
    }
    get eyeBallBrushType() {
        return this._eyeBallBrushType;
    }
    set eyeBallBrushType(value) {
        let oldValue = this._eyeBallBrushType;
        if (oldValue != value) {
            this._eyeBallBrushType = value;
            this._isChanged = true;
        }
    }
    get eyeBallBrushColor() {
        return this._eyeBallBrushColor;
    }
    set eyeBallBrushColor(value) {
        let oldValue = this._eyeBallBrushColor;
        if (oldValue != value) {
            this._eyeBallBrushColor = value;
            this._eyeBallBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get startEyeBallBrushColor() {
        return this._startEyeBallBrushColor;
    }
    set startEyeBallBrushColor(value) {
        let oldValue = this._startEyeBallBrushColor;
        if (oldValue != value) {
            this._startEyeBallBrushColor = value;
            this._startEyeBallBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get endEyeBallBrushColor() {
        return this._endEyeBallBrushColor;
    }
    set endEyeBallBrushColor(value) {
        let oldValue = this._endEyeBallBrushColor;
        if (oldValue != value) {
            this._endEyeBallBrushColor = value;
            this._endEyeBallBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get eyeBallBrushBackColor() {
        return this._eyeBallBrushBackColor;
    }
    set eyeBallBrushBackColor(value) {
        let oldValue = this._eyeBallBrushBackColor;
        if (oldValue != value) {
            this._eyeBallBrushBackColor = value;
            this._eyeBallBrushBackColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get eyeBallBrushForeColor() {
        return this._eyeBallBrushForeColor;
    }
    set eyeBallBrushForeColor(value) {
        let oldValue = this._eyeBallBrushForeColor;
        if (oldValue != value) {
            this._eyeBallBrushForeColor = value;
            this._eyeBallBrushForeColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get eyeBallShapeType() {
        return this._eyeBallShapeType;
    }
    set eyeBallShapeType(value) {
        let oldValue = this._eyeBallShapeType;
        if (oldValue != value) {
            this._eyeBallShapeType = value;
            this._isChanged = true;
        }
    }
    get eyeBallBrushAngle() {
        return this._eyeBallBrushAngle;
    }
    set eyeBallBrushAngle(value) {
        let oldValue = this._eyeBallBrushAngle;
        if (oldValue != value) {
            if (value <= 0) {
                this._eyeBallBrushAngle = 0;
            }
            else {
                this._eyeBallBrushAngle = value;
            }
            this._isChanged = true;
        }
    }
    get eyeBallBrushHatchStyle() {
        return this._eyeBallBrushHatchStyle;
    }
    set eyeBallBrushHatchStyle(value) {
        let oldValue = this._eyeBallBrushHatchStyle;
        if (oldValue != value) {
            this._eyeBallBrushHatchStyle = value;
            this._isChanged = true;
        }
    }
    get eyeBallBrushFocus() {
        return this._eyeBallBrushFocus;
    }
    set eyeBallBrushFocus(value) {
        let oldValue = this._eyeBallBrushFocus;
        if (oldValue != value) {
            if (value <= 0) {
                this._eyeBallBrushFocus = 0;
            }
            else {
                this._eyeBallBrushFocus = value;
            }
            this._isChanged = true;
        }
    }
    get eyeBallBrushBlend() {
        return this._eyeBallBrushBlend;
    }
    set eyeBallBrushBlend(value) {
        let oldValue = this._eyeBallBrushBlend;
        if (oldValue != value) {
            if (value <= 0) {
                this._eyeBallBrushBlend = 0;
            }
            else {
                this._eyeBallBrushBlend = value;
            }
            this._isChanged = true;
        }
    }
    get eyeBallBrushDrawHatch() {
        return this._eyeBallBrushDrawHatch;
    }
    set eyeBallBrushDrawHatch(value) {
        let oldValue = this._eyeBallBrushDrawHatch;
        if (oldValue != value) {
            this._eyeBallBrushDrawHatch = value;
            this._isChanged = true;
        }
    }
    get bodyBrushType() {
        return this._bodyBrushType;
    }
    set bodyBrushType(value) {
        let oldValue = this._bodyBrushType;
        if (oldValue != value) {
            this._bodyBrushType = value;
            this._isChanged = true;
        }
    }
    get bodyBrushColor() {
        return this._bodyBrushColor;
    }
    set bodyBrushColor(value) {
        let oldValue = this._bodyBrushColor;
        if (oldValue != value) {
            this._bodyBrushColor = value;
            this._bodyBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get startBodyBrushColor() {
        return this._startBodyBrushColor;
    }
    set startBodyBrushColor(value) {
        let oldValue = this._startBodyBrushColor;
        if (oldValue != value) {
            this._startBodyBrushColor = value;
            this._startBodyBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get endBodyBrushColor() {
        return this._endBodyBrushColor;
    }
    set endBodyBrushColor(value) {
        let oldValue = this._endBodyBrushColor;
        if (oldValue != value) {
            this._endBodyBrushColor = value;
            this._endBodyBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get bodyBrushBackColor() {
        return this._bodyBrushBackColor;
    }
    set bodyBrushBackColor(value) {
        let oldValue = this._bodyBrushBackColor;
        if (oldValue != value) {
            this._bodyBrushBackColor = value;
            this._bodyBrushBackColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get bodyBrushForeColor() {
        return this._bodyBrushForeColor;
    }
    set bodyBrushForeColor(value) {
        let oldValue = this._bodyBrushForeColor;
        if (oldValue != value) {
            this._bodyBrushForeColor = value;
            this._bodyBrushForeColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get bodyShapeType() {
        return this._bodyShapeType;
    }
    set bodyShapeType(value) {
        let oldValue = this._bodyShapeType;
        if (oldValue != value) {
            this._bodyShapeType = value;
            this._isChanged = true;
        }
    }
    get bodyBrushAngle() {
        return this._bodyBrushAngle;
    }
    set bodyBrushAngle(value) {
        let oldValue = this._bodyBrushAngle;
        if (oldValue != value) {
            if (value <= 0) {
                this._bodyBrushAngle = 0;
            }
            else {
                this._bodyBrushAngle = value;
            }
            this._isChanged = true;
        }
    }
    get bodyBrushHatchStyle() {
        return this._bodyBrushHatchStyle;
    }
    set bodyBrushHatchStyle(value) {
        let oldValue = this._bodyBrushHatchStyle;
        if (oldValue != value) {
            this._bodyBrushHatchStyle = value;
            this._isChanged = true;
        }
    }
    get bodyBrushFocus() {
        return this._bodyBrushFocus;
    }
    set bodyBrushFocus(value) {
        let oldValue = this._bodyBrushFocus;
        if (oldValue != value) {
            if (value <= 0) {
                this._bodyBrushFocus = 0;
            }
            else {
                this._bodyBrushFocus = value;
            }
            this._isChanged = true;
        }
    }
    get bodyBrushBlend() {
        return this._bodyBrushBlend;
    }
    set bodyBrushBlend(value) {
        let oldValue = this._bodyBrushBlend;
        if (oldValue != value) {
            if (value <= 0) {
                this._bodyBrushBlend = 0;
            }
            else {
                this._bodyBrushBlend = value;
            }
            this._isChanged = true;
        }
    }
    get bodyBrushDrawHatch() {
        return this._bodyBrushDrawHatch;
    }
    set bodyBrushDrawHatch(value) {
        let oldValue = this._bodyBrushDrawHatch;
        if (oldValue != value) {
            this._bodyBrushDrawHatch = value;
            this._isChanged = true;
        }
    }
    get eyeFrameBrushType() {
        return this._eyeFrameBrushType;
    }
    set eyeFrameBrushType(value) {
        let oldValue = this._eyeFrameBrushType;
        if (oldValue != value) {
            this._eyeFrameBrushType = value;
            this._isChanged = true;
        }
    }
    get eyeFrameBrushColor() {
        return this._eyeFrameBrushColor;
    }
    set eyeFrameBrushColor(value) {
        let oldValue = this._eyeFrameBrushColor;
        if (oldValue != value) {
            this._eyeFrameBrushColor = value;
            this._eyeFrameBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get startEyeFrameBrushColor() {
        return this._startEyeFrameBrushColor;
    }
    set startEyeFrameBrushColor(value) {
        let oldValue = this._startEyeFrameBrushColor;
        if (oldValue != value) {
            this._startEyeFrameBrushColor = value;
            this._startEyeFrameBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get endEyeFrameBrushColor() {
        return this._endEyeFrameBrushColor;
    }
    set endEyeFrameBrushColor(value) {
        let oldValue = this._endEyeFrameBrushColor;
        if (oldValue != value) {
            this._endEyeFrameBrushColor = value;
            this._endEyeFrameBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get eyeFrameBrushBackColor() {
        return this._eyeFrameBrushBackColor;
    }
    set eyeFrameBrushBackColor(value) {
        let oldValue = this._eyeFrameBrushBackColor;
        if (oldValue != value) {
            this._eyeFrameBrushBackColor = value;
            this._eyeFrameBrushBackColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get eyeFrameBrushForeColor() {
        return this._eyeFrameBrushForeColor;
    }
    set eyeFrameBrushForeColor(value) {
        let oldValue = this._eyeFrameBrushForeColor;
        if (oldValue != value) {
            this._eyeFrameBrushForeColor = value;
            this._eyeFrameBrushForeColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get eyeFrameShapeType() {
        return this._eyeFrameShapeType;
    }
    set eyeFrameShapeType(value) {
        let oldValue = this._eyeFrameShapeType;
        if (oldValue != value) {
            this._eyeFrameShapeType = value;
            this._isChanged = true;
        }
    }
    get eyeFrameBrushAngle() {
        return this._eyeFrameBrushAngle;
    }
    set eyeFrameBrushAngle(value) {
        let oldValue = this._eyeFrameBrushAngle;
        if (oldValue != value) {
            if (value <= 0) {
                this._eyeFrameBrushAngle = 0;
            }
            else {
                this._eyeFrameBrushAngle = value;
            }
            this._isChanged = true;
        }
    }
    get eyeFrameBrushHatchStyle() {
        return this._eyeFrameBrushHatchStyle;
    }
    set eyeFrameBrushHatchStyle(value) {
        let oldValue = this._eyeFrameBrushHatchStyle;
        if (oldValue != value) {
            this._eyeFrameBrushHatchStyle = value;
            this._isChanged = true;
        }
    }
    get eyeFrameBrushFocus() {
        return this._eyeFrameBrushFocus;
    }
    set eyeFrameBrushFocus(value) {
        let oldValue = this._eyeFrameBrushFocus;
        if (oldValue != value) {
            if (value <= 0) {
                this._eyeFrameBrushFocus = 0;
            }
            else {
                this._eyeFrameBrushFocus = value;
            }
            this._isChanged = true;
        }
    }
    get eyeFrameBrushBlend() {
        return this._eyeFrameBrushBlend;
    }
    set eyeFrameBrushBlend(value) {
        let oldValue = this._eyeFrameBrushBlend;
        if (oldValue != value) {
            if (value <= 0) {
                this._eyeFrameBrushBlend = 0;
            }
            else {
                this._eyeFrameBrushBlend = value;
            }
            this._isChanged = true;
        }
    }
    get eyeFrameBrushDrawHatch() {
        return this._eyeFrameBrushDrawHatch;
    }
    set eyeFrameBrushDrawHatch(value) {
        let oldValue = this._eyeFrameBrushDrawHatch;
        if (oldValue != value) {
            this._eyeFrameBrushDrawHatch = value;
            this._isChanged = true;
        }
    }
    saveToJsonObject(options) {
        if (this.element && this.element.nativeElement) {
            if (this.element.nativeElement?.offsetWidth > 0 &&
                this.element.nativeElement?.offsetHeight > 0 &&
                (this.barcodeType == StiBarcodeType.Aztec ||
                    this.barcodeType == StiBarcodeType.QRCode ||
                    this.barcodeType == StiBarcodeType.DataMatrix ||
                    this.barcodeType == StiBarcodeType.Maxicode)) {
                if (this.element.nativeElement?.offsetWidth < this.element.nativeElement?.offsetHeight) {
                    this.Width = this.element.nativeElement?.offsetWidth;
                    this.Height = this.element.nativeElement?.offsetWidth;
                }
                else {
                    this.Width = this.element.nativeElement?.offsetHeight;
                    this.Height = this.element.nativeElement?.offsetHeight;
                }
            }
            else {
                this.Width = this.element.nativeElement?.offsetWidth;
                this.Height = this.element.nativeElement?.offsetHeight;
            }
        }
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyEnum("BarcodeType", StiBarcodeType, this.barcodeType);
        jObject.addPropertyString("CodeString", this.codeString);
        // jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyNumber("Width", this.Width);
        jObject.addPropertyNumber("Height", this.Height);
        jObject.addPropertyNumber("Style", this.style);
        jObject.addPropertyColor("BackColor", this.backColor);
        jObject.addPropertyColor("ForeColor", this.foreColor);
        jObject.addPropertyEnum("MatrixSize", StiQRCodeSize, this.matrixSize);
        jObject.addPropertyEnum("ErrorCorrectionLevel", StiQRCodeErrorCorrectionLevel, this.errorCorrectionLevel);
        jObject.addPropertyEnum("BodyBrushType", StiBodyBrush, this.bodyBrushType);
        jObject.addPropertyEnum("EyeBallBrushType", StiBodyBrush, this.eyeBallBrushType);
        jObject.addPropertyEnum("EyeFrameBrushType", StiBodyBrush, this.eyeFrameBrushType);
        jObject.addPropertyEnum("BodyShapeType", StiQRCodeBodyShapeType, this.bodyShapeType);
        jObject.addPropertyColor("BodyBrushColor", this.bodyBrushColor);
        jObject.addPropertyColor("StartBodyBrushColor", this.startBodyBrushColor);
        jObject.addPropertyColor("EndBodyBrushColor", this.endBodyBrushColor);
        jObject.addPropertyColor("BodyBrushForeColor", this.bodyBrushForeColor);
        jObject.addPropertyColor("BodyBrushBackColor", this.bodyBrushBackColor);
        jObject.addPropertyNumber("BodyBrushAngle", this.bodyBrushAngle);
        jObject.addPropertyEnum("BodyBrushHatchStyle", HatchStyle, this.bodyBrushHatchStyle);
        jObject.addPropertyNumber("BodyBrushFocus", this.bodyBrushFocus);
        jObject.addPropertyNumber("BodyBrushBlend", this.bodyBrushBlend);
        jObject.addPropertyBool("BodyBrushDrawHatch", this.bodyBrushDrawHatch);
        jObject.addPropertyColor("EyeBallBrushColor", this.eyeBallBrushColor);
        jObject.addPropertyColor("StartEyeBallBrushColor", this.startEyeBallBrushColor);
        jObject.addPropertyColor("EndEyeBallBrushColor", this.endEyeBallBrushColor);
        jObject.addPropertyEnum("EyeBallShapeType", StiQRCodeEyeBallShapeType, this.eyeBallShapeType);
        jObject.addPropertyColor("EyeBallBrushForeColor", this.eyeBallBrushForeColor);
        jObject.addPropertyColor("EyeBallBrushBackColor", this.eyeBallBrushBackColor);
        jObject.addPropertyNumber("EyeBallBrushAngle", this.eyeBallBrushAngle);
        jObject.addPropertyNumber("EyeBallBrushBlend", this.eyeBallBrushBlend);
        jObject.addPropertyEnum("EyeBallBrushHatchStyle", HatchStyle, this.eyeBallBrushHatchStyle);
        jObject.addPropertyNumber("EyeBallBrushFocus", this.eyeBallBrushFocus);
        jObject.addPropertyBool("EyeBallBrushDrawHatch", this.eyeBallBrushDrawHatch);
        jObject.addPropertyColor("EyeFrameBrushColor", this.eyeFrameBrushColor);
        jObject.addPropertyColor("StartEyeFrameBrushColor", this.startEyeFrameBrushColor);
        jObject.addPropertyColor("EndEyeFrameBrushColor", this.endEyeFrameBrushColor);
        jObject.addPropertyEnum("EyeFrameShapeType", StiQRCodeEyeFrameShapeType, this.eyeFrameShapeType);
        jObject.addPropertyColor("EyeFrameBrushForeColor", this.eyeFrameBrushForeColor);
        jObject.addPropertyColor("EyeFrameBrushBackColor", this.eyeFrameBrushBackColor);
        jObject.addPropertyNumber("EyeFrameBrushAngle", this.eyeFrameBrushAngle);
        jObject.addPropertyNumber("EyeFrameBrushBlend", this.eyeFrameBrushBlend);
        jObject.addPropertyEnum("EyeFrameBrushHatchStyle", HatchStyle, this.eyeFrameBrushHatchStyle);
        jObject.addPropertyNumber("EyeFrameBrushFocus", this.eyeFrameBrushFocus);
        jObject.addPropertyBool("EyeFrameBrushDrawHatch", this.eyeFrameBrushDrawHatch);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "BarcodeType":
                    this.barcodeType = Enum.parse(StiBarcodeType, property.value);
                    break;
                case "CodeString":
                    this.codeString = property.value;
                    break;
                /*  case "Tooltip":
                  this.tooltip = property.value;
                  break; */
                case "Width":
                    this.Width = property.value;
                    break;
                case "Height":
                    this.Height = property.value;
                    break;
                case "Style":
                    this.style = property.value;
                    break;
                case "BackColor":
                    this.backColor = new Color();
                    this.backColor.deserializeFromString(property.value);
                    break;
                case "ForeColor":
                    this.foreColor = new Color();
                    this.foreColor.deserializeFromString(property.value);
                    break;
                case "MatrixSize":
                    this.matrixSize = Enum.parse(StiQRCodeSize, property.value, false);
                    break;
                case "ErrorCorrectionLevel":
                    this.errorCorrectionLevel = Enum.parse(StiQRCodeErrorCorrectionLevel, property.value);
                    break;
                case "BodyBrushType":
                    this.bodyBrushType = Enum.parse(StiBodyBrush, property.value);
                    break;
                case "EyeBallBrushType":
                    this.eyeBallBrushType = Enum.parse(StiBodyBrush, property.value);
                    break;
                case "EyeFrameBrushType":
                    this.eyeFrameBrushType = Enum.parse(StiBodyBrush, property.value);
                    break;
                case "BodyShapeType":
                    this.bodyShapeType = Enum.parse(StiQRCodeBodyShapeType, property.value);
                    break;
                case "BodyBrushColor":
                    this.bodyBrushColor = new Color();
                    this.bodyBrushColor.deserializeFromString(property.value);
                    break;
                case "StartBodyBrushColor":
                    this.startBodyBrushColor = new Color();
                    this.startBodyBrushColor.deserializeFromString(property.value);
                    break;
                case "EndBodyBrushColor":
                    this.endBodyBrushColor = new Color();
                    this.endBodyBrushColor.deserializeFromString(property.value);
                    break;
                case "BodyBrushForeColor":
                    this.bodyBrushForeColor = new Color();
                    this.bodyBrushForeColor.deserializeFromString(property.value);
                    break;
                case "BodyBrushBackColor":
                    this.bodyBrushBackColor = new Color();
                    this.bodyBrushBackColor.deserializeFromString(property.value);
                    break;
                case "BodyBrushAngle":
                    this.bodyBrushAngle = property.value;
                    break;
                case "BodyBrushBlend":
                    this.bodyBrushBlend = property.value;
                    break;
                case "EyeBallBrushBlend":
                    this.eyeBallBrushBlend = property.value;
                    break;
                case "EyeFrameBrushBlend":
                    this.eyeFrameBrushBlend = property.value;
                    break;
                case "BodyBrushHatchStyle":
                    this.bodyBrushHatchStyle = Enum.parse(HatchStyle, property.value);
                    break;
                case "BodyBrushFocus":
                    this.bodyBrushFocus = property.value;
                    break;
                case "BodyBrushDrawHatch":
                    this.bodyBrushDrawHatch = property.value;
                    break;
                case "EyeBallBrushColor":
                    this.eyeBallBrushColor = new Color();
                    this.eyeBallBrushColor.deserializeFromString(property.value);
                    break;
                case "StartEyeBallBrushColor":
                    this.startEyeBallBrushColor = new Color();
                    this.startEyeBallBrushColor.deserializeFromString(property.value);
                    break;
                case "EndEyeBallBrushColor":
                    this.endEyeBallBrushColor = new Color();
                    this.endEyeBallBrushColor.deserializeFromString(property.value);
                    break;
                case "EyeBallShapeType":
                    this.eyeBallShapeType = Enum.parse(StiQRCodeEyeBallShapeType, property.value);
                    break;
                case "EyeBallBrushForeColor":
                    this.eyeBallBrushForeColor = new Color();
                    this.eyeBallBrushForeColor.deserializeFromString(property.value);
                    break;
                case "EyeBallBrushBackColor":
                    this.eyeBallBrushBackColor = new Color();
                    this.eyeBallBrushBackColor.deserializeFromString(property.value);
                    break;
                case "EyeBallBrushAngle":
                    this.eyeBallBrushAngle = property.value;
                    break;
                case "EyeBallBrushHatchStyle":
                    this.eyeBallBrushHatchStyle = Enum.parse(HatchStyle, property.value);
                    break;
                case "EyeBallBrushFocus":
                    this.eyeBallBrushFocus = property.value;
                    break;
                case "EyeBallBrushDrawHatch":
                    this.eyeBallBrushDrawHatch = property.value;
                    break;
                case "EyeFrameBrushColor":
                    this.eyeFrameBrushColor = new Color();
                    this.eyeFrameBrushColor.deserializeFromString(property.value);
                    break;
                case "StartEyeFrameBrushColor":
                    this.startEyeFrameBrushColor = new Color();
                    this.startEyeFrameBrushColor.deserializeFromString(property.value);
                    break;
                case "EndEyeFrameBrushColor":
                    this.endEyeFrameBrushColor = new Color();
                    this.endEyeFrameBrushColor.deserializeFromString(property.value);
                    break;
                case "EyeFrameShapeType":
                    this.eyeFrameShapeType = Enum.parse(StiQRCodeEyeFrameShapeType, property.value);
                    break;
                case "EyeFrameBrushForeColor":
                    this.eyeFrameBrushForeColor = new Color();
                    this.eyeFrameBrushForeColor.deserializeFromString(property.value);
                    break;
                case "EyeFrameBrushBackColor":
                    this.eyeFrameBrushBackColor = new Color();
                    this.eyeFrameBrushBackColor.deserializeFromString(property.value);
                    break;
                case "EyeFrameBrushAngle":
                    this.eyeFrameBrushAngle = property.value;
                    break;
                case "EyeFrameBrushHatchStyle":
                    this.eyeFrameBrushHatchStyle = Enum.parse(HatchStyle, property.value);
                    break;
                case "EyeFrameBrushFocus":
                    this.eyeFrameBrushFocus = property.value;
                    break;
                case "EyeFrameBrushDrawHatch":
                    this.eyeFrameBrushDrawHatch = property.value;
                    break;
            }
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3RpQmFyY29kZUVsZW1lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LWZvcm1zL3NyYy9saWIvZWxlbWVudHMvU3RpQmFyY29kZUVsZW1lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxvQkFBb0IsTUFBTSxvQ0FBb0MsQ0FBQztBQUV0RSxPQUFPLEVBQUUsc0JBQXNCLEVBQUUsTUFBTSxzQ0FBc0MsQ0FBQztBQUM5RSxPQUFPLEtBQUssTUFBTSxpQkFBaUIsQ0FBQztBQUNwQyxPQUFPLEVBQUUsSUFBSSxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFDdEMsT0FBTyxFQUNMLFVBQVUsRUFDVixjQUFjLEVBQ2QsWUFBWSxFQUVaLHNCQUFzQixFQUN0Qiw2QkFBNkIsRUFDN0IseUJBQXlCLEVBQ3pCLDBCQUEwQixFQUMxQixhQUFhLEdBQ2QsTUFBTSxpQkFBaUIsQ0FBQztBQUd6QixPQUFPLEVBQUUsY0FBYyxFQUFFLE1BQU0sdUJBQXVCLENBQUM7QUFDdkQsT0FBTyxFQUFFLFlBQVksRUFBRSxNQUFNLHFCQUFxQixDQUFDO0FBQ25ELE9BQU8sRUFBRSxXQUFXLEVBQUUsTUFBTSxvQkFBb0IsQ0FBQztBQUVqRCxNQUFNLE9BQU8saUJBQWtCLFNBQVEsY0FBYztJQXdIbkQ7UUFDRSxLQUFLLEVBQUUsQ0FBQztRQXhISCxTQUFJLEdBQVcsZ0JBQWdCLENBQUM7UUFDaEMsWUFBTyxHQUFHLEVBQUUsQ0FBQztRQUNaLGlCQUFZLEdBQWdCLElBQUksV0FBVyxFQUFFLENBQUM7UUFDOUMsaUJBQVksR0FBbUIsY0FBYyxDQUFDLE1BQU0sQ0FBQztRQUNyRCxnQkFBVyxHQUFrQixhQUFhLENBQUMsU0FBUyxDQUFDO1FBQ3JELDBCQUFxQixHQUFrQyw2QkFBNkIsQ0FBQyxNQUFNLENBQUM7UUFFNUYsbUJBQWMsR0FBaUIsWUFBWSxDQUFDLEtBQUssQ0FBQztRQUNsRCxvQkFBZSxHQUFVLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUN2Qyx5QkFBb0IsR0FBVSxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDNUMsdUJBQWtCLEdBQVUsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQzFDLHdCQUFtQixHQUFVLEtBQUssQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUNqRCx3QkFBbUIsR0FBVSxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDM0MsbUJBQWMsR0FBMkIsc0JBQXNCLENBQUMsTUFBTSxDQUFDO1FBQ3ZFLG9CQUFlLEdBQVcsQ0FBQyxDQUFDO1FBQzVCLHlCQUFvQixHQUFlLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDekQsb0JBQWUsR0FBVyxHQUFHLENBQUM7UUFDOUIsb0JBQWUsR0FBVyxHQUFHLENBQUM7UUFDOUIsd0JBQW1CLEdBQVksS0FBSyxDQUFDO1FBRXJDLHNCQUFpQixHQUFpQixZQUFZLENBQUMsS0FBSyxDQUFDO1FBQ3JELHVCQUFrQixHQUFVLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUMxQyw0QkFBdUIsR0FBVSxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDL0MsMEJBQXFCLEdBQVUsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQzdDLDJCQUFzQixHQUFVLEtBQUssQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUNwRCwyQkFBc0IsR0FBVSxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDOUMsc0JBQWlCLEdBQThCLHlCQUF5QixDQUFDLE1BQU0sQ0FBQztRQUNoRix1QkFBa0IsR0FBVyxDQUFDLENBQUM7UUFDL0IsNEJBQXVCLEdBQWUsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUM1RCx1QkFBa0IsR0FBVyxHQUFHLENBQUM7UUFDakMsdUJBQWtCLEdBQVcsR0FBRyxDQUFDO1FBQ2pDLDJCQUFzQixHQUFZLEtBQUssQ0FBQztRQUV4Qyx1QkFBa0IsR0FBaUIsWUFBWSxDQUFDLEtBQUssQ0FBQztRQUN0RCx3QkFBbUIsR0FBVSxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDM0MsNkJBQXdCLEdBQVUsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ2hELDJCQUFzQixHQUFVLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUM5Qyw0QkFBdUIsR0FBVSxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7UUFDckQsNEJBQXVCLEdBQVUsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQy9DLHVCQUFrQixHQUErQiwwQkFBMEIsQ0FBQyxNQUFNLENBQUM7UUFDbkYsd0JBQW1CLEdBQVcsQ0FBQyxDQUFDO1FBQ2hDLDZCQUF3QixHQUFlLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDN0Qsd0JBQW1CLEdBQVcsR0FBRyxDQUFDO1FBQ2xDLHdCQUFtQixHQUFXLEdBQUcsQ0FBQztRQUNsQyw0QkFBdUIsR0FBWSxLQUFLLENBQUM7UUFFekMsZ0JBQVcsR0FBRyxzQkFBc0IsQ0FBQyxHQUFHLENBQUMsWUFBWSxFQUFFLFlBQVksQ0FBQyxDQUFDO1FBQ3JFLFdBQU0sR0FBVyxFQUFFLENBQUM7UUFDcEIsWUFBTyxHQUFXLEVBQUUsQ0FBQztRQUNyQixXQUFNLEdBQVcsQ0FBQyxDQUFDO1FBQ25CLGVBQVUsR0FBVSxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7UUFDeEMsZUFBVSxHQUFVLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUNuQyxpQkFBWSxHQUFHLEtBQUssQ0FBQztRQUdyQix3QkFBbUIsR0FBWSxLQUFLLENBQUM7UUFDckMsMkJBQXNCLEdBQVksS0FBSyxDQUFDO1FBQ3hDLDRCQUF1QixHQUFZLEtBQUssQ0FBQztRQWdFOUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLG9CQUFvQixDQUFDLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztRQUNuRCxJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksWUFBWSxDQUFDLElBQUksRUFBRSxzQkFBc0IsQ0FBQyxHQUFHLENBQUMsWUFBWSxFQUFFLFlBQVksQ0FBQyxDQUFDLENBQUM7UUFDNUYsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7UUFDckMsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFFL0IsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDcEMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUN6QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7UUFDOUMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUV4QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDNUMsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUMxQyxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDLFdBQVcsRUFBRSxDQUFDO1FBQ2pELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFFM0MsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUN4QyxJQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQzdDLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDM0MsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUNsRCxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO0lBQzlDLENBQUM7SUFwRkQsZUFBZSxDQUFDLFFBQWdCO1FBQzlCLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO0lBQ3pCLENBQUM7SUFFRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFDRCxJQUFXLFNBQVMsQ0FBQyxLQUFZO1FBQy9CLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUM7UUFDL0IsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO1lBQ3hCLElBQUksQ0FBQyxVQUFVLENBQUMsa0JBQWtCLEdBQUcsSUFBSSxDQUFDO1lBQzFDLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUVELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUNELElBQVcsU0FBUyxDQUFDLEtBQVk7UUFDL0IsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQztRQUMvQixJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7WUFDeEIsS0FBSyxDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztZQUNoQyxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFFRCxJQUFXLEtBQUs7UUFDZCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDckIsQ0FBQztJQUNELElBQVcsS0FBSyxDQUFDLEtBQWE7UUFDNUIsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUM7WUFDcEIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUNyQixJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFDRCxJQUFXLEtBQUs7UUFDZCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDckIsQ0FBQztJQUNELElBQVcsS0FBSyxDQUFDLEtBQWE7UUFDNUIsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUM7WUFDcEIsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBQ0QsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7UUFDNUIsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO1lBQ3JCLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQTRCTSxZQUFZLENBQUMsU0FBMkI7UUFDN0MsS0FBSyxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUM5QixTQUFTLENBQUMsR0FBRyxDQUNYLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFDNUIsSUFBSSxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxFQUN2RCxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQzNCLENBQUM7SUFDSixDQUFDO0lBQ00sU0FBUztRQUNkLE9BQU8sS0FBSyxDQUFDLFNBQVMsRUFBRSxJQUFJLElBQUksQ0FBQyxLQUFLLEVBQUUsU0FBUyxFQUFFLElBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxTQUFTLEVBQUUsQ0FBQztJQUN2RixDQUFDO0lBQ00sUUFBUSxDQUFDLEtBQWE7UUFDM0IsUUFBUSxLQUFLLEVBQUU7WUFDYixLQUFLLENBQUM7Z0JBQ0osSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7Z0JBQ3JDLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDeEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQ3BDLElBQUksQ0FBQyxhQUFhLEdBQUcsc0JBQXNCLENBQUMsTUFBTSxDQUFDO2dCQUNuRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDM0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztnQkFDdkMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLHlCQUF5QixDQUFDLE1BQU0sQ0FBQztnQkFDekQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQzVDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQ3hDLElBQUksQ0FBQyxpQkFBaUIsR0FBRywwQkFBMEIsQ0FBQyxNQUFNLENBQUM7Z0JBQzNELE1BQU07WUFDUixLQUFLLENBQUM7Z0JBQ0osSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7Z0JBQ3JDLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDeEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxFQUFFLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQ2xELElBQUksQ0FBQyxhQUFhLEdBQUcsc0JBQXNCLENBQUMsT0FBTyxDQUFDO2dCQUNwRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsWUFBWSxDQUFDLFFBQVEsQ0FBQztnQkFDOUMsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDMUQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDekQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEVBQUUsQ0FBQztnQkFDNUIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLHlCQUF5QixDQUFDLE1BQU0sQ0FBQztnQkFDekQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQzVDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQ3hELElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUM7Z0JBQ3BDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxHQUFHLENBQUM7Z0JBQzlCLElBQUksQ0FBQyxpQkFBaUIsR0FBRywwQkFBMEIsQ0FBQyxNQUFNLENBQUM7Z0JBQzNELE1BQU07WUFDUixLQUFLLENBQUM7Z0JBQ0osSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7Z0JBQ3JDLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDeEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQ2pELElBQUksQ0FBQyxhQUFhLEdBQUcsc0JBQXNCLENBQUMsTUFBTSxDQUFDO2dCQUNuRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDM0MsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDM0QsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDekQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLENBQUMsQ0FBQztnQkFDM0IsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEdBQUcsQ0FBQztnQkFDN0IsSUFBSSxDQUFDLGdCQUFnQixHQUFHLHlCQUF5QixDQUFDLE1BQU0sQ0FBQztnQkFDekQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQzVDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxFQUFFLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQ3RELElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUM7Z0JBQ3BDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxHQUFHLENBQUM7Z0JBQzlCLElBQUksQ0FBQyxpQkFBaUIsR0FBRywwQkFBMEIsQ0FBQyxNQUFNLENBQUM7Z0JBQzNELE1BQU07WUFDUixLQUFLLENBQUM7Z0JBQ0osSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7Z0JBQ3JDLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDeEMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDdkQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxFQUFFLEVBQUUsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDckQsSUFBSSxDQUFDLGNBQWMsR0FBRyxDQUFDLENBQUM7Z0JBQ3hCLElBQUksQ0FBQyxjQUFjLEdBQUcsR0FBRyxDQUFDO2dCQUMxQixJQUFJLENBQUMsYUFBYSxHQUFHLHNCQUFzQixDQUFDLGFBQWEsQ0FBQztnQkFDMUQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQzNDLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxVQUFVLENBQUMsaUJBQWlCLENBQUM7Z0JBQzNELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQ3pELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxFQUFFLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzFELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyx5QkFBeUIsQ0FBQyxLQUFLLENBQUM7Z0JBQ3hELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxZQUFZLENBQUMsUUFBUSxDQUFDO2dCQUMvQyxJQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUMxRCxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxFQUFFLEVBQUUsRUFBRSxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN6RCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsRUFBRSxDQUFDO2dCQUM3QixJQUFJLENBQUMsaUJBQWlCLEdBQUcsMEJBQTBCLENBQUMsS0FBSyxDQUFDO2dCQUMxRCxNQUFNO1lBQ1IsS0FBSyxDQUFDO2dCQUNKLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFdBQVcsRUFBRSxDQUFDO2dCQUNyQyxJQUFJLENBQUMsYUFBYSxHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQ3hDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7Z0JBQ3JELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQ3RELElBQUksQ0FBQyxjQUFjLEdBQUcsQ0FBQyxDQUFDO2dCQUN4QixJQUFJLENBQUMsY0FBYyxHQUFHLEdBQUcsQ0FBQztnQkFDMUIsSUFBSSxDQUFDLGFBQWEsR0FBRyxzQkFBc0IsQ0FBQyxXQUFXLENBQUM7Z0JBQ3hELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDO2dCQUMzQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxFQUFFLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN0RCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcseUJBQXlCLENBQUMsTUFBTSxDQUFDO2dCQUN6RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsWUFBWSxDQUFDLFFBQVEsQ0FBQztnQkFDL0MsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLENBQUMsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDM0QsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDeEQsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEVBQUUsQ0FBQztnQkFDN0IsSUFBSSxDQUFDLGlCQUFpQixHQUFHLDBCQUEwQixDQUFDLE1BQU0sQ0FBQztnQkFDM0QsTUFBTTtZQUNSLEtBQUssQ0FBQztnQkFDSixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxXQUFXLEVBQUUsQ0FBQztnQkFDckMsSUFBSSxDQUFDLGFBQWEsR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDO2dCQUN4QyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxFQUFFLEVBQUUsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUN0RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxDQUFDLEVBQUUsR0FBRyxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUNwRCxJQUFJLENBQUMsY0FBYyxHQUFHLENBQUMsQ0FBQztnQkFDeEIsSUFBSSxDQUFDLGNBQWMsR0FBRyxHQUFHLENBQUM7Z0JBQzFCLElBQUksQ0FBQyxhQUFhLEdBQUcsc0JBQXNCLENBQUMsR0FBRyxDQUFDO2dCQUNoRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDM0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxFQUFFLEVBQUUsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDckQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLHlCQUF5QixDQUFDLElBQUksQ0FBQztnQkFDdkQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQzVDLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzNELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQ3hELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxFQUFFLENBQUM7Z0JBQzdCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxHQUFHLENBQUM7Z0JBQzlCLElBQUksQ0FBQyxpQkFBaUIsR0FBRywwQkFBMEIsQ0FBQyxJQUFJLENBQUM7Z0JBQ3pELE1BQU07WUFDUixLQUFLLENBQUM7Z0JBQ0osSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQzVDLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDeEMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDdkQsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDeEQsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDeEQsSUFBSSxDQUFDLGFBQWEsR0FBRyxzQkFBc0IsQ0FBQyxNQUFNLENBQUM7Z0JBQ25ELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxZQUFZLENBQUMsUUFBUSxDQUFDO2dCQUM5QyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUM1RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUMxRCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsQ0FBQyxDQUFDO2dCQUMzQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcseUJBQXlCLENBQUMsTUFBTSxDQUFDO2dCQUN6RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDNUMsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDN0QsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDM0QsSUFBSSxDQUFDLGtCQUFrQixHQUFHLENBQUMsQ0FBQztnQkFDNUIsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEdBQUcsQ0FBQztnQkFDOUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLDBCQUEwQixDQUFDLE1BQU0sQ0FBQztnQkFDM0QsTUFBTTtZQUNSLEtBQUssQ0FBQztnQkFDSixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDOUMsSUFBSSxDQUFDLGFBQWEsR0FBRyxZQUFZLENBQUMsUUFBUSxDQUFDO2dCQUMzQyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN6RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN2RCxJQUFJLENBQUMsY0FBYyxHQUFHLENBQUMsQ0FBQztnQkFDeEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxzQkFBc0IsQ0FBQyxHQUFHLENBQUM7Z0JBQ2hELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxZQUFZLENBQUMsUUFBUSxDQUFDO2dCQUM5QyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUM1RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUMxRCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsQ0FBQyxDQUFDO2dCQUMzQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcseUJBQXlCLENBQUMsTUFBTSxDQUFDO2dCQUN6RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsWUFBWSxDQUFDLFFBQVEsQ0FBQztnQkFDL0MsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDN0QsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDM0QsSUFBSSxDQUFDLGtCQUFrQixHQUFHLENBQUMsQ0FBQztnQkFDNUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLDBCQUEwQixDQUFDLE1BQU0sQ0FBQztnQkFDM0QsTUFBTTtZQUNSLEtBQUssQ0FBQztnQkFDSixJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDN0MsSUFBSSxDQUFDLGFBQWEsR0FBRyxZQUFZLENBQUMsUUFBUSxDQUFDO2dCQUMzQyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN6RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN2RCxJQUFJLENBQUMsY0FBYyxHQUFHLENBQUMsQ0FBQztnQkFDeEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxzQkFBc0IsQ0FBQyxNQUFNLENBQUM7Z0JBQ25ELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxZQUFZLENBQUMsUUFBUSxDQUFDO2dCQUM5QyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUM1RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUMxRCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsQ0FBQyxDQUFDO2dCQUMzQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcseUJBQXlCLENBQUMsTUFBTSxDQUFDO2dCQUN6RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsWUFBWSxDQUFDLFFBQVEsQ0FBQztnQkFDL0MsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDN0QsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDM0QsSUFBSSxDQUFDLGtCQUFrQixHQUFHLENBQUMsQ0FBQztnQkFDNUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLDBCQUEwQixDQUFDLE1BQU0sQ0FBQztnQkFDM0QsTUFBTTtZQUNSLEtBQUssRUFBRTtnQkFDTCxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxFQUFFLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDNUMsSUFBSSxDQUFDLGFBQWEsR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDO2dCQUN4QyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsVUFBVSxDQUFDLGdCQUFnQixDQUFDO2dCQUN2RCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN4RCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN4RCxJQUFJLENBQUMsYUFBYSxHQUFHLHNCQUFzQixDQUFDLE1BQU0sQ0FBQztnQkFDbkQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQzNDLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7Z0JBQzFELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzNELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzNELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyx5QkFBeUIsQ0FBQyxNQUFNLENBQUM7Z0JBQ3pELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDO2dCQUM1QyxJQUFJLENBQUMsdUJBQXVCLEdBQUcsVUFBVSxDQUFDLGdCQUFnQixDQUFDO2dCQUMzRCxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUM1RCxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUM1RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsMEJBQTBCLENBQUMsTUFBTSxDQUFDO2dCQUMzRCxNQUFNO1lBQ1IsS0FBSyxFQUFFO2dCQUNMLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUMvQyxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxFQUFFLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDNUMsSUFBSSxDQUFDLGFBQWEsR0FBRyxZQUFZLENBQUMsUUFBUSxDQUFDO2dCQUMzQyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN6RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN2RCxJQUFJLENBQUMsY0FBYyxHQUFHLENBQUMsQ0FBQztnQkFDeEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxzQkFBc0IsQ0FBQyxPQUFPLENBQUM7Z0JBQ3BELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDO2dCQUMzQyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUM1RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUMxRCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsQ0FBQyxDQUFDO2dCQUMzQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcseUJBQXlCLENBQUMsTUFBTSxDQUFDO2dCQUN6RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDNUMsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDN0QsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDMUQsSUFBSSxDQUFDLGtCQUFrQixHQUFHLENBQUMsQ0FBQztnQkFDNUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLDBCQUEwQixDQUFDLE1BQU0sQ0FBQztnQkFDM0QsTUFBTTtZQUNSLEtBQUssRUFBRTtnQkFDTCxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxFQUFFLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDNUMsSUFBSSxDQUFDLGFBQWEsR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDO2dCQUN4QyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN6RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxDQUFDLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUNyRCxJQUFJLENBQUMsY0FBYyxHQUFHLENBQUMsQ0FBQztnQkFDeEIsSUFBSSxDQUFDLGNBQWMsR0FBRyxHQUFHLENBQUM7Z0JBQzFCLElBQUksQ0FBQyxhQUFhLEdBQUcsc0JBQXNCLENBQUMsR0FBRyxDQUFDO2dCQUNoRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDM0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDdkQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLHlCQUF5QixDQUFDLElBQUksQ0FBQztnQkFDdkQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFlBQVksQ0FBQyxRQUFRLENBQUM7Z0JBQy9DLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzdELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQzFELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxDQUFDLENBQUM7Z0JBQzVCLElBQUksQ0FBQyxpQkFBaUIsR0FBRywwQkFBMEIsQ0FBQyxJQUFJLENBQUM7Z0JBQ3pELE1BQU07WUFDUixLQUFLLEVBQUU7Z0JBQ0wsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7Z0JBQ3JDLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDeEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQ25ELElBQUksQ0FBQyxhQUFhLEdBQUcsc0JBQXNCLENBQUMsYUFBYSxDQUFDO2dCQUMxRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDM0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDdEQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLHlCQUF5QixDQUFDLGVBQWUsQ0FBQztnQkFDbEUsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQzVDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxFQUFFLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQ3RELElBQUksQ0FBQyxpQkFBaUIsR0FBRywwQkFBMEIsQ0FBQyxLQUFLLENBQUM7Z0JBQzFELE1BQU07WUFDUixLQUFLLEVBQUU7Z0JBQ0wsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7Z0JBQ3JDLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDeEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQ2pELElBQUksQ0FBQyxhQUFhLEdBQUcsc0JBQXNCLENBQUMsYUFBYSxDQUFDO2dCQUMxRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDM0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxFQUFFLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDcEQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLHlCQUF5QixDQUFDLE1BQU0sQ0FBQztnQkFDekQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQzVDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQ3JELElBQUksQ0FBQyxpQkFBaUIsR0FBRywwQkFBMEIsQ0FBQyxNQUFNLENBQUM7Z0JBQzNELE1BQU07WUFDUixLQUFLLEVBQUU7Z0JBQ0wsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7Z0JBQ3JDLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDeEMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLFVBQVUsQ0FBQyxjQUFjLENBQUM7Z0JBQ3JELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQ3RELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQ3ZELElBQUksQ0FBQyxhQUFhLEdBQUcsc0JBQXNCLENBQUMsTUFBTSxDQUFDO2dCQUNuRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDM0MsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDNUQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDeEQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEVBQUUsQ0FBQztnQkFDNUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEdBQUcsQ0FBQztnQkFDN0IsSUFBSSxDQUFDLGdCQUFnQixHQUFHLHlCQUF5QixDQUFDLE1BQU0sQ0FBQztnQkFDekQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQzVDLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxFQUFFLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzVELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQ3pELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxDQUFDLENBQUM7Z0JBQzVCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxDQUFDLENBQUM7Z0JBQzVCLElBQUksQ0FBQyxpQkFBaUIsR0FBRywwQkFBMEIsQ0FBQyxNQUFNLENBQUM7Z0JBQzNELE1BQU07WUFDUixLQUFLLEVBQUU7Z0JBQ0wsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7Z0JBQ3JDLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDLFFBQVEsQ0FBQztnQkFDM0MsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDdkQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDdEQsSUFBSSxDQUFDLGNBQWMsR0FBRyxDQUFDLENBQUM7Z0JBQ3hCLElBQUksQ0FBQyxhQUFhLEdBQUcsc0JBQXNCLENBQUMsV0FBVyxDQUFDO2dCQUN4RCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsWUFBWSxDQUFDLFFBQVEsQ0FBQztnQkFDOUMsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDMUQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDekQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLENBQUMsQ0FBQztnQkFDM0IsSUFBSSxDQUFDLGdCQUFnQixHQUFHLHlCQUF5QixDQUFDLE1BQU0sQ0FBQztnQkFDekQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFlBQVksQ0FBQyxRQUFRLENBQUM7Z0JBQy9DLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQzNELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQzFELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxDQUFDLENBQUM7Z0JBQzVCLElBQUksQ0FBQyxpQkFBaUIsR0FBRywwQkFBMEIsQ0FBQyxNQUFNLENBQUM7Z0JBQzNELE1BQU07WUFDUixLQUFLLEVBQUU7Z0JBQ0wsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7Z0JBQ3JDLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDLFFBQVEsQ0FBQztnQkFDM0MsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLENBQUMsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDdkQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDdEQsSUFBSSxDQUFDLGNBQWMsR0FBRyxDQUFDLENBQUM7Z0JBQ3hCLElBQUksQ0FBQyxhQUFhLEdBQUcsc0JBQXNCLENBQUMsTUFBTSxDQUFDO2dCQUNuRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsWUFBWSxDQUFDLFFBQVEsQ0FBQztnQkFDOUMsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLENBQUMsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDMUQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDekQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLENBQUMsQ0FBQztnQkFDM0IsSUFBSSxDQUFDLGdCQUFnQixHQUFHLHlCQUF5QixDQUFDLE1BQU0sQ0FBQztnQkFDekQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFlBQVksQ0FBQyxRQUFRLENBQUM7Z0JBQy9DLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzNELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzFELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxDQUFDLENBQUM7Z0JBQzVCLElBQUksQ0FBQyxpQkFBaUIsR0FBRywwQkFBMEIsQ0FBQyxNQUFNLENBQUM7Z0JBQzNELE1BQU07WUFDUixLQUFLLEVBQUU7Z0JBQ0wsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsV0FBVyxFQUFFLENBQUM7Z0JBQ3JDLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDLFFBQVEsQ0FBQztnQkFDM0MsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQztnQkFDdEQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDcEQsSUFBSSxDQUFDLGNBQWMsR0FBRyxDQUFDLENBQUM7Z0JBQ3hCLElBQUksQ0FBQyxhQUFhLEdBQUcsc0JBQXNCLENBQUMsSUFBSSxDQUFDO2dCQUNqRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDM0MsSUFBSSxDQUFDLHNCQUFzQixHQUFHLFVBQVUsQ0FBQyxLQUFLLENBQUM7Z0JBQy9DLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxFQUFFLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQ3pELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQ3pELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyx5QkFBeUIsQ0FBQyxNQUFNLENBQUM7Z0JBQ3pELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxZQUFZLENBQUMsUUFBUSxDQUFDO2dCQUMvQyxJQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUMzRCxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxFQUFFLEVBQUUsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUN4RCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsQ0FBQyxDQUFDO2dCQUM1QixJQUFJLENBQUMsaUJBQWlCLEdBQUcsMEJBQTBCLENBQUMsTUFBTSxDQUFDO2dCQUMzRCxNQUFNO1lBQ1IsS0FBSyxFQUFFO2dCQUNMLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxFQUFFLEVBQUUsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUM1QyxJQUFJLENBQUMsYUFBYSxHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQ3hDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLENBQUMsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQ3ZELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsTUFBTSxFQUFFLENBQUM7Z0JBQ3hDLElBQUksQ0FBQyxjQUFjLEdBQUcsQ0FBQyxDQUFDO2dCQUN4QixJQUFJLENBQUMsY0FBYyxHQUFHLEdBQUcsQ0FBQztnQkFDMUIsSUFBSSxDQUFDLGFBQWEsR0FBRyxzQkFBc0IsQ0FBQyxXQUFXLENBQUM7Z0JBQ3hELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxZQUFZLENBQUMsUUFBUSxDQUFDO2dCQUM5QyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUM1RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO2dCQUMxQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsQ0FBQyxDQUFDO2dCQUMzQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcseUJBQXlCLENBQUMsYUFBYSxDQUFDO2dCQUNoRSxJQUFJLENBQUMsaUJBQWlCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDNUMsSUFBSSxDQUFDLHVCQUF1QixHQUFHLFVBQVUsQ0FBQyxZQUFZLENBQUM7Z0JBQ3ZELElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzVELElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzVELElBQUksQ0FBQyxpQkFBaUIsR0FBRywwQkFBMEIsQ0FBQyxJQUFJLENBQUM7Z0JBQ3pELE1BQU07WUFDUixLQUFLLEVBQUU7Z0JBQ0wsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEVBQUUsRUFBRSxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUM7Z0JBQzVDLElBQUksQ0FBQyxhQUFhLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDeEMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDekQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDdkQsSUFBSSxDQUFDLGNBQWMsR0FBRyxDQUFDLENBQUM7Z0JBQ3hCLElBQUksQ0FBQyxjQUFjLEdBQUcsR0FBRyxDQUFDO2dCQUMxQixJQUFJLENBQUMsYUFBYSxHQUFHLHNCQUFzQixDQUFDLFdBQVcsQ0FBQztnQkFDeEQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQzNDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQ3ZELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUM7Z0JBQ25DLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxHQUFHLENBQUM7Z0JBQzdCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyx5QkFBeUIsQ0FBQyxNQUFNLENBQUM7Z0JBQ3pELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxZQUFZLENBQUMsUUFBUSxDQUFDO2dCQUMvQyxJQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUM3RCxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUMxRCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsQ0FBQyxDQUFDO2dCQUM1QixJQUFJLENBQUMsaUJBQWlCLEdBQUcsMEJBQTBCLENBQUMsTUFBTSxDQUFDO2dCQUMzRCxNQUFNO1lBQ1IsS0FBSyxFQUFFO2dCQUNMLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxFQUFFLEVBQUUsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUM1QyxJQUFJLENBQUMsYUFBYSxHQUFHLFlBQVksQ0FBQyxRQUFRLENBQUM7Z0JBQzNDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQ3pDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQ3ZELElBQUksQ0FBQyxjQUFjLEdBQUcsQ0FBQyxDQUFDO2dCQUN4QixJQUFJLENBQUMsYUFBYSxHQUFHLHNCQUFzQixDQUFDLE1BQU0sQ0FBQztnQkFDbkQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQzNDLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzVELElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzFELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxDQUFDLENBQUM7Z0JBQzNCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxHQUFHLENBQUM7Z0JBQzdCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyx5QkFBeUIsQ0FBQyxNQUFNLENBQUM7Z0JBQ3pELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDO2dCQUM1QyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN4RCxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDO2dCQUNwQyxJQUFJLENBQUMsa0JBQWtCLEdBQUcsR0FBRyxDQUFDO2dCQUM5QixJQUFJLENBQUMsaUJBQWlCLEdBQUcsMEJBQTBCLENBQUMsTUFBTSxDQUFDO2dCQUMzRCxNQUFNO1lBQ1IsS0FBSyxFQUFFO2dCQUNMLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxFQUFFLEVBQUUsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUM1QyxJQUFJLENBQUMsYUFBYSxHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQ3hDLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQ3pELElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQ3ZELElBQUksQ0FBQyxjQUFjLEdBQUcsQ0FBQyxDQUFDO2dCQUN4QixJQUFJLENBQUMsY0FBYyxHQUFHLEdBQUcsQ0FBQztnQkFDMUIsSUFBSSxDQUFDLGFBQWEsR0FBRyxzQkFBc0IsQ0FBQyxhQUFhLENBQUM7Z0JBQzFELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDO2dCQUMzQyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsVUFBVSxDQUFDLGlCQUFpQixDQUFDO2dCQUMzRCxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUMzRCxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUMzRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcseUJBQXlCLENBQUMsS0FBSyxDQUFDO2dCQUN4RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDNUMsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDN0QsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDM0QsSUFBSSxDQUFDLGtCQUFrQixHQUFHLENBQUMsQ0FBQztnQkFDNUIsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEdBQUcsQ0FBQztnQkFDOUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLDBCQUEwQixDQUFDLEtBQUssQ0FBQztnQkFDMUQsTUFBTTtZQUNSLEtBQUssRUFBRTtnQkFDTCxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxFQUFFLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDNUMsSUFBSSxDQUFDLGFBQWEsR0FBRyxZQUFZLENBQUMsUUFBUSxDQUFDO2dCQUMzQyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN6RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO2dCQUN2QyxJQUFJLENBQUMsY0FBYyxHQUFHLENBQUMsQ0FBQztnQkFDeEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxzQkFBc0IsQ0FBQyxPQUFPLENBQUM7Z0JBQ3BELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDO2dCQUMzQyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUM1RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsRUFBRSxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN6RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsQ0FBQyxDQUFDO2dCQUMzQixJQUFJLENBQUMsaUJBQWlCLEdBQUcsR0FBRyxDQUFDO2dCQUM3QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcseUJBQXlCLENBQUMsTUFBTSxDQUFDO2dCQUN6RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsWUFBWSxDQUFDLEtBQUssQ0FBQztnQkFDNUMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDeEQsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQztnQkFDcEMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEdBQUcsQ0FBQztnQkFDOUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLDBCQUEwQixDQUFDLE1BQU0sQ0FBQztnQkFDM0QsTUFBTTtZQUNSLEtBQUssRUFBRTtnQkFDTCxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxFQUFFLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztnQkFDNUMsSUFBSSxDQUFDLGFBQWEsR0FBRyxZQUFZLENBQUMsS0FBSyxDQUFDO2dCQUN4QyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsRUFBRSxFQUFFLEdBQUcsQ0FBQyxDQUFDO2dCQUN4RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUN0RCxJQUFJLENBQUMsY0FBYyxHQUFHLENBQUMsQ0FBQztnQkFDeEIsSUFBSSxDQUFDLGNBQWMsR0FBRyxHQUFHLENBQUM7Z0JBQzFCLElBQUksQ0FBQyxhQUFhLEdBQUcsc0JBQXNCLENBQUMsZUFBZSxDQUFDO2dCQUM1RCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsWUFBWSxDQUFDLFFBQVEsQ0FBQztnQkFDOUMsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDMUQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFDMUQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLENBQUMsQ0FBQztnQkFDM0IsSUFBSSxDQUFDLGdCQUFnQixHQUFHLHlCQUF5QixDQUFDLElBQUksQ0FBQztnQkFDdkQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFlBQVksQ0FBQyxLQUFLLENBQUM7Z0JBQzVDLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxVQUFVLENBQUMsb0JBQW9CLENBQUM7Z0JBQy9ELElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzVELElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUM7Z0JBQzVELElBQUksQ0FBQyxpQkFBaUIsR0FBRywwQkFBMEIsQ0FBQyxNQUFNLENBQUM7Z0JBQzNELE1BQU07U0FDVDtJQUNILENBQUM7SUFFTSxZQUFZO1FBQ2pCLEtBQUssQ0FBQyxZQUFZLEVBQUUsQ0FBQztRQUNyQixJQUFJLElBQUksQ0FBQyxLQUFLLElBQUksSUFBSSxFQUFFO1lBQ3RCLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxFQUFFLENBQUM7U0FDM0I7UUFDRCxJQUFJLElBQUksQ0FBQyxXQUFXLElBQUksSUFBSSxFQUFFO1lBQzVCLElBQUksQ0FBQyxXQUFXLENBQUMsWUFBWSxFQUFFLENBQUM7U0FDakM7SUFDSCxDQUFDO0lBRUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBRUQsSUFBVyxXQUFXLENBQUMsS0FBa0I7UUFDdkMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztRQUNqQyxJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7WUFDMUIsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBRUQsSUFBVyxXQUFXLENBQUMsS0FBcUI7UUFDMUMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztRQUNqQyxJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7WUFDMUIsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBQ0QsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBRUQsSUFBVyxVQUFVLENBQUMsS0FBb0I7UUFDeEMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQztRQUNoQyxJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7WUFDekIsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBQ0QsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMscUJBQXFCLENBQUM7SUFDcEMsQ0FBQztJQUVELElBQVcsb0JBQW9CLENBQUMsS0FBb0M7UUFDbEUsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLHFCQUFxQixDQUFDO1FBQzFDLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRTtZQUNyQixJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDO1lBQ25DLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUVELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUVELElBQVcsVUFBVSxDQUFDLEtBQWE7UUFDakMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQztRQUNoQyxJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7WUFDekIsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUM7SUFDaEMsQ0FBQztJQUVELElBQVcsZ0JBQWdCLENBQUMsS0FBbUI7UUFDN0MsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDO1FBQ3RDLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRTtZQUNyQixJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDO1lBQy9CLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUVELElBQVcsaUJBQWlCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDO0lBQ2pDLENBQUM7SUFFRCxJQUFXLGlCQUFpQixDQUFDLEtBQVk7UUFDdkMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixDQUFDO1FBQ3ZDLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRTtZQUNyQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO1lBQ2hDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7WUFDbEQsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsdUJBQXVCLENBQUM7SUFDdEMsQ0FBQztJQUVELElBQVcsc0JBQXNCLENBQUMsS0FBWTtRQUM1QyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsdUJBQXVCLENBQUM7UUFDNUMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxLQUFLLENBQUM7WUFDckMsSUFBSSxDQUFDLHVCQUF1QixDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztZQUN2RCxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFFRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztJQUNwQyxDQUFDO0lBRUQsSUFBVyxvQkFBb0IsQ0FBQyxLQUFZO1FBQzFDLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztRQUMxQyxJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQztZQUNuQyxJQUFJLENBQUMscUJBQXFCLENBQUMsa0JBQWtCLEdBQUcsSUFBSSxDQUFDO1lBQ3JELElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUVELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLHNCQUFzQixDQUFDO0lBQ3JDLENBQUM7SUFFRCxJQUFXLHFCQUFxQixDQUFDLEtBQVk7UUFDM0MsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLHNCQUFzQixDQUFDO1FBQzNDLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRTtZQUNyQixJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDO1lBQ3BDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7WUFDdEQsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsc0JBQXNCLENBQUM7SUFDckMsQ0FBQztJQUVELElBQVcscUJBQXFCLENBQUMsS0FBWTtRQUMzQyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsc0JBQXNCLENBQUM7UUFDM0MsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUM7WUFDcEMsSUFBSSxDQUFDLHNCQUFzQixDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztZQUN0RCxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFFRCxJQUFXLGdCQUFnQjtRQUN6QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDO0lBRUQsSUFBVyxnQkFBZ0IsQ0FBQyxLQUFnQztRQUMxRCxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUM7UUFDdEMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7WUFDL0IsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUVELElBQVcsaUJBQWlCLENBQUMsS0FBYTtRQUN4QyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUM7UUFDdkMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksS0FBSyxJQUFJLENBQUMsRUFBRTtnQkFDZCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsQ0FBQyxDQUFDO2FBQzdCO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7YUFDakM7WUFDRCxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFDRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyx1QkFBdUIsQ0FBQztJQUN0QyxDQUFDO0lBRUQsSUFBVyxzQkFBc0IsQ0FBQyxLQUFpQjtRQUNqRCxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsdUJBQXVCLENBQUM7UUFDNUMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxLQUFLLENBQUM7WUFDckMsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUVELElBQVcsaUJBQWlCLENBQUMsS0FBYTtRQUN4QyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUM7UUFDdkMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksS0FBSyxJQUFJLENBQUMsRUFBRTtnQkFDZCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsQ0FBQyxDQUFDO2FBQzdCO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7YUFDakM7WUFDRCxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFFRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztJQUNqQyxDQUFDO0lBRUQsSUFBVyxpQkFBaUIsQ0FBQyxLQUFhO1FBQ3hDLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztRQUN2QyxJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxLQUFLLElBQUksQ0FBQyxFQUFFO2dCQUNkLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxDQUFDLENBQUM7YUFDN0I7aUJBQU07Z0JBQ0wsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQzthQUNqQztZQUNELElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUVELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLHNCQUFzQixDQUFDO0lBQ3JDLENBQUM7SUFFRCxJQUFXLHFCQUFxQixDQUFDLEtBQWM7UUFDN0MsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLHNCQUFzQixDQUFDO1FBQzNDLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRTtZQUNyQixJQUFJLENBQUMsc0JBQXNCLEdBQUcsS0FBSyxDQUFDO1lBQ3BDLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUVELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQW1CO1FBQzFDLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUM7UUFDbkMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO1lBQzVCLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUVELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUVELElBQVcsY0FBYyxDQUFDLEtBQVk7UUFDcEMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQztRQUNwQyxJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7WUFDN0IsSUFBSSxDQUFDLGVBQWUsQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7WUFDL0MsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsb0JBQW9CLENBQUM7SUFDbkMsQ0FBQztJQUVELElBQVcsbUJBQW1CLENBQUMsS0FBWTtRQUN6QyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsb0JBQW9CLENBQUM7UUFDekMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUM7WUFDbEMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztZQUNwRCxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFFRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztJQUNqQyxDQUFDO0lBRUQsSUFBVyxpQkFBaUIsQ0FBQyxLQUFZO1FBQ3ZDLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztRQUN2QyxJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztZQUNoQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsa0JBQWtCLEdBQUcsSUFBSSxDQUFDO1lBQ2xELElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUVELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDO0lBQ2xDLENBQUM7SUFFRCxJQUFXLGtCQUFrQixDQUFDLEtBQVk7UUFDeEMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDO1FBQ3hDLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRTtZQUNyQixJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO1lBQ2pDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7WUFDbkQsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUM7SUFDbEMsQ0FBQztJQUVELElBQVcsa0JBQWtCLENBQUMsS0FBWTtRQUN4QyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUM7UUFDeEMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7WUFDakMsSUFBSSxDQUFDLG1CQUFtQixDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztZQUNuRCxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFFRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUE2QjtRQUNwRCxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDO1FBQ25DLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRTtZQUNyQixJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztZQUM1QixJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFFRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFFRCxJQUFXLGNBQWMsQ0FBQyxLQUFhO1FBQ3JDLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUM7UUFDcEMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksS0FBSyxJQUFJLENBQUMsRUFBRTtnQkFDZCxJQUFJLENBQUMsZUFBZSxHQUFHLENBQUMsQ0FBQzthQUMxQjtpQkFBTTtnQkFDTCxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQzthQUM5QjtZQUNELElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUNELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLG9CQUFvQixDQUFDO0lBQ25DLENBQUM7SUFFRCxJQUFXLG1CQUFtQixDQUFDLEtBQWlCO1FBQzlDLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztRQUN6QyxJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQztZQUNsQyxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFFRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFFRCxJQUFXLGNBQWMsQ0FBQyxLQUFhO1FBQ3JDLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUM7UUFDcEMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksS0FBSyxJQUFJLENBQUMsRUFBRTtnQkFDZCxJQUFJLENBQUMsZUFBZSxHQUFHLENBQUMsQ0FBQzthQUMxQjtpQkFBTTtnQkFDTCxJQUFJLENBQUMsZUFBZSxHQUFHLEtBQUssQ0FBQzthQUM5QjtZQUNELElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUVELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxlQUFlLENBQUM7SUFDOUIsQ0FBQztJQUVELElBQVcsY0FBYyxDQUFDLEtBQWE7UUFDckMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQztRQUNwQyxJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxLQUFLLElBQUksQ0FBQyxFQUFFO2dCQUNkLElBQUksQ0FBQyxlQUFlLEdBQUcsQ0FBQyxDQUFDO2FBQzFCO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO2FBQzlCO1lBQ0QsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUM7SUFDbEMsQ0FBQztJQUVELElBQVcsa0JBQWtCLENBQUMsS0FBYztRQUMxQyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUM7UUFDeEMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7WUFDakMsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUVELElBQVcsaUJBQWlCLENBQUMsS0FBbUI7UUFDOUMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixDQUFDO1FBQ3ZDLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRTtZQUNyQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO1lBQ2hDLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUVELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDO0lBQ2xDLENBQUM7SUFFRCxJQUFXLGtCQUFrQixDQUFDLEtBQVk7UUFDeEMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixDQUFDO1FBQ3hDLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRTtZQUNyQixJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO1lBQ2pDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7WUFDbkQsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyx1QkFBdUI7UUFDaEMsT0FBTyxJQUFJLENBQUMsd0JBQXdCLENBQUM7SUFDdkMsQ0FBQztJQUVELElBQVcsdUJBQXVCLENBQUMsS0FBWTtRQUM3QyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsd0JBQXdCLENBQUM7UUFDN0MsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxLQUFLLENBQUM7WUFDdEMsSUFBSSxDQUFDLHdCQUF3QixDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztZQUN4RCxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFFRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztJQUNyQyxDQUFDO0lBRUQsSUFBVyxxQkFBcUIsQ0FBQyxLQUFZO1FBQzNDLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztRQUMzQyxJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQztZQUNwQyxJQUFJLENBQUMsc0JBQXNCLENBQUMsa0JBQWtCLEdBQUcsSUFBSSxDQUFDO1lBQ3RELElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUVELElBQVcsc0JBQXNCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLHVCQUF1QixDQUFDO0lBQ3RDLENBQUM7SUFFRCxJQUFXLHNCQUFzQixDQUFDLEtBQVk7UUFDNUMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLHVCQUF1QixDQUFDO1FBQzVDLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRTtZQUNyQixJQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDO1lBQ3JDLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUM7WUFDdkQsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsdUJBQXVCLENBQUM7SUFDdEMsQ0FBQztJQUVELElBQVcsc0JBQXNCLENBQUMsS0FBWTtRQUM1QyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsdUJBQXVCLENBQUM7UUFDNUMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxLQUFLLENBQUM7WUFDckMsSUFBSSxDQUFDLHVCQUF1QixDQUFDLGtCQUFrQixHQUFHLElBQUksQ0FBQztZQUN2RCxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFFRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztJQUNqQyxDQUFDO0lBRUQsSUFBVyxpQkFBaUIsQ0FBQyxLQUFpQztRQUM1RCxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUM7UUFDdkMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7WUFDaEMsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUM7SUFDbEMsQ0FBQztJQUVELElBQVcsa0JBQWtCLENBQUMsS0FBYTtRQUN6QyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUM7UUFDeEMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksS0FBSyxJQUFJLENBQUMsRUFBRTtnQkFDZCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsQ0FBQyxDQUFDO2FBQzlCO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7YUFDbEM7WUFDRCxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFDRCxJQUFXLHVCQUF1QjtRQUNoQyxPQUFPLElBQUksQ0FBQyx3QkFBd0IsQ0FBQztJQUN2QyxDQUFDO0lBRUQsSUFBVyx1QkFBdUIsQ0FBQyxLQUFpQjtRQUNsRCxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsd0JBQXdCLENBQUM7UUFDN0MsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxLQUFLLENBQUM7WUFDdEMsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUM7U0FDeEI7SUFDSCxDQUFDO0lBRUQsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUM7SUFDbEMsQ0FBQztJQUVELElBQVcsa0JBQWtCLENBQUMsS0FBYTtRQUN6QyxJQUFJLFFBQVEsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUM7UUFDeEMsSUFBSSxRQUFRLElBQUksS0FBSyxFQUFFO1lBQ3JCLElBQUksS0FBSyxJQUFJLENBQUMsRUFBRTtnQkFDZCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsQ0FBQyxDQUFDO2FBQzlCO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7YUFDbEM7WUFDRCxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQztTQUN4QjtJQUNILENBQUM7SUFFRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztJQUNsQyxDQUFDO0lBRUQsSUFBVyxrQkFBa0IsQ0FBQyxLQUFhO1FBQ3pDLElBQUksUUFBUSxHQUFHLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztRQUN4QyxJQUFJLFFBQVEsSUFBSSxLQUFLLEVBQUU7WUFDckIsSUFBSSxLQUFLLElBQUksQ0FBQyxFQUFFO2dCQUNkLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxDQUFDLENBQUM7YUFDOUI7aUJBQU07Z0JBQ0wsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQzthQUNsQztZQUNELElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUVELElBQVcsc0JBQXNCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLHVCQUF1QixDQUFDO0lBQ3RDLENBQUM7SUFFRCxJQUFXLHNCQUFzQixDQUFDLEtBQWM7UUFDOUMsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLHVCQUF1QixDQUFDO1FBQzVDLElBQUksUUFBUSxJQUFJLEtBQUssRUFBRTtZQUNyQixJQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDO1lBQ3JDLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQztJQUVELGdCQUFnQixDQUFDLE9BQVk7UUFDM0IsSUFBSSxJQUFJLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsYUFBYSxFQUFFO1lBQzlDLElBQ0UsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLEVBQUUsV0FBVyxHQUFHLENBQUM7Z0JBQzNDLElBQUksQ0FBQyxPQUFPLENBQUMsYUFBYSxFQUFFLFlBQVksR0FBRyxDQUFDO2dCQUM1QyxDQUFDLElBQUksQ0FBQyxXQUFXLElBQUksY0FBYyxDQUFDLEtBQUs7b0JBQ3ZDLElBQUksQ0FBQyxXQUFXLElBQUksY0FBYyxDQUFDLE1BQU07b0JBQ3pDLElBQUksQ0FBQyxXQUFXLElBQUksY0FBYyxDQUFDLFVBQVU7b0JBQzdDLElBQUksQ0FBQyxXQUFXLElBQUksY0FBYyxDQUFDLFFBQVEsQ0FBQyxFQUM5QztnQkFDQSxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsYUFBYSxFQUFFLFdBQVcsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLGFBQWEsRUFBRSxZQUFZLEVBQUU7b0JBQ3RGLElBQUksQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLEVBQUUsV0FBVyxDQUFDO29CQUNyRCxJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsYUFBYSxFQUFFLFdBQVcsQ0FBQztpQkFDdkQ7cUJBQU07b0JBQ0wsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLGFBQWEsRUFBRSxZQUFZLENBQUM7b0JBQ3RELElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLEVBQUUsWUFBWSxDQUFDO2lCQUN4RDthQUNGO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxhQUFhLEVBQUUsV0FBVyxDQUFDO2dCQUNyRCxJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsYUFBYSxFQUFFLFlBQVksQ0FBQzthQUN4RDtTQUNGO1FBQ0QsSUFBSSxPQUFPLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQzlDLE9BQU8sQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1FBQzFFLE9BQU8sQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1FBQ3RGLE9BQU8sQ0FBQyxlQUFlLENBQUMsYUFBYSxFQUFFLGNBQWMsRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7UUFDekUsT0FBTyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDekQsc0RBQXNEO1FBQ3RELE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQy9DLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ2pELE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQy9DLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQ3RELE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxXQUFXLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQ3RELE9BQU8sQ0FBQyxlQUFlLENBQUMsWUFBWSxFQUFFLGFBQWEsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDdEUsT0FBTyxDQUFDLGVBQWUsQ0FBQyxzQkFBc0IsRUFBRSw2QkFBNkIsRUFBRSxJQUFJLENBQUMsb0JBQW9CLENBQUMsQ0FBQztRQUUxRyxPQUFPLENBQUMsZUFBZSxDQUFDLGVBQWUsRUFBRSxZQUFZLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQzNFLE9BQU8sQ0FBQyxlQUFlLENBQUMsa0JBQWtCLEVBQUUsWUFBWSxFQUFFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBQ2pGLE9BQU8sQ0FBQyxlQUFlLENBQUMsbUJBQW1CLEVBQUUsWUFBWSxFQUFFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQ25GLE9BQU8sQ0FBQyxlQUFlLENBQUMsZUFBZSxFQUFFLHNCQUFzQixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztRQUNyRixPQUFPLENBQUMsZ0JBQWdCLENBQUMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQ2hFLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxxQkFBcUIsRUFBRSxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQztRQUMxRSxPQUFPLENBQUMsZ0JBQWdCLENBQUMsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDdEUsT0FBTyxDQUFDLGdCQUFnQixDQUFDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ3hFLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUN4RSxPQUFPLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQ2pFLE9BQU8sQ0FBQyxlQUFlLENBQUMscUJBQXFCLEVBQUUsVUFBVSxFQUFFLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO1FBQ3JGLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLENBQUM7UUFDakUsT0FBTyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUNqRSxPQUFPLENBQUMsZUFBZSxDQUFDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBRXZFLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxtQkFBbUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUN0RSxPQUFPLENBQUMsZ0JBQWdCLENBQUMsd0JBQXdCLEVBQUUsSUFBSSxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDaEYsT0FBTyxDQUFDLGdCQUFnQixDQUFDLHNCQUFzQixFQUFFLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1FBQzVFLE9BQU8sQ0FBQyxlQUFlLENBQUMsa0JBQWtCLEVBQUUseUJBQXlCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFDOUYsT0FBTyxDQUFDLGdCQUFnQixDQUFDLHVCQUF1QixFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBQzlFLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyx1QkFBdUIsRUFBRSxJQUFJLENBQUMscUJBQXFCLENBQUMsQ0FBQztRQUM5RSxPQUFPLENBQUMsaUJBQWlCLENBQUMsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDdkUsT0FBTyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQ3ZFLE9BQU8sQ0FBQyxlQUFlLENBQUMsd0JBQXdCLEVBQUUsVUFBVSxFQUFFLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQzNGLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxtQkFBbUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUN2RSxPQUFPLENBQUMsZUFBZSxDQUFDLHVCQUF1QixFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBRTdFLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUN4RSxPQUFPLENBQUMsZ0JBQWdCLENBQUMseUJBQXlCLEVBQUUsSUFBSSxDQUFDLHVCQUF1QixDQUFDLENBQUM7UUFDbEYsT0FBTyxDQUFDLGdCQUFnQixDQUFDLHVCQUF1QixFQUFFLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBQzlFLE9BQU8sQ0FBQyxlQUFlLENBQUMsbUJBQW1CLEVBQUUsMEJBQTBCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDakcsT0FBTyxDQUFDLGdCQUFnQixDQUFDLHdCQUF3QixFQUFFLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ2hGLE9BQU8sQ0FBQyxnQkFBZ0IsQ0FBQyx3QkFBd0IsRUFBRSxJQUFJLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNoRixPQUFPLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDekUsT0FBTyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ3pFLE9BQU8sQ0FBQyxlQUFlLENBQUMseUJBQXlCLEVBQUUsVUFBVSxFQUFFLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO1FBQzdGLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUN6RSxPQUFPLENBQUMsZUFBZSxDQUFDLHdCQUF3QixFQUFFLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQy9FLE9BQU8sT0FBTyxDQUFDO0lBQ2pCLENBQUM7SUFFTSxrQkFBa0IsQ0FBQyxJQUFhO1FBQ3JDLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUMvQixLQUFLLElBQUksUUFBUSxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUUsRUFBRTtZQUN0QyxRQUFRLFFBQVEsQ0FBQyxJQUFJLEVBQUU7Z0JBQ3JCLEtBQUssT0FBTztvQkFDVixJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksWUFBWSxDQUFDLElBQUksQ0FBQyxDQUFDO29CQUNwQyxJQUFJLENBQUMsS0FBSyxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDOUMsTUFBTTtnQkFDUixLQUFLLGFBQWE7b0JBQ2hCLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxXQUFXLEVBQUUsQ0FBQztvQkFDckMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ3BELE1BQU07Z0JBQ1IsS0FBSyxhQUFhO29CQUNoQixJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxFQUFFLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDOUQsTUFBTTtnQkFDUixLQUFLLFlBQVk7b0JBQ2YsSUFBSSxDQUFDLFVBQVUsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUNqQyxNQUFNO2dCQUNSOzsyQkFFVztnQkFDWCxLQUFLLE9BQU87b0JBQ1YsSUFBSSxDQUFDLEtBQUssR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUM1QixNQUFNO2dCQUNSLEtBQUssUUFBUTtvQkFDWCxJQUFJLENBQUMsTUFBTSxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQzdCLE1BQU07Z0JBQ1IsS0FBSyxPQUFPO29CQUNWLElBQUksQ0FBQyxLQUFLLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDNUIsTUFBTTtnQkFDUixLQUFLLFdBQVc7b0JBQ2QsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLEtBQUssRUFBRSxDQUFDO29CQUM3QixJQUFJLENBQUMsU0FBUyxDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDckQsTUFBTTtnQkFDUixLQUFLLFdBQVc7b0JBQ2QsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLEtBQUssRUFBRSxDQUFDO29CQUM3QixJQUFJLENBQUMsU0FBUyxDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDckQsTUFBTTtnQkFDUixLQUFLLFlBQVk7b0JBQ2YsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsRUFBRSxRQUFRLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDO29CQUNuRSxNQUFNO2dCQUNSLEtBQUssc0JBQXNCO29CQUN6QixJQUFJLENBQUMsb0JBQW9CLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyw2QkFBNkIsRUFBRSxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ3RGLE1BQU07Z0JBQ1IsS0FBSyxlQUFlO29CQUNsQixJQUFJLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxFQUFFLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDOUQsTUFBTTtnQkFDUixLQUFLLGtCQUFrQjtvQkFDckIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxFQUFFLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDakUsTUFBTTtnQkFDUixLQUFLLG1CQUFtQjtvQkFDdEIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxFQUFFLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDbEUsTUFBTTtnQkFDUixLQUFLLGVBQWU7b0JBQ2xCLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxzQkFBc0IsRUFBRSxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ3hFLE1BQU07Z0JBQ1IsS0FBSyxnQkFBZ0I7b0JBQ25CLElBQUksQ0FBQyxjQUFjLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDbEMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxxQkFBcUIsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQzFELE1BQU07Z0JBQ1IsS0FBSyxxQkFBcUI7b0JBQ3hCLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLEtBQUssRUFBRSxDQUFDO29CQUN2QyxJQUFJLENBQUMsbUJBQW1CLENBQUMscUJBQXFCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUMvRCxNQUFNO2dCQUNSLEtBQUssbUJBQW1CO29CQUN0QixJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDckMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDN0QsTUFBTTtnQkFDUixLQUFLLG9CQUFvQjtvQkFDdkIsSUFBSSxDQUFDLGtCQUFrQixHQUFHLElBQUksS0FBSyxFQUFFLENBQUM7b0JBQ3RDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxxQkFBcUIsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQzlELE1BQU07Z0JBQ1IsS0FBSyxvQkFBb0I7b0JBQ3ZCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLEtBQUssRUFBRSxDQUFDO29CQUN0QyxJQUFJLENBQUMsa0JBQWtCLENBQUMscUJBQXFCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUM5RCxNQUFNO2dCQUNSLEtBQUssZ0JBQWdCO29CQUNuQixJQUFJLENBQUMsY0FBYyxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQ3JDLE1BQU07Z0JBQ1IsS0FBSyxnQkFBZ0I7b0JBQ25CLElBQUksQ0FBQyxjQUFjLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDckMsTUFBTTtnQkFDUixLQUFLLG1CQUFtQjtvQkFDdEIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQ3hDLE1BQU07Z0JBQ1IsS0FBSyxvQkFBb0I7b0JBQ3ZCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUN6QyxNQUFNO2dCQUNSLEtBQUsscUJBQXFCO29CQUN4QixJQUFJLENBQUMsbUJBQW1CLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEVBQUUsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUNsRSxNQUFNO2dCQUNSLEtBQUssZ0JBQWdCO29CQUNuQixJQUFJLENBQUMsY0FBYyxHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQ3JDLE1BQU07Z0JBQ1IsS0FBSyxvQkFBb0I7b0JBQ3ZCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUN6QyxNQUFNO2dCQUNSLEtBQUssbUJBQW1CO29CQUN0QixJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDckMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDN0QsTUFBTTtnQkFDUixLQUFLLHdCQUF3QjtvQkFDM0IsSUFBSSxDQUFDLHNCQUFzQixHQUFHLElBQUksS0FBSyxFQUFFLENBQUM7b0JBQzFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxxQkFBcUIsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ2xFLE1BQU07Z0JBQ1IsS0FBSyxzQkFBc0I7b0JBQ3pCLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxJQUFJLEtBQUssRUFBRSxDQUFDO29CQUN4QyxJQUFJLENBQUMsb0JBQW9CLENBQUMscUJBQXFCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUNoRSxNQUFNO2dCQUNSLEtBQUssa0JBQWtCO29CQUNyQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyx5QkFBeUIsRUFBRSxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQzlFLE1BQU07Z0JBQ1IsS0FBSyx1QkFBdUI7b0JBQzFCLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxJQUFJLEtBQUssRUFBRSxDQUFDO29CQUN6QyxJQUFJLENBQUMscUJBQXFCLENBQUMscUJBQXFCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUNqRSxNQUFNO2dCQUNSLEtBQUssdUJBQXVCO29CQUMxQixJQUFJLENBQUMscUJBQXFCLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDekMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDakUsTUFBTTtnQkFDUixLQUFLLG1CQUFtQjtvQkFDdEIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQ3hDLE1BQU07Z0JBQ1IsS0FBSyx3QkFBd0I7b0JBQzNCLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsRUFBRSxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ3JFLE1BQU07Z0JBQ1IsS0FBSyxtQkFBbUI7b0JBQ3RCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUN4QyxNQUFNO2dCQUNSLEtBQUssdUJBQXVCO29CQUMxQixJQUFJLENBQUMscUJBQXFCLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDNUMsTUFBTTtnQkFDUixLQUFLLG9CQUFvQjtvQkFDdkIsSUFBSSxDQUFDLGtCQUFrQixHQUFHLElBQUksS0FBSyxFQUFFLENBQUM7b0JBQ3RDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxxQkFBcUIsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQzlELE1BQU07Z0JBQ1IsS0FBSyx5QkFBeUI7b0JBQzVCLElBQUksQ0FBQyx1QkFBdUIsR0FBRyxJQUFJLEtBQUssRUFBRSxDQUFDO29CQUMzQyxJQUFJLENBQUMsdUJBQXVCLENBQUMscUJBQXFCLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUNuRSxNQUFNO2dCQUNSLEtBQUssdUJBQXVCO29CQUMxQixJQUFJLENBQUMscUJBQXFCLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDekMsSUFBSSxDQUFDLHFCQUFxQixDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDakUsTUFBTTtnQkFDUixLQUFLLG1CQUFtQjtvQkFDdEIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsMEJBQTBCLEVBQUUsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUNoRixNQUFNO2dCQUNSLEtBQUssd0JBQXdCO29CQUMzQixJQUFJLENBQUMsc0JBQXNCLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztvQkFDMUMsSUFBSSxDQUFDLHNCQUFzQixDQUFDLHFCQUFxQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztvQkFDbEUsTUFBTTtnQkFDUixLQUFLLHdCQUF3QjtvQkFDM0IsSUFBSSxDQUFDLHNCQUFzQixHQUFHLElBQUksS0FBSyxFQUFFLENBQUM7b0JBQzFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxxQkFBcUIsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLENBQUM7b0JBQ2xFLE1BQU07Z0JBQ1IsS0FBSyxvQkFBb0I7b0JBQ3ZCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxRQUFRLENBQUMsS0FBSyxDQUFDO29CQUN6QyxNQUFNO2dCQUNSLEtBQUsseUJBQXlCO29CQUM1QixJQUFJLENBQUMsdUJBQXVCLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEVBQUUsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUN0RSxNQUFNO2dCQUNSLEtBQUssb0JBQW9CO29CQUN2QixJQUFJLENBQUMsa0JBQWtCLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQztvQkFDekMsTUFBTTtnQkFDUixLQUFLLHdCQUF3QjtvQkFDM0IsSUFBSSxDQUFDLHNCQUFzQixHQUFHLFFBQVEsQ0FBQyxLQUFLLENBQUM7b0JBQzdDLE1BQU07YUFDVDtTQUNGO0lBQ0gsQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFN0aVJlY3RhbmdsZUdlb21ldHJ5IGZyb20gXCIuLi9wcm9wZXJ0aWVzL1N0aVJlY3RhbmdsZUdlb21ldHJ5XCI7XHJcbmltcG9ydCB7IFN0aVVzZWRGb250c0xpc3QgfSBmcm9tIFwiLi4vc2VydmljZXMvb2JqZWN0c1wiO1xyXG5pbXBvcnQgeyBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlIH0gZnJvbSBcIi4uL3NlcnZpY2VzL3N0aS1sb2NhbGl6YXRpb24uc2VydmljZVwiO1xyXG5pbXBvcnQgQ29sb3IgZnJvbSBcIi4uL3N5c3RlbS9Db2xvclwiO1xyXG5pbXBvcnQgeyBFbnVtIH0gZnJvbSBcIi4uL3N5c3RlbS9FbnVtXCI7XHJcbmltcG9ydCB7XHJcbiAgSGF0Y2hTdHlsZSxcclxuICBTdGlCYXJjb2RlVHlwZSxcclxuICBTdGlCb2R5QnJ1c2gsXHJcbiAgU3RpTGFiZWxBbGlnbm1lbnQsXHJcbiAgU3RpUVJDb2RlQm9keVNoYXBlVHlwZSxcclxuICBTdGlRUkNvZGVFcnJvckNvcnJlY3Rpb25MZXZlbCxcclxuICBTdGlRUkNvZGVFeWVCYWxsU2hhcGVUeXBlLFxyXG4gIFN0aVFSQ29kZUV5ZUZyYW1lU2hhcGVUeXBlLFxyXG4gIFN0aVFSQ29kZVNpemUsXHJcbn0gZnJvbSBcIi4uL3N5c3RlbS9lbnVtc1wiO1xyXG5pbXBvcnQgeyBTdGlMYWJlbCwgU3RpRGVzY3JpcHRpb24sIFN0aUNoYW5nZXNJbnRlcmNlcHRvciB9IGZyb20gXCIuLi9zeXN0ZW0vaW50ZXJmYWNlc1wiO1xyXG5pbXBvcnQgU3RpSnNvbiBmcm9tIFwiLi4vc3lzdGVtL1N0aUpzb25cIjtcclxuaW1wb3J0IHsgU3RpRm9ybUVsZW1lbnQgfSBmcm9tIFwiLi9iYXNlL1N0aUZvcm1FbGVtZW50XCI7XHJcbmltcG9ydCB7IFN0aUxhYmVsSXRlbSB9IGZyb20gXCIuL3RleHQvU3RpTGFiZWxJdGVtXCI7XHJcbmltcG9ydCB7IFN0aVRleHRJdGVtIH0gZnJvbSBcIi4vdGV4dC9TdGlUZXh0SXRlbVwiO1xyXG5cclxuZXhwb3J0IGNsYXNzIFN0aUJhcmNvZGVFbGVtZW50IGV4dGVuZHMgU3RpRm9ybUVsZW1lbnQgaW1wbGVtZW50cyBTdGlMYWJlbCwgU3RpRGVzY3JpcHRpb24sIFN0aUNoYW5nZXNJbnRlcmNlcHRvciB7XHJcbiAgcHVibGljIHR5cGU6IHN0cmluZyA9IFwiQmFyQ29kZUVsZW1lbnRcIjtcclxuICBwdWJsaWMgdG9vbHRpcCA9IFwiXCI7XHJcbiAgcHJpdmF0ZSBfZGVzY3JpcHRpb246IFN0aVRleHRJdGVtID0gbmV3IFN0aVRleHRJdGVtKCk7XHJcbiAgcHJpdmF0ZSBfYmFyY29kZVR5cGU6IFN0aUJhcmNvZGVUeXBlID0gU3RpQmFyY29kZVR5cGUuUVJDb2RlO1xyXG4gIHByaXZhdGUgX21hdHJpeFNpemU6IFN0aVFSQ29kZVNpemUgPSBTdGlRUkNvZGVTaXplLkF1dG9tYXRpYztcclxuICBwcml2YXRlIF9lcnJvckNvcnJlY3Rpb25MZXZlbDogU3RpUVJDb2RlRXJyb3JDb3JyZWN0aW9uTGV2ZWwgPSBTdGlRUkNvZGVFcnJvckNvcnJlY3Rpb25MZXZlbC5MZXZlbDE7XHJcblxyXG4gIHByaXZhdGUgX2JvZHlCcnVzaFR5cGU6IFN0aUJvZHlCcnVzaCA9IFN0aUJvZHlCcnVzaC5Tb2xpZDtcclxuICBwcml2YXRlIF9ib2R5QnJ1c2hDb2xvcjogQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gIHByaXZhdGUgX3N0YXJ0Qm9keUJydXNoQ29sb3I6IENvbG9yID0gQ29sb3IuYmxhY2soKTtcclxuICBwcml2YXRlIF9lbmRCb2R5QnJ1c2hDb2xvcjogQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gIHByaXZhdGUgX2JvZHlCcnVzaEJhY2tDb2xvcjogQ29sb3IgPSBDb2xvci50cmFuc3BhcmVudCgpO1xyXG4gIHByaXZhdGUgX2JvZHlCcnVzaEZvcmVDb2xvcjogQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gIHByaXZhdGUgX2JvZHlTaGFwZVR5cGU6IFN0aVFSQ29kZUJvZHlTaGFwZVR5cGUgPSBTdGlRUkNvZGVCb2R5U2hhcGVUeXBlLlNxdWFyZTtcclxuICBwcml2YXRlIF9ib2R5QnJ1c2hBbmdsZTogbnVtYmVyID0gMDtcclxuICBwcml2YXRlIF9ib2R5QnJ1c2hIYXRjaFN0eWxlOiBIYXRjaFN0eWxlID0gSGF0Y2hTdHlsZS5Ib3Jpem9udGFsO1xyXG4gIHByaXZhdGUgX2JvZHlCcnVzaEZvY3VzOiBudW1iZXIgPSAwLjU7XHJcbiAgcHJpdmF0ZSBfYm9keUJydXNoQmxlbmQ6IG51bWJlciA9IDAuMjtcclxuICBwcml2YXRlIF9ib2R5QnJ1c2hEcmF3SGF0Y2g6IGJvb2xlYW4gPSBmYWxzZTtcclxuXHJcbiAgcHJpdmF0ZSBfZXllQmFsbEJydXNoVHlwZTogU3RpQm9keUJydXNoID0gU3RpQm9keUJydXNoLlNvbGlkO1xyXG4gIHByaXZhdGUgX2V5ZUJhbGxCcnVzaENvbG9yOiBDb2xvciA9IENvbG9yLmJsYWNrKCk7XHJcbiAgcHJpdmF0ZSBfc3RhcnRFeWVCYWxsQnJ1c2hDb2xvcjogQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gIHByaXZhdGUgX2VuZEV5ZUJhbGxCcnVzaENvbG9yOiBDb2xvciA9IENvbG9yLmJsYWNrKCk7XHJcbiAgcHJpdmF0ZSBfZXllQmFsbEJydXNoQmFja0NvbG9yOiBDb2xvciA9IENvbG9yLnRyYW5zcGFyZW50KCk7XHJcbiAgcHJpdmF0ZSBfZXllQmFsbEJydXNoRm9yZUNvbG9yOiBDb2xvciA9IENvbG9yLmJsYWNrKCk7XHJcbiAgcHJpdmF0ZSBfZXllQmFsbFNoYXBlVHlwZTogU3RpUVJDb2RlRXllQmFsbFNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUJhbGxTaGFwZVR5cGUuU3F1YXJlO1xyXG4gIHByaXZhdGUgX2V5ZUJhbGxCcnVzaEFuZ2xlOiBudW1iZXIgPSAwO1xyXG4gIHByaXZhdGUgX2V5ZUJhbGxCcnVzaEhhdGNoU3R5bGU6IEhhdGNoU3R5bGUgPSBIYXRjaFN0eWxlLkhvcml6b250YWw7XHJcbiAgcHJpdmF0ZSBfZXllQmFsbEJydXNoRm9jdXM6IG51bWJlciA9IDAuNTtcclxuICBwcml2YXRlIF9leWVCYWxsQnJ1c2hCbGVuZDogbnVtYmVyID0gMC4yO1xyXG4gIHByaXZhdGUgX2V5ZUJhbGxCcnVzaERyYXdIYXRjaDogYm9vbGVhbiA9IGZhbHNlO1xyXG5cclxuICBwcml2YXRlIF9leWVGcmFtZUJydXNoVHlwZTogU3RpQm9keUJydXNoID0gU3RpQm9keUJydXNoLlNvbGlkO1xyXG4gIHByaXZhdGUgX2V5ZUZyYW1lQnJ1c2hDb2xvcjogQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gIHByaXZhdGUgX3N0YXJ0RXllRnJhbWVCcnVzaENvbG9yOiBDb2xvciA9IENvbG9yLmJsYWNrKCk7XHJcbiAgcHJpdmF0ZSBfZW5kRXllRnJhbWVCcnVzaENvbG9yOiBDb2xvciA9IENvbG9yLmJsYWNrKCk7XHJcbiAgcHJpdmF0ZSBfZXllRnJhbWVCcnVzaEJhY2tDb2xvcjogQ29sb3IgPSBDb2xvci50cmFuc3BhcmVudCgpO1xyXG4gIHByaXZhdGUgX2V5ZUZyYW1lQnJ1c2hGb3JlQ29sb3I6IENvbG9yID0gQ29sb3IuYmxhY2soKTtcclxuICBwcml2YXRlIF9leWVGcmFtZVNoYXBlVHlwZTogU3RpUVJDb2RlRXllRnJhbWVTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVGcmFtZVNoYXBlVHlwZS5TcXVhcmU7XHJcbiAgcHJpdmF0ZSBfZXllRnJhbWVCcnVzaEFuZ2xlOiBudW1iZXIgPSAwO1xyXG4gIHByaXZhdGUgX2V5ZUZyYW1lQnJ1c2hIYXRjaFN0eWxlOiBIYXRjaFN0eWxlID0gSGF0Y2hTdHlsZS5Ib3Jpem9udGFsO1xyXG4gIHByaXZhdGUgX2V5ZUZyYW1lQnJ1c2hGb2N1czogbnVtYmVyID0gMC41O1xyXG4gIHByaXZhdGUgX2V5ZUZyYW1lQnJ1c2hCbGVuZDogbnVtYmVyID0gMC4yO1xyXG4gIHByaXZhdGUgX2V5ZUZyYW1lQnJ1c2hEcmF3SGF0Y2g6IGJvb2xlYW4gPSBmYWxzZTtcclxuXHJcbiAgcHJpdmF0ZSBfY29kZVN0cmluZyA9IFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiQ29tcG9uZW50c1wiLCBcIlN0aUJhckNvZGVcIik7XHJcbiAgcHJpdmF0ZSBfd2lkdGg6IG51bWJlciA9IDkwO1xyXG4gIHByaXZhdGUgX2hlaWdodDogbnVtYmVyID0gOTA7XHJcbiAgcHJpdmF0ZSBfc3R5bGU6IG51bWJlciA9IDE7XHJcbiAgcHJpdmF0ZSBfYmFja0NvbG9yOiBDb2xvciA9IENvbG9yLnRyYW5zcGFyZW50KCk7XHJcbiAgcHJpdmF0ZSBfZm9yZUNvbG9yOiBDb2xvciA9IENvbG9yLmJsYWNrKCk7XHJcbiAgcHVibGljIHNob3dQcm9ncmVzcyA9IGZhbHNlO1xyXG4gIHB1YmxpYyBpbWc6IHN0cmluZztcclxuXHJcbiAgcHVibGljIHNob3dCb2R5QnJ1c2hFZGl0b3I6IGJvb2xlYW4gPSBmYWxzZTtcclxuICBwdWJsaWMgc2hvd0V5ZUJhbGxCcnVzaEVkaXRvcjogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIHB1YmxpYyBzaG93RXllRnJhbWVCcnVzaEVkaXRvcjogYm9vbGVhbiA9IGZhbHNlO1xyXG5cclxuICBwcm9wZXJ0eUNoYW5nZWQocHJvcE5hbWU6IHN0cmluZykge1xyXG4gICAgdGhpcy5faXNDaGFuZ2VkID0gdHJ1ZTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgYmFja0NvbG9yKCkge1xyXG4gICAgcmV0dXJuIHRoaXMuX2JhY2tDb2xvcjtcclxuICB9XHJcbiAgcHVibGljIHNldCBiYWNrQ29sb3IodmFsdWU6IENvbG9yKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9iYWNrQ29sb3I7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5fYmFja0NvbG9yID0gdmFsdWU7XHJcbiAgICAgIHRoaXMuX2JhY2tDb2xvci5jaGFuZ2VzSW50ZXJjZXB0b3IgPSB0aGlzO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBmb3JlQ29sb3IoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5fZm9yZUNvbG9yO1xyXG4gIH1cclxuICBwdWJsaWMgc2V0IGZvcmVDb2xvcih2YWx1ZTogQ29sb3IpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2ZvcmVDb2xvcjtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICB0aGlzLl9mb3JlQ29sb3IgPSB2YWx1ZTtcclxuICAgICAgdmFsdWUuY2hhbmdlc0ludGVyY2VwdG9yID0gdGhpcztcclxuICAgICAgdGhpcy5faXNDaGFuZ2VkID0gdHJ1ZTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgc3R5bGUoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5fc3R5bGU7XHJcbiAgfVxyXG4gIHB1YmxpYyBzZXQgc3R5bGUodmFsdWU6IG51bWJlcikge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fc3R5bGU7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5fc3R5bGUgPSB2YWx1ZTtcclxuICAgICAgdGhpcy5zZXRTdHlsZSh2YWx1ZSk7XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXQgV2lkdGgoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5fd2lkdGg7XHJcbiAgfVxyXG4gIHB1YmxpYyBzZXQgV2lkdGgodmFsdWU6IG51bWJlcikge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fd2lkdGg7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5fd2lkdGggPSB2YWx1ZTtcclxuICAgICAgdGhpcy5faXNDaGFuZ2VkID0gdHJ1ZTtcclxuICAgIH1cclxuICB9XHJcbiAgcHVibGljIGdldCBIZWlnaHQoKSB7XHJcbiAgICByZXR1cm4gdGhpcy5faGVpZ2h0O1xyXG4gIH1cclxuICBwdWJsaWMgc2V0IEhlaWdodCh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9oZWlnaHQ7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5faGVpZ2h0ID0gdmFsdWU7XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBjb25zdHJ1Y3RvcigpIHtcclxuICAgIHN1cGVyKCk7XHJcbiAgICB0aGlzLmdlb21ldHJ5ID0gbmV3IFN0aVJlY3RhbmdsZUdlb21ldHJ5KDE3MCwgMTEwKTtcclxuICAgIHRoaXMubGFiZWwgPSBuZXcgU3RpTGFiZWxJdGVtKHRoaXMsIFN0aUxvY2FsaXphdGlvblNlcnZpY2UuZ2V0KFwiQ29tcG9uZW50c1wiLCBcIlN0aUJhckNvZGVcIikpO1xyXG4gICAgdGhpcy5iYWNrQ29sb3IgPSBDb2xvci50cmFuc3BhcmVudCgpO1xyXG4gICAgdGhpcy5mb3JlQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG5cclxuICAgIHRoaXMuYm9keUJydXNoQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gICAgdGhpcy5zdGFydEJvZHlCcnVzaENvbG9yID0gQ29sb3IuYmxhY2soKTtcclxuICAgIHRoaXMuZW5kQm9keUJydXNoQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gICAgdGhpcy5ib2R5QnJ1c2hCYWNrQ29sb3IgPSBDb2xvci50cmFuc3BhcmVudCgpO1xyXG4gICAgdGhpcy5ib2R5QnJ1c2hGb3JlQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG5cclxuICAgIHRoaXMuZXllQmFsbEJydXNoQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gICAgdGhpcy5zdGFydEV5ZUJhbGxCcnVzaENvbG9yID0gQ29sb3IuYmxhY2soKTtcclxuICAgIHRoaXMuZW5kRXllQmFsbEJydXNoQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gICAgdGhpcy5leWVCYWxsQnJ1c2hCYWNrQ29sb3IgPSBDb2xvci50cmFuc3BhcmVudCgpO1xyXG4gICAgdGhpcy5leWVCYWxsQnJ1c2hGb3JlQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG5cclxuICAgIHRoaXMuZXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuYmxhY2soKTtcclxuICAgIHRoaXMuc3RhcnRFeWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gICAgdGhpcy5lbmRFeWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gICAgdGhpcy5leWVGcmFtZUJydXNoQmFja0NvbG9yID0gQ29sb3IudHJhbnNwYXJlbnQoKTtcclxuICAgIHRoaXMuZXllRnJhbWVCcnVzaEZvcmVDb2xvciA9IENvbG9yLmJsYWNrKCk7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0VXNlZEZvbnRzKHVzZWRGb250czogU3RpVXNlZEZvbnRzTGlzdCkge1xyXG4gICAgc3VwZXIuZ2V0VXNlZEZvbnRzKHVzZWRGb250cyk7XHJcbiAgICB1c2VkRm9udHMuYWRkKFxyXG4gICAgICB0aGlzLmRlc2NyaXB0aW9uLmZvbnQuZmFtaWx5LFxyXG4gICAgICB0aGlzLmFycmF5T2ZTdHlsZXNUb1N0cmluZyh0aGlzLmRlc2NyaXB0aW9uLmZvbnQuc3R5bGUpLFxyXG4gICAgICB0aGlzLmRlc2NyaXB0aW9uLmZvbnQuc2l6ZVxyXG4gICAgKTtcclxuICB9XHJcbiAgcHVibGljIGlzQ2hhbmdlZCgpOiBib29sZWFuIHtcclxuICAgIHJldHVybiBzdXBlci5pc0NoYW5nZWQoKSB8fCB0aGlzLmxhYmVsPy5pc0NoYW5nZWQoKSB8fCB0aGlzLmRlc2NyaXB0aW9uPy5pc0NoYW5nZWQoKTtcclxuICB9XHJcbiAgcHVibGljIHNldFN0eWxlKHZhbHVlOiBudW1iZXIpIHtcclxuICAgIHN3aXRjaCAodmFsdWUpIHtcclxuICAgICAgY2FzZSAxOlxyXG4gICAgICAgIHRoaXMuYmFja0NvbG9yID0gQ29sb3IudHJhbnNwYXJlbnQoKTtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guU29saWQ7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hDb2xvciA9IENvbG9yLmJsYWNrKCk7XHJcbiAgICAgICAgdGhpcy5ib2R5U2hhcGVUeXBlID0gU3RpUVJDb2RlQm9keVNoYXBlVHlwZS5TcXVhcmU7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLlNvbGlkO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbFNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUJhbGxTaGFwZVR5cGUuU3F1YXJlO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guU29saWQ7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5ibGFjaygpO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVGcmFtZVNoYXBlVHlwZS5TcXVhcmU7XHJcbiAgICAgICAgYnJlYWs7XHJcbiAgICAgIGNhc2UgMjpcclxuICAgICAgICB0aGlzLmJhY2tDb2xvciA9IENvbG9yLnRyYW5zcGFyZW50KCk7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLlNvbGlkO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYig5NiwgNzUsIDExNyk7XHJcbiAgICAgICAgdGhpcy5ib2R5U2hhcGVUeXBlID0gU3RpUVJDb2RlQm9keVNoYXBlVHlwZS5EaWFtb25kO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HcmFkaWVudDtcclxuICAgICAgICB0aGlzLnN0YXJ0RXllQmFsbEJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigzLCAxNTIsIDE1Mik7XHJcbiAgICAgICAgdGhpcy5lbmRFeWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDQ0LCAxMTAsIDE1NCk7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hBbmdsZSA9IDMwO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbFNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUJhbGxTaGFwZVR5cGUuUm91bmQxO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guR2xhc3M7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigxMTgsIDIwMiwgMjI2KTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hEcmF3SGF0Y2ggPSBmYWxzZTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hCbGVuZCA9IDAuMjtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllRnJhbWVTaGFwZVR5cGUuUm91bmQxO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIDM6XHJcbiAgICAgICAgdGhpcy5iYWNrQ29sb3IgPSBDb2xvci50cmFuc3BhcmVudCgpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5Tb2xpZDtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoODUsIDg1LCA4NSk7XHJcbiAgICAgICAgdGhpcy5ib2R5U2hhcGVUeXBlID0gU3RpUVJDb2RlQm9keVNoYXBlVHlwZS5DaXJjbGU7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdsYXJlO1xyXG4gICAgICAgIHRoaXMuc3RhcnRFeWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDEwMCwgMTE1LCA1Myk7XHJcbiAgICAgICAgdGhpcy5lbmRFeWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDEzNywgNzMsIDEwNik7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hBbmdsZSA9IDU7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hGb2N1cyA9IDAuNTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVCYWxsU2hhcGVUeXBlLkNpcmNsZTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdsYXNzO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoNTcsIDk0LCAxMzMpO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaERyYXdIYXRjaCA9IGZhbHNlO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaEJsZW5kID0gMC4yO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVGcmFtZVNoYXBlVHlwZS5DaXJjbGU7XHJcbiAgICAgICAgYnJlYWs7XHJcbiAgICAgIGNhc2UgNDpcclxuICAgICAgICB0aGlzLmJhY2tDb2xvciA9IENvbG9yLnRyYW5zcGFyZW50KCk7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdsYXJlO1xyXG4gICAgICAgIHRoaXMuc3RhcnRCb2R5QnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDExNiwgNDYsIDQ0KTtcclxuICAgICAgICB0aGlzLmVuZEJvZHlCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMzMsIDc3LCAxMzIpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoQW5nbGUgPSA3O1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoRm9jdXMgPSAwLjk7XHJcbiAgICAgICAgdGhpcy5ib2R5U2hhcGVUeXBlID0gU3RpUVJDb2RlQm9keVNoYXBlVHlwZS5Sb3VuZGVkU3F1YXJlO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5IYXRjaDtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaEhhdGNoU3R5bGUgPSBIYXRjaFN0eWxlLkxhcmdlQ2hlY2tlckJvYXJkO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoRm9yZUNvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTIwLCA1NywgNzIpO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoQmFja0NvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTA1LCA4MiwgMTM3KTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVCYWxsU2hhcGVUeXBlLlJvdW5kO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guR3JhZGllbnQ7XHJcbiAgICAgICAgdGhpcy5zdGFydEV5ZUZyYW1lQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDkwLCAxLCAxNzkpO1xyXG4gICAgICAgIHRoaXMuZW5kRXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoNTksIDczLCAxNDQpO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaEFuZ2xlID0gMzA7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZVNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUZyYW1lU2hhcGVUeXBlLlJvdW5kO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIDU6XHJcbiAgICAgICAgdGhpcy5iYWNrQ29sb3IgPSBDb2xvci50cmFuc3BhcmVudCgpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HbGFyZTtcclxuICAgICAgICB0aGlzLnN0YXJ0Qm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigxODQsIDUsIDgpO1xyXG4gICAgICAgIHRoaXMuZW5kQm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYig0OCwgMTE3LCAxMzIpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoQW5nbGUgPSAzO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoRm9jdXMgPSAwLjU7XHJcbiAgICAgICAgdGhpcy5ib2R5U2hhcGVUeXBlID0gU3RpUVJDb2RlQm9keVNoYXBlVHlwZS5aZWJyYUNyb3NzMTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guU29saWQ7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDEyLCAxNzIsIDE3Mik7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllQmFsbFNoYXBlVHlwZS5DaXJjbGU7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HcmFkaWVudDtcclxuICAgICAgICB0aGlzLnN0YXJ0RXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTkxLCAwLCAxNzgpO1xyXG4gICAgICAgIHRoaXMuZW5kRXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTkzLCAwLCA2NCk7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQW5nbGUgPSAxMDtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllRnJhbWVTaGFwZVR5cGUuUm91bmQxO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIDY6XHJcbiAgICAgICAgdGhpcy5iYWNrQ29sb3IgPSBDb2xvci50cmFuc3BhcmVudCgpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HbGFyZTtcclxuICAgICAgICB0aGlzLnN0YXJ0Qm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYig3MywgNTcsIDk5KTtcclxuICAgICAgICB0aGlzLmVuZEJvZHlCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMSwgMTIzLCA0Nik7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hBbmdsZSA9IDM7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hGb2N1cyA9IDAuNTtcclxuICAgICAgICB0aGlzLmJvZHlTaGFwZVR5cGUgPSBTdGlRUkNvZGVCb2R5U2hhcGVUeXBlLkRvdDtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guU29saWQ7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDM2LCA4MiwgMTQzKTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVCYWxsU2hhcGVUeXBlLkRvdHM7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HbGFyZTtcclxuICAgICAgICB0aGlzLnN0YXJ0RXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTc5LCAxLCAxNjYpO1xyXG4gICAgICAgIHRoaXMuZW5kRXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoNDksIDUzLCAyOCk7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQW5nbGUgPSAxMDtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hGb2N1cyA9IDAuODtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllRnJhbWVTaGFwZVR5cGUuRG90cztcclxuICAgICAgICBicmVhaztcclxuICAgICAgY2FzZSA3OlxyXG4gICAgICAgIHRoaXMuYmFja0NvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMzcsIDg2LCA5OSk7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkhhdGNoO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoSGF0Y2hTdHlsZSA9IEhhdGNoU3R5bGUuRGFzaGVkSG9yaXpvbnRhbDtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaEZvcmVDb2xvciA9IENvbG9yLmZyb21BcmdiKDIxNiwgMjM4LCAyNDMpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoQmFja0NvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjI5LCAxODUsIDE4Myk7XHJcbiAgICAgICAgdGhpcy5ib2R5U2hhcGVUeXBlID0gU3RpUVJDb2RlQm9keVNoYXBlVHlwZS5TcXVhcmU7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdyYWRpZW50O1xyXG4gICAgICAgIHRoaXMuc3RhcnRFeWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDI0MiwgMjQyLCAyNDIpO1xyXG4gICAgICAgIHRoaXMuZW5kRXllQmFsbEJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyNTUsIDE0NywgMTQ3KTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaEFuZ2xlID0gNDtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVCYWxsU2hhcGVUeXBlLlNxdWFyZTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdsYXJlO1xyXG4gICAgICAgIHRoaXMuc3RhcnRFeWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigxNzgsIDE2MSwgMTk5KTtcclxuICAgICAgICB0aGlzLmVuZEV5ZUZyYW1lQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDI1MywgMjM0LCAyMTgpO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaEFuZ2xlID0gNDtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hGb2N1cyA9IDAuNTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllRnJhbWVTaGFwZVR5cGUuU3F1YXJlO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIDg6XHJcbiAgICAgICAgdGhpcy5iYWNrQ29sb3IgPSBDb2xvci5mcm9tQXJnYig4NywgMTE4LCAxNTcpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HcmFkaWVudDtcclxuICAgICAgICB0aGlzLnN0YXJ0Qm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyMTksIDIzOCwgMjQzKTtcclxuICAgICAgICB0aGlzLmVuZEJvZHlCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjAzLCAxODQsIDE2OCk7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hBbmdsZSA9IDU7XHJcbiAgICAgICAgdGhpcy5ib2R5U2hhcGVUeXBlID0gU3RpUVJDb2RlQm9keVNoYXBlVHlwZS5Eb3Q7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdyYWRpZW50O1xyXG4gICAgICAgIHRoaXMuc3RhcnRFeWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDIxOSwgMjM4LCAyNDMpO1xyXG4gICAgICAgIHRoaXMuZW5kRXllQmFsbEJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyMDMsIDE4NCwgMTY4KTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaEFuZ2xlID0gNTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVCYWxsU2hhcGVUeXBlLlNxdWFyZTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdyYWRpZW50O1xyXG4gICAgICAgIHRoaXMuc3RhcnRFeWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyMTksIDIzOCwgMjQzKTtcclxuICAgICAgICB0aGlzLmVuZEV5ZUZyYW1lQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDIwMywgMTg0LCAxNjgpO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaEFuZ2xlID0gNTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllRnJhbWVTaGFwZVR5cGUuU3F1YXJlO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIDk6XHJcbiAgICAgICAgdGhpcy5iYWNrQ29sb3IgPSBDb2xvci5mcm9tQXJnYigxNDQsIDYwLCA1Nyk7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdyYWRpZW50O1xyXG4gICAgICAgIHRoaXMuc3RhcnRCb2R5QnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDIxOSwgMjM4LCAyNDMpO1xyXG4gICAgICAgIHRoaXMuZW5kQm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyNTEsIDIxMywgMTgxKTtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaEFuZ2xlID0gMztcclxuICAgICAgICB0aGlzLmJvZHlTaGFwZVR5cGUgPSBTdGlRUkNvZGVCb2R5U2hhcGVUeXBlLlNxdWFyZTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guR3JhZGllbnQ7XHJcbiAgICAgICAgdGhpcy5zdGFydEV5ZUJhbGxCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjE5LCAyMzgsIDI0Myk7XHJcbiAgICAgICAgdGhpcy5lbmRFeWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDI1MSwgMjEzLCAxODEpO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoQW5nbGUgPSAzO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbFNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUJhbGxTaGFwZVR5cGUuU3F1YXJlO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guR3JhZGllbnQ7XHJcbiAgICAgICAgdGhpcy5zdGFydEV5ZUZyYW1lQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDIxOSwgMjM4LCAyNDMpO1xyXG4gICAgICAgIHRoaXMuZW5kRXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjUxLCAyMTMsIDE4MSk7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQW5nbGUgPSAzO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVGcmFtZVNoYXBlVHlwZS5TcXVhcmU7XHJcbiAgICAgICAgYnJlYWs7XHJcbiAgICAgIGNhc2UgMTA6XHJcbiAgICAgICAgdGhpcy5iYWNrQ29sb3IgPSBDb2xvci5mcm9tQXJnYigzNywgODYsIDk5KTtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guSGF0Y2g7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hIYXRjaFN0eWxlID0gSGF0Y2hTdHlsZS5EYXNoZWRIb3Jpem9udGFsO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoRm9yZUNvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjE5LCAyMzgsIDI0Myk7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hCYWNrQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyMjksIDE4NSwgMTgzKTtcclxuICAgICAgICB0aGlzLmJvZHlTaGFwZVR5cGUgPSBTdGlRUkNvZGVCb2R5U2hhcGVUeXBlLlNxdWFyZTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guSGF0Y2g7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hIYXRjaFN0eWxlID0gSGF0Y2hTdHlsZS5EYXNoZWRIb3Jpem9udGFsO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoRm9yZUNvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjE5LCAyMzgsIDI0Myk7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hCYWNrQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyMjksIDE4NSwgMTgzKTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVCYWxsU2hhcGVUeXBlLlNxdWFyZTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkhhdGNoO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaEhhdGNoU3R5bGUgPSBIYXRjaFN0eWxlLkRhc2hlZEhvcml6b250YWw7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoRm9yZUNvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjE5LCAyMzgsIDI0Myk7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQmFja0NvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjI5LCAxODUsIDE4Myk7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZVNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUZyYW1lU2hhcGVUeXBlLlNxdWFyZTtcclxuICAgICAgICBicmVhaztcclxuICAgICAgY2FzZSAxMTpcclxuICAgICAgICB0aGlzLmZvcmVDb2xvciA9IENvbG9yLmZyb21BcmdiKDE5MSwgMTc4LCAyMDUpO1xyXG4gICAgICAgIHRoaXMuYmFja0NvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMzgsIDM4LCAzOCk7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdyYWRpZW50O1xyXG4gICAgICAgIHRoaXMuc3RhcnRCb2R5QnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDI1NCwgMjQzLCAyNTUpO1xyXG4gICAgICAgIHRoaXMuZW5kQm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigxNTQsIDE0MywgMTY3KTtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaEFuZ2xlID0gMTtcclxuICAgICAgICB0aGlzLmJvZHlTaGFwZVR5cGUgPSBTdGlRUkNvZGVCb2R5U2hhcGVUeXBlLkRpYW1vbmQ7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkVtcHR5O1xyXG4gICAgICAgIHRoaXMuc3RhcnRFeWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDI1NCwgMjQzLCAyNTUpO1xyXG4gICAgICAgIHRoaXMuZW5kRXllQmFsbEJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigxNTQsIDE0MywgMTY3KTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaEFuZ2xlID0gMztcclxuICAgICAgICB0aGlzLmV5ZUJhbGxTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVCYWxsU2hhcGVUeXBlLlNxdWFyZTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkVtcHR5O1xyXG4gICAgICAgIHRoaXMuc3RhcnRFeWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyNTQsIDI0MywgMjU1KTtcclxuICAgICAgICB0aGlzLmVuZEV5ZUZyYW1lQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDE1NCwgMTQzLCAxNik7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQW5nbGUgPSAxO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVGcmFtZVNoYXBlVHlwZS5TcXVhcmU7XHJcbiAgICAgICAgYnJlYWs7XHJcbiAgICAgIGNhc2UgMTI6XHJcbiAgICAgICAgdGhpcy5iYWNrQ29sb3IgPSBDb2xvci5mcm9tQXJnYigzNywgODYsIDk5KTtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guR2xhcmU7XHJcbiAgICAgICAgdGhpcy5zdGFydEJvZHlCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTc4LCAxNjEsIDE5OSk7XHJcbiAgICAgICAgdGhpcy5lbmRCb2R5QnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDAsIDI1NSwgMTIwKTtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaEFuZ2xlID0gMztcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaEZvY3VzID0gMC41O1xyXG4gICAgICAgIHRoaXMuYm9keVNoYXBlVHlwZSA9IFN0aVFSQ29kZUJvZHlTaGFwZVR5cGUuRG90O1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5Tb2xpZDtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTQxLCAxNzksIDIyNik7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllQmFsbFNoYXBlVHlwZS5Eb3RzO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guR3JhZGllbnQ7XHJcbiAgICAgICAgdGhpcy5zdGFydEV5ZUZyYW1lQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDI1NSwgMTQ3LCAyNTEpO1xyXG4gICAgICAgIHRoaXMuZW5kRXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTQ2LCAyMDgsIDgwKTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hBbmdsZSA9IDQ7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZVNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUZyYW1lU2hhcGVUeXBlLkRvdHM7XHJcbiAgICAgICAgYnJlYWs7XHJcbiAgICAgIGNhc2UgMTM6XHJcbiAgICAgICAgdGhpcy5iYWNrQ29sb3IgPSBDb2xvci50cmFuc3BhcmVudCgpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5Tb2xpZDtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjgsIDEyNSwgMTM4KTtcclxuICAgICAgICB0aGlzLmJvZHlTaGFwZVR5cGUgPSBTdGlRUkNvZGVCb2R5U2hhcGVUeXBlLlplYnJhVmVydGljYWw7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLlNvbGlkO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyMTEsIDEzNiwgODQpO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbFNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUJhbGxTaGFwZVR5cGUuWmVicmFIb3Jpem9udGFsO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guU29saWQ7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYig4OCwgNjYsIDExMSk7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZVNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUZyYW1lU2hhcGVUeXBlLlJvdW5kO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIDE0OlxyXG4gICAgICAgIHRoaXMuYmFja0NvbG9yID0gQ29sb3IudHJhbnNwYXJlbnQoKTtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guU29saWQ7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDM0LCA4MiwgOTQpO1xyXG4gICAgICAgIHRoaXMuYm9keVNoYXBlVHlwZSA9IFN0aVFSQ29kZUJvZHlTaGFwZVR5cGUuUm91bmRlZFNxdWFyZTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guU29saWQ7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDM0LCA4MiwgOTQpO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbFNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUJhbGxTaGFwZVR5cGUuU3F1YXJlO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guU29saWQ7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigzNCwgODIsIDk0KTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllRnJhbWVTaGFwZVR5cGUuU3F1YXJlO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIDE1OlxyXG4gICAgICAgIHRoaXMuYmFja0NvbG9yID0gQ29sb3IudHJhbnNwYXJlbnQoKTtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guSGF0Y2g7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hIYXRjaFN0eWxlID0gSGF0Y2hTdHlsZS5EYXJrSG9yaXpvbnRhbDtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaEZvcmVDb2xvciA9IENvbG9yLmZyb21BcmdiKDE3NiwgNzEsIDY3KTtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaEJhY2tDb2xvciA9IENvbG9yLmZyb21BcmdiKDkxLCAxMzksIDE1MCk7XHJcbiAgICAgICAgdGhpcy5ib2R5U2hhcGVUeXBlID0gU3RpUVJDb2RlQm9keVNoYXBlVHlwZS5TcXVhcmU7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdsYXJlO1xyXG4gICAgICAgIHRoaXMuc3RhcnRFeWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDE5MSwgMTgzLCAxODQpO1xyXG4gICAgICAgIHRoaXMuZW5kRXllQmFsbEJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigxOTksIDI5LCAyOCk7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hBbmdsZSA9IDMwO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoRm9jdXMgPSAwLjU7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllQmFsbFNoYXBlVHlwZS5TcXVhcmU7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HbGFyZTtcclxuICAgICAgICB0aGlzLnN0YXJ0RXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTAyLCA3OSwgMTI4KTtcclxuICAgICAgICB0aGlzLmVuZEV5ZUZyYW1lQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDE4OSwgOTUsIDMyKTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hBbmdsZSA9IDA7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoRm9jdXMgPSAwO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVGcmFtZVNoYXBlVHlwZS5TcXVhcmU7XHJcbiAgICAgICAgYnJlYWs7XHJcbiAgICAgIGNhc2UgMTY6XHJcbiAgICAgICAgdGhpcy5iYWNrQ29sb3IgPSBDb2xvci50cmFuc3BhcmVudCgpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HcmFkaWVudDtcclxuICAgICAgICB0aGlzLnN0YXJ0Qm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigxNDcsIDYwLCA1Myk7XHJcbiAgICAgICAgdGhpcy5lbmRCb2R5QnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDEyMiwgMTA2LCA2Nik7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hBbmdsZSA9IDM7XHJcbiAgICAgICAgdGhpcy5ib2R5U2hhcGVUeXBlID0gU3RpUVJDb2RlQm9keVNoYXBlVHlwZS5aZWJyYUNyb3NzMjtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guR3JhZGllbnQ7XHJcbiAgICAgICAgdGhpcy5zdGFydEV5ZUJhbGxCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTQ3LCA2MCwgNTMpO1xyXG4gICAgICAgIHRoaXMuZW5kRXllQmFsbEJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigxMjIsIDEwNiwgNjYpO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoQW5nbGUgPSAzO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbFNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUJhbGxTaGFwZVR5cGUuU3F1YXJlO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guR3JhZGllbnQ7XHJcbiAgICAgICAgdGhpcy5zdGFydEV5ZUZyYW1lQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDE0NywgNjAsIDUzKTtcclxuICAgICAgICB0aGlzLmVuZEV5ZUZyYW1lQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDEyMiwgMTA2LCA2Nik7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQW5nbGUgPSAzO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVGcmFtZVNoYXBlVHlwZS5TcXVhcmU7XHJcbiAgICAgICAgYnJlYWs7XHJcbiAgICAgIGNhc2UgMTc6XHJcbiAgICAgICAgdGhpcy5iYWNrQ29sb3IgPSBDb2xvci50cmFuc3BhcmVudCgpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HcmFkaWVudDtcclxuICAgICAgICB0aGlzLnN0YXJ0Qm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyMDMsIDcsIDIwMyk7XHJcbiAgICAgICAgdGhpcy5lbmRCb2R5QnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDE4LCAxNTgsIDE3Nyk7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hBbmdsZSA9IDU7XHJcbiAgICAgICAgdGhpcy5ib2R5U2hhcGVUeXBlID0gU3RpUVJDb2RlQm9keVNoYXBlVHlwZS5TcXVhcmU7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdyYWRpZW50O1xyXG4gICAgICAgIHRoaXMuc3RhcnRFeWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDIwMywgNywgMjAzKTtcclxuICAgICAgICB0aGlzLmVuZEV5ZUJhbGxCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTgsIDE1OCwgMTc3KTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaEFuZ2xlID0gNTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVCYWxsU2hhcGVUeXBlLlNxdWFyZTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdyYWRpZW50O1xyXG4gICAgICAgIHRoaXMuc3RhcnRFeWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyMDMsIDcsIDIwMyk7XHJcbiAgICAgICAgdGhpcy5lbmRFeWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigxOCwgMTU4LCAxNzcpO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaEFuZ2xlID0gNTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllRnJhbWVTaGFwZVR5cGUuU3F1YXJlO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIDE4OlxyXG4gICAgICAgIHRoaXMuYmFja0NvbG9yID0gQ29sb3IudHJhbnNwYXJlbnQoKTtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guR3JhZGllbnQ7XHJcbiAgICAgICAgdGhpcy5zdGFydEJvZHlCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTM4LCA1NywgMCk7XHJcbiAgICAgICAgdGhpcy5lbmRCb2R5QnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDEzNywgMywgMTUpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoQW5nbGUgPSAzO1xyXG4gICAgICAgIHRoaXMuYm9keVNoYXBlVHlwZSA9IFN0aVFSQ29kZUJvZHlTaGFwZVR5cGUuU3RhcjtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guSGF0Y2g7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hIYXRjaFN0eWxlID0gSGF0Y2hTdHlsZS5QbGFpZDtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaEZvcmVDb2xvciA9IENvbG9yLmZyb21BcmdiKDgxLCA2OCwgMTE1KTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaEJhY2tDb2xvciA9IENvbG9yLmZyb21BcmdiKDEyNSwgNDIsIDM1KTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVCYWxsU2hhcGVUeXBlLlJvdW5kMztcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdyYWRpZW50O1xyXG4gICAgICAgIHRoaXMuc3RhcnRFeWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigxMzEsIDUwLCA0OSk7XHJcbiAgICAgICAgdGhpcy5lbmRFeWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYig0MiwgODIsIDkyKTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hBbmdsZSA9IDg7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZVNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUZyYW1lU2hhcGVUeXBlLlJvdW5kMztcclxuICAgICAgICBicmVhaztcclxuICAgICAgY2FzZSAxOTpcclxuICAgICAgICB0aGlzLmJhY2tDb2xvciA9IENvbG9yLmZyb21BcmdiKDM3LCA4NiwgOTkpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HbGFyZTtcclxuICAgICAgICB0aGlzLnN0YXJ0Qm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigwLCAyMjYsIDEyMCk7XHJcbiAgICAgICAgdGhpcy5lbmRCb2R5QnJ1c2hDb2xvciA9IENvbG9yLnllbGxvdygpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoQW5nbGUgPSAzO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoRm9jdXMgPSAwLjU7XHJcbiAgICAgICAgdGhpcy5ib2R5U2hhcGVUeXBlID0gU3RpUVJDb2RlQm9keVNoYXBlVHlwZS5aZWJyYUNyb3NzMTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guR3JhZGllbnQ7XHJcbiAgICAgICAgdGhpcy5zdGFydEV5ZUJhbGxCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTc4LCAxNjEsIDE5OSk7XHJcbiAgICAgICAgdGhpcy5lbmRFeWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLndoaXRlKCk7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hBbmdsZSA9IDQ7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllQmFsbFNoYXBlVHlwZS5aZWJyYVZlcnRpY2FsO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guSGF0Y2g7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoSGF0Y2hTdHlsZSA9IEhhdGNoU3R5bGUuRGFya1ZlcnRpY2FsO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaEZvcmVDb2xvciA9IENvbG9yLmZyb21BcmdiKDI1MywgMjM0LCAyMTgpO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaEJhY2tDb2xvciA9IENvbG9yLmZyb21BcmdiKDE5OCwgMjE3LCAyNDApO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVGcmFtZVNoYXBlVHlwZS5Eb3RzO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIDIwOlxyXG4gICAgICAgIHRoaXMuYmFja0NvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMzcsIDg2LCA5OSk7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdsYXJlO1xyXG4gICAgICAgIHRoaXMuc3RhcnRCb2R5QnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDI1NSwgMTQ3LCAxNDcpO1xyXG4gICAgICAgIHRoaXMuZW5kQm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyMTksIDIzOCwgMjQzKTtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaEFuZ2xlID0gMDtcclxuICAgICAgICB0aGlzLmJvZHlCcnVzaEZvY3VzID0gMC41O1xyXG4gICAgICAgIHRoaXMuYm9keVNoYXBlVHlwZSA9IFN0aVFSQ29kZUJvZHlTaGFwZVR5cGUuWmVicmFDcm9zczI7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdsYXNzO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigxNDcsIDI1NSwgMjU1KTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaERyYXdIYXRjaCA9IGZhbHNlO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoQmxlbmQgPSAwLjI7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllQmFsbFNoYXBlVHlwZS5DaXJjbGU7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HcmFkaWVudDtcclxuICAgICAgICB0aGlzLnN0YXJ0RXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjU1LCAxNDcsIDI1MSk7XHJcbiAgICAgICAgdGhpcy5lbmRFeWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyNTUsIDE0NywgMTQpO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaEFuZ2xlID0gNTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllRnJhbWVTaGFwZVR5cGUuUm91bmQxO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIDIxOlxyXG4gICAgICAgIHRoaXMuYmFja0NvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMzcsIDg2LCA5OSk7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdyYWRpZW50O1xyXG4gICAgICAgIHRoaXMuc3RhcnRCb2R5QnJ1c2hDb2xvciA9IENvbG9yLndoaXRlKCk7XHJcbiAgICAgICAgdGhpcy5lbmRCb2R5QnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDE2NSwgMTY1LCAxNjUpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoQW5nbGUgPSAzO1xyXG4gICAgICAgIHRoaXMuYm9keVNoYXBlVHlwZSA9IFN0aVFSQ29kZUJvZHlTaGFwZVR5cGUuQ2lyY2xlO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HbGFyZTtcclxuICAgICAgICB0aGlzLnN0YXJ0RXllQmFsbEJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyMTUsIDIyNywgMTg4KTtcclxuICAgICAgICB0aGlzLmVuZEV5ZUJhbGxCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjU1LCAxNDcsIDI1MSk7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hBbmdsZSA9IDU7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hGb2N1cyA9IDAuNTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVCYWxsU2hhcGVUeXBlLkNpcmNsZTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdsYXNzO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjE5LCAyMjksIDI0MSk7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoRHJhd0hhdGNoID0gZmFsc2U7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQmxlbmQgPSAwLjI7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZVNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUZyYW1lU2hhcGVUeXBlLkNpcmNsZTtcclxuICAgICAgICBicmVhaztcclxuICAgICAgY2FzZSAyMjpcclxuICAgICAgICB0aGlzLmJhY2tDb2xvciA9IENvbG9yLmZyb21BcmdiKDM3LCA4NiwgOTkpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HbGFyZTtcclxuICAgICAgICB0aGlzLnN0YXJ0Qm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyMjksIDE4MiwgMTgzKTtcclxuICAgICAgICB0aGlzLmVuZEJvZHlCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTQxLCAxNzksIDIyNik7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hBbmdsZSA9IDc7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hGb2N1cyA9IDAuOTtcclxuICAgICAgICB0aGlzLmJvZHlTaGFwZVR5cGUgPSBTdGlRUkNvZGVCb2R5U2hhcGVUeXBlLlJvdW5kZWRTcXVhcmU7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkhhdGNoO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbEJydXNoSGF0Y2hTdHlsZSA9IEhhdGNoU3R5bGUuTGFyZ2VDaGVja2VyQm9hcmQ7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hGb3JlQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyMDQsIDE5MywgMjE3KTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaEJhY2tDb2xvciA9IENvbG9yLmZyb21BcmdiKDI0MiwgMjIwLCAyMTkpO1xyXG4gICAgICAgIHRoaXMuZXllQmFsbFNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUJhbGxTaGFwZVR5cGUuUm91bmQ7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HbGFyZTtcclxuICAgICAgICB0aGlzLnN0YXJ0RXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjAxLCAxNDcsIDI1NSk7XHJcbiAgICAgICAgdGhpcy5lbmRFeWVGcmFtZUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyMTksIDIyOSwgMjQxKTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hBbmdsZSA9IDU7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoRm9jdXMgPSAwLjU7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZVNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUZyYW1lU2hhcGVUeXBlLlJvdW5kO1xyXG4gICAgICAgIGJyZWFrO1xyXG4gICAgICBjYXNlIDIzOlxyXG4gICAgICAgIHRoaXMuYmFja0NvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMzcsIDg2LCA5OSk7XHJcbiAgICAgICAgdGhpcy5ib2R5QnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdyYWRpZW50O1xyXG4gICAgICAgIHRoaXMuc3RhcnRCb2R5QnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDE2NSwgMTY1LCAxNjUpO1xyXG4gICAgICAgIHRoaXMuZW5kQm9keUJydXNoQ29sb3IgPSBDb2xvci53aGl0ZSgpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoQW5nbGUgPSAzO1xyXG4gICAgICAgIHRoaXMuYm9keVNoYXBlVHlwZSA9IFN0aVFSQ29kZUJvZHlTaGFwZVR5cGUuRGlhbW9uZDtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guR2xhcmU7XHJcbiAgICAgICAgdGhpcy5zdGFydEV5ZUJhbGxCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTQ3LCAyNTUsIDI1NSk7XHJcbiAgICAgICAgdGhpcy5lbmRFeWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDExMiwgNDgsIDE2MCk7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hBbmdsZSA9IDU7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hGb2N1cyA9IDAuNTtcclxuICAgICAgICB0aGlzLmV5ZUJhbGxTaGFwZVR5cGUgPSBTdGlRUkNvZGVFeWVCYWxsU2hhcGVUeXBlLlJvdW5kMTtcclxuICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdsYXNzO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjE2LCAyMzgsIDI0Myk7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoRHJhd0hhdGNoID0gZmFsc2U7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQmxlbmQgPSAwLjI7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZVNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUZyYW1lU2hhcGVUeXBlLlJvdW5kMTtcclxuICAgICAgICBicmVhaztcclxuICAgICAgY2FzZSAyNDpcclxuICAgICAgICB0aGlzLmJhY2tDb2xvciA9IENvbG9yLmZyb21BcmdiKDM3LCA4NiwgOTkpO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoVHlwZSA9IFN0aUJvZHlCcnVzaC5HbGFyZTtcclxuICAgICAgICB0aGlzLnN0YXJ0Qm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigyNTUsIDQwLCAxMDApO1xyXG4gICAgICAgIHRoaXMuZW5kQm9keUJydXNoQ29sb3IgPSBDb2xvci5mcm9tQXJnYigxNDYsIDIxNSwgODApO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoQW5nbGUgPSAzO1xyXG4gICAgICAgIHRoaXMuYm9keUJydXNoRm9jdXMgPSAwLjU7XHJcbiAgICAgICAgdGhpcy5ib2R5U2hhcGVUeXBlID0gU3RpUVJDb2RlQm9keVNoYXBlVHlwZS5aZWJyYUhvcml6b250YWw7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hUeXBlID0gU3RpQm9keUJydXNoLkdyYWRpZW50O1xyXG4gICAgICAgIHRoaXMuc3RhcnRFeWVCYWxsQnJ1c2hDb2xvciA9IENvbG9yLmZyb21BcmdiKDAsIDE3NiwgMjQwKTtcclxuICAgICAgICB0aGlzLmVuZEV5ZUJhbGxCcnVzaENvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMjI5LCAyMjQsIDIzNik7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hBbmdsZSA9IDA7XHJcbiAgICAgICAgdGhpcy5leWVCYWxsU2hhcGVUeXBlID0gU3RpUVJDb2RlRXllQmFsbFNoYXBlVHlwZS5TdGFyO1xyXG4gICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaFR5cGUgPSBTdGlCb2R5QnJ1c2guSGF0Y2g7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoSGF0Y2hTdHlsZSA9IEhhdGNoU3R5bGUuRGFzaGVkVXB3YXJkRGlhZ29uYWw7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoRm9yZUNvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTg0LCAyMDQsIDIyOCk7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQmFja0NvbG9yID0gQ29sb3IuZnJvbUFyZ2IoMTc4LCAxNjEsIDE5OSk7XHJcbiAgICAgICAgdGhpcy5leWVGcmFtZVNoYXBlVHlwZSA9IFN0aVFSQ29kZUV5ZUZyYW1lU2hhcGVUeXBlLkNpcmNsZTtcclxuICAgICAgICBicmVhaztcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyByZXNldENoYW5nZWQoKSB7XHJcbiAgICBzdXBlci5yZXNldENoYW5nZWQoKTtcclxuICAgIGlmICh0aGlzLmxhYmVsICE9IG51bGwpIHtcclxuICAgICAgdGhpcy5sYWJlbC5yZXNldENoYW5nZWQoKTtcclxuICAgIH1cclxuICAgIGlmICh0aGlzLmRlc2NyaXB0aW9uICE9IG51bGwpIHtcclxuICAgICAgdGhpcy5kZXNjcmlwdGlvbi5yZXNldENoYW5nZWQoKTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgZGVzY3JpcHRpb24oKTogU3RpVGV4dEl0ZW0ge1xyXG4gICAgcmV0dXJuIHRoaXMuX2Rlc2NyaXB0aW9uO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBkZXNjcmlwdGlvbih2YWx1ZTogU3RpVGV4dEl0ZW0pIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2Rlc2NyaXB0aW9uO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2Rlc2NyaXB0aW9uID0gdmFsdWU7XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IGJhcmNvZGVUeXBlKCk6IFN0aUJhcmNvZGVUeXBlIHtcclxuICAgIHJldHVybiB0aGlzLl9iYXJjb2RlVHlwZTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgYmFyY29kZVR5cGUodmFsdWU6IFN0aUJhcmNvZGVUeXBlKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9iYXJjb2RlVHlwZTtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICB0aGlzLl9iYXJjb2RlVHlwZSA9IHZhbHVlO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuICBwdWJsaWMgZ2V0IG1hdHJpeFNpemUoKTogU3RpUVJDb2RlU2l6ZSB7XHJcbiAgICByZXR1cm4gdGhpcy5fbWF0cml4U2l6ZTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgbWF0cml4U2l6ZSh2YWx1ZTogU3RpUVJDb2RlU2l6ZSkge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fbWF0cml4U2l6ZTtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICB0aGlzLl9tYXRyaXhTaXplID0gdmFsdWU7XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXQgZXJyb3JDb3JyZWN0aW9uTGV2ZWwoKTogU3RpUVJDb2RlRXJyb3JDb3JyZWN0aW9uTGV2ZWwge1xyXG4gICAgcmV0dXJuIHRoaXMuX2Vycm9yQ29ycmVjdGlvbkxldmVsO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBlcnJvckNvcnJlY3Rpb25MZXZlbCh2YWx1ZTogU3RpUVJDb2RlRXJyb3JDb3JyZWN0aW9uTGV2ZWwpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2Vycm9yQ29ycmVjdGlvbkxldmVsO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2Vycm9yQ29ycmVjdGlvbkxldmVsID0gdmFsdWU7XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IGNvZGVTdHJpbmcoKTogc3RyaW5nIHtcclxuICAgIHJldHVybiB0aGlzLl9jb2RlU3RyaW5nO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBjb2RlU3RyaW5nKHZhbHVlOiBzdHJpbmcpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2NvZGVTdHJpbmc7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5fY29kZVN0cmluZyA9IHZhbHVlO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBleWVCYWxsQnJ1c2hUeXBlKCk6IFN0aUJvZHlCcnVzaCB7XHJcbiAgICByZXR1cm4gdGhpcy5fZXllQmFsbEJydXNoVHlwZTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgZXllQmFsbEJydXNoVHlwZSh2YWx1ZTogU3RpQm9keUJydXNoKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9leWVCYWxsQnJ1c2hUeXBlO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2V5ZUJhbGxCcnVzaFR5cGUgPSB2YWx1ZTtcclxuICAgICAgdGhpcy5faXNDaGFuZ2VkID0gdHJ1ZTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgZXllQmFsbEJydXNoQ29sb3IoKTogQ29sb3Ige1xyXG4gICAgcmV0dXJuIHRoaXMuX2V5ZUJhbGxCcnVzaENvbG9yO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBleWVCYWxsQnJ1c2hDb2xvcih2YWx1ZTogQ29sb3IpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2V5ZUJhbGxCcnVzaENvbG9yO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2V5ZUJhbGxCcnVzaENvbG9yID0gdmFsdWU7XHJcbiAgICAgIHRoaXMuX2V5ZUJhbGxCcnVzaENvbG9yLmNoYW5nZXNJbnRlcmNlcHRvciA9IHRoaXM7XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IHN0YXJ0RXllQmFsbEJydXNoQ29sb3IoKTogQ29sb3Ige1xyXG4gICAgcmV0dXJuIHRoaXMuX3N0YXJ0RXllQmFsbEJydXNoQ29sb3I7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IHN0YXJ0RXllQmFsbEJydXNoQ29sb3IodmFsdWU6IENvbG9yKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9zdGFydEV5ZUJhbGxCcnVzaENvbG9yO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX3N0YXJ0RXllQmFsbEJydXNoQ29sb3IgPSB2YWx1ZTtcclxuICAgICAgdGhpcy5fc3RhcnRFeWVCYWxsQnJ1c2hDb2xvci5jaGFuZ2VzSW50ZXJjZXB0b3IgPSB0aGlzO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBlbmRFeWVCYWxsQnJ1c2hDb2xvcigpOiBDb2xvciB7XHJcbiAgICByZXR1cm4gdGhpcy5fZW5kRXllQmFsbEJydXNoQ29sb3I7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IGVuZEV5ZUJhbGxCcnVzaENvbG9yKHZhbHVlOiBDb2xvcikge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fZW5kRXllQmFsbEJydXNoQ29sb3I7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5fZW5kRXllQmFsbEJydXNoQ29sb3IgPSB2YWx1ZTtcclxuICAgICAgdGhpcy5fZW5kRXllQmFsbEJydXNoQ29sb3IuY2hhbmdlc0ludGVyY2VwdG9yID0gdGhpcztcclxuICAgICAgdGhpcy5faXNDaGFuZ2VkID0gdHJ1ZTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgZXllQmFsbEJydXNoQmFja0NvbG9yKCk6IENvbG9yIHtcclxuICAgIHJldHVybiB0aGlzLl9leWVCYWxsQnJ1c2hCYWNrQ29sb3I7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IGV5ZUJhbGxCcnVzaEJhY2tDb2xvcih2YWx1ZTogQ29sb3IpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2V5ZUJhbGxCcnVzaEJhY2tDb2xvcjtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICB0aGlzLl9leWVCYWxsQnJ1c2hCYWNrQ29sb3IgPSB2YWx1ZTtcclxuICAgICAgdGhpcy5fZXllQmFsbEJydXNoQmFja0NvbG9yLmNoYW5nZXNJbnRlcmNlcHRvciA9IHRoaXM7XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IGV5ZUJhbGxCcnVzaEZvcmVDb2xvcigpOiBDb2xvciB7XHJcbiAgICByZXR1cm4gdGhpcy5fZXllQmFsbEJydXNoRm9yZUNvbG9yO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBleWVCYWxsQnJ1c2hGb3JlQ29sb3IodmFsdWU6IENvbG9yKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9leWVCYWxsQnJ1c2hGb3JlQ29sb3I7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5fZXllQmFsbEJydXNoRm9yZUNvbG9yID0gdmFsdWU7XHJcbiAgICAgIHRoaXMuX2V5ZUJhbGxCcnVzaEZvcmVDb2xvci5jaGFuZ2VzSW50ZXJjZXB0b3IgPSB0aGlzO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBleWVCYWxsU2hhcGVUeXBlKCk6IFN0aVFSQ29kZUV5ZUJhbGxTaGFwZVR5cGUge1xyXG4gICAgcmV0dXJuIHRoaXMuX2V5ZUJhbGxTaGFwZVR5cGU7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IGV5ZUJhbGxTaGFwZVR5cGUodmFsdWU6IFN0aVFSQ29kZUV5ZUJhbGxTaGFwZVR5cGUpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2V5ZUJhbGxTaGFwZVR5cGU7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5fZXllQmFsbFNoYXBlVHlwZSA9IHZhbHVlO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBleWVCYWxsQnJ1c2hBbmdsZSgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMuX2V5ZUJhbGxCcnVzaEFuZ2xlO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBleWVCYWxsQnJ1c2hBbmdsZSh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9leWVCYWxsQnJ1c2hBbmdsZTtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICBpZiAodmFsdWUgPD0gMCkge1xyXG4gICAgICAgIHRoaXMuX2V5ZUJhbGxCcnVzaEFuZ2xlID0gMDtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLl9leWVCYWxsQnJ1c2hBbmdsZSA9IHZhbHVlO1xyXG4gICAgICB9XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXQgZXllQmFsbEJydXNoSGF0Y2hTdHlsZSgpOiBIYXRjaFN0eWxlIHtcclxuICAgIHJldHVybiB0aGlzLl9leWVCYWxsQnJ1c2hIYXRjaFN0eWxlO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBleWVCYWxsQnJ1c2hIYXRjaFN0eWxlKHZhbHVlOiBIYXRjaFN0eWxlKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9leWVCYWxsQnJ1c2hIYXRjaFN0eWxlO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2V5ZUJhbGxCcnVzaEhhdGNoU3R5bGUgPSB2YWx1ZTtcclxuICAgICAgdGhpcy5faXNDaGFuZ2VkID0gdHJ1ZTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgZXllQmFsbEJydXNoRm9jdXMoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9leWVCYWxsQnJ1c2hGb2N1cztcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgZXllQmFsbEJydXNoRm9jdXModmFsdWU6IG51bWJlcikge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fZXllQmFsbEJydXNoRm9jdXM7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgaWYgKHZhbHVlIDw9IDApIHtcclxuICAgICAgICB0aGlzLl9leWVCYWxsQnJ1c2hGb2N1cyA9IDA7XHJcbiAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgdGhpcy5fZXllQmFsbEJydXNoRm9jdXMgPSB2YWx1ZTtcclxuICAgICAgfVxyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBleWVCYWxsQnJ1c2hCbGVuZCgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMuX2V5ZUJhbGxCcnVzaEJsZW5kO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBleWVCYWxsQnJ1c2hCbGVuZCh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9leWVCYWxsQnJ1c2hCbGVuZDtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICBpZiAodmFsdWUgPD0gMCkge1xyXG4gICAgICAgIHRoaXMuX2V5ZUJhbGxCcnVzaEJsZW5kID0gMDtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLl9leWVCYWxsQnJ1c2hCbGVuZCA9IHZhbHVlO1xyXG4gICAgICB9XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IGV5ZUJhbGxCcnVzaERyYXdIYXRjaCgpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0aGlzLl9leWVCYWxsQnJ1c2hEcmF3SGF0Y2g7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IGV5ZUJhbGxCcnVzaERyYXdIYXRjaCh2YWx1ZTogYm9vbGVhbikge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fZXllQmFsbEJydXNoRHJhd0hhdGNoO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2V5ZUJhbGxCcnVzaERyYXdIYXRjaCA9IHZhbHVlO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBib2R5QnJ1c2hUeXBlKCk6IFN0aUJvZHlCcnVzaCB7XHJcbiAgICByZXR1cm4gdGhpcy5fYm9keUJydXNoVHlwZTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgYm9keUJydXNoVHlwZSh2YWx1ZTogU3RpQm9keUJydXNoKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9ib2R5QnJ1c2hUeXBlO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2JvZHlCcnVzaFR5cGUgPSB2YWx1ZTtcclxuICAgICAgdGhpcy5faXNDaGFuZ2VkID0gdHJ1ZTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgYm9keUJydXNoQ29sb3IoKTogQ29sb3Ige1xyXG4gICAgcmV0dXJuIHRoaXMuX2JvZHlCcnVzaENvbG9yO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBib2R5QnJ1c2hDb2xvcih2YWx1ZTogQ29sb3IpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2JvZHlCcnVzaENvbG9yO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2JvZHlCcnVzaENvbG9yID0gdmFsdWU7XHJcbiAgICAgIHRoaXMuX2JvZHlCcnVzaENvbG9yLmNoYW5nZXNJbnRlcmNlcHRvciA9IHRoaXM7XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IHN0YXJ0Qm9keUJydXNoQ29sb3IoKTogQ29sb3Ige1xyXG4gICAgcmV0dXJuIHRoaXMuX3N0YXJ0Qm9keUJydXNoQ29sb3I7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IHN0YXJ0Qm9keUJydXNoQ29sb3IodmFsdWU6IENvbG9yKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9zdGFydEJvZHlCcnVzaENvbG9yO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX3N0YXJ0Qm9keUJydXNoQ29sb3IgPSB2YWx1ZTtcclxuICAgICAgdGhpcy5fc3RhcnRCb2R5QnJ1c2hDb2xvci5jaGFuZ2VzSW50ZXJjZXB0b3IgPSB0aGlzO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBlbmRCb2R5QnJ1c2hDb2xvcigpOiBDb2xvciB7XHJcbiAgICByZXR1cm4gdGhpcy5fZW5kQm9keUJydXNoQ29sb3I7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IGVuZEJvZHlCcnVzaENvbG9yKHZhbHVlOiBDb2xvcikge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fZW5kQm9keUJydXNoQ29sb3I7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5fZW5kQm9keUJydXNoQ29sb3IgPSB2YWx1ZTtcclxuICAgICAgdGhpcy5fZW5kQm9keUJydXNoQ29sb3IuY2hhbmdlc0ludGVyY2VwdG9yID0gdGhpcztcclxuICAgICAgdGhpcy5faXNDaGFuZ2VkID0gdHJ1ZTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgYm9keUJydXNoQmFja0NvbG9yKCk6IENvbG9yIHtcclxuICAgIHJldHVybiB0aGlzLl9ib2R5QnJ1c2hCYWNrQ29sb3I7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IGJvZHlCcnVzaEJhY2tDb2xvcih2YWx1ZTogQ29sb3IpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2JvZHlCcnVzaEJhY2tDb2xvcjtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICB0aGlzLl9ib2R5QnJ1c2hCYWNrQ29sb3IgPSB2YWx1ZTtcclxuICAgICAgdGhpcy5fYm9keUJydXNoQmFja0NvbG9yLmNoYW5nZXNJbnRlcmNlcHRvciA9IHRoaXM7XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IGJvZHlCcnVzaEZvcmVDb2xvcigpOiBDb2xvciB7XHJcbiAgICByZXR1cm4gdGhpcy5fYm9keUJydXNoRm9yZUNvbG9yO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBib2R5QnJ1c2hGb3JlQ29sb3IodmFsdWU6IENvbG9yKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9ib2R5QnJ1c2hGb3JlQ29sb3I7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5fYm9keUJydXNoRm9yZUNvbG9yID0gdmFsdWU7XHJcbiAgICAgIHRoaXMuX2JvZHlCcnVzaEZvcmVDb2xvci5jaGFuZ2VzSW50ZXJjZXB0b3IgPSB0aGlzO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBib2R5U2hhcGVUeXBlKCk6IFN0aVFSQ29kZUJvZHlTaGFwZVR5cGUge1xyXG4gICAgcmV0dXJuIHRoaXMuX2JvZHlTaGFwZVR5cGU7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IGJvZHlTaGFwZVR5cGUodmFsdWU6IFN0aVFSQ29kZUJvZHlTaGFwZVR5cGUpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2JvZHlTaGFwZVR5cGU7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5fYm9keVNoYXBlVHlwZSA9IHZhbHVlO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBib2R5QnJ1c2hBbmdsZSgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMuX2JvZHlCcnVzaEFuZ2xlO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBib2R5QnJ1c2hBbmdsZSh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9ib2R5QnJ1c2hBbmdsZTtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICBpZiAodmFsdWUgPD0gMCkge1xyXG4gICAgICAgIHRoaXMuX2JvZHlCcnVzaEFuZ2xlID0gMDtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLl9ib2R5QnJ1c2hBbmdsZSA9IHZhbHVlO1xyXG4gICAgICB9XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXQgYm9keUJydXNoSGF0Y2hTdHlsZSgpOiBIYXRjaFN0eWxlIHtcclxuICAgIHJldHVybiB0aGlzLl9ib2R5QnJ1c2hIYXRjaFN0eWxlO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBib2R5QnJ1c2hIYXRjaFN0eWxlKHZhbHVlOiBIYXRjaFN0eWxlKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9ib2R5QnJ1c2hIYXRjaFN0eWxlO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2JvZHlCcnVzaEhhdGNoU3R5bGUgPSB2YWx1ZTtcclxuICAgICAgdGhpcy5faXNDaGFuZ2VkID0gdHJ1ZTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgYm9keUJydXNoRm9jdXMoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9ib2R5QnJ1c2hGb2N1cztcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgYm9keUJydXNoRm9jdXModmFsdWU6IG51bWJlcikge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fYm9keUJydXNoRm9jdXM7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgaWYgKHZhbHVlIDw9IDApIHtcclxuICAgICAgICB0aGlzLl9ib2R5QnJ1c2hGb2N1cyA9IDA7XHJcbiAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgdGhpcy5fYm9keUJydXNoRm9jdXMgPSB2YWx1ZTtcclxuICAgICAgfVxyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBib2R5QnJ1c2hCbGVuZCgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMuX2JvZHlCcnVzaEJsZW5kO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBib2R5QnJ1c2hCbGVuZCh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9ib2R5QnJ1c2hCbGVuZDtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICBpZiAodmFsdWUgPD0gMCkge1xyXG4gICAgICAgIHRoaXMuX2JvZHlCcnVzaEJsZW5kID0gMDtcclxuICAgICAgfSBlbHNlIHtcclxuICAgICAgICB0aGlzLl9ib2R5QnJ1c2hCbGVuZCA9IHZhbHVlO1xyXG4gICAgICB9XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IGJvZHlCcnVzaERyYXdIYXRjaCgpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0aGlzLl9ib2R5QnJ1c2hEcmF3SGF0Y2g7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IGJvZHlCcnVzaERyYXdIYXRjaCh2YWx1ZTogYm9vbGVhbikge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fYm9keUJydXNoRHJhd0hhdGNoO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2JvZHlCcnVzaERyYXdIYXRjaCA9IHZhbHVlO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBleWVGcmFtZUJydXNoVHlwZSgpOiBTdGlCb2R5QnJ1c2gge1xyXG4gICAgcmV0dXJuIHRoaXMuX2V5ZUZyYW1lQnJ1c2hUeXBlO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBleWVGcmFtZUJydXNoVHlwZSh2YWx1ZTogU3RpQm9keUJydXNoKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9leWVGcmFtZUJydXNoVHlwZTtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICB0aGlzLl9leWVGcmFtZUJydXNoVHlwZSA9IHZhbHVlO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBleWVGcmFtZUJydXNoQ29sb3IoKTogQ29sb3Ige1xyXG4gICAgcmV0dXJuIHRoaXMuX2V5ZUZyYW1lQnJ1c2hDb2xvcjtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgZXllRnJhbWVCcnVzaENvbG9yKHZhbHVlOiBDb2xvcikge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fZXllRnJhbWVCcnVzaENvbG9yO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2V5ZUZyYW1lQnJ1c2hDb2xvciA9IHZhbHVlO1xyXG4gICAgICB0aGlzLl9leWVGcmFtZUJydXNoQ29sb3IuY2hhbmdlc0ludGVyY2VwdG9yID0gdGhpcztcclxuICAgICAgdGhpcy5faXNDaGFuZ2VkID0gdHJ1ZTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgc3RhcnRFeWVGcmFtZUJydXNoQ29sb3IoKTogQ29sb3Ige1xyXG4gICAgcmV0dXJuIHRoaXMuX3N0YXJ0RXllRnJhbWVCcnVzaENvbG9yO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBzdGFydEV5ZUZyYW1lQnJ1c2hDb2xvcih2YWx1ZTogQ29sb3IpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX3N0YXJ0RXllRnJhbWVCcnVzaENvbG9yO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX3N0YXJ0RXllRnJhbWVCcnVzaENvbG9yID0gdmFsdWU7XHJcbiAgICAgIHRoaXMuX3N0YXJ0RXllRnJhbWVCcnVzaENvbG9yLmNoYW5nZXNJbnRlcmNlcHRvciA9IHRoaXM7XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IGVuZEV5ZUZyYW1lQnJ1c2hDb2xvcigpOiBDb2xvciB7XHJcbiAgICByZXR1cm4gdGhpcy5fZW5kRXllRnJhbWVCcnVzaENvbG9yO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBlbmRFeWVGcmFtZUJydXNoQ29sb3IodmFsdWU6IENvbG9yKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9lbmRFeWVGcmFtZUJydXNoQ29sb3I7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5fZW5kRXllRnJhbWVCcnVzaENvbG9yID0gdmFsdWU7XHJcbiAgICAgIHRoaXMuX2VuZEV5ZUZyYW1lQnJ1c2hDb2xvci5jaGFuZ2VzSW50ZXJjZXB0b3IgPSB0aGlzO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBleWVGcmFtZUJydXNoQmFja0NvbG9yKCk6IENvbG9yIHtcclxuICAgIHJldHVybiB0aGlzLl9leWVGcmFtZUJydXNoQmFja0NvbG9yO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBleWVGcmFtZUJydXNoQmFja0NvbG9yKHZhbHVlOiBDb2xvcikge1xyXG4gICAgbGV0IG9sZFZhbHVlID0gdGhpcy5fZXllRnJhbWVCcnVzaEJhY2tDb2xvcjtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICB0aGlzLl9leWVGcmFtZUJydXNoQmFja0NvbG9yID0gdmFsdWU7XHJcbiAgICAgIHRoaXMuX2V5ZUZyYW1lQnJ1c2hCYWNrQ29sb3IuY2hhbmdlc0ludGVyY2VwdG9yID0gdGhpcztcclxuICAgICAgdGhpcy5faXNDaGFuZ2VkID0gdHJ1ZTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgZXllRnJhbWVCcnVzaEZvcmVDb2xvcigpOiBDb2xvciB7XHJcbiAgICByZXR1cm4gdGhpcy5fZXllRnJhbWVCcnVzaEZvcmVDb2xvcjtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgZXllRnJhbWVCcnVzaEZvcmVDb2xvcih2YWx1ZTogQ29sb3IpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2V5ZUZyYW1lQnJ1c2hGb3JlQ29sb3I7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgdGhpcy5fZXllRnJhbWVCcnVzaEZvcmVDb2xvciA9IHZhbHVlO1xyXG4gICAgICB0aGlzLl9leWVGcmFtZUJydXNoRm9yZUNvbG9yLmNoYW5nZXNJbnRlcmNlcHRvciA9IHRoaXM7XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IGV5ZUZyYW1lU2hhcGVUeXBlKCk6IFN0aVFSQ29kZUV5ZUZyYW1lU2hhcGVUeXBlIHtcclxuICAgIHJldHVybiB0aGlzLl9leWVGcmFtZVNoYXBlVHlwZTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgZXllRnJhbWVTaGFwZVR5cGUodmFsdWU6IFN0aVFSQ29kZUV5ZUZyYW1lU2hhcGVUeXBlKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9leWVGcmFtZVNoYXBlVHlwZTtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICB0aGlzLl9leWVGcmFtZVNoYXBlVHlwZSA9IHZhbHVlO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBleWVGcmFtZUJydXNoQW5nbGUoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9leWVGcmFtZUJydXNoQW5nbGU7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IGV5ZUZyYW1lQnJ1c2hBbmdsZSh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9leWVGcmFtZUJydXNoQW5nbGU7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgaWYgKHZhbHVlIDw9IDApIHtcclxuICAgICAgICB0aGlzLl9leWVGcmFtZUJydXNoQW5nbGUgPSAwO1xyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIHRoaXMuX2V5ZUZyYW1lQnJ1c2hBbmdsZSA9IHZhbHVlO1xyXG4gICAgICB9XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXQgZXllRnJhbWVCcnVzaEhhdGNoU3R5bGUoKTogSGF0Y2hTdHlsZSB7XHJcbiAgICByZXR1cm4gdGhpcy5fZXllRnJhbWVCcnVzaEhhdGNoU3R5bGU7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IGV5ZUZyYW1lQnJ1c2hIYXRjaFN0eWxlKHZhbHVlOiBIYXRjaFN0eWxlKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9leWVGcmFtZUJydXNoSGF0Y2hTdHlsZTtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICB0aGlzLl9leWVGcmFtZUJydXNoSGF0Y2hTdHlsZSA9IHZhbHVlO1xyXG4gICAgICB0aGlzLl9pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHVibGljIGdldCBleWVGcmFtZUJydXNoRm9jdXMoKTogbnVtYmVyIHtcclxuICAgIHJldHVybiB0aGlzLl9leWVGcmFtZUJydXNoRm9jdXM7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgc2V0IGV5ZUZyYW1lQnJ1c2hGb2N1cyh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9leWVGcmFtZUJydXNoRm9jdXM7XHJcbiAgICBpZiAob2xkVmFsdWUgIT0gdmFsdWUpIHtcclxuICAgICAgaWYgKHZhbHVlIDw9IDApIHtcclxuICAgICAgICB0aGlzLl9leWVGcmFtZUJydXNoRm9jdXMgPSAwO1xyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIHRoaXMuX2V5ZUZyYW1lQnJ1c2hGb2N1cyA9IHZhbHVlO1xyXG4gICAgICB9XHJcbiAgICAgIHRoaXMuX2lzQ2hhbmdlZCA9IHRydWU7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgZ2V0IGV5ZUZyYW1lQnJ1c2hCbGVuZCgpOiBudW1iZXIge1xyXG4gICAgcmV0dXJuIHRoaXMuX2V5ZUZyYW1lQnJ1c2hCbGVuZDtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBzZXQgZXllRnJhbWVCcnVzaEJsZW5kKHZhbHVlOiBudW1iZXIpIHtcclxuICAgIGxldCBvbGRWYWx1ZSA9IHRoaXMuX2V5ZUZyYW1lQnJ1c2hCbGVuZDtcclxuICAgIGlmIChvbGRWYWx1ZSAhPSB2YWx1ZSkge1xyXG4gICAgICBpZiAodmFsdWUgPD0gMCkge1xyXG4gICAgICAgIHRoaXMuX2V5ZUZyYW1lQnJ1c2hCbGVuZCA9IDA7XHJcbiAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgdGhpcy5fZXllRnJhbWVCcnVzaEJsZW5kID0gdmFsdWU7XHJcbiAgICAgIH1cclxuICAgICAgdGhpcy5faXNDaGFuZ2VkID0gdHJ1ZTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHB1YmxpYyBnZXQgZXllRnJhbWVCcnVzaERyYXdIYXRjaCgpOiBib29sZWFuIHtcclxuICAgIHJldHVybiB0aGlzLl9leWVGcmFtZUJydXNoRHJhd0hhdGNoO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHNldCBleWVGcmFtZUJydXNoRHJhd0hhdGNoKHZhbHVlOiBib29sZWFuKSB7XHJcbiAgICBsZXQgb2xkVmFsdWUgPSB0aGlzLl9leWVGcmFtZUJydXNoRHJhd0hhdGNoO1xyXG4gICAgaWYgKG9sZFZhbHVlICE9IHZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2V5ZUZyYW1lQnJ1c2hEcmF3SGF0Y2ggPSB2YWx1ZTtcclxuICAgICAgdGhpcy5faXNDaGFuZ2VkID0gdHJ1ZTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIHNhdmVUb0pzb25PYmplY3Qob3B0aW9uczogYW55KTogU3RpSnNvbiB7XHJcbiAgICBpZiAodGhpcy5lbGVtZW50ICYmIHRoaXMuZWxlbWVudC5uYXRpdmVFbGVtZW50KSB7XHJcbiAgICAgIGlmIChcclxuICAgICAgICB0aGlzLmVsZW1lbnQubmF0aXZlRWxlbWVudD8ub2Zmc2V0V2lkdGggPiAwICYmXHJcbiAgICAgICAgdGhpcy5lbGVtZW50Lm5hdGl2ZUVsZW1lbnQ/Lm9mZnNldEhlaWdodCA+IDAgJiZcclxuICAgICAgICAodGhpcy5iYXJjb2RlVHlwZSA9PSBTdGlCYXJjb2RlVHlwZS5BenRlYyB8fFxyXG4gICAgICAgICAgdGhpcy5iYXJjb2RlVHlwZSA9PSBTdGlCYXJjb2RlVHlwZS5RUkNvZGUgfHxcclxuICAgICAgICAgIHRoaXMuYmFyY29kZVR5cGUgPT0gU3RpQmFyY29kZVR5cGUuRGF0YU1hdHJpeCB8fFxyXG4gICAgICAgICAgdGhpcy5iYXJjb2RlVHlwZSA9PSBTdGlCYXJjb2RlVHlwZS5NYXhpY29kZSlcclxuICAgICAgKSB7XHJcbiAgICAgICAgaWYgKHRoaXMuZWxlbWVudC5uYXRpdmVFbGVtZW50Py5vZmZzZXRXaWR0aCA8IHRoaXMuZWxlbWVudC5uYXRpdmVFbGVtZW50Py5vZmZzZXRIZWlnaHQpIHtcclxuICAgICAgICAgIHRoaXMuV2lkdGggPSB0aGlzLmVsZW1lbnQubmF0aXZlRWxlbWVudD8ub2Zmc2V0V2lkdGg7XHJcbiAgICAgICAgICB0aGlzLkhlaWdodCA9IHRoaXMuZWxlbWVudC5uYXRpdmVFbGVtZW50Py5vZmZzZXRXaWR0aDtcclxuICAgICAgICB9IGVsc2Uge1xyXG4gICAgICAgICAgdGhpcy5XaWR0aCA9IHRoaXMuZWxlbWVudC5uYXRpdmVFbGVtZW50Py5vZmZzZXRIZWlnaHQ7XHJcbiAgICAgICAgICB0aGlzLkhlaWdodCA9IHRoaXMuZWxlbWVudC5uYXRpdmVFbGVtZW50Py5vZmZzZXRIZWlnaHQ7XHJcbiAgICAgICAgfVxyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIHRoaXMuV2lkdGggPSB0aGlzLmVsZW1lbnQubmF0aXZlRWxlbWVudD8ub2Zmc2V0V2lkdGg7XHJcbiAgICAgICAgdGhpcy5IZWlnaHQgPSB0aGlzLmVsZW1lbnQubmF0aXZlRWxlbWVudD8ub2Zmc2V0SGVpZ2h0O1xyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgICBsZXQgak9iamVjdCA9IHN1cGVyLnNhdmVUb0pzb25PYmplY3Qob3B0aW9ucyk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5Sk9iamVjdChcIkxhYmVsXCIsIHRoaXMubGFiZWwuc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zKSk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5Sk9iamVjdChcIkRlc2NyaXB0aW9uXCIsIHRoaXMuZGVzY3JpcHRpb24uc2F2ZVRvSnNvbk9iamVjdChvcHRpb25zKSk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5RW51bShcIkJhcmNvZGVUeXBlXCIsIFN0aUJhcmNvZGVUeXBlLCB0aGlzLmJhcmNvZGVUeXBlKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlTdHJpbmcoXCJDb2RlU3RyaW5nXCIsIHRoaXMuY29kZVN0cmluZyk7XHJcbiAgICAvLyBqT2JqZWN0LmFkZFByb3BlcnR5U3RyaW5nKFwiVG9vbHRpcFwiLCB0aGlzLnRvb2x0aXApO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eU51bWJlcihcIldpZHRoXCIsIHRoaXMuV2lkdGgpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eU51bWJlcihcIkhlaWdodFwiLCB0aGlzLkhlaWdodCk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5TnVtYmVyKFwiU3R5bGVcIiwgdGhpcy5zdHlsZSk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5Q29sb3IoXCJCYWNrQ29sb3JcIiwgdGhpcy5iYWNrQ29sb3IpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiRm9yZUNvbG9yXCIsIHRoaXMuZm9yZUNvbG9yKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlFbnVtKFwiTWF0cml4U2l6ZVwiLCBTdGlRUkNvZGVTaXplLCB0aGlzLm1hdHJpeFNpemUpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUVudW0oXCJFcnJvckNvcnJlY3Rpb25MZXZlbFwiLCBTdGlRUkNvZGVFcnJvckNvcnJlY3Rpb25MZXZlbCwgdGhpcy5lcnJvckNvcnJlY3Rpb25MZXZlbCk7XHJcblxyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUVudW0oXCJCb2R5QnJ1c2hUeXBlXCIsIFN0aUJvZHlCcnVzaCwgdGhpcy5ib2R5QnJ1c2hUeXBlKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlFbnVtKFwiRXllQmFsbEJydXNoVHlwZVwiLCBTdGlCb2R5QnJ1c2gsIHRoaXMuZXllQmFsbEJydXNoVHlwZSk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5RW51bShcIkV5ZUZyYW1lQnJ1c2hUeXBlXCIsIFN0aUJvZHlCcnVzaCwgdGhpcy5leWVGcmFtZUJydXNoVHlwZSk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5RW51bShcIkJvZHlTaGFwZVR5cGVcIiwgU3RpUVJDb2RlQm9keVNoYXBlVHlwZSwgdGhpcy5ib2R5U2hhcGVUeXBlKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlDb2xvcihcIkJvZHlCcnVzaENvbG9yXCIsIHRoaXMuYm9keUJydXNoQ29sb3IpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiU3RhcnRCb2R5QnJ1c2hDb2xvclwiLCB0aGlzLnN0YXJ0Qm9keUJydXNoQ29sb3IpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiRW5kQm9keUJydXNoQ29sb3JcIiwgdGhpcy5lbmRCb2R5QnJ1c2hDb2xvcik7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5Q29sb3IoXCJCb2R5QnJ1c2hGb3JlQ29sb3JcIiwgdGhpcy5ib2R5QnJ1c2hGb3JlQ29sb3IpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiQm9keUJydXNoQmFja0NvbG9yXCIsIHRoaXMuYm9keUJydXNoQmFja0NvbG9yKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlOdW1iZXIoXCJCb2R5QnJ1c2hBbmdsZVwiLCB0aGlzLmJvZHlCcnVzaEFuZ2xlKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlFbnVtKFwiQm9keUJydXNoSGF0Y2hTdHlsZVwiLCBIYXRjaFN0eWxlLCB0aGlzLmJvZHlCcnVzaEhhdGNoU3R5bGUpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eU51bWJlcihcIkJvZHlCcnVzaEZvY3VzXCIsIHRoaXMuYm9keUJydXNoRm9jdXMpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eU51bWJlcihcIkJvZHlCcnVzaEJsZW5kXCIsIHRoaXMuYm9keUJydXNoQmxlbmQpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUJvb2woXCJCb2R5QnJ1c2hEcmF3SGF0Y2hcIiwgdGhpcy5ib2R5QnJ1c2hEcmF3SGF0Y2gpO1xyXG5cclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlDb2xvcihcIkV5ZUJhbGxCcnVzaENvbG9yXCIsIHRoaXMuZXllQmFsbEJydXNoQ29sb3IpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiU3RhcnRFeWVCYWxsQnJ1c2hDb2xvclwiLCB0aGlzLnN0YXJ0RXllQmFsbEJydXNoQ29sb3IpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiRW5kRXllQmFsbEJydXNoQ29sb3JcIiwgdGhpcy5lbmRFeWVCYWxsQnJ1c2hDb2xvcik7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5RW51bShcIkV5ZUJhbGxTaGFwZVR5cGVcIiwgU3RpUVJDb2RlRXllQmFsbFNoYXBlVHlwZSwgdGhpcy5leWVCYWxsU2hhcGVUeXBlKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlDb2xvcihcIkV5ZUJhbGxCcnVzaEZvcmVDb2xvclwiLCB0aGlzLmV5ZUJhbGxCcnVzaEZvcmVDb2xvcik7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5Q29sb3IoXCJFeWVCYWxsQnJ1c2hCYWNrQ29sb3JcIiwgdGhpcy5leWVCYWxsQnJ1c2hCYWNrQ29sb3IpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eU51bWJlcihcIkV5ZUJhbGxCcnVzaEFuZ2xlXCIsIHRoaXMuZXllQmFsbEJydXNoQW5nbGUpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eU51bWJlcihcIkV5ZUJhbGxCcnVzaEJsZW5kXCIsIHRoaXMuZXllQmFsbEJydXNoQmxlbmQpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUVudW0oXCJFeWVCYWxsQnJ1c2hIYXRjaFN0eWxlXCIsIEhhdGNoU3R5bGUsIHRoaXMuZXllQmFsbEJydXNoSGF0Y2hTdHlsZSk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5TnVtYmVyKFwiRXllQmFsbEJydXNoRm9jdXNcIiwgdGhpcy5leWVCYWxsQnJ1c2hGb2N1cyk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5Qm9vbChcIkV5ZUJhbGxCcnVzaERyYXdIYXRjaFwiLCB0aGlzLmV5ZUJhbGxCcnVzaERyYXdIYXRjaCk7XHJcblxyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiRXllRnJhbWVCcnVzaENvbG9yXCIsIHRoaXMuZXllRnJhbWVCcnVzaENvbG9yKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlDb2xvcihcIlN0YXJ0RXllRnJhbWVCcnVzaENvbG9yXCIsIHRoaXMuc3RhcnRFeWVGcmFtZUJydXNoQ29sb3IpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiRW5kRXllRnJhbWVCcnVzaENvbG9yXCIsIHRoaXMuZW5kRXllRnJhbWVCcnVzaENvbG9yKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlFbnVtKFwiRXllRnJhbWVTaGFwZVR5cGVcIiwgU3RpUVJDb2RlRXllRnJhbWVTaGFwZVR5cGUsIHRoaXMuZXllRnJhbWVTaGFwZVR5cGUpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiRXllRnJhbWVCcnVzaEZvcmVDb2xvclwiLCB0aGlzLmV5ZUZyYW1lQnJ1c2hGb3JlQ29sb3IpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eUNvbG9yKFwiRXllRnJhbWVCcnVzaEJhY2tDb2xvclwiLCB0aGlzLmV5ZUZyYW1lQnJ1c2hCYWNrQ29sb3IpO1xyXG4gICAgak9iamVjdC5hZGRQcm9wZXJ0eU51bWJlcihcIkV5ZUZyYW1lQnJ1c2hBbmdsZVwiLCB0aGlzLmV5ZUZyYW1lQnJ1c2hBbmdsZSk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5TnVtYmVyKFwiRXllRnJhbWVCcnVzaEJsZW5kXCIsIHRoaXMuZXllRnJhbWVCcnVzaEJsZW5kKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlFbnVtKFwiRXllRnJhbWVCcnVzaEhhdGNoU3R5bGVcIiwgSGF0Y2hTdHlsZSwgdGhpcy5leWVGcmFtZUJydXNoSGF0Y2hTdHlsZSk7XHJcbiAgICBqT2JqZWN0LmFkZFByb3BlcnR5TnVtYmVyKFwiRXllRnJhbWVCcnVzaEZvY3VzXCIsIHRoaXMuZXllRnJhbWVCcnVzaEZvY3VzKTtcclxuICAgIGpPYmplY3QuYWRkUHJvcGVydHlCb29sKFwiRXllRnJhbWVCcnVzaERyYXdIYXRjaFwiLCB0aGlzLmV5ZUZyYW1lQnJ1c2hEcmF3SGF0Y2gpO1xyXG4gICAgcmV0dXJuIGpPYmplY3Q7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgbG9hZEZyb21Kc29uT2JqZWN0KGpzb246IFN0aUpzb24pIHtcclxuICAgIHN1cGVyLmxvYWRGcm9tSnNvbk9iamVjdChqc29uKTtcclxuICAgIGZvciAobGV0IHByb3BlcnR5IG9mIGpzb24ucHJvcGVydGllcygpKSB7XHJcbiAgICAgIHN3aXRjaCAocHJvcGVydHkubmFtZSkge1xyXG4gICAgICAgIGNhc2UgXCJMYWJlbFwiOlxyXG4gICAgICAgICAgdGhpcy5sYWJlbCA9IG5ldyBTdGlMYWJlbEl0ZW0odGhpcyk7XHJcbiAgICAgICAgICB0aGlzLmxhYmVsLmxvYWRGcm9tSnNvbk9iamVjdChwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiRGVzY3JpcHRpb25cIjpcclxuICAgICAgICAgIHRoaXMuZGVzY3JpcHRpb24gPSBuZXcgU3RpVGV4dEl0ZW0oKTtcclxuICAgICAgICAgIHRoaXMuZGVzY3JpcHRpb24ubG9hZEZyb21Kc29uT2JqZWN0KHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJCYXJjb2RlVHlwZVwiOlxyXG4gICAgICAgICAgdGhpcy5iYXJjb2RlVHlwZSA9IEVudW0ucGFyc2UoU3RpQmFyY29kZVR5cGUsIHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJDb2RlU3RyaW5nXCI6XHJcbiAgICAgICAgICB0aGlzLmNvZGVTdHJpbmcgPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIC8qICBjYXNlIFwiVG9vbHRpcFwiOlxyXG4gICAgICAgICAgdGhpcy50b29sdGlwID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhazsgKi9cclxuICAgICAgICBjYXNlIFwiV2lkdGhcIjpcclxuICAgICAgICAgIHRoaXMuV2lkdGggPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJIZWlnaHRcIjpcclxuICAgICAgICAgIHRoaXMuSGVpZ2h0ID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiU3R5bGVcIjpcclxuICAgICAgICAgIHRoaXMuc3R5bGUgPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJCYWNrQ29sb3JcIjpcclxuICAgICAgICAgIHRoaXMuYmFja0NvbG9yID0gbmV3IENvbG9yKCk7XHJcbiAgICAgICAgICB0aGlzLmJhY2tDb2xvci5kZXNlcmlhbGl6ZUZyb21TdHJpbmcocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkZvcmVDb2xvclwiOlxyXG4gICAgICAgICAgdGhpcy5mb3JlQ29sb3IgPSBuZXcgQ29sb3IoKTtcclxuICAgICAgICAgIHRoaXMuZm9yZUNvbG9yLmRlc2VyaWFsaXplRnJvbVN0cmluZyhwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiTWF0cml4U2l6ZVwiOlxyXG4gICAgICAgICAgdGhpcy5tYXRyaXhTaXplID0gRW51bS5wYXJzZShTdGlRUkNvZGVTaXplLCBwcm9wZXJ0eS52YWx1ZSwgZmFsc2UpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkVycm9yQ29ycmVjdGlvbkxldmVsXCI6XHJcbiAgICAgICAgICB0aGlzLmVycm9yQ29ycmVjdGlvbkxldmVsID0gRW51bS5wYXJzZShTdGlRUkNvZGVFcnJvckNvcnJlY3Rpb25MZXZlbCwgcHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkJvZHlCcnVzaFR5cGVcIjpcclxuICAgICAgICAgIHRoaXMuYm9keUJydXNoVHlwZSA9IEVudW0ucGFyc2UoU3RpQm9keUJydXNoLCBwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiRXllQmFsbEJydXNoVHlwZVwiOlxyXG4gICAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hUeXBlID0gRW51bS5wYXJzZShTdGlCb2R5QnJ1c2gsIHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJFeWVGcmFtZUJydXNoVHlwZVwiOlxyXG4gICAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoVHlwZSA9IEVudW0ucGFyc2UoU3RpQm9keUJydXNoLCBwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiQm9keVNoYXBlVHlwZVwiOlxyXG4gICAgICAgICAgdGhpcy5ib2R5U2hhcGVUeXBlID0gRW51bS5wYXJzZShTdGlRUkNvZGVCb2R5U2hhcGVUeXBlLCBwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiQm9keUJydXNoQ29sb3JcIjpcclxuICAgICAgICAgIHRoaXMuYm9keUJydXNoQ29sb3IgPSBuZXcgQ29sb3IoKTtcclxuICAgICAgICAgIHRoaXMuYm9keUJydXNoQ29sb3IuZGVzZXJpYWxpemVGcm9tU3RyaW5nKHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJTdGFydEJvZHlCcnVzaENvbG9yXCI6XHJcbiAgICAgICAgICB0aGlzLnN0YXJ0Qm9keUJydXNoQ29sb3IgPSBuZXcgQ29sb3IoKTtcclxuICAgICAgICAgIHRoaXMuc3RhcnRCb2R5QnJ1c2hDb2xvci5kZXNlcmlhbGl6ZUZyb21TdHJpbmcocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkVuZEJvZHlCcnVzaENvbG9yXCI6XHJcbiAgICAgICAgICB0aGlzLmVuZEJvZHlCcnVzaENvbG9yID0gbmV3IENvbG9yKCk7XHJcbiAgICAgICAgICB0aGlzLmVuZEJvZHlCcnVzaENvbG9yLmRlc2VyaWFsaXplRnJvbVN0cmluZyhwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiQm9keUJydXNoRm9yZUNvbG9yXCI6XHJcbiAgICAgICAgICB0aGlzLmJvZHlCcnVzaEZvcmVDb2xvciA9IG5ldyBDb2xvcigpO1xyXG4gICAgICAgICAgdGhpcy5ib2R5QnJ1c2hGb3JlQ29sb3IuZGVzZXJpYWxpemVGcm9tU3RyaW5nKHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJCb2R5QnJ1c2hCYWNrQ29sb3JcIjpcclxuICAgICAgICAgIHRoaXMuYm9keUJydXNoQmFja0NvbG9yID0gbmV3IENvbG9yKCk7XHJcbiAgICAgICAgICB0aGlzLmJvZHlCcnVzaEJhY2tDb2xvci5kZXNlcmlhbGl6ZUZyb21TdHJpbmcocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkJvZHlCcnVzaEFuZ2xlXCI6XHJcbiAgICAgICAgICB0aGlzLmJvZHlCcnVzaEFuZ2xlID0gcHJvcGVydHkudmFsdWU7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiQm9keUJydXNoQmxlbmRcIjpcclxuICAgICAgICAgIHRoaXMuYm9keUJydXNoQmxlbmQgPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJFeWVCYWxsQnJ1c2hCbGVuZFwiOlxyXG4gICAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hCbGVuZCA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkV5ZUZyYW1lQnJ1c2hCbGVuZFwiOlxyXG4gICAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQmxlbmQgPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJCb2R5QnJ1c2hIYXRjaFN0eWxlXCI6XHJcbiAgICAgICAgICB0aGlzLmJvZHlCcnVzaEhhdGNoU3R5bGUgPSBFbnVtLnBhcnNlKEhhdGNoU3R5bGUsIHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJCb2R5QnJ1c2hGb2N1c1wiOlxyXG4gICAgICAgICAgdGhpcy5ib2R5QnJ1c2hGb2N1cyA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkJvZHlCcnVzaERyYXdIYXRjaFwiOlxyXG4gICAgICAgICAgdGhpcy5ib2R5QnJ1c2hEcmF3SGF0Y2ggPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJFeWVCYWxsQnJ1c2hDb2xvclwiOlxyXG4gICAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hDb2xvciA9IG5ldyBDb2xvcigpO1xyXG4gICAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hDb2xvci5kZXNlcmlhbGl6ZUZyb21TdHJpbmcocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlN0YXJ0RXllQmFsbEJydXNoQ29sb3JcIjpcclxuICAgICAgICAgIHRoaXMuc3RhcnRFeWVCYWxsQnJ1c2hDb2xvciA9IG5ldyBDb2xvcigpO1xyXG4gICAgICAgICAgdGhpcy5zdGFydEV5ZUJhbGxCcnVzaENvbG9yLmRlc2VyaWFsaXplRnJvbVN0cmluZyhwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiRW5kRXllQmFsbEJydXNoQ29sb3JcIjpcclxuICAgICAgICAgIHRoaXMuZW5kRXllQmFsbEJydXNoQ29sb3IgPSBuZXcgQ29sb3IoKTtcclxuICAgICAgICAgIHRoaXMuZW5kRXllQmFsbEJydXNoQ29sb3IuZGVzZXJpYWxpemVGcm9tU3RyaW5nKHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJFeWVCYWxsU2hhcGVUeXBlXCI6XHJcbiAgICAgICAgICB0aGlzLmV5ZUJhbGxTaGFwZVR5cGUgPSBFbnVtLnBhcnNlKFN0aVFSQ29kZUV5ZUJhbGxTaGFwZVR5cGUsIHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJFeWVCYWxsQnJ1c2hGb3JlQ29sb3JcIjpcclxuICAgICAgICAgIHRoaXMuZXllQmFsbEJydXNoRm9yZUNvbG9yID0gbmV3IENvbG9yKCk7XHJcbiAgICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaEZvcmVDb2xvci5kZXNlcmlhbGl6ZUZyb21TdHJpbmcocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkV5ZUJhbGxCcnVzaEJhY2tDb2xvclwiOlxyXG4gICAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hCYWNrQ29sb3IgPSBuZXcgQ29sb3IoKTtcclxuICAgICAgICAgIHRoaXMuZXllQmFsbEJydXNoQmFja0NvbG9yLmRlc2VyaWFsaXplRnJvbVN0cmluZyhwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiRXllQmFsbEJydXNoQW5nbGVcIjpcclxuICAgICAgICAgIHRoaXMuZXllQmFsbEJydXNoQW5nbGUgPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJFeWVCYWxsQnJ1c2hIYXRjaFN0eWxlXCI6XHJcbiAgICAgICAgICB0aGlzLmV5ZUJhbGxCcnVzaEhhdGNoU3R5bGUgPSBFbnVtLnBhcnNlKEhhdGNoU3R5bGUsIHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJFeWVCYWxsQnJ1c2hGb2N1c1wiOlxyXG4gICAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hGb2N1cyA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkV5ZUJhbGxCcnVzaERyYXdIYXRjaFwiOlxyXG4gICAgICAgICAgdGhpcy5leWVCYWxsQnJ1c2hEcmF3SGF0Y2ggPSBwcm9wZXJ0eS52YWx1ZTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJFeWVGcmFtZUJydXNoQ29sb3JcIjpcclxuICAgICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaENvbG9yID0gbmV3IENvbG9yKCk7XHJcbiAgICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hDb2xvci5kZXNlcmlhbGl6ZUZyb21TdHJpbmcocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIlN0YXJ0RXllRnJhbWVCcnVzaENvbG9yXCI6XHJcbiAgICAgICAgICB0aGlzLnN0YXJ0RXllRnJhbWVCcnVzaENvbG9yID0gbmV3IENvbG9yKCk7XHJcbiAgICAgICAgICB0aGlzLnN0YXJ0RXllRnJhbWVCcnVzaENvbG9yLmRlc2VyaWFsaXplRnJvbVN0cmluZyhwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiRW5kRXllRnJhbWVCcnVzaENvbG9yXCI6XHJcbiAgICAgICAgICB0aGlzLmVuZEV5ZUZyYW1lQnJ1c2hDb2xvciA9IG5ldyBDb2xvcigpO1xyXG4gICAgICAgICAgdGhpcy5lbmRFeWVGcmFtZUJydXNoQ29sb3IuZGVzZXJpYWxpemVGcm9tU3RyaW5nKHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJFeWVGcmFtZVNoYXBlVHlwZVwiOlxyXG4gICAgICAgICAgdGhpcy5leWVGcmFtZVNoYXBlVHlwZSA9IEVudW0ucGFyc2UoU3RpUVJDb2RlRXllRnJhbWVTaGFwZVR5cGUsIHByb3BlcnR5LnZhbHVlKTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJFeWVGcmFtZUJydXNoRm9yZUNvbG9yXCI6XHJcbiAgICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hGb3JlQ29sb3IgPSBuZXcgQ29sb3IoKTtcclxuICAgICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaEZvcmVDb2xvci5kZXNlcmlhbGl6ZUZyb21TdHJpbmcocHJvcGVydHkudmFsdWUpO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkV5ZUZyYW1lQnJ1c2hCYWNrQ29sb3JcIjpcclxuICAgICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaEJhY2tDb2xvciA9IG5ldyBDb2xvcigpO1xyXG4gICAgICAgICAgdGhpcy5leWVGcmFtZUJydXNoQmFja0NvbG9yLmRlc2VyaWFsaXplRnJvbVN0cmluZyhwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiRXllRnJhbWVCcnVzaEFuZ2xlXCI6XHJcbiAgICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hBbmdsZSA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkV5ZUZyYW1lQnJ1c2hIYXRjaFN0eWxlXCI6XHJcbiAgICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hIYXRjaFN0eWxlID0gRW51bS5wYXJzZShIYXRjaFN0eWxlLCBwcm9wZXJ0eS52YWx1ZSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiRXllRnJhbWVCcnVzaEZvY3VzXCI6XHJcbiAgICAgICAgICB0aGlzLmV5ZUZyYW1lQnJ1c2hGb2N1cyA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcIkV5ZUZyYW1lQnJ1c2hEcmF3SGF0Y2hcIjpcclxuICAgICAgICAgIHRoaXMuZXllRnJhbWVCcnVzaERyYXdIYXRjaCA9IHByb3BlcnR5LnZhbHVlO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgIH1cclxuICAgIH1cclxuICB9XHJcbn1cclxuIl19