import { Injectable } from "@angular/core";
import { StiFormPageElement } from "../elements/StiFormPageElement";
import StiRectangleGeometry from "../properties/StiRectangleGeometry";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
export default class StiRectangleGeometryLayout {
    constructor(model) {
        this.model = model;
    }
    insertElement(newElement, contentAreaWidth = 0) {
        // let fixedGeometry = this.fixForInsert(newElement.geometry);
        let parentElement = this.model.getElementPage(newElement) ?? this.model.getElementPanel(newElement);
        let otherElements = Array.from(parentElement.elements);
        otherElements.splice(otherElements.indexOf(newElement), 1);
        if (newElement) {
            let fixedGeometry = newElement.geometry;
            this.insertFixed(fixedGeometry, newElement, otherElements, contentAreaWidth);
        }
    }
    isHigherThan(left, right) {
        return left.bottom <= right.y;
    }
    isHigherThan2(left, right) {
        return left.bottom - left.height / 2 <= right.y;
    }
    removeElement(elementToRemove, otherElements) {
        let elementsAbove = [];
        let elementsBelow = [];
        for (let element of otherElements) {
            if (this.isHigherThan(element.geometry, elementToRemove.geometry)) {
                elementsAbove.push(element);
            }
            else {
                elementsBelow.push(element);
            }
        }
        this.snapBelowsToAboves(elementsBelow, elementsAbove);
    }
    changeElementGeometry(elementToChange, otherElements, contentAreaWidth = 0) {
        let fixedGeometry = elementToChange.geometry;
        this.insertFixed(fixedGeometry, elementToChange, otherElements, contentAreaWidth);
    }
    fitWidth(fixedGeometry, otherElements, contentAreaWidth) {
        if (contentAreaWidth > 0) {
            let right = contentAreaWidth;
            let rect = new StiRectangleGeometry(fixedGeometry.width - fixedGeometry.minWidth, fixedGeometry.height / 2);
            rect.x = fixedGeometry.x + fixedGeometry.minWidth;
            rect.y = fixedGeometry.y;
            otherElements.forEach((element) => {
                if (element.geometry.intersectWith(rect)) {
                    right = Math.min(right, element.geometry.x);
                }
            });
            let newWidth = fixedGeometry.width - (fixedGeometry.right - right);
            if (newWidth + StiRectangleGeometry.DELTA > fixedGeometry.minWidth &&
                newWidth <= fixedGeometry.width + StiRectangleGeometry.DELTA) {
                fixedGeometry.width = newWidth;
            }
        }
    }
    insertFixed(fixedGeometry, elementToInsert, otherElements, contentAreaWidth) {
        let elementsAbove = [];
        let elementsBelow = [];
        for (let element of otherElements) {
            if (this.isHigherThan2(element.geometry, fixedGeometry)) {
                elementsAbove.push(element);
            }
            else {
                elementsBelow.push(element);
            }
        }
        this.fitWidth(fixedGeometry, otherElements, contentAreaWidth);
        let snappedNewGeometry = this.snapOneToAboves(fixedGeometry, elementsAbove, true);
        elementToInsert.geometry = snappedNewGeometry;
        elementsAbove.push(elementToInsert);
        this.moveDown(elementsBelow, 2 * snappedNewGeometry.height);
        this.snapBelowsToAboves(elementsBelow, elementsAbove);
        this.fitWidth(snappedNewGeometry, otherElements, contentAreaWidth);
    }
    snapOneToAboves(geometry, elementsAboveToSnap, canShrink = false) {
        let elementsExcatlyAbove = elementsAboveToSnap.filter((element) => element.geometry.xProjectionIntersectsWith(geometry));
        if (elementsExcatlyAbove.length > 0) {
            let max = elementsExcatlyAbove.reduce((acc, curr) => (acc.geometry.bottom > curr.geometry.bottom ? acc : curr));
            return geometry.withY(max.geometry.bottom);
        }
        else
            return geometry.withY(0);
    }
    moveDown(elementsToMoveDown, distance) {
        for (let element of elementsToMoveDown) {
            element.geometry = element.geometry.withY(element.geometry.y + distance);
        }
    }
    snapBelowsToAboves(belows, aboves) {
        belows.sort(function (left, right) {
            let difference = left.geometry.y - right.geometry.y;
            if (difference < StiRectangleGeometry.DELTA) {
                return -1;
            }
            else if (difference > StiRectangleGeometry.DELTA) {
                return 1;
            }
            else {
                return 0;
            }
        });
        for (let element of belows) {
            let snappedFromBelow = this.snapOneToAboves(element.geometry, aboves);
            element.geometry = snappedFromBelow;
            aboves.push(element);
        }
    }
    getFreeToBottomResizeArea(currentResizeElement, otherElements) {
        let currentContainer = this.model.getElementPage(currentResizeElement) ?? this.model.getElementPanel(currentResizeElement);
        let geometry = currentResizeElement.geometry;
        let bottomElements = otherElements?.filter((element) => element.y >= geometry.bottom);
        let elementsExcatlyBelow = bottomElements?.filter((element) => element.geometry.xProjectionIntersectsWith(geometry));
        let bottomPoints = elementsExcatlyBelow?.map((element) => {
            return element.geometry.bottom;
        });
        let topPoints = elementsExcatlyBelow?.map((element) => {
            return element.geometry.y;
        });
        let maxBottomPoint = Math.max(...bottomPoints);
        let minTopPoint = Math.min(...topPoints);
        let bottomElementsHeight = maxBottomPoint - minTopPoint;
        return (currentContainer.contentAreaHeight -
            geometry.bottom -
            (elementsExcatlyBelow.length > 0 ? bottomElementsHeight : 0));
    }
    checkOutputs(usedPage) {
        let outputElements = [];
        let summaryHeight = 0;
        usedPage?.elements.forEach((element) => {
            if (element.geometry.bottom > usedPage.contentAreaHeight) {
                outputElements.push(element);
            }
        });
        if (outputElements.length > 0) {
            outputElements.forEach((element) => {
                summaryHeight += element.height;
                usedPage.elements.splice(usedPage.elements.indexOf(element), 1);
                this.removeElement(element, usedPage.elements);
            });
            if (this.model.form.pages[this.model.form.pages.indexOf(usedPage) + 1]) {
                let nextPage = this.model.form.pages[this.model.form.pages.indexOf(usedPage) + 1];
                if (nextPage.contentAreaHeight - Math.max(...nextPage.elements.map((element) => element.geometry.bottom)) >
                    summaryHeight) {
                    let currentBottomPoint = 0;
                    outputElements.forEach((element, index) => {
                        nextPage.elements.splice(index, 0, element);
                        element.y = currentBottomPoint;
                        this.insertElement(element);
                        currentBottomPoint += element.height;
                    });
                }
                else {
                    let page1 = new StiFormPageElement();
                    this.model.form.pages.splice(this.model.form.pages.indexOf(nextPage), 0, page1);
                    let currentBottomPoint = 0;
                    outputElements.forEach((element, index) => {
                        page1.elements.splice(index, 0, element);
                        element.y = currentBottomPoint;
                        this.insertElement(element);
                        currentBottomPoint += element.height;
                    });
                }
            }
            else {
                let page1 = new StiFormPageElement();
                this.model.form.pages.push(page1);
                let currentBottomPoint = 0;
                outputElements.forEach((element, index) => {
                    page1.elements.splice(index, 0, element);
                    element.y = currentBottomPoint;
                    this.insertElement(element);
                    currentBottomPoint += element.geometry.bottom;
                });
            }
        }
    }
}
StiRectangleGeometryLayout.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiRectangleGeometryLayout, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable });
StiRectangleGeometryLayout.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiRectangleGeometryLayout });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiRectangleGeometryLayout, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; } });
//# sourceMappingURL=data:application/json;base64,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