export function RenderComponentsGeometry(containers, model) {
    let currentRightPoint = 0;
    let currentBottomPoint = 0;
    let maxContainerWidth;
    let maxContainerHeight;
    let paddingLeft;
    let paddingTop;
    let paddingBot;
    let paddingRight;
    let previousElement;
    let currentColumnWidth;
    let previousColumnWidth;
    let maxContainerWidthInColumns = 12;
    let columns;
    containers.forEach((container) => {
        maxContainerHeight = container.height;
        maxContainerWidth = container.contentAreaWidth;
        currentRightPoint = 0;
        currentBottomPoint = 0;
        paddingLeft = container.padding.left;
        paddingTop = container.padding.top;
        paddingBot = container.padding.bottom;
        paddingRight = container.padding.right;
        previousColumnWidth = (model.previousContentAreaWidth - 2) / maxContainerWidthInColumns;
        currentColumnWidth = (container.contentAreaWidth - 2) / maxContainerWidthInColumns;
        container.elements.forEach((element) => {
            if (element.render) {
                if (!element.hasGeometry) {
                    if (currentRightPoint == 0 && currentBottomPoint == 0) {
                        element.x = currentRightPoint;
                        element.y = currentBottomPoint;
                        element.hasGeometry = true;
                        currentRightPoint += element.width;
                    }
                    else {
                        if (currentRightPoint + element.width <= maxContainerWidth) {
                            element.x = currentRightPoint;
                            element.y = currentBottomPoint;
                            element.hasGeometry = true;
                            currentRightPoint += element.width;
                        }
                        else {
                            currentBottomPoint += previousElement.computedHeight;
                            currentRightPoint = 0;
                            element.x = currentRightPoint;
                            element.y = currentBottomPoint;
                            element.hasGeometry = true;
                            currentRightPoint += element.width;
                        }
                    }
                }
                else if (element.hasGeometry) {
                    if (container.contentAreaWidth != model.previousContentAreaWidth) {
                        if (element.x > 0) {
                            columns = Math.round(element.x / previousColumnWidth);
                            element.x = columns * currentColumnWidth;
                            columns = Math.round(element.width / previousColumnWidth);
                            element.width = columns * currentColumnWidth;
                        }
                        else {
                            columns = Math.round(element.width / previousColumnWidth);
                            element.width = columns * currentColumnWidth;
                        }
                    }
                    else {
                        if (currentRightPoint == 0 && currentBottomPoint == 0) {
                            currentRightPoint = element.x;
                            element.y = currentBottomPoint;
                            currentRightPoint += element.width;
                        }
                        else {
                            if (currentRightPoint <= element.x && element.x + element.width <= maxContainerWidth) {
                                currentRightPoint = element.x;
                                element.y = currentBottomPoint;
                                currentRightPoint += element.width;
                            }
                            else {
                                currentBottomPoint += previousElement.computedHeight;
                                currentRightPoint = element.x;
                                element.y = currentBottomPoint;
                                currentRightPoint += element.width;
                            }
                        }
                    }
                }
                previousElement = element;
            }
        });
    });
}
//# sourceMappingURL=data:application/json;base64,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