import { Component, ViewChild } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-export.service";
import * as i3 from "../../services/sti-toolbar-resizer.service";
import * as i4 from "@angular/common";
import * as i5 from "../page.component/page.component";
export class WorkspaceComponent {
    constructor(model, exportService, toolbarResizerService) {
        this.model = model;
        this.exportService = exportService;
        this.toolbarResizerService = toolbarResizerService;
    }
    get padding() {
        if (this.toolbarResizerService.isMinimizeMode) {
            return 20 + "px";
        }
        else
            return 0 + "px";
    }
    get pages() {
        return this.model.form?.pages;
    }
    onClick(event) {
        let elements = document.elementsFromPoint(event.clientX, event.clientY);
        if (!elements.find((elem) => elem?.classList.contains("page")) &&
            !elements.find((elem) => elem?.classList.contains("page-navigation"))) {
            this.model.selectedComponent = null;
        }
    }
}
WorkspaceComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: WorkspaceComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiExportService }, { token: i3.StiToolbarResizerService }], target: i0.ɵɵFactoryTarget.Component });
WorkspaceComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: WorkspaceComponent, selector: "sti-workspace", viewQueries: [{ propertyName: "workspaceEl", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div class="main-container" [style.paddingLeft]="this.padding" (click)="onClick($event)">
      <div #element class="workspace" [style.transform]="model.getScale()" [style.transform-origin]="'left top'">
        <app-page [page]="page" *ngFor="let page of pages" (click)="onClick($event)"></app-page>
        <!-- <sti-toolbar-resizer [style.visibility]="this.model.isPreviewMode ? 'hidden' : ''"></sti-toolbar-resizer> -->
      </div>
    </div>

    <style>
      .workspace {
        width: fit-content;
        height: 100%;
        position: relative;
      }
      .center {
        text-align: center;
      }
      .main-container {
        height: 100%;
        width: 100%;
        padding-top: 10px;
        padding-right: 20px;
      }
    </style>
  `, isInline: true, styles: ["\n      .workspace {\n        width: fit-content;\n        height: 100%;\n        position: relative;\n      }\n      .center {\n        text-align: center;\n      }\n      .main-container {\n        height: 100%;\n        width: 100%;\n        padding-top: 10px;\n        padding-right: 20px;\n      }\n    "], dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: i5.PageComponent, selector: "app-page", inputs: ["page"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: WorkspaceComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-workspace",
                    template: `
    <div class="main-container" [style.paddingLeft]="this.padding" (click)="onClick($event)">
      <div #element class="workspace" [style.transform]="model.getScale()" [style.transform-origin]="'left top'">
        <app-page [page]="page" *ngFor="let page of pages" (click)="onClick($event)"></app-page>
        <!-- <sti-toolbar-resizer [style.visibility]="this.model.isPreviewMode ? 'hidden' : ''"></sti-toolbar-resizer> -->
      </div>
    </div>

    <style>
      .workspace {
        width: fit-content;
        height: 100%;
        position: relative;
      }
      .center {
        text-align: center;
      }
      .main-container {
        height: 100%;
        width: 100%;
        padding-top: 10px;
        padding-right: 20px;
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiExportService }, { type: i3.StiToolbarResizerService }]; }, propDecorators: { workspaceEl: [{
                type: ViewChild,
                args: ["element"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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