import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/platform-browser";
import * as i3 from "../../services/http-client.service";
import * as i4 from "@angular/common";
export class StiPdfPreviewComponent {
    constructor(model, sanitizer, httpService) {
        this.model = model;
        this.sanitizer = sanitizer;
        this.httpService = httpService;
    }
    ngOnDestroy() {
        if (this.model.selectedComponent) {
            this.model.selectedComponent.element.needToSelectComponent = true;
        }
    }
    ngAfterViewInit() {
        setTimeout(() => {
            let currentForm = this.model.currentFormState;
            let data = {
                action: "GeneratePDF",
                form: currentForm,
                settings: {
                    usePdfA: false,
                    readOnly: false,
                },
            };
            this.httpService.post(this.model.requestUrl, data, "byteArray", { showProgress: true }).subscribe((data) => {
                let pdfBytes = new Int8Array(data);
                this.model.showProgress = false;
                let blob = new Blob([pdfBytes], { type: "application/pdf" });
                let toolbar = this.model.isWebView ? "#toolbar=0" : "";
                this.src = this.sanitizer.bypassSecurityTrustResourceUrl(URL.createObjectURL(blob) + toolbar);
            });
        }, 0);
    }
    ngOnInit() { }
}
StiPdfPreviewComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiPdfPreviewComponent, deps: [{ token: i1.StiModelService }, { token: i2.DomSanitizer }, { token: i3.StiHttpClientService }], target: i0.ɵɵFactoryTarget.Component });
StiPdfPreviewComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiPdfPreviewComponent, selector: "sti-pdf-preview", ngImport: i0, template: ` <embed *ngIf="src" [src]="src" style="width: 100%;height: 100%" type="application/pdf" /> `, isInline: true, styles: [""], dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiPdfPreviewComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-pdf-preview", template: ` <embed *ngIf="src" [src]="src" style="width: 100%;height: 100%" type="application/pdf" /> ` }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.DomSanitizer }, { type: i3.StiHttpClientService }]; } });
//# sourceMappingURL=data:application/json;base64,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