import { Component, EventEmitter, Input, Output } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "../sti-editable-content.component";
import * as i5 from "../sti-tooltip/sti-tooltip.directive";
export class StiSvgRadiobuttonComponent {
    constructor(model) {
        this.model = model;
        this.useCustomOption = false;
        this.buttonClick = new EventEmitter();
        this.isCurrentOption = false;
    }
    get selected() {
        return this.model.selectedComponent?.element == this.element;
    }
    get isMozila() {
        return this.model.getBrowserType() == "firefox" ? true : false;
    }
    get isSafari() {
        return this.model.getBrowserType() == "safari" ? true : false;
    }
    get backColor() {
        return this.element.backgroundColor.toHtmlColor();
    }
    get checkColor() {
        return this.element.checkColor.toHtmlColor();
    }
    get borderColor() {
        return this.element.borderColor.toHtmlColor();
    }
    get textStyle() {
        return this.element?.htmlStyle();
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
    changeState() {
        this.buttonClick.emit();
    }
    get needToFill() {
        return this.element.required && !this.element.value && this.model.hasEmptyReuiredFields;
    }
    getContent(innerText) {
        if (this.isCurrentOption) {
            this.element.selectedOption = innerText;
        }
        this.element["customOptionText"] = innerText;
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    getCharCode(event) {
        return null === event.which ? event.keyCode : !(0 === event.which || 0 === event.charCode) ? event.which : -1;
    }
    checkOption() {
        if (this.element.selectedOption == this.element.customOptionText) {
            this.isCurrentOption = true;
        }
    }
    disableEnter(event) {
        if (13 === this.getCharCode(event))
            event.preventDefault();
    }
    ngOnInit() { }
}
StiSvgRadiobuttonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSvgRadiobuttonComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiSvgRadiobuttonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiSvgRadiobuttonComponent, selector: "sti-svg-radiobutton-component", inputs: { element: "element", id: "id", text: "text", state: "state", useCustomOption: "useCustomOption", tabIndex: "tabIndex" }, outputs: { buttonClick: "buttonClick" }, ngImport: i0, template: `
    <div
      class="custom-radio"
      *ngIf="!useCustomOption"
      (mousedown)="disableDrag($event)"
      (mouseup)="this.model.canDrag = true"
    >
      <input
        type="radio"
        name="radio +{{ element.name }}"
        id="{{ id }}"
        value=""
        [tabIndex]="tabIndex"
        [disabled]="element?.readOnly ? true : false"
        [required]="element?.required"
        [stiTooltip]="element?.tooltip"
        (click)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
        <circle
          class="box"
          cx="6"
          cy="6"
          r="5.5"
          [attr.fill]="backColor"
          [attr.stroke]="needToFill ? 'red' : borderColor"
        />
        <circle *ngIf="state" class="check" cx="6" cy="6" r="2.5" [attr.fill]="checkColor" />
      </svg>
      <sti-editable-content-component
        [style.display]="'flex'"
        [style.margin-left]="'5px'"
        [style.overflow]="'hidden'"
        [style.maxWidth]="'calc(100% - 17px)'"
        [eParent]="element"
        [editableContent]="text"
        [hideEmpty]="false"
        [active]="selected"
      ></sti-editable-content-component>
    </div>
    <div
      class="custom-radio other"
      *ngIf="useCustomOption"
      [style.width]="'100%'"
      [style.align-items]="'center'"
      (mousedown)="disableDrag($event)"
      (mouseup)="this.model.canDrag = true"
    >
      <input
        type="radio"
        name="radio +{{ element.name }}"
        id="{{ id }}"
        value=""
        [disabled]="element?.readOnly ? true : false"
        [required]="element?.required"
        [stiTooltip]="element?.tooltip"
        (mousedown)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
        <circle class="box" cx="6" cy="6" r="5.5" [attr.fill]="backColor" [attr.stroke]="borderColor" />
        <circle *ngIf="state" class="check" cx="6" cy="6" r="2.5" [attr.fill]="checkColor" />
      </svg>
      <div class="other-option-container" [style.maxWidth]="'calc(100% - 17px)'" [style]="textStyle">
        <span *ngIf="element?.prefix?.length > 0">
          {{ element?.prefix }}
        </span>
        <input
          type="text"
          [style.background-color]="backColor"
          [style.border-color]="borderColor"
          [style.maxWidth]="'100%'"
          [ngModel]="text"
          [tabIndex]="-1"
          (input)="getContent($event.target.value)"
          [style]="textStyle"
          (focus)="checkOption()"
          (blur)="isCurrentOption = false"
        />
        <span *ngIf="element?.suffix?.length > 0" [style.margin-left.px]="3">
          {{ element?.suffix }}
        </span>
      </div>
      <!-- <span
        for="{{ id }}"
        [attr.contenteditable]="true"
        [style.flex]="1"
        class="custom-option"
        [textContent]="text"
        [style.background-color]="backColor"
        [style.border-color]="borderColor"
        [style.-webkit-user-select]="isSafari ? 'text' : ''"
        (input)="!isMozila && !isSafari ? getContent($event.target.textContent) : ''"
        (blur)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keyup.enter)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keypress)="disableEnter($event)"
        [style]="textStyle"
        >{{ text }}</span
      > -->
    </div>
  `, isInline: true, styles: [".other-option-container{display:flex}.other-option-container span{align-self:center}input[type=radio]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=radio]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=radio]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}input[type=text]{margin-left:5px;width:100%;outline:none;border:1px solid lightgray;padding:3px 5px}label,span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-radio{width:100%;position:relative;align-items:center;display:flex}.custom-radio input[type=radio],.other input[type=radio]{position:absolute;width:14px;z-index:10;opacity:0;margin:0}.custom-option{border:1px solid lightgray;padding:3px 5px;z-index:11;white-space:nowrap;outline:none;overflow:hidden;scroll-behavior:smooth}.custom-option:hover{border-color:#a3bde3;cursor:text}.custom-option:focus{border-color:#a3bde3}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "directive", type: i5.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSvgRadiobuttonComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-svg-radiobutton-component", template: `
    <div
      class="custom-radio"
      *ngIf="!useCustomOption"
      (mousedown)="disableDrag($event)"
      (mouseup)="this.model.canDrag = true"
    >
      <input
        type="radio"
        name="radio +{{ element.name }}"
        id="{{ id }}"
        value=""
        [tabIndex]="tabIndex"
        [disabled]="element?.readOnly ? true : false"
        [required]="element?.required"
        [stiTooltip]="element?.tooltip"
        (click)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
        <circle
          class="box"
          cx="6"
          cy="6"
          r="5.5"
          [attr.fill]="backColor"
          [attr.stroke]="needToFill ? 'red' : borderColor"
        />
        <circle *ngIf="state" class="check" cx="6" cy="6" r="2.5" [attr.fill]="checkColor" />
      </svg>
      <sti-editable-content-component
        [style.display]="'flex'"
        [style.margin-left]="'5px'"
        [style.overflow]="'hidden'"
        [style.maxWidth]="'calc(100% - 17px)'"
        [eParent]="element"
        [editableContent]="text"
        [hideEmpty]="false"
        [active]="selected"
      ></sti-editable-content-component>
    </div>
    <div
      class="custom-radio other"
      *ngIf="useCustomOption"
      [style.width]="'100%'"
      [style.align-items]="'center'"
      (mousedown)="disableDrag($event)"
      (mouseup)="this.model.canDrag = true"
    >
      <input
        type="radio"
        name="radio +{{ element.name }}"
        id="{{ id }}"
        value=""
        [disabled]="element?.readOnly ? true : false"
        [required]="element?.required"
        [stiTooltip]="element?.tooltip"
        (mousedown)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
        <circle class="box" cx="6" cy="6" r="5.5" [attr.fill]="backColor" [attr.stroke]="borderColor" />
        <circle *ngIf="state" class="check" cx="6" cy="6" r="2.5" [attr.fill]="checkColor" />
      </svg>
      <div class="other-option-container" [style.maxWidth]="'calc(100% - 17px)'" [style]="textStyle">
        <span *ngIf="element?.prefix?.length > 0">
          {{ element?.prefix }}
        </span>
        <input
          type="text"
          [style.background-color]="backColor"
          [style.border-color]="borderColor"
          [style.maxWidth]="'100%'"
          [ngModel]="text"
          [tabIndex]="-1"
          (input)="getContent($event.target.value)"
          [style]="textStyle"
          (focus)="checkOption()"
          (blur)="isCurrentOption = false"
        />
        <span *ngIf="element?.suffix?.length > 0" [style.margin-left.px]="3">
          {{ element?.suffix }}
        </span>
      </div>
      <!-- <span
        for="{{ id }}"
        [attr.contenteditable]="true"
        [style.flex]="1"
        class="custom-option"
        [textContent]="text"
        [style.background-color]="backColor"
        [style.border-color]="borderColor"
        [style.-webkit-user-select]="isSafari ? 'text' : ''"
        (input)="!isMozila && !isSafari ? getContent($event.target.textContent) : ''"
        (blur)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keyup.enter)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keypress)="disableEnter($event)"
        [style]="textStyle"
        >{{ text }}</span
      > -->
    </div>
  `, styles: [".other-option-container{display:flex}.other-option-container span{align-self:center}input[type=radio]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=radio]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=radio]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}input[type=text]{margin-left:5px;width:100%;outline:none;border:1px solid lightgray;padding:3px 5px}label,span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-radio{width:100%;position:relative;align-items:center;display:flex}.custom-radio input[type=radio],.other input[type=radio]{position:absolute;width:14px;z-index:10;opacity:0;margin:0}.custom-option{border:1px solid lightgray;padding:3px 5px;z-index:11;white-space:nowrap;outline:none;overflow:hidden;scroll-behavior:smooth}.custom-option:hover{border-color:#a3bde3;cursor:text}.custom-option:focus{border-color:#a3bde3}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { element: [{
                type: Input
            }], id: [{
                type: Input
            }], text: [{
                type: Input
            }], state: [{
                type: Input
            }], useCustomOption: [{
                type: Input
            }], buttonClick: [{
                type: Output
            }], tabIndex: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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