import { Component, EventEmitter, Input, Output } from "@angular/core";
import { StiCheckBoxElement } from "../../elements/StiCheckBoxElement";
import { StiMultipleSelectionElement } from "../../elements/StiMultipleSelectionElement";
import { StiDateTimeBoxElement } from "../../elements/StiDateTimeBoxElement";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "../sti-editable-content.component";
import * as i5 from "../sti-tooltip/sti-tooltip.directive";
export class StiSvgCheckBoxComponent {
    constructor(model) {
        this.model = model;
        this.useCustomOption = false;
        this.disablePlaceHolder = false;
        this.buttonClick = new EventEmitter();
        this.isCurrentOption = false;
    }
    get selected() {
        return this.model.selectedComponent?.element == this.element;
    }
    get isMozila() {
        return this.model.getBrowserType() == "firefox" ? true : false;
    }
    get isSafari() {
        return this.model.getBrowserType() == "safari" ? true : false;
    }
    get isCheckBox() {
        return this.element instanceof StiCheckBoxElement;
    }
    get backColor() {
        return this.element.backgroundColor.toHtmlColor();
    }
    get checkColor() {
        if (this.element instanceof StiCheckBoxElement) {
            return this.element?.checkColor.toHtmlColor();
        }
        else if (this.element instanceof StiMultipleSelectionElement) {
            return this.element?.checkColor.toHtmlColor();
        }
        else if (this.element instanceof StiDateTimeBoxElement) {
            return "black";
        }
    }
    get borderColor() {
        return this.element.borderColor.toHtmlColor();
    }
    get required() {
        return this.element["required"];
    }
    get tooltip() {
        return this.element instanceof StiDateTimeBoxElement ? "" : this.element["tooltip"];
    }
    get textStyle() {
        if (this.element instanceof StiCheckBoxElement) {
            return this.element?.text.htmlStyle();
        }
        else if (this.element instanceof StiMultipleSelectionElement) {
            return this.element?.htmlStyle();
        }
    }
    get needToFill() {
        return (this.element.required &&
            (!this.element.value || this.element.value.length == 0) &&
            this.model.hasEmptyReuiredFields);
    }
    setContent(innerText) {
        this.text = innerText;
    }
    disableDrag(event) {
        this.model.canDrag = false;
    }
    changeState() {
        this.buttonClick.emit();
    }
    getContent(innerText) {
        if (this.isCurrentOption) {
            this.element.selectedOptions?.forEach((option) => {
                if (this.element.options?.indexOf(option) == -1) {
                    this.element.selectedOptions?.splice(this.element.selectedOptions.indexOf(option), 1);
                }
            });
            this.element.selectedOptions.push(innerText);
        }
        this.element["customOptionText"] = innerText;
    }
    getCharCode(event) {
        return null === event.which ? event.keyCode : !(0 === event.which || 0 === event.charCode) ? event.which : -1;
    }
    disableEnter(event) {
        if (13 === this.getCharCode(event))
            event.preventDefault();
    }
    checkOption() {
        if (this.element.selectedOptions.indexOf(this.element?.customOptionText) >= 0) {
            this.isCurrentOption = true;
        }
    }
    ngOnInit() { }
}
StiSvgCheckBoxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSvgCheckBoxComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiSvgCheckBoxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiSvgCheckBoxComponent, selector: "sti-svg-checkbox-component", inputs: { element: "element", id: "id", text: "text", state: "state", useCustomOption: "useCustomOption", disablePlaceHolder: "disablePlaceHolder", tabIndex: "tabIndex" }, outputs: { buttonClick: "buttonClick" }, ngImport: i0, template: `
    <div
      class="custom-checkbox"
      *ngIf="!useCustomOption"
      (mousedown)="disableDrag($event)"
      (mouseup)="model.canDrag = true"
    >
      <input
        type="checkbox"
        name=""
        id="{{ id }}"
        [disabled]="element?.readOnly ? true : false"
        [required]="required"
        [stiTooltip]="tooltip"
        [tabIndex]="tabIndex"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 18 16" fill="none">
        <rect
          class="box"
          x="0.5"
          y="15.5"
          width="16"
          height="16"
          transform="rotate(-90 0.5 15.5)"
          [attr.fill]="backColor"
          [attr.stroke]="needToFill ? 'red' : borderColor"
        />
        <path
          *ngIf="state"
          class="check"
          d="M5 7.23529L8.15 12L14 3"
          attr.stroke="{{ checkColor }}"
          fill="transparent"
          stroke-width="2"
          stroke-linecap="round"
          stroke-linejoin="round"
        />
      </svg>

      <sti-editable-content-component
        [style.display]="'flex'"
        [style.margin-left]="'5px'"
        [style.overflow]="'hidden'"
        [style.maxWidth]="'calc(100% - 19px)'"
        [eParent]="element"
        [editableContent]="text"
        [hideEmpty]="disablePlaceHolder"
        [active]="selected"
      ></sti-editable-content-component>
    </div>
    <div
      class="custom-checkbox other"
      *ngIf="useCustomOption"
      [style.width]="'100%'"
      [style.align-items]="'center'"
      (mousedown)="disableDrag($event)"
      (mouseup)="model.canDrag = true"
    >
      <input
        type="checkbox"
        name=""
        id="{{ id }}"
        [disabled]="element?.readOnly ? true : false"
        [required]="required"
        [stiTooltip]="tooltip"
        tooltipPosition="bottom"
        [tabIndex]="tabIndex"
        showDelay="500"
        (mousedown)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 18 16" fill="none">
        <rect
          class="box"
          x="0.5"
          y="15.5"
          width="16"
          height="16"
          transform="rotate(-90 0.5 15.5)"
          [attr.fill]="backColor"
          [attr.stroke]="borderColor"
        />
        <path
          *ngIf="state"
          class="check"
          d="M5 7.23529L8.15 12L14 3"
          attr.stroke="{{ checkColor }}"
          fill="transparent"
          stroke-width="2"
          stroke-linecap="round"
          stroke-linejoin="round"
        />
      </svg>
      <div class="other-option-container" [style.maxWidth]="'calc(100% - 19px)'" [style]="textStyle">
        <span *ngIf="element?.prefix?.length > 0">
          {{ element?.prefix }}
        </span>
        <input
          type="text"
          [style.background-color]="backColor"
          [style.border-color]="borderColor"
          [style.maxWidth]="'100%'"
          [ngModel]="text"
          [tabIndex]="-1"
          (input)="getContent($event.target.value)"
          (focus)="checkOption()"
          (blur)="isCurrentOption = false"
        />
        <span *ngIf="element?.suffix?.length > 0" [style.margin-left.px]="3">
          {{ element?.suffix }}
        </span>
      </div>

      <!--  <span
        for="{{ id }}"
        [attr.contenteditable]="true"
        [style.flex]="1"
        class="custom-option"
        [textContent]="text"
        [style.background-color]="backColor"
        [style.border-color]="borderColor"
        [style.-webkit-user-select]="isSafari ? 'text' : ''"
        (input)="!isMozila && !isSafari ? getContent($event.target.textContent) : ''"
        (blur)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keyup.enter)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keypress)="disableEnter($event)"
        [style]="textStyle"
        >{{ text }}</span
      > -->
    </div>
  `, isInline: true, styles: [".other-option-container{display:flex}.other-option-container span{align-self:center}input[type=checkbox]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=checkbox]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=checkbox]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}input[type=text]{margin-left:5px;width:100%;outline:none;border:1px solid lightgray;padding:3px 5px}label{margin-left:5px;white-space:nowrap;outline:none;overflow:hidden;scroll-behavior:smooth}label:hover{cursor:text}span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-checkbox{align-items:center;width:100%;position:relative;display:flex}.custom-checkbox input[type=checkbox],.other input[type=checkbox]{position:absolute;width:14px;z-index:10;opacity:0;margin:0}.custom-option{border:1px solid lightgray;padding:3px 5px;z-index:100;white-space:nowrap;outline:none;overflow:hidden;scroll-behavior:smooth}.custom-option:hover{border-color:#a3bde3;cursor:text}.custom-option:focus{border-color:#a3bde3}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "directive", type: i5.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSvgCheckBoxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-svg-checkbox-component", template: `
    <div
      class="custom-checkbox"
      *ngIf="!useCustomOption"
      (mousedown)="disableDrag($event)"
      (mouseup)="model.canDrag = true"
    >
      <input
        type="checkbox"
        name=""
        id="{{ id }}"
        [disabled]="element?.readOnly ? true : false"
        [required]="required"
        [stiTooltip]="tooltip"
        [tabIndex]="tabIndex"
        tooltipPosition="bottom"
        showDelay="500"
        (click)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 18 16" fill="none">
        <rect
          class="box"
          x="0.5"
          y="15.5"
          width="16"
          height="16"
          transform="rotate(-90 0.5 15.5)"
          [attr.fill]="backColor"
          [attr.stroke]="needToFill ? 'red' : borderColor"
        />
        <path
          *ngIf="state"
          class="check"
          d="M5 7.23529L8.15 12L14 3"
          attr.stroke="{{ checkColor }}"
          fill="transparent"
          stroke-width="2"
          stroke-linecap="round"
          stroke-linejoin="round"
        />
      </svg>

      <sti-editable-content-component
        [style.display]="'flex'"
        [style.margin-left]="'5px'"
        [style.overflow]="'hidden'"
        [style.maxWidth]="'calc(100% - 19px)'"
        [eParent]="element"
        [editableContent]="text"
        [hideEmpty]="disablePlaceHolder"
        [active]="selected"
      ></sti-editable-content-component>
    </div>
    <div
      class="custom-checkbox other"
      *ngIf="useCustomOption"
      [style.width]="'100%'"
      [style.align-items]="'center'"
      (mousedown)="disableDrag($event)"
      (mouseup)="model.canDrag = true"
    >
      <input
        type="checkbox"
        name=""
        id="{{ id }}"
        [disabled]="element?.readOnly ? true : false"
        [required]="required"
        [stiTooltip]="tooltip"
        tooltipPosition="bottom"
        [tabIndex]="tabIndex"
        showDelay="500"
        (mousedown)="changeState()"
      />
      <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 18 16" fill="none">
        <rect
          class="box"
          x="0.5"
          y="15.5"
          width="16"
          height="16"
          transform="rotate(-90 0.5 15.5)"
          [attr.fill]="backColor"
          [attr.stroke]="borderColor"
        />
        <path
          *ngIf="state"
          class="check"
          d="M5 7.23529L8.15 12L14 3"
          attr.stroke="{{ checkColor }}"
          fill="transparent"
          stroke-width="2"
          stroke-linecap="round"
          stroke-linejoin="round"
        />
      </svg>
      <div class="other-option-container" [style.maxWidth]="'calc(100% - 19px)'" [style]="textStyle">
        <span *ngIf="element?.prefix?.length > 0">
          {{ element?.prefix }}
        </span>
        <input
          type="text"
          [style.background-color]="backColor"
          [style.border-color]="borderColor"
          [style.maxWidth]="'100%'"
          [ngModel]="text"
          [tabIndex]="-1"
          (input)="getContent($event.target.value)"
          (focus)="checkOption()"
          (blur)="isCurrentOption = false"
        />
        <span *ngIf="element?.suffix?.length > 0" [style.margin-left.px]="3">
          {{ element?.suffix }}
        </span>
      </div>

      <!--  <span
        for="{{ id }}"
        [attr.contenteditable]="true"
        [style.flex]="1"
        class="custom-option"
        [textContent]="text"
        [style.background-color]="backColor"
        [style.border-color]="borderColor"
        [style.-webkit-user-select]="isSafari ? 'text' : ''"
        (input)="!isMozila && !isSafari ? getContent($event.target.textContent) : ''"
        (blur)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keyup.enter)="isMozila || isSafari ? getContent($event.target.textContent) : ''"
        (keypress)="disableEnter($event)"
        [style]="textStyle"
        >{{ text }}</span
      > -->
    </div>
  `, styles: [".other-option-container{display:flex}.other-option-container span{align-self:center}input[type=checkbox]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=checkbox]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=checkbox]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}input[type=text]{margin-left:5px;width:100%;outline:none;border:1px solid lightgray;padding:3px 5px}label{margin-left:5px;white-space:nowrap;outline:none;overflow:hidden;scroll-behavior:smooth}label:hover{cursor:text}span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-checkbox{align-items:center;width:100%;position:relative;display:flex}.custom-checkbox input[type=checkbox],.other input[type=checkbox]{position:absolute;width:14px;z-index:10;opacity:0;margin:0}.custom-option{border:1px solid lightgray;padding:3px 5px;z-index:100;white-space:nowrap;outline:none;overflow:hidden;scroll-behavior:smooth}.custom-option:hover{border-color:#a3bde3;cursor:text}.custom-option:focus{border-color:#a3bde3}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { element: [{
                type: Input
            }], id: [{
                type: Input
            }], text: [{
                type: Input
            }], state: [{
                type: Input
            }], useCustomOption: [{
                type: Input
            }], disablePlaceHolder: [{
                type: Input
            }], buttonClick: [{
                type: Output
            }], tabIndex: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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