import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/http-client.service";
import * as i3 from "../services/sti-user-service";
import * as i4 from "../services/sti-localization.service";
import * as i5 from "@angular/common";
export class StiUserInfoComponent {
    constructor(model, httpService, userService, loc) {
        this.model = model;
        this.httpService = httpService;
        this.userService = userService;
        this.loc = loc;
    }
    get userInfo() {
        return { name: "My1 Company", mail: "Stimulsoft130@gmail.com" };
    }
    setEvent(event) {
        if (event == "Logout") {
            this.httpService.post("", { action: "InterfaceEvent", event: "LogoutButtonClick" }).subscribe(() => {
                if (!this.model.isWebView) {
                    this.model.userIsAuthorized = false;
                    this.userService.licenseProducts = [];
                    this.userService.currentUser = "empty";
                    this.userService.checkLicense();
                }
            });
        }
        else if (event == "Account") {
            this.httpService.post("", { action: "InterfaceEvent", event: "AccountButtonClick" }).subscribe(() => { });
        }
        else if (event == "Cloud") {
            this.httpService.post("", { action: "InterfaceEvent", event: "CloudButtonClick" }).subscribe(() => { });
        }
        this.userService.showUserInfo = false;
    }
    ngOnInit() { }
}
StiUserInfoComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiUserInfoComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiHttpClientService }, { token: i3.StiUserService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiUserInfoComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiUserInfoComponent, selector: "sti-user-info", ngImport: i0, template: `
    <div
      class="parent-user-info-container"
      [style.visibility]="userService.showUserInfo ? 'visible' : 'hidden'"
      [style.left.px]="userService.previewX"
      [style.top.px]="userService.previewY"
      [style.width.px]="350"
    >
      <div class="user-info">
        <div class="user-image">
          <img
            [style.width.px]="82"
            [style.height.px]="82"
            *ngIf="userService?.currentUser?.picture"
            src="data:image/jpeg;base64,{{ userService?.currentUser?.picture }}"
            alt=""
          />
          <div
            *ngIf="!userService?.currentUser?.picture"
            class="custom-image"
            [style.background-color]="userService.getBackground(userService.currentUser)"
          >
            <span [style.margin-top.px]="11">{{
              userService.currentUser
                ? (userService.currentUser.firstName ? userService.currentUser.firstName[0] : "") +
                  (userService.currentUser.lastName ? userService.currentUser.lastName[0] : "")
                : "MC"
            }}</span>
          </div>
        </div>
        <div class="info">
          <span [style.font-size.px]="18" [style.font-weight]="'bold'">{{
            userService.currentUser
              ? (userService.currentUser.firstName ? userService.currentUser.firstName : "") +
                " " +
                (userService.currentUser.lastName ? userService.currentUser.lastName : "")
              : "My1 Company"
          }}</span>
          <span>{{
            userService.currentUser
              ? userService.currentUser.userName
                ? userService.currentUser.userName
                : ""
              : userInfo.mail
          }}</span>
          <span class="link" (click)="setEvent('Cloud')">{{ loc.get2("Cloud", "Cloud") }}</span>
          <span class="link" (click)="setEvent('Account')">{{ loc.get2("Cloud", "Account") }}</span>
        </div>
      </div>
      <div class="logout">
        <div class="logout-button" (click)="setEvent('Logout')">
          <span>{{ loc.get2("Cloud", "ButtonLogout") }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".parent-user-info-container{position:absolute;z-index:999;background-color:var(--back-color);-webkit-touch-callout:none;-webkit-user-select:none;height:max-content;padding:1px;border:1px solid #c6c6c6;border-radius:3px;overflow:hidden;font-family:Segoe UI;box-shadow:0 0 7px #0000004d}.user-info{height:100%;width:100%;display:flex;overflow:hidden}.info{display:flex;flex-direction:column;font-size:13px;align-items:start;justify-content:center}.info span{margin:3px}.user-image{padding:15px}.user-image img{border-radius:40px}.logout{width:100%;height:60px;display:flex;justify-content:flex-end;align-items:flex-end;padding:10px}.logout-button{height:24px;min-width:60px;background-color:#3d6bba;display:flex;align-items:center;justify-content:center;font-size:13px;padding:0 10px;color:#fff}.logout-button:hover{background-color:#4377d0}.link{color:#5a83ad;border-bottom:1px solid transparent}.link:hover{border-color:#5a83ad}span{width:max-content}.custom-image{height:82px;width:82px;border-radius:40px;margin:0 5px;color:#fff;font-size:42px;display:flex;justify-content:center}\n"], dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiUserInfoComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-user-info", template: `
    <div
      class="parent-user-info-container"
      [style.visibility]="userService.showUserInfo ? 'visible' : 'hidden'"
      [style.left.px]="userService.previewX"
      [style.top.px]="userService.previewY"
      [style.width.px]="350"
    >
      <div class="user-info">
        <div class="user-image">
          <img
            [style.width.px]="82"
            [style.height.px]="82"
            *ngIf="userService?.currentUser?.picture"
            src="data:image/jpeg;base64,{{ userService?.currentUser?.picture }}"
            alt=""
          />
          <div
            *ngIf="!userService?.currentUser?.picture"
            class="custom-image"
            [style.background-color]="userService.getBackground(userService.currentUser)"
          >
            <span [style.margin-top.px]="11">{{
              userService.currentUser
                ? (userService.currentUser.firstName ? userService.currentUser.firstName[0] : "") +
                  (userService.currentUser.lastName ? userService.currentUser.lastName[0] : "")
                : "MC"
            }}</span>
          </div>
        </div>
        <div class="info">
          <span [style.font-size.px]="18" [style.font-weight]="'bold'">{{
            userService.currentUser
              ? (userService.currentUser.firstName ? userService.currentUser.firstName : "") +
                " " +
                (userService.currentUser.lastName ? userService.currentUser.lastName : "")
              : "My1 Company"
          }}</span>
          <span>{{
            userService.currentUser
              ? userService.currentUser.userName
                ? userService.currentUser.userName
                : ""
              : userInfo.mail
          }}</span>
          <span class="link" (click)="setEvent('Cloud')">{{ loc.get2("Cloud", "Cloud") }}</span>
          <span class="link" (click)="setEvent('Account')">{{ loc.get2("Cloud", "Account") }}</span>
        </div>
      </div>
      <div class="logout">
        <div class="logout-button" (click)="setEvent('Logout')">
          <span>{{ loc.get2("Cloud", "ButtonLogout") }}</span>
        </div>
      </div>
    </div>
  `, styles: [".parent-user-info-container{position:absolute;z-index:999;background-color:var(--back-color);-webkit-touch-callout:none;-webkit-user-select:none;height:max-content;padding:1px;border:1px solid #c6c6c6;border-radius:3px;overflow:hidden;font-family:Segoe UI;box-shadow:0 0 7px #0000004d}.user-info{height:100%;width:100%;display:flex;overflow:hidden}.info{display:flex;flex-direction:column;font-size:13px;align-items:start;justify-content:center}.info span{margin:3px}.user-image{padding:15px}.user-image img{border-radius:40px}.logout{width:100%;height:60px;display:flex;justify-content:flex-end;align-items:flex-end;padding:10px}.logout-button{height:24px;min-width:60px;background-color:#3d6bba;display:flex;align-items:center;justify-content:center;font-size:13px;padding:0 10px;color:#fff}.logout-button:hover{background-color:#4377d0}.link{color:#5a83ad;border-bottom:1px solid transparent}.link:hover{border-color:#5a83ad}span{width:max-content}.custom-image{height:82px;width:82px;border-radius:40px;margin:0 5px;color:#fff;font-size:42px;display:flex;justify-content:center}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHttpClientService }, { type: i3.StiUserService }, { type: i4.StiLocalizationService }]; } });
//# sourceMappingURL=data:application/json;base64,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