import { Component } from "@angular/core";
import StiJson from "../../system/StiJson";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-localization.service";
import * as i3 from "../../services/sti-user-service";
export class StiTrialTimerWindowComponent {
    constructor(model, loc, userService) {
        this.model = model;
        this.loc = loc;
        this.userService = userService;
    }
    isRusLocalization() {
        if (this.loc.currentLocalization?.cultureName?.toLowerCase() == "ru") {
            return true;
        }
        else {
            return false;
        }
    }
    upgradeClick() {
        window.open("https://www.stimulsoft.com/en/online-store#embedded/forms/web", "_blank");
    }
    getRemainingDays() {
        let user = this.userService?.currentUser;
        if (!user || user?.days <= 0) {
            return "0";
        }
        let today = new Date();
        let created = StiJson.jsonDateFormatToDate(user.created)?.date;
        let oneDay = 24 * 60 * 60 * 1000;
        let differenceInTime = today.getTime() - created.getTime();
        let diffDays = user?.days - differenceInTime / oneDay;
        return diffDays.toString();
    }
    ngOnInit() { }
}
StiTrialTimerWindowComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTrialTimerWindowComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiUserService }], target: i0.ɵɵFactoryTarget.Component });
StiTrialTimerWindowComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTrialTimerWindowComponent, selector: "sti-trial-timer-window", ngImport: i0, template: `<div class="trial-timer-window">
    <div class="trial-timer-window-navbar">
      <span [style.flex]="1">{{ loc.get2("Permissions", "ItemForms") }}</span>
      <div
        class="close-button {{ getRemainingDays() == '0' ? 'disabled' : '' }}"
        (click)="model.showTrialTimerWindow = false"
      >
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
      </div>
    </div>
    <div class="trial-timer-window-content">
      <div class="trial-timer-window-interface">
        <div class="trial-timer-image">
          <img
            [style.width.px]="isRusLocalization() ? 239 : 197"
            [src]="
              isRusLocalization()
                ? model.getImage('images.Other.TrialDaysLeft_Ru.png')
                : model.getImage('images.Other.TrialDaysLeft_En.png')
            "
          />
          <div
            class="timer-remaining-days"
            [style.left]="isRusLocalization() ? 'calc(50% - 93px)' : 'calc(50% - 72px)'"
          >
            {{ getRemainingDays() }}
          </div>
        </div>
        <div class="trial-timer-warnings">
          <span class="blue description">{{
            loc.get2("Notices", "YourTrialWillExpire").replace("{0}", getRemainingDays())
          }}</span>
          <span class="lightgray description">{{ loc.get2("Notices", "ActivationTrialExpired") }}</span>
        </div>
      </div>
      <div class="trial-timer-window-navigation">
        <div
          class="button gray {{ getRemainingDays() == '0' ? 'disabled' : '' }}"
          (click)="model.showTrialTimerWindow = false"
        >
          <span>{{ "Continue" }}</span>
        </div>
        <div class="button navy" (click)="upgradeClick()">
          <span>{{ "Upgrade" }}</span>
        </div>
      </div>
    </div>
  </div>`, isInline: true, styles: [".disabled{opacity:.5;pointer-events:none}.gray{background:#dddddd;border:1px solid #dddddd;color:#444}.gray:hover{background:#d5d5d5;border:1px solid #d5d5d5}.navy{background:#19478a;border:1px solid #19478a;color:#fff}.navy:hover{background:#3b629b;border:1px solid #3b629b}.trial-timer-window-navigation{display:flex;align-items:center;justify-content:center;margin-top:10px}.button{width:150px;height:32px;font-size:14px;font-family:Arial;display:flex;align-items:center;justify-content:center;margin:10px;border-radius:3px;-webkit-user-select:none}.blue{font-size:16px;color:#19478a}.lightgray{font-size:14px;color:#888}.trial-timer-warnings{display:flex;flex-direction:column;justify-content:center;align-items:center}.description{padding:10px 25px;font-family:Arial}.timer-remaining-days{position:absolute;display:inline-block;color:#76a797;font-family:Arial;font-size:30px;text-align:center;width:50px;top:calc(50% - 13px);left:calc(50% - 72px)}.trial-timer-window-interface{display:flex;flex-direction:column;justify-content:center;align-items:center}.trial-timer-image{position:relative;margin-top:20px}.trial-timer-image img{height:112px;width:197px}.trial-timer-window{background-color:var(--back-color);position:absolute;left:calc(50% - 275px);top:calc(50% - 176px);z-index:999;width:550px;height:352px;overflow:hidden;box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);color:var(--text-color);font-size:13px;border-radius:5px;font-family:Arial;-webkit-user-select:none}.trial-timer-window-navbar{display:flex;height:30px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none;color:#fff;align-items:center}.trial-timer-window-navbar span{font-size:13px}.close-button{height:30px;width:30px;border-radius:3px;display:flex;align-items:center;justify-content:center}span{margin-left:5px;font-size:12px}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTrialTimerWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-trial-timer-window", template: `<div class="trial-timer-window">
    <div class="trial-timer-window-navbar">
      <span [style.flex]="1">{{ loc.get2("Permissions", "ItemForms") }}</span>
      <div
        class="close-button {{ getRemainingDays() == '0' ? 'disabled' : '' }}"
        (click)="model.showTrialTimerWindow = false"
      >
        <img [src]="model.getImage('images.Other.CloseForm.png')" />
      </div>
    </div>
    <div class="trial-timer-window-content">
      <div class="trial-timer-window-interface">
        <div class="trial-timer-image">
          <img
            [style.width.px]="isRusLocalization() ? 239 : 197"
            [src]="
              isRusLocalization()
                ? model.getImage('images.Other.TrialDaysLeft_Ru.png')
                : model.getImage('images.Other.TrialDaysLeft_En.png')
            "
          />
          <div
            class="timer-remaining-days"
            [style.left]="isRusLocalization() ? 'calc(50% - 93px)' : 'calc(50% - 72px)'"
          >
            {{ getRemainingDays() }}
          </div>
        </div>
        <div class="trial-timer-warnings">
          <span class="blue description">{{
            loc.get2("Notices", "YourTrialWillExpire").replace("{0}", getRemainingDays())
          }}</span>
          <span class="lightgray description">{{ loc.get2("Notices", "ActivationTrialExpired") }}</span>
        </div>
      </div>
      <div class="trial-timer-window-navigation">
        <div
          class="button gray {{ getRemainingDays() == '0' ? 'disabled' : '' }}"
          (click)="model.showTrialTimerWindow = false"
        >
          <span>{{ "Continue" }}</span>
        </div>
        <div class="button navy" (click)="upgradeClick()">
          <span>{{ "Upgrade" }}</span>
        </div>
      </div>
    </div>
  </div>`, styles: [".disabled{opacity:.5;pointer-events:none}.gray{background:#dddddd;border:1px solid #dddddd;color:#444}.gray:hover{background:#d5d5d5;border:1px solid #d5d5d5}.navy{background:#19478a;border:1px solid #19478a;color:#fff}.navy:hover{background:#3b629b;border:1px solid #3b629b}.trial-timer-window-navigation{display:flex;align-items:center;justify-content:center;margin-top:10px}.button{width:150px;height:32px;font-size:14px;font-family:Arial;display:flex;align-items:center;justify-content:center;margin:10px;border-radius:3px;-webkit-user-select:none}.blue{font-size:16px;color:#19478a}.lightgray{font-size:14px;color:#888}.trial-timer-warnings{display:flex;flex-direction:column;justify-content:center;align-items:center}.description{padding:10px 25px;font-family:Arial}.timer-remaining-days{position:absolute;display:inline-block;color:#76a797;font-family:Arial;font-size:30px;text-align:center;width:50px;top:calc(50% - 13px);left:calc(50% - 72px)}.trial-timer-window-interface{display:flex;flex-direction:column;justify-content:center;align-items:center}.trial-timer-image{position:relative;margin-top:20px}.trial-timer-image img{height:112px;width:197px}.trial-timer-window{background-color:var(--back-color);position:absolute;left:calc(50% - 275px);top:calc(50% - 176px);z-index:999;width:550px;height:352px;overflow:hidden;box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);color:var(--text-color);font-size:13px;border-radius:5px;font-family:Arial;-webkit-user-select:none}.trial-timer-window-navbar{display:flex;height:30px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none;color:#fff;align-items:center}.trial-timer-window-navbar span{font-size:13px}.close-button{height:30px;width:30px;border-radius:3px;display:flex;align-items:center;justify-content:center}span{margin-left:5px;font-size:12px}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiUserService }]; } });
//# sourceMappingURL=data:application/json;base64,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