import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/sti-localization.service";
import * as i2 from "../../services/model.service";
import * as i3 from "../../services/sti-user-service";
import * as i4 from "../../services/http-client.service";
export class StiTrialModalWindowComponent {
    constructor(loc, model, userService, httpService) {
        this.loc = loc;
        this.model = model;
        this.userService = userService;
        this.httpService = httpService;
    }
    upgradeClick() {
        if (this.model.canCloseTrialWindow) {
            this.model.showTrialModalWindow = !this.model.showTrialModalWindow;
        }
        else {
            if (this.model.isWebView) {
                this.httpService
                    .post("", {
                    action: "InterfaceEvent",
                    event: "ExpiredTrialButtonClick",
                    data: { message: this.userService.trialMessage },
                })
                    .subscribe(() => { });
            }
            else {
                window.location.href = "https://www.stimulsoft.com/en/online-store#embedded/forms/ultimate";
            }
        }
    }
    ngOnInit() { }
}
StiTrialModalWindowComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTrialModalWindowComponent, deps: [{ token: i1.StiLocalizationService }, { token: i2.StiModelService }, { token: i3.StiUserService }, { token: i4.StiHttpClientService }], target: i0.ɵɵFactoryTarget.Component });
StiTrialModalWindowComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTrialModalWindowComponent, selector: "sti-trial-modal-window", ngImport: i0, template: `
    <div class="trial-modal">
      <div class="trial-navigation">
        <div class="designer-info">
          <span>{{ loc.getP("Designer") }}</span>
        </div>
        <div class="close-button" (click)="upgradeClick()">
          <i class="pi pi-times"></i>
        </div>
      </div>
      <div class="trial-info">
        <div class="trial-image">
          <img class="warning-image" [src]="model.getImage('images.Other.Warning.png')" alt="" />
        </div>
        <div class="trial-alert">
          <span>{{ loc.getP(userService.trialMessage) }}</span>
        </div>
      </div>
      <div class="close-container">
        <div class="agree-button" (click)="upgradeClick()">
          <span>{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".pi{font-size:.825rem;color:var(--text-color)}.trial-modal{cursor:default;z-index:9999;width:550px;height:290px;position:absolute;left:calc(50% - 225px);top:calc(50% - 145px);display:flex;flex-direction:column;border:1px solid rgb(28,71,134);background-color:#fff;box-shadow:0 0 7px #0000004d}.trial-navigation{width:100%;height:31px;display:flex}.designer-info{padding-left:15px;width:100%;height:100%;display:flex;align-items:center;justify-content:start}.designer-info span{font-size:15px;font-weight:700;color:#1c4786}.close-button{height:24px;width:28px;display:flex;align-items:center;justify-content:center}.close-button img{height:16px;width:16px}.close-button:hover{background-color:#dadada}.trial-info{height:173px;width:100%;display:flex;flex-direction:column}.trial-image{height:132px;display:flex;align-items:center;justify-content:center}.warning-image{width:112px;height:112px}.trial-alert{display:flex;align-items:center;justify-content:center;flex:1}.trial-alert span{font-size:16px;color:#1c4786}.close-container{display:flex;width:100%;justify-content:center;flex:1;padding-top:20px}.agree-button{width:200px;height:30px;display:flex;align-items:center;justify-content:center;border-radius:3px;background-color:#1c4786}.agree-button:hover{background-color:#3b629b}.agree-button span{color:#fff;font-size:14px}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTrialModalWindowComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-trial-modal-window", template: `
    <div class="trial-modal">
      <div class="trial-navigation">
        <div class="designer-info">
          <span>{{ loc.getP("Designer") }}</span>
        </div>
        <div class="close-button" (click)="upgradeClick()">
          <i class="pi pi-times"></i>
        </div>
      </div>
      <div class="trial-info">
        <div class="trial-image">
          <img class="warning-image" [src]="model.getImage('images.Other.Warning.png')" alt="" />
        </div>
        <div class="trial-alert">
          <span>{{ loc.getP(userService.trialMessage) }}</span>
        </div>
      </div>
      <div class="close-container">
        <div class="agree-button" (click)="upgradeClick()">
          <span>{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
      </div>
    </div>
  `, styles: [".pi{font-size:.825rem;color:var(--text-color)}.trial-modal{cursor:default;z-index:9999;width:550px;height:290px;position:absolute;left:calc(50% - 225px);top:calc(50% - 145px);display:flex;flex-direction:column;border:1px solid rgb(28,71,134);background-color:#fff;box-shadow:0 0 7px #0000004d}.trial-navigation{width:100%;height:31px;display:flex}.designer-info{padding-left:15px;width:100%;height:100%;display:flex;align-items:center;justify-content:start}.designer-info span{font-size:15px;font-weight:700;color:#1c4786}.close-button{height:24px;width:28px;display:flex;align-items:center;justify-content:center}.close-button img{height:16px;width:16px}.close-button:hover{background-color:#dadada}.trial-info{height:173px;width:100%;display:flex;flex-direction:column}.trial-image{height:132px;display:flex;align-items:center;justify-content:center}.warning-image{width:112px;height:112px}.trial-alert{display:flex;align-items:center;justify-content:center;flex:1}.trial-alert span{font-size:16px;color:#1c4786}.close-container{display:flex;width:100%;justify-content:center;flex:1;padding-top:20px}.agree-button{width:200px;height:30px;display:flex;align-items:center;justify-content:center;border-radius:3px;background-color:#1c4786}.agree-button:hover{background-color:#3b629b}.agree-button span{color:#fff;font-size:14px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiLocalizationService }, { type: i2.StiModelService }, { type: i3.StiUserService }, { type: i4.StiHttpClientService }]; } });
//# sourceMappingURL=data:application/json;base64,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