import { Directive, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./sti-tooltip.service";
import * as i2 from "../../services/model.service";
export class StiTooltipDirective {
    constructor(tooltipService, el, model) {
        this.tooltipService = tooltipService;
        this.el = el;
        this.model = model;
        this.active = false;
    }
    ngAfterViewInit() {
        const onMouseEnter = (event) => {
            this.active = true;
            this.tooltipService.text = this.text;
            this.tooltipService.position = this.tooltipPosition ? this.tooltipPosition : "bottom";
            this.tooltipService.delay = this.showDelay ? this.showDelay : 0;
            this.tooltipService.elementRect = this.model.getPositionRelativeToForm(this.el.nativeElement);
            if (this.text) {
                this.activate();
            }
        };
        const onClick = (event) => {
            this.deactivate();
        };
        const onMouseLeave = (event) => {
            this.deactivate();
        };
        this.el.nativeElement.addEventListener("mouseenter", onMouseEnter);
        this.el.nativeElement.addEventListener("click", onClick);
        this.el.nativeElement.addEventListener("mouseleave", onMouseLeave);
    }
    activate() {
        this.active = true;
        this.clearHideTimeout();
        if (this.showDelay) {
            this.showTimeout = setTimeout(() => {
                this.show();
            }, this.showDelay);
        }
        else {
            this.show();
        }
    }
    deactivate() {
        this.active = false;
        this.clearShowTimeout();
        this.hide();
    }
    show() {
        this.tooltipService.showTooltip = true;
    }
    hide() {
        this.tooltipService.showTooltip = false;
    }
    clearShowTimeout() {
        if (this.showTimeout) {
            clearTimeout(this.showTimeout);
            this.showTimeout = null;
        }
    }
    clearHideTimeout() {
        if (this.hideTimeout) {
            clearTimeout(this.hideTimeout);
            this.hideTimeout = null;
        }
    }
    ngOnDestroy() { }
}
StiTooltipDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTooltipDirective, deps: [{ token: i1.StiTooltipService }, { token: i0.ElementRef }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Directive });
StiTooltipDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.3.0", type: StiTooltipDirective, selector: "[stiTooltip]", inputs: { tooltipPosition: "tooltipPosition", text: ["stiTooltip", "text"], showDelay: "showDelay" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTooltipDirective, decorators: [{
            type: Directive,
            args: [{ selector: "[stiTooltip]" }]
        }], ctorParameters: function () { return [{ type: i1.StiTooltipService }, { type: i0.ElementRef }, { type: i2.StiModelService }]; }, propDecorators: { tooltipPosition: [{
                type: Input
            }], text: [{
                type: Input,
                args: ["stiTooltip"]
            }], showDelay: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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