import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./sti-tooltip.service";
import * as i2 from "../../services/model.service";
export class StiTooltipComponent {
    constructor(tooltipService, model) {
        this.tooltipService = tooltipService;
        this.model = model;
        this.initialized = false;
    }
    ngAfterViewInit() {
        setTimeout(() => {
            this.initialized = true;
        });
    }
    getTooltipArrow() {
        switch (this.tooltipService.position) {
            case "top":
                return "bottom-arrow";
            case "bottom":
                return "top-arrow";
            case "left":
                return "right-arrow";
            case "right":
                return "left-arrow";
        }
    }
    getLeft(tooltipElement) {
        let elementRect = this.model.getPositionRelativeToForm(tooltipElement);
        if (this.tooltipService.elementRect && this.initialized) {
            switch (this.tooltipService.position) {
                case "left":
                    return this.correctLeftLimits(this.tooltipService.elementRect.left - (elementRect.width + 8), elementRect);
                case "right":
                    return this.correctLeftLimits(this.tooltipService.elementRect.right + 8, elementRect);
                case "top":
                case "bottom":
                    return this.correctLeftLimits(this.tooltipService.elementRect.left + (this.tooltipService.elementRect.width / 2 - elementRect.width / 2), elementRect);
            }
        }
        else {
            return -999;
        }
    }
    getTop(tooltipElement) {
        let elementRect = this.model.getPositionRelativeToForm(tooltipElement);
        if (this.tooltipService.elementRect && this.initialized) {
            switch (this.tooltipService.position) {
                case "top":
                    return this.correctTopLimits(this.tooltipService.elementRect.top - (elementRect.height + 8), elementRect);
                case "bottom":
                    return this.correctTopLimits(this.tooltipService.elementRect.bottom + 8, elementRect);
                case "left":
                case "right":
                    return this.correctTopLimits(this.tooltipService.elementRect.top + (this.tooltipService.elementRect.height / 2 - elementRect.height / 2), elementRect);
            }
        }
        else {
            return -999;
        }
    }
    correctLeftLimits(value, tooltipRect) {
        if (value < 0) {
            return 0;
        }
        else if (value + tooltipRect.width > window.innerWidth) {
            return Math.round(window.innerWidth - tooltipRect.width).toFixed(2);
        }
        else {
            return Math.round(value).toFixed(2);
        }
    }
    correctTopLimits(value, tooltipRect) {
        if (value < 0) {
            return 0;
        }
        else if (value + tooltipRect.height > window.innerHeight) {
            return Math.round(window.innerHeight - tooltipRect.height).toFixed(2);
        }
        else {
            return Math.round(value).toFixed(2);
        }
    }
    ngOnInit() { }
}
StiTooltipComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTooltipComponent, deps: [{ token: i1.StiTooltipService }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiTooltipComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTooltipComponent, selector: "sti-tooltip", ngImport: i0, template: ` <div
    #tooltip
    class="sti-tooltip {{ getTooltipArrow() }}"
    [style.left.px]="getLeft(tooltip)"
    [style.top.px]="getTop(tooltip)"
  >
    <span>{{ tooltipService.text }}</span>
  </div>`, isInline: true, styles: [".sti-tooltip{position:absolute;background:var(--back-color);color:var(--text-color);padding:.429rem;box-shadow:0 3px 6px #00000029;border-radius:3px;z-index:99999999;white-space:pre-line}.sti-tooltip span{font-size:16px;font-family:Arial}.bottom-arrow:before,.bottom-arrow:after{content:\"\";position:absolute;left:calc(50% - 8px);bottom:-16px;border:8px solid transparent;border-top:8px solid white}.bottom-arrow:after{border-top:8px solid white;bottom:-16px}.top-arrow:before,.top-arrow:after{content:\"\";position:absolute;left:calc(50% - 8px);top:-16px;border:8px solid transparent;border-bottom:8px solid white}.top-arrow:after{border-bottom:8px solid white;top:-16px}.left-arrow:before,.left-arrow:after{content:\"\";position:absolute;left:-16px;top:calc(50% - 8px);border:8px solid transparent;border-right:8px solid white}.left-arrow:after{border-right:8px solid white;left:-16px}.right-arrow:before,.right-arrow:after{content:\"\";position:absolute;right:-16px;top:calc(50% - 8px);border:8px solid transparent;border-left:8px solid white}.right-arrow:after{border-left:8px solid white;right:-16px}\n"] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTooltipComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-tooltip", template: ` <div
    #tooltip
    class="sti-tooltip {{ getTooltipArrow() }}"
    [style.left.px]="getLeft(tooltip)"
    [style.top.px]="getTop(tooltip)"
  >
    <span>{{ tooltipService.text }}</span>
  </div>`, styles: [".sti-tooltip{position:absolute;background:var(--back-color);color:var(--text-color);padding:.429rem;box-shadow:0 3px 6px #00000029;border-radius:3px;z-index:99999999;white-space:pre-line}.sti-tooltip span{font-size:16px;font-family:Arial}.bottom-arrow:before,.bottom-arrow:after{content:\"\";position:absolute;left:calc(50% - 8px);bottom:-16px;border:8px solid transparent;border-top:8px solid white}.bottom-arrow:after{border-top:8px solid white;bottom:-16px}.top-arrow:before,.top-arrow:after{content:\"\";position:absolute;left:calc(50% - 8px);top:-16px;border:8px solid transparent;border-bottom:8px solid white}.top-arrow:after{border-bottom:8px solid white;top:-16px}.left-arrow:before,.left-arrow:after{content:\"\";position:absolute;left:-16px;top:calc(50% - 8px);border:8px solid transparent;border-right:8px solid white}.left-arrow:after{border-right:8px solid white;left:-16px}.right-arrow:before,.right-arrow:after{content:\"\";position:absolute;right:-16px;top:calc(50% - 8px);border:8px solid transparent;border-left:8px solid white}.right-arrow:after{border-left:8px solid white;right:-16px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiTooltipService }, { type: i2.StiModelService }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLXRvb2x0aXAuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL2NvbXBvbmVudHMvc3RpLXRvb2x0aXAvc3RpLXRvb2x0aXAuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBaUIsU0FBUyxFQUFVLE1BQU0sZUFBZSxDQUFDOzs7O0FBcUZqRSxNQUFNLE9BQU8sbUJBQW1CO0lBQzlCLFlBQW1CLGNBQWlDLEVBQVMsS0FBc0I7UUFBaEUsbUJBQWMsR0FBZCxjQUFjLENBQW1CO1FBQVMsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUFDNUUsZ0JBQVcsR0FBWSxLQUFLLENBQUM7SUFEa0QsQ0FBQztJQUV2RixlQUFlO1FBQ2IsVUFBVSxDQUFDLEdBQUcsRUFBRTtZQUNkLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDO1FBQzFCLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUNNLGVBQWU7UUFDcEIsUUFBUSxJQUFJLENBQUMsY0FBYyxDQUFDLFFBQVEsRUFBRTtZQUNwQyxLQUFLLEtBQUs7Z0JBQ1IsT0FBTyxjQUFjLENBQUM7WUFDeEIsS0FBSyxRQUFRO2dCQUNYLE9BQU8sV0FBVyxDQUFDO1lBQ3JCLEtBQUssTUFBTTtnQkFDVCxPQUFPLGFBQWEsQ0FBQztZQUN2QixLQUFLLE9BQU87Z0JBQ1YsT0FBTyxZQUFZLENBQUM7U0FDdkI7SUFDSCxDQUFDO0lBQ00sT0FBTyxDQUFDLGNBQWM7UUFDM0IsSUFBSSxXQUFXLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUN2RSxJQUFJLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUU7WUFDdkQsUUFBUSxJQUFJLENBQUMsY0FBYyxDQUFDLFFBQVEsRUFBRTtnQkFDcEMsS0FBSyxNQUFNO29CQUNULE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLElBQUksR0FBRyxDQUFDLFdBQVcsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDLEVBQUUsV0FBVyxDQUFDLENBQUM7Z0JBQzdHLEtBQUssT0FBTztvQkFDVixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLFdBQVcsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxFQUFFLFdBQVcsQ0FBQyxDQUFDO2dCQUN4RixLQUFLLEtBQUssQ0FBQztnQkFDWCxLQUFLLFFBQVE7b0JBQ1gsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQzNCLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLElBQUksR0FBRyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLEtBQUssR0FBRyxDQUFDLEdBQUcsV0FBVyxDQUFDLEtBQUssR0FBRyxDQUFDLENBQUMsRUFDMUcsV0FBVyxDQUNaLENBQUM7YUFDTDtTQUNGO2FBQU07WUFDTCxPQUFPLENBQUMsR0FBRyxDQUFDO1NBQ2I7SUFDSCxDQUFDO0lBQ00sTUFBTSxDQUFDLGNBQWM7UUFDMUIsSUFBSSxXQUFXLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUN2RSxJQUFJLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUU7WUFDdkQsUUFBUSxJQUFJLENBQUMsY0FBYyxDQUFDLFFBQVEsRUFBRTtnQkFDcEMsS0FBSyxLQUFLO29CQUNSLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLEdBQUcsR0FBRyxDQUFDLFdBQVcsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLEVBQUUsV0FBVyxDQUFDLENBQUM7Z0JBQzVHLEtBQUssUUFBUTtvQkFDWCxPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLFdBQVcsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLFdBQVcsQ0FBQyxDQUFDO2dCQUN4RixLQUFLLE1BQU0sQ0FBQztnQkFDWixLQUFLLE9BQU87b0JBQ1YsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQzFCLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLEdBQUcsR0FBRyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLE1BQU0sR0FBRyxDQUFDLEdBQUcsV0FBVyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsRUFDM0csV0FBVyxDQUNaLENBQUM7YUFDTDtTQUNGO2FBQU07WUFDTCxPQUFPLENBQUMsR0FBRyxDQUFDO1NBQ2I7SUFDSCxDQUFDO0lBQ0QsaUJBQWlCLENBQUMsS0FBSyxFQUFFLFdBQVc7UUFDbEMsSUFBSSxLQUFLLEdBQUcsQ0FBQyxFQUFFO1lBQ2IsT0FBTyxDQUFDLENBQUM7U0FDVjthQUFNLElBQUksS0FBSyxHQUFHLFdBQVcsQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLFVBQVUsRUFBRTtZQUN4RCxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLFVBQVUsR0FBRyxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQ3JFO2FBQU07WUFDTCxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO1NBQ3JDO0lBQ0gsQ0FBQztJQUNELGdCQUFnQixDQUFDLEtBQUssRUFBRSxXQUFXO1FBQ2pDLElBQUksS0FBSyxHQUFHLENBQUMsRUFBRTtZQUNiLE9BQU8sQ0FBQyxDQUFDO1NBQ1Y7YUFBTSxJQUFJLEtBQUssR0FBRyxXQUFXLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQyxXQUFXLEVBQUU7WUFDMUQsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxXQUFXLEdBQUcsV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztTQUN2RTthQUFNO1lBQ0wsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztTQUNyQztJQUNILENBQUM7SUFDRCxRQUFRLEtBQUksQ0FBQzs7Z0hBNUVGLG1CQUFtQjtvR0FBbkIsbUJBQW1CLG1EQS9FcEI7Ozs7Ozs7U0FPSDsyRkF3RUksbUJBQW1CO2tCQWpGL0IsU0FBUzsrQkFDRSxhQUFhLFlBQ2I7Ozs7Ozs7U0FPSCIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFmdGVyVmlld0luaXQsIENvbXBvbmVudCwgT25Jbml0IH0gZnJvbSBcIkBhbmd1bGFyL2NvcmVcIjtcclxuaW1wb3J0IHsgU3RpVG9vbHRpcFNlcnZpY2UgfSBmcm9tIFwiLi9zdGktdG9vbHRpcC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aU1vZGVsU2VydmljZSB9IGZyb20gXCIuLi8uLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlXCI7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogXCJzdGktdG9vbHRpcFwiLFxyXG4gIHRlbXBsYXRlOiBgIDxkaXZcclxuICAgICN0b29sdGlwXHJcbiAgICBjbGFzcz1cInN0aS10b29sdGlwIHt7IGdldFRvb2x0aXBBcnJvdygpIH19XCJcclxuICAgIFtzdHlsZS5sZWZ0LnB4XT1cImdldExlZnQodG9vbHRpcClcIlxyXG4gICAgW3N0eWxlLnRvcC5weF09XCJnZXRUb3AodG9vbHRpcClcIlxyXG4gID5cclxuICAgIDxzcGFuPnt7IHRvb2x0aXBTZXJ2aWNlLnRleHQgfX08L3NwYW4+XHJcbiAgPC9kaXY+YCxcclxuICBzdHlsZXM6IFtcclxuICAgIGBcclxuICAgICAgLnN0aS10b29sdGlwIHtcclxuICAgICAgICBwb3NpdGlvbjogYWJzb2x1dGU7XHJcbiAgICAgICAgYmFja2dyb3VuZDogdmFyKC0tYmFjay1jb2xvcik7XHJcbiAgICAgICAgY29sb3I6IHZhcigtLXRleHQtY29sb3IpO1xyXG4gICAgICAgIHBhZGRpbmc6IDAuNDI5cmVtIDAuNDI5cmVtO1xyXG4gICAgICAgIGJveC1zaGFkb3c6IDAgM3B4IDZweCAwIHJnYmEoMCwgMCwgMCwgMC4xNik7XHJcbiAgICAgICAgYm9yZGVyLXJhZGl1czogM3B4O1xyXG4gICAgICAgIHotaW5kZXg6IDk5OTk5OTk5O1xyXG4gICAgICAgIHdoaXRlLXNwYWNlOiBwcmUtbGluZTtcclxuICAgICAgfVxyXG4gICAgICAuc3RpLXRvb2x0aXAgc3BhbiB7XHJcbiAgICAgICAgZm9udC1zaXplOiAxNnB4O1xyXG4gICAgICAgIGZvbnQtZmFtaWx5OiBBcmlhbDtcclxuICAgICAgfVxyXG4gICAgICAuYm90dG9tLWFycm93OjpiZWZvcmUsXHJcbiAgICAgIC5ib3R0b20tYXJyb3c6OmFmdGVyIHtcclxuICAgICAgICBjb250ZW50OiBcIlwiO1xyXG4gICAgICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuICAgICAgICBsZWZ0OiBjYWxjKDUwJSAtIDhweCk7XHJcbiAgICAgICAgYm90dG9tOiAtMTZweDtcclxuICAgICAgICBib3JkZXI6IDhweCBzb2xpZCB0cmFuc3BhcmVudDtcclxuICAgICAgICBib3JkZXItdG9wOiA4cHggc29saWQgd2hpdGU7XHJcbiAgICAgIH1cclxuICAgICAgLmJvdHRvbS1hcnJvdzo6YWZ0ZXIge1xyXG4gICAgICAgIGJvcmRlci10b3A6IDhweCBzb2xpZCB3aGl0ZTtcclxuICAgICAgICBib3R0b206IC0xNnB4O1xyXG4gICAgICB9XHJcbiAgICAgIC50b3AtYXJyb3c6OmJlZm9yZSxcclxuICAgICAgLnRvcC1hcnJvdzo6YWZ0ZXIge1xyXG4gICAgICAgIGNvbnRlbnQ6IFwiXCI7XHJcbiAgICAgICAgcG9zaXRpb246IGFic29sdXRlO1xyXG4gICAgICAgIGxlZnQ6IGNhbGMoNTAlIC0gOHB4KTtcclxuICAgICAgICB0b3A6IC0xNnB4O1xyXG4gICAgICAgIGJvcmRlcjogOHB4IHNvbGlkIHRyYW5zcGFyZW50O1xyXG4gICAgICAgIGJvcmRlci1ib3R0b206IDhweCBzb2xpZCB3aGl0ZTtcclxuICAgICAgfVxyXG4gICAgICAudG9wLWFycm93OjphZnRlciB7XHJcbiAgICAgICAgYm9yZGVyLWJvdHRvbTogOHB4IHNvbGlkIHdoaXRlO1xyXG4gICAgICAgIHRvcDogLTE2cHg7XHJcbiAgICAgIH1cclxuICAgICAgLmxlZnQtYXJyb3c6OmJlZm9yZSxcclxuICAgICAgLmxlZnQtYXJyb3c6OmFmdGVyIHtcclxuICAgICAgICBjb250ZW50OiBcIlwiO1xyXG4gICAgICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuICAgICAgICBsZWZ0OiAtMTZweDtcclxuICAgICAgICB0b3A6IGNhbGMoNTAlIC0gOHB4KTtcclxuICAgICAgICBib3JkZXI6IDhweCBzb2xpZCB0cmFuc3BhcmVudDtcclxuICAgICAgICBib3JkZXItcmlnaHQ6IDhweCBzb2xpZCB3aGl0ZTtcclxuICAgICAgfVxyXG4gICAgICAubGVmdC1hcnJvdzo6YWZ0ZXIge1xyXG4gICAgICAgIGJvcmRlci1yaWdodDogOHB4IHNvbGlkIHdoaXRlO1xyXG4gICAgICAgIGxlZnQ6IC0xNnB4O1xyXG4gICAgICB9XHJcbiAgICAgIC5yaWdodC1hcnJvdzo6YmVmb3JlLFxyXG4gICAgICAucmlnaHQtYXJyb3c6OmFmdGVyIHtcclxuICAgICAgICBjb250ZW50OiBcIlwiO1xyXG4gICAgICAgIHBvc2l0aW9uOiBhYnNvbHV0ZTtcclxuICAgICAgICByaWdodDogLTE2cHg7XHJcbiAgICAgICAgdG9wOiBjYWxjKDUwJSAtIDhweCk7XHJcbiAgICAgICAgYm9yZGVyOiA4cHggc29saWQgdHJhbnNwYXJlbnQ7XHJcbiAgICAgICAgYm9yZGVyLWxlZnQ6IDhweCBzb2xpZCB3aGl0ZTtcclxuICAgICAgfVxyXG4gICAgICAucmlnaHQtYXJyb3c6OmFmdGVyIHtcclxuICAgICAgICBib3JkZXItbGVmdDogOHB4IHNvbGlkIHdoaXRlO1xyXG4gICAgICAgIHJpZ2h0OiAtMTZweDtcclxuICAgICAgfVxyXG4gICAgYCxcclxuICBdLFxyXG59KVxyXG5leHBvcnQgY2xhc3MgU3RpVG9vbHRpcENvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCwgQWZ0ZXJWaWV3SW5pdCB7XHJcbiAgY29uc3RydWN0b3IocHVibGljIHRvb2x0aXBTZXJ2aWNlOiBTdGlUb29sdGlwU2VydmljZSwgcHVibGljIG1vZGVsOiBTdGlNb2RlbFNlcnZpY2UpIHt9XHJcbiAgcHVibGljIGluaXRpYWxpemVkOiBib29sZWFuID0gZmFsc2U7XHJcbiAgbmdBZnRlclZpZXdJbml0KCk6IHZvaWQge1xyXG4gICAgc2V0VGltZW91dCgoKSA9PiB7XHJcbiAgICAgIHRoaXMuaW5pdGlhbGl6ZWQgPSB0cnVlO1xyXG4gICAgfSk7XHJcbiAgfVxyXG4gIHB1YmxpYyBnZXRUb29sdGlwQXJyb3coKSB7XHJcbiAgICBzd2l0Y2ggKHRoaXMudG9vbHRpcFNlcnZpY2UucG9zaXRpb24pIHtcclxuICAgICAgY2FzZSBcInRvcFwiOlxyXG4gICAgICAgIHJldHVybiBcImJvdHRvbS1hcnJvd1wiO1xyXG4gICAgICBjYXNlIFwiYm90dG9tXCI6XHJcbiAgICAgICAgcmV0dXJuIFwidG9wLWFycm93XCI7XHJcbiAgICAgIGNhc2UgXCJsZWZ0XCI6XHJcbiAgICAgICAgcmV0dXJuIFwicmlnaHQtYXJyb3dcIjtcclxuICAgICAgY2FzZSBcInJpZ2h0XCI6XHJcbiAgICAgICAgcmV0dXJuIFwibGVmdC1hcnJvd1wiO1xyXG4gICAgfVxyXG4gIH1cclxuICBwdWJsaWMgZ2V0TGVmdCh0b29sdGlwRWxlbWVudCkge1xyXG4gICAgbGV0IGVsZW1lbnRSZWN0ID0gdGhpcy5tb2RlbC5nZXRQb3NpdGlvblJlbGF0aXZlVG9Gb3JtKHRvb2x0aXBFbGVtZW50KTtcclxuICAgIGlmICh0aGlzLnRvb2x0aXBTZXJ2aWNlLmVsZW1lbnRSZWN0ICYmIHRoaXMuaW5pdGlhbGl6ZWQpIHtcclxuICAgICAgc3dpdGNoICh0aGlzLnRvb2x0aXBTZXJ2aWNlLnBvc2l0aW9uKSB7XHJcbiAgICAgICAgY2FzZSBcImxlZnRcIjpcclxuICAgICAgICAgIHJldHVybiB0aGlzLmNvcnJlY3RMZWZ0TGltaXRzKHRoaXMudG9vbHRpcFNlcnZpY2UuZWxlbWVudFJlY3QubGVmdCAtIChlbGVtZW50UmVjdC53aWR0aCArIDgpLCBlbGVtZW50UmVjdCk7XHJcbiAgICAgICAgY2FzZSBcInJpZ2h0XCI6XHJcbiAgICAgICAgICByZXR1cm4gdGhpcy5jb3JyZWN0TGVmdExpbWl0cyh0aGlzLnRvb2x0aXBTZXJ2aWNlLmVsZW1lbnRSZWN0LnJpZ2h0ICsgOCwgZWxlbWVudFJlY3QpO1xyXG4gICAgICAgIGNhc2UgXCJ0b3BcIjpcclxuICAgICAgICBjYXNlIFwiYm90dG9tXCI6XHJcbiAgICAgICAgICByZXR1cm4gdGhpcy5jb3JyZWN0TGVmdExpbWl0cyhcclxuICAgICAgICAgICAgdGhpcy50b29sdGlwU2VydmljZS5lbGVtZW50UmVjdC5sZWZ0ICsgKHRoaXMudG9vbHRpcFNlcnZpY2UuZWxlbWVudFJlY3Qud2lkdGggLyAyIC0gZWxlbWVudFJlY3Qud2lkdGggLyAyKSxcclxuICAgICAgICAgICAgZWxlbWVudFJlY3RcclxuICAgICAgICAgICk7XHJcbiAgICAgIH1cclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIHJldHVybiAtOTk5O1xyXG4gICAgfVxyXG4gIH1cclxuICBwdWJsaWMgZ2V0VG9wKHRvb2x0aXBFbGVtZW50KSB7XHJcbiAgICBsZXQgZWxlbWVudFJlY3QgPSB0aGlzLm1vZGVsLmdldFBvc2l0aW9uUmVsYXRpdmVUb0Zvcm0odG9vbHRpcEVsZW1lbnQpO1xyXG4gICAgaWYgKHRoaXMudG9vbHRpcFNlcnZpY2UuZWxlbWVudFJlY3QgJiYgdGhpcy5pbml0aWFsaXplZCkge1xyXG4gICAgICBzd2l0Y2ggKHRoaXMudG9vbHRpcFNlcnZpY2UucG9zaXRpb24pIHtcclxuICAgICAgICBjYXNlIFwidG9wXCI6XHJcbiAgICAgICAgICByZXR1cm4gdGhpcy5jb3JyZWN0VG9wTGltaXRzKHRoaXMudG9vbHRpcFNlcnZpY2UuZWxlbWVudFJlY3QudG9wIC0gKGVsZW1lbnRSZWN0LmhlaWdodCArIDgpLCBlbGVtZW50UmVjdCk7XHJcbiAgICAgICAgY2FzZSBcImJvdHRvbVwiOlxyXG4gICAgICAgICAgcmV0dXJuIHRoaXMuY29ycmVjdFRvcExpbWl0cyh0aGlzLnRvb2x0aXBTZXJ2aWNlLmVsZW1lbnRSZWN0LmJvdHRvbSArIDgsIGVsZW1lbnRSZWN0KTtcclxuICAgICAgICBjYXNlIFwibGVmdFwiOlxyXG4gICAgICAgIGNhc2UgXCJyaWdodFwiOlxyXG4gICAgICAgICAgcmV0dXJuIHRoaXMuY29ycmVjdFRvcExpbWl0cyhcclxuICAgICAgICAgICAgdGhpcy50b29sdGlwU2VydmljZS5lbGVtZW50UmVjdC50b3AgKyAodGhpcy50b29sdGlwU2VydmljZS5lbGVtZW50UmVjdC5oZWlnaHQgLyAyIC0gZWxlbWVudFJlY3QuaGVpZ2h0IC8gMiksXHJcbiAgICAgICAgICAgIGVsZW1lbnRSZWN0XHJcbiAgICAgICAgICApO1xyXG4gICAgICB9XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICByZXR1cm4gLTk5OTtcclxuICAgIH1cclxuICB9XHJcbiAgY29ycmVjdExlZnRMaW1pdHModmFsdWUsIHRvb2x0aXBSZWN0KSB7XHJcbiAgICBpZiAodmFsdWUgPCAwKSB7XHJcbiAgICAgIHJldHVybiAwO1xyXG4gICAgfSBlbHNlIGlmICh2YWx1ZSArIHRvb2x0aXBSZWN0LndpZHRoID4gd2luZG93LmlubmVyV2lkdGgpIHtcclxuICAgICAgcmV0dXJuIE1hdGgucm91bmQod2luZG93LmlubmVyV2lkdGggLSB0b29sdGlwUmVjdC53aWR0aCkudG9GaXhlZCgyKTtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIHJldHVybiBNYXRoLnJvdW5kKHZhbHVlKS50b0ZpeGVkKDIpO1xyXG4gICAgfVxyXG4gIH1cclxuICBjb3JyZWN0VG9wTGltaXRzKHZhbHVlLCB0b29sdGlwUmVjdCkge1xyXG4gICAgaWYgKHZhbHVlIDwgMCkge1xyXG4gICAgICByZXR1cm4gMDtcclxuICAgIH0gZWxzZSBpZiAodmFsdWUgKyB0b29sdGlwUmVjdC5oZWlnaHQgPiB3aW5kb3cuaW5uZXJIZWlnaHQpIHtcclxuICAgICAgcmV0dXJuIE1hdGgucm91bmQod2luZG93LmlubmVySGVpZ2h0IC0gdG9vbHRpcFJlY3QuaGVpZ2h0KS50b0ZpeGVkKDIpO1xyXG4gICAgfSBlbHNlIHtcclxuICAgICAgcmV0dXJuIE1hdGgucm91bmQodmFsdWUpLnRvRml4ZWQoMik7XHJcbiAgICB9XHJcbiAgfVxyXG4gIG5nT25Jbml0KCkge31cclxufVxyXG4iXX0=