import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/sti-toolbar-resizer.service";
import * as i2 from "@angular/common";
import * as i3 from "./sti-tooltip/sti-tooltip.directive";
export class StiToolbarResizerComponent {
    constructor(toolbarResizerService) {
        this.toolbarResizerService = toolbarResizerService;
    }
    get isMaximize() {
        return this.toolbarResizerService.isMaximizeMode;
    }
    get isMinimize() {
        return this.toolbarResizerService.isMinimizeMode;
    }
    setMinimizeMode() {
        this.toolbarResizerService.isMinimizeMode = true;
        this.toolbarResizerService.isMaximizeMode = false;
        if (document.querySelector(".maximize")) {
            document.querySelector(".maximize")?.classList?.remove("maxMode");
        }
        document.querySelector(".minimize")?.classList?.add("minMode");
    }
    setMaximizeMode() {
        this.toolbarResizerService.isMinimizeMode = false;
        this.toolbarResizerService.isMaximizeMode = true;
        if (document.querySelector(".minimize")) {
            document.querySelector(".minimize")?.classList?.remove("minMode");
        }
        document.querySelector(".maximize")?.classList?.add("maxMode");
    }
    ngOnInit() { }
}
StiToolbarResizerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiToolbarResizerComponent, deps: [{ token: i1.StiToolbarResizerService }], target: i0.ɵɵFactoryTarget.Component });
StiToolbarResizerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiToolbarResizerComponent, selector: "sti-toolbar-resizer", ngImport: i0, template: `
    <div class="toolbarResizer">
      <div
        class="resizer minimize"
        *ngIf="this.isMaximize"
        (mousedown)="setMinimizeMode()"
        stiTooltip="Minimize"
        tooltipPosition="bottom"
        showDelay="500"
      >
        <div class="point"></div>
      </div>
      <div
        class="resizer maximize"
        *ngIf="this.isMinimize"
        (mousedown)="setMaximizeMode()"
        stiTooltip="Maximize"
        tooltipPosition="bottom"
        showDelay="500"
      >
        <div class="point"></div>
      </div>
    </div>
    <style>
      .toolbarResizer {
      }
      .resizer {
        width: 8px;
        height: 30px;
        background-color: var(--toolbarResizer-color);
        border: 1px solid var(--toolbarResizerBorder-color);
        position: fixed;
        top: calc((100% - 85px - 24px) / 2 + 85px - 15px);
      }
      .minimize {
        border-bottom-left-radius: 3px;
        border-top-left-radius: 3px;
        left: 192px;
      }
      .minimize:hover {
        background-color: var(--hover-color);
      }
      .point {
        position: absolute;
        top: 50%;
        left: 50%;
        width: 1px;
        height: 2px;
        background-color: rgb(119, 119, 119);
      }
      .maximize {
        border-top-right-radius: 3px;
        border-bottom-right-radius: 3px;
        left: 45px;
        margin-right: 10px;
      }
      .maximize:hover {
        background-color: var(--hover-color);
      }
      .maxMode {
        left: 192px;
      }
      .minMode {
        left: 45px;
      }
    </style>
  `, isInline: true, styles: ["\n      .toolbarResizer {\n      }\n      .resizer {\n        width: 8px;\n        height: 30px;\n        background-color: var(--toolbarResizer-color);\n        border: 1px solid var(--toolbarResizerBorder-color);\n        position: fixed;\n        top: calc((100% - 85px - 24px) / 2 + 85px - 15px);\n      }\n      .minimize {\n        border-bottom-left-radius: 3px;\n        border-top-left-radius: 3px;\n        left: 192px;\n      }\n      .minimize:hover {\n        background-color: var(--hover-color);\n      }\n      .point {\n        position: absolute;\n        top: 50%;\n        left: 50%;\n        width: 1px;\n        height: 2px;\n        background-color: rgb(119, 119, 119);\n      }\n      .maximize {\n        border-top-right-radius: 3px;\n        border-bottom-right-radius: 3px;\n        left: 45px;\n        margin-right: 10px;\n      }\n      .maximize:hover {\n        background-color: var(--hover-color);\n      }\n      .maxMode {\n        left: 192px;\n      }\n      .minMode {\n        left: 45px;\n      }\n    "], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiToolbarResizerComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-toolbar-resizer",
                    template: `
    <div class="toolbarResizer">
      <div
        class="resizer minimize"
        *ngIf="this.isMaximize"
        (mousedown)="setMinimizeMode()"
        stiTooltip="Minimize"
        tooltipPosition="bottom"
        showDelay="500"
      >
        <div class="point"></div>
      </div>
      <div
        class="resizer maximize"
        *ngIf="this.isMinimize"
        (mousedown)="setMaximizeMode()"
        stiTooltip="Maximize"
        tooltipPosition="bottom"
        showDelay="500"
      >
        <div class="point"></div>
      </div>
    </div>
    <style>
      .toolbarResizer {
      }
      .resizer {
        width: 8px;
        height: 30px;
        background-color: var(--toolbarResizer-color);
        border: 1px solid var(--toolbarResizerBorder-color);
        position: fixed;
        top: calc((100% - 85px - 24px) / 2 + 85px - 15px);
      }
      .minimize {
        border-bottom-left-radius: 3px;
        border-top-left-radius: 3px;
        left: 192px;
      }
      .minimize:hover {
        background-color: var(--hover-color);
      }
      .point {
        position: absolute;
        top: 50%;
        left: 50%;
        width: 1px;
        height: 2px;
        background-color: rgb(119, 119, 119);
      }
      .maximize {
        border-top-right-radius: 3px;
        border-bottom-right-radius: 3px;
        left: 45px;
        margin-right: 10px;
      }
      .maximize:hover {
        background-color: var(--hover-color);
      }
      .maxMode {
        left: 192px;
      }
      .minMode {
        left: 45px;
      }
    </style>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiToolbarResizerService }]; } });
//# sourceMappingURL=data:application/json;base64,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