import { Component, Input, ViewChild, } from "@angular/core";
import StiRectangleGeometryLayout from "../../computed/StiRectangleGeometryLayout";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-rich-text.service";
import * as i3 from "../../services/sti-component-resizer.service";
import * as i4 from "@angular/common";
import * as i5 from "../sti-component";
export class StiTextComponent {
    constructor(model, richTextService, componentResizerService, render) {
        this.model = model;
        this.richTextService = richTextService;
        this.componentResizerService = componentResizerService;
        this.render = render;
        this.isClone = false;
    }
    //component: StiComponent;
    get borderInnerWidth() {
        return Number(this.element.width) + Number(this.element.border.pen.width);
    }
    get borderInnerHeight() {
        return Number(this.element.height) + Number(this.element.border.pen.width);
    }
    ngAfterViewChecked() {
        let frameElement = document.getElementById("iframe" + this.element?.guid);
        let doc = frameElement?.contentWindow?.document;
    }
    changeMode(value) {
        let frameElement = document.getElementById("iframe" + this.element?.guid);
        let doc = frameElement?.contentWindow?.document;
        doc.body.contentEditable = value.toString();
    }
    get currentVerticalStep() {
        return this.model.form?.settings?.gridVerticalStep != 1 ? this.model.form?.settings?.gridVerticalStep : 5;
    }
    getIframeHeight(iframe) {
        if (this.getIframeMinHeight(iframe) > this.element?.height) {
            setTimeout(() => {
                if (!this.isClone) {
                    let height = this.getIframeMinHeight(iframe) + this.element.padding.top + this.element.padding.bottom;
                    this.element.height = Math.ceil(height / this.currentVerticalStep) * this.currentVerticalStep;
                    this.updateFormGeometry();
                }
            });
            return this.getIframeMinHeight(iframe);
        }
        else {
            return this.element.height;
        }
    }
    updateFormGeometry() {
        this.render.insertElement(this.element);
    }
    getIframeMinHeight(iframe) {
        if (iframe) {
            let firstChild = iframe?.contentDocument?.body?.firstChild;
            if (firstChild) {
                return firstChild.offsetHeight;
            }
            else {
                return 0;
            }
        }
        else {
            return 0;
        }
    }
    ngOnDestroy() {
        if (this.observer) {
            this.observer.disconnect();
        }
        this.changeModeSubscription?.unsubscribe();
    }
    ngAfterViewInit() {
        if (this.element.isAdded && !this.isClone) {
            if (this.model.getBrowserType() == "firefox") {
                let frameElements = document.querySelectorAll("#iframe" + this.element?.guid);
                frameElements.forEach((frameElement) => {
                    let this_ = this;
                    frameElement?.contentWindow?.addEventListener("load", () => {
                        let doc = frameElement?.contentWindow?.document;
                        doc.body.contentEditable = "true";
                        doc.body.style.margin = "0";
                        doc.body.style.overflowWrap = "break-word";
                        doc.body.innerHTML = this_.element.htmlTextString;
                        this_.richTextService.convertHtmlAttributesForWysiwyg(doc);
                        let element = this_.element;
                        const targetNode = doc.body;
                        this_.observer = new MutationObserver(() => (element.htmlTextString = this_.richTextService.convertDocumentToForm(doc)));
                        doc.body.addEventListener("mouseup", () => this_.richTextService.showCurrentState());
                        doc.body.addEventListener("keyup", () => this_.richTextService.showCurrentState());
                        doc.body.addEventListener("focus", () => {
                            this_.richTextService.initFont(this_.element.htmlTextString);
                            this_.richTextService.showCurrentState();
                        });
                        doc.body.addEventListener("mousedown", () => {
                            this_.model.selectedComponent = this_.component;
                        });
                        this_.observer.observe(targetNode, {
                            childList: true,
                            subtree: true,
                            attributes: true,
                            characterData: true,
                        });
                    });
                });
            }
            else {
                let frameElements = document.querySelectorAll("#iframe" + this.element?.guid);
                frameElements.forEach((frameElement) => {
                    let doc = frameElement?.contentWindow?.document;
                    doc.body.contentEditable = "true";
                    doc.body.style.margin = "0";
                    doc.body.innerHTML = this.element.htmlTextString;
                    this.richTextService.convertHtmlAttributesForWysiwyg(doc);
                    let element = this.element;
                    const targetNode = doc.body;
                    let this_ = this;
                    this.observer = new MutationObserver(() => (element.htmlTextString = this_.richTextService.convertDocumentToForm(doc)));
                    this.observer.observe(targetNode, {
                        childList: true,
                        subtree: true,
                        attributes: true,
                        characterData: true,
                    });
                    doc.body.addEventListener("mouseup", () => this.richTextService.showCurrentState());
                    doc.body.addEventListener("keyup", () => this.richTextService.showCurrentState());
                    doc.body.addEventListener("focus", () => {
                        this.richTextService.initFont(this.element.htmlTextString);
                        this.richTextService.showCurrentState();
                    });
                    doc.body.addEventListener("mousedown", () => {
                        this_.model.selectedComponent = this_.component;
                    });
                });
            }
        }
    }
    ngOnInit() {
        this.changeModeSubscription = this.model.interfaceEvent.subscribe((event) => {
            if (event.name == "SetPreviewMode") {
                this.changeMode(false);
            }
            else if (event.name == "UnsetPreviewMode") {
                this.changeMode(true);
            }
        });
    }
}
StiTextComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTextComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiRichTextService }, { token: i3.StiComponentResizerService }, { token: StiRectangleGeometryLayout }], target: i0.ɵɵFactoryTarget.Component });
StiTextComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTextComponent, selector: "sti-text-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "richTextEditor", first: true, predicate: ["richTextEditor"], descendants: true }, { propertyName: "component", first: true, predicate: ["component"], descendants: true }], ngImport: i0, template: ` <sti-component [element]="element" #component [isClone]="isClone" class="sti-text">
    <div
      style="position: absolute;pointer-events:none;width:100%;height:100%; left:0; top:0;z-index:999"
      [style.height.px]="borderInnerHeight"
      [style.width.px]="borderInnerWidth"
      [style.left.px]="-(element.border.pen.width / 2)"
      [style.top.px]="-(element.border.pen.width / 2)"
      [style.border-top]="element.border.drawTop ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-left]="element.border.drawLeft ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-right]="element.border.drawRight ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-bottom]="element.border.drawBottom ? element.border.pen.toHtmlBorder() : 'transparent'"
    ></div>
    <iframe
      #iframe
      *ngIf="element.isAdded"
      id="{{ 'iframe' + element.guid }}"
      src="about:blank"
      frameborder="0"
      [style.height.px]="getIframeHeight(iframe)"
      [style.width]="'100%'"
      (mouseup)="model.canDrag = true"
      [style.pointer-events]="componentResizerService.isResizing ? 'none' : ''"
    >
    </iframe>
  </sti-component>`, isInline: true, styles: [".rich-text-editor{height:100%;width:100%;outline:none;font-weight:400;overflow:hidden}.rich-text-editor:hover{cursor:text}\n"], dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTextComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-text-component", template: ` <sti-component [element]="element" #component [isClone]="isClone" class="sti-text">
    <div
      style="position: absolute;pointer-events:none;width:100%;height:100%; left:0; top:0;z-index:999"
      [style.height.px]="borderInnerHeight"
      [style.width.px]="borderInnerWidth"
      [style.left.px]="-(element.border.pen.width / 2)"
      [style.top.px]="-(element.border.pen.width / 2)"
      [style.border-top]="element.border.drawTop ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-left]="element.border.drawLeft ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-right]="element.border.drawRight ? element.border.pen.toHtmlBorder() : 'transparent'"
      [style.border-bottom]="element.border.drawBottom ? element.border.pen.toHtmlBorder() : 'transparent'"
    ></div>
    <iframe
      #iframe
      *ngIf="element.isAdded"
      id="{{ 'iframe' + element.guid }}"
      src="about:blank"
      frameborder="0"
      [style.height.px]="getIframeHeight(iframe)"
      [style.width]="'100%'"
      (mouseup)="model.canDrag = true"
      [style.pointer-events]="componentResizerService.isResizing ? 'none' : ''"
    >
    </iframe>
  </sti-component>`, styles: [".rich-text-editor{height:100%;width:100%;outline:none;font-weight:400;overflow:hidden}.rich-text-editor:hover{cursor:text}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiRichTextService }, { type: i3.StiComponentResizerService }, { type: StiRectangleGeometryLayout }]; }, propDecorators: { richTextEditor: [{
                type: ViewChild,
                args: ["richTextEditor"]
            }], component: [{
                type: ViewChild,
                args: ["component"]
            }], element: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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