import { Component, Input, ViewChild } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "../sti-component";
import * as i5 from "../sti-editable-content.component";
import * as i6 from "../sti-input-text.component";
import * as i7 from "../sti-tooltip/sti-tooltip.directive";
export class StiTextBoxComponent {
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    get align() {
        return "start";
    }
    get needToFill() {
        return (this.element.required &&
            (this.element.isPassword ? !this.element.password : !this.element.value) &&
            this.model.hasEmptyReuiredFields);
    }
    disableDrag(event) {
        let t = null;
        this.model.canDrag = false;
    }
    ngDoCheck() {
        if (this.textArea) {
            this.element.element = this.textArea;
        }
    }
    ngOnInit() { }
    borderWidth() {
        return `${this.element.borderWeight}px`;
    }
    get text() {
        return this.element.text;
    }
    set text(value) {
        this.element.text = value;
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    get password() {
        return this.element.password;
    }
    set password(value) {
        this.element.password = value;
        this.model.formEvents.next({ name: "ValueChanged" });
    }
    onInput(value) {
        this.element.text = value;
        this.model.formEvents.next({ name: "ValueChanged" });
        //this.model.selectedComponent.element.options.options = value.split("\n"); TODO
    }
}
StiTextBoxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTextBoxComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiTextBoxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTextBoxComponent, selector: "sti-textbox-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "textArea", first: true, predicate: ["textArea"], descendants: true }], ngImport: i0, template: `
    <sti-component [element]="element" [isClone]="isClone" class="sti-text-box">
      <sti-editable-content-component
        *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
        [editableContent]="element?.label"
        [required]="element.required"
        [style.align-self]="align"
        [style.text-align]="element?.getContentAlign()"
        [style.width]="element?.getLabelWidth()"
        [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      ></sti-editable-content-component>
      <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
        <tr>
          <td
            *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
            [style.display]="'flex'"
            [style.height]="'100%'"
            [style.width]="element?.getLabelWidth()"
            [style.align-items]="element?.getVerticalAlignment()"
          >
            <sti-editable-content-component
              *ngIf="element?.label.value?.length > 0"
              [editableContent]="element?.label"
              [required]="element.required"
              [style.text-align]="element?.getContentAlign()"
              [style.width]="element?.getLabelWidth()"
              [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
            ></sti-editable-content-component>
          </td>
          <td [style.width]="'100%'">
            <textarea
              #textArea
              name=""
              id=""
              cols="30"
              [rows]="element?.linesCount"
              *ngIf="!element?.isPassword && element?.isMultiline"
              [ngModel]="text"
              (input)="onInput($event.target.value)"
              [style.color]="element?.textColor.toHtmlColor()"
              [style.background-color]="element?.backgroundColor.toHtmlColor()"
              [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
              [style.border-width]="borderWidth()"
              [style]="element?.htmlStyle()"
              [stiTooltip]="element?.tooltip"
              [tabIndex]="element['tabIndex']"
              tooltipPosition="bottom"
              showDelay="500"
              [required]="element?.required"
              [readonly]="element?.readOnly"
              (mousedown)="disableDrag($event)"
              (mouseup)="this.model.canDrag = true"
            ></textarea>
            <input
              type="password"
              *ngIf="element?.isPassword"
              [style]="element?.htmlStyle()"
              [style.color]="element?.textColor.toHtmlColor()"
              [style.background-color]="element?.backgroundColor.toHtmlColor()"
              spellcheck="false"
              [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
              [style.border-width]="borderWidth()"
              maxlength="{{ element?.maxLength }}"
              [stiTooltip]="element?.tooltip"
              [tabIndex]="element['tabIndex']"
              tooltipPosition="bottom"
              showDelay="500"
              [required]="element?.required"
              [readonly]="element?.readOnly"
              [(ngModel)]="password"
              (mousedown)="disableDrag($event)"
              (mouseup)="this.model.canDrag = true"
            />
            <sti-input-text-component
              *ngIf="!element?.isPassword && !element?.isMultiline"
              [element]="element"
              [tabIndex]="element['tabIndex']"
              [property]="'text'"
              [stiTooltip]="element?.tooltip"
              tooltipPosition="bottom"
              showDelay="500"
            ></sti-input-text-component>
          </td>
        </tr>
        <tr *ngIf="element?.description.value?.length > 0">
          <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
          <td [style.maxWidth.px]="element.maxWidth + 1">
            <sti-editable-content-component
              *ngIf="element?.description.value?.length > 0"
              [editableContent]="element.description"
            >
            </sti-editable-content-component>
          </td>
        </tr>
      </table>
    </sti-component>
  `, isInline: true, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}textarea{resize:none;width:100%;height:auto;overflow-y:auto;padding:3px 4px}textarea:hover{border-color:#a3bde3!important}textarea:focus{outline:none}input{height:-moz-fit-content;height:fit-content;padding:3px 4px;width:100%;border:1px solid rgb(198,198,198)}.sti-text-box input:hover{border-color:#a3bde3!important}.sti-text-box input:focus{outline:none;border:1px solid rgb(163,189,227)}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.RequiredValidator, selector: ":not([type=checkbox])[required][formControlName],:not([type=checkbox])[required][formControl],:not([type=checkbox])[required][ngModel]", inputs: ["required"] }, { kind: "directive", type: i3.MaxLengthValidator, selector: "[maxlength][formControlName],[maxlength][formControl],[maxlength][ngModel]", inputs: ["maxlength"] }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "component", type: i4.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i5.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "component", type: i6.StiInputTextComponent, selector: "sti-input-text-component", inputs: ["element", "property", "tabIndex"] }, { kind: "directive", type: i7.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTextBoxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-textbox-component", template: `
    <sti-component [element]="element" [isClone]="isClone" class="sti-text-box">
      <sti-editable-content-component
        *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
        [editableContent]="element?.label"
        [required]="element.required"
        [style.align-self]="align"
        [style.text-align]="element?.getContentAlign()"
        [style.width]="element?.getLabelWidth()"
        [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
      ></sti-editable-content-component>
      <table [style.width]="'100%'" [style.height]="'max-content'" [style.margin-top.px]="element?.getTopMargin()">
        <tr>
          <td
            *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
            [style.display]="'flex'"
            [style.height]="'100%'"
            [style.width]="element?.getLabelWidth()"
            [style.align-items]="element?.getVerticalAlignment()"
          >
            <sti-editable-content-component
              *ngIf="element?.label.value?.length > 0"
              [editableContent]="element?.label"
              [required]="element.required"
              [style.text-align]="element?.getContentAlign()"
              [style.width]="element?.getLabelWidth()"
              [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
            ></sti-editable-content-component>
          </td>
          <td [style.width]="'100%'">
            <textarea
              #textArea
              name=""
              id=""
              cols="30"
              [rows]="element?.linesCount"
              *ngIf="!element?.isPassword && element?.isMultiline"
              [ngModel]="text"
              (input)="onInput($event.target.value)"
              [style.color]="element?.textColor.toHtmlColor()"
              [style.background-color]="element?.backgroundColor.toHtmlColor()"
              [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
              [style.border-width]="borderWidth()"
              [style]="element?.htmlStyle()"
              [stiTooltip]="element?.tooltip"
              [tabIndex]="element['tabIndex']"
              tooltipPosition="bottom"
              showDelay="500"
              [required]="element?.required"
              [readonly]="element?.readOnly"
              (mousedown)="disableDrag($event)"
              (mouseup)="this.model.canDrag = true"
            ></textarea>
            <input
              type="password"
              *ngIf="element?.isPassword"
              [style]="element?.htmlStyle()"
              [style.color]="element?.textColor.toHtmlColor()"
              [style.background-color]="element?.backgroundColor.toHtmlColor()"
              spellcheck="false"
              [style.border-color]="needToFill ? 'red' : element?.borderColor.toHtmlColor()"
              [style.border-width]="borderWidth()"
              maxlength="{{ element?.maxLength }}"
              [stiTooltip]="element?.tooltip"
              [tabIndex]="element['tabIndex']"
              tooltipPosition="bottom"
              showDelay="500"
              [required]="element?.required"
              [readonly]="element?.readOnly"
              [(ngModel)]="password"
              (mousedown)="disableDrag($event)"
              (mouseup)="this.model.canDrag = true"
            />
            <sti-input-text-component
              *ngIf="!element?.isPassword && !element?.isMultiline"
              [element]="element"
              [tabIndex]="element['tabIndex']"
              [property]="'text'"
              [stiTooltip]="element?.tooltip"
              tooltipPosition="bottom"
              showDelay="500"
            ></sti-input-text-component>
          </td>
        </tr>
        <tr *ngIf="element?.description.value?.length > 0">
          <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
          <td [style.maxWidth.px]="element.maxWidth + 1">
            <sti-editable-content-component
              *ngIf="element?.description.value?.length > 0"
              [editableContent]="element.description"
            >
            </sti-editable-content-component>
          </td>
        </tr>
      </table>
    </sti-component>
  `, styles: ["table{border-spacing:0}tr{height:max-content;padding:0;margin:0}td{height:100%;padding:0;margin:0}textarea{resize:none;width:100%;height:auto;overflow-y:auto;padding:3px 4px}textarea:hover{border-color:#a3bde3!important}textarea:focus{outline:none}input{height:-moz-fit-content;height:fit-content;padding:3px 4px;width:100%;border:1px solid rgb(198,198,198)}.sti-text-box input:hover{border-color:#a3bde3!important}.sti-text-box input:focus{outline:none;border:1px solid rgb(163,189,227)}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { element: [{
                type: Input
            }], textArea: [{
                type: ViewChild,
                args: ["textArea"]
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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