import { Component, Input, ViewChild, } from "@angular/core";
import { StiHorizontalAlignment, StiLabelAlignment, StiVerticalAlignment } from "../../system/enums";
import { StiRadioButtonColumnItem } from "../../elements/table/columns/StiRadioButtonColumnItem";
import { Enum } from "../../system/Enum";
import Color from "../../system/Color";
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/sti-draggable.service";
import * as i3 from "../../services/sti-column-draggable.service";
import * as i4 from "../../services/sti-editable-content.service";
import * as i5 from "../../services/mouse.service";
import * as i6 from "@angular/common";
import * as i7 from "../sti-component";
import * as i8 from "../sti-editable-content.component";
import * as i9 from "./sti-table-totals-field/sti-table-totals-field.component";
import * as i10 from "../sti-table-column-resizer.component";
import * as i11 from "./sti-table-column/sti-table-column.component";
export class StiTableComponent {
    constructor(model, draggableService, columnDraggableService, editableContentService, cdr, mouseService) {
        this.model = model;
        this.draggableService = draggableService;
        this.columnDraggableService = columnDraggableService;
        this.editableContentService = editableContentService;
        this.cdr = cdr;
        this.mouseService = mouseService;
        this.isClone = false;
        this.minWidth = 40;
        this.isDrag = false;
        this.canDrag = false;
        this.isInitialized = false;
        this.isActive = false;
        this._canAddRow = false;
        this._canDeleteRow = false;
        this.innerMargin = 5;
    }
    get selected() {
        return this.model.selectedComponent?.element == this.element;
    }
    get canAddRow() {
        return this._canAddRow;
    }
    set canAddRow(value) {
        let oldValue = this._canAddRow;
        if (oldValue != value) {
            this._canAddRow = value;
            this.cdr.detectChanges();
        }
    }
    get canDeleteRow() {
        return this._canDeleteRow;
    }
    set canDeleteRow(value) {
        let oldValue = this._canDeleteRow;
        if (oldValue != value) {
            this._canDeleteRow = value;
            this.cdr.detectChanges();
        }
    }
    checkAbilityToAddRow() {
        if (this.isInitialized) {
            let tableRect = this.model.getPositionRelativeToForm(this.table?.nativeElement);
            let totalsRect = this.model.getPositionRelativeToForm(this.totals?.nativeElement);
            let tableRowRect = this.model.getPositionRelativeToForm(this.tableRow?.nativeElement);
            let componentLabelRect = this.model.getPositionRelativeToForm(this.componentLabel?.nativeElement);
            let componentDescriptionRect = this.model.getPositionRelativeToForm(this.componentDescription?.nativeElement);
            if (this.model.isPreviewMode) {
                let componentInnerHeight = this.element.height - this.element.padding.top - this.element.padding.bottom;
                this.canAddRow =
                    componentInnerHeight -
                        (this.element.label.value && this.element.label.alignment == StiLabelAlignment.Top
                            ? componentLabelRect?.height
                            : 0) -
                        (this.element.description.value ? componentDescriptionRect?.height : 0) -
                        (this.element.useTotals ? totalsRect?.height : 0) -
                        tableRect?.height >
                        tableRowRect?.height;
            }
            else {
                let parentContainer = this.model.getElementPage(this.element) ?? this.model.getElementPanel(this.element);
                this.canAddRow =
                    parentContainer.contentAreaHeight -
                        (this.element.label.value && this.element.label.alignment == StiLabelAlignment.Top
                            ? componentLabelRect?.height
                            : 0) -
                        (this.element.description.value ? componentDescriptionRect?.height : 0) -
                        (this.element.useTotals ? totalsRect?.height : 0) -
                        tableRect?.height >
                        tableRowRect?.height;
            }
        }
        else {
            this.canAddRow = false;
        }
    }
    getMaxHeight() {
        if (!this.isInitialized) {
            return 0;
        }
        let tBodyRec = this.tBody ? this.model.getPositionRelativeToForm(this.tBody?.nativeElement) : 0;
        let totalsRec = this.totals ? this.model.getPositionRelativeToForm(this.totals?.nativeElement) : 0;
        return Number((this.element.geometry.bottom -
            this.element.padding.bottom -
            this.element.padding.top -
            this.getSizeWithZoom(tBodyRec instanceof DOMRect ? tBodyRec.height : 0) -
            this.getSizeWithZoom(totalsRec instanceof DOMRect ? totalsRec.height : 0) -
            this.innerMargin).toFixed(2));
    }
    checkAbilityToDeleteRow() {
        this.canDeleteRow = this.element.rowLabels.length > 1;
    }
    canDeleteColumn() {
        return this.element.columns.length > 0 && this.isInitialized ? true : false;
    }
    getSizeWithZoom(size) {
        return size / this.model.zoom;
    }
    isOverMaxHeight() {
        if (!this.isInitialized) {
            return false;
        }
        let parentContainer = this.model.getElementPage(this.element) ?? this.model.getElementPanel(this.element);
        return this.element.height == parentContainer.contentAreaHeight - this.element.y;
    }
    updatePropertyGrid(column, event) {
        if (!this.element.showColumnsEditor) {
            this.element.showColumnsEditor = true;
            this.model.needToRefresh.next(true);
        }
        setTimeout(() => {
            let index = this.element.columns.findIndex((item) => item == column);
            if (this.model.currentContentEditableItemIndex != index ||
                this.model.previousSelectedComponent?.element != this.element) {
                this.model.currentContentEditableItem.next(index);
                this.model.currentContentEditableItemIndex = index;
            }
        }, 0);
    }
    get totalsWidth() {
        return this.element?.label?.alignment == StiLabelAlignment.Top
            ? this.element?.width - this.element.padding.left - this.element.padding.right
            : this.element?.width - this.element?.label?.width - this.element.padding.left - this.element.padding.right;
    }
    getPageColor() {
        if (this.model.selectedComponent.element == this.element) {
            if (this.model.getElementPage(this.element)) {
                return this.model.getElementPage(this.element)?.backgroundColor?.toHtmlColor();
            }
            else {
                let currentElement = this.model.getElementPanel(this.element);
                if (this.model.getElementPage(currentElement)) {
                    return this.model.getElementPage(currentElement)?.backgroundColor?.toHtmlColor();
                }
                else {
                    while (this.model.getElementPage(currentElement)) {
                        currentElement = this.model.getElementPanel(currentElement);
                    }
                    return this.model.getElementPage(currentElement)?.backgroundColor?.toHtmlColor();
                }
            }
        }
        else {
            return "transparent";
        }
    }
    get align() {
        return "start";
    }
    get contentAlign() {
        return this.element["label"]["alignment"] == StiLabelAlignment.Right ? "flex-end" : "start";
    }
    get width() {
        if (this.element.label.alignment == StiLabelAlignment.Top) {
            return "100%";
        }
        else {
            return this.element.label.width + "px";
        }
    }
    get margin() {
        return this.element["label"]["alignment"] == StiLabelAlignment.Top && this.element.label.value ? "10" : "0";
    }
    get headerAlignment() {
        return Enum.getName(StiHorizontalAlignment, this.element.tableHeaderAlignment);
    }
    get rowAlignment() {
        return Enum.getName(StiHorizontalAlignment, this.element.rowLabelsHorizontalAlignment);
    }
    get totalVerticalAlignment() {
        if (this.element.totalsRowHeaderVerticalAlignment == StiVerticalAlignment.Top) {
            return "flex-start";
        }
        else if (this.element.totalsRowHeaderVerticalAlignment == StiVerticalAlignment.Bottom) {
            return "flex-end";
        }
        else {
            return "center";
        }
    }
    get totalHorizontalAlignment() {
        if (this.element.totalsRowHeaderHorizontalAlignment == StiHorizontalAlignment.Left) {
            return "flex-start";
        }
        else if (this.element.totalsRowHeaderHorizontalAlignment == StiHorizontalAlignment.Right) {
            return "flex-end";
        }
        else {
            return "center";
        }
    }
    onHeaderClick(event, item) {
        if (this.model.isPreviewMode) {
            return;
        }
        let form = document.querySelector("stimulsoft-forms");
        form?.classList.add("unselectable");
        this.model.canDrag = false;
        if (this.editableContentService.editableContent != item) {
            this.columnDraggableService.onHeaderClick(event, item, this.element.columns, true, this.element);
        }
    }
    changeStyle(elem) { }
    get tableBackColor() {
        return this.element?.backgroundColor.toHtmlColor()
            ? this.element.backgroundColor.toHtmlColor()
            : Color.transparent().toHtmlColor();
    }
    addColumn() {
        this.element.addColumn();
        this.model.showColumnPreview(this.element.columns.length - 1);
    }
    addRow() {
        this.element.addRow();
    }
    deleteColumn() {
        this.element.deleteLastColumn();
    }
    deleteRow() {
        this.element.deleteLastRow();
    }
    getColumnAlignment(column) {
        return Enum.getName(StiHorizontalAlignment, column.cellAlignment);
    }
    getBorder(pen, isVisible, isDragPreview = false) {
        return isVisible || isDragPreview ? pen.toHtmlBorder() : "transparent";
    }
    getBorderWidth(pen, isDragPreview) {
        let res = isDragPreview ? Number(pen.width) + 2 : pen.width;
        return res + "px";
    }
    getColumnBackColor(column, index) {
        if (this.element.alternateRowColors) {
            if (index % 2 === 0) {
                return this.element.oddRowsStyle.toHtmlColor();
            }
            else {
                return this.element.evenRowsStyle.toHtmlColor();
            }
        }
        else {
            return column.backgroundColor?.toHtmlColor() ?? column.eBackgroundColor.toHtmlColor();
        }
    }
    getColumnForeColor(column, index) {
        if (this.element.alternateRowColors) {
            if (index % 2 === 0) {
                return this.element.oddRowsTextColor.toHtmlColor();
            }
            else {
                return this.element.evenRowsTextColor.toHtmlColor();
            }
        }
        else {
            return column.cellForeColor?.toHtmlColor() ?? column.eColor.toHtmlColor();
        }
    }
    ngAfterContentChecked() {
        if (!this.model.draggingElement &&
            !this.isClone &&
            (this.model?.selectedComponent?.element == this.element || this.isActive)) {
            this.checkAbilityToAddRow();
            this.checkAbilityToDeleteRow();
        }
    }
    ngOnDestroy() {
        this.isInitialized = false;
    }
    ngAfterViewInit() {
        if (this.element && !this.isClone) {
            this.element.element = this.tableTr;
            if (this.element != this.model.draggingElement) {
                setTimeout(() => {
                    this.isInitialized = true;
                });
            }
        }
    }
    ngOnInit() { }
    changeState(column, i) {
        if (column instanceof StiRadioButtonColumnItem) {
            column.cells.forEach((cell) => {
                cell.isChecked = false;
            });
        }
        column.cells[i].isChecked = !column.cells[i].isChecked;
    }
}
StiTableComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiDraggableService }, { token: i3.StiColumnDraggableService }, { token: i4.StiEditableContentService }, { token: i0.ChangeDetectorRef }, { token: i5.StiMouseService }], target: i0.ɵɵFactoryTarget.Component });
StiTableComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTableComponent, selector: "sti-table-component", inputs: { element: "element", isClone: "isClone" }, viewQueries: [{ propertyName: "tableTr", first: true, predicate: ["tableTr"], descendants: true }, { propertyName: "tBody", first: true, predicate: ["tBody"], descendants: true }, { propertyName: "totals", first: true, predicate: ["totals"], descendants: true }, { propertyName: "table", first: true, predicate: ["table"], descendants: true }, { propertyName: "tableRow", first: true, predicate: ["tableRow"], descendants: true }, { propertyName: "componentDescription", first: true, predicate: ["description"], descendants: true }, { propertyName: "componentLabel", first: true, predicate: ["label"], descendants: true }], ngImport: i0, template: ` <sti-component
    [element]="element"
    [isClone]="isClone"
    (mouseenter)="model.isPreviewMode ? (isActive = true) : ''"
    (mouseleave)="model.isPreviewMode ? (isActive = false) : ''"
  >
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [style.align-self]="align"
      [style.text-align]="contentAlign"
      [editableContent]="element.label"
      [style.width]="width"
    ></sti-editable-content-component>
    <table
      class="outer-table"
      [style.width]="'100%'"
      [style.height]="'max-content'"
      [style.margin-top.px]="element?.getTopMargin()"
    >
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
          #label
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div class="sti-table" #table>
            <div [style.display]="'flex'">
              <table
                class="column-drop-area"
                [style.background-color]="element?.backgroundColor.toHtmlColor()"
                [style.align-self]="align"
              >
                <thead>
                  <tr #tableTr>
                    <th
                      *ngIf="element?.showRowLabels"
                      [id]="0"
                      (mousemove)="columnDraggableService.fromTable ? (columnDraggableService.insertIndex = 0) : return"
                      [style.justify-content]="headerAlignment"
                      [style.color]="element?.tableHeaderColor.toHtmlColor()"
                      [style.background-color]="element?.tableHeaderBackgroundColor.toHtmlColor()"
                      [style.width.px]="!isClone ? element?.rowLabelsWidth : 0"
                      [style.max-height.px]="
                        !isClone && !model.pdfPreviewMode && isInitialized && isOverMaxHeight()
                          ? getMaxHeight()
                          : 'auto'
                      "
                      [style.border-top]="getBorder(element?.border.pen, element?.border.drawTop)"
                      [style.border-left]="getBorder(element?.border.pen, element?.border.drawLeft)"
                      [style.border-bottom]="
                        getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawTop)
                      "
                      [style.border-right]="
                        element.columns.length > 0 ? '' : getBorder(element?.border.pen, element?.border.drawRight)
                      "
                      [style.padding]="'5px 0px 5px 5px'"
                    >
                      <sti-editable-content-component
                        [editableContent]="element"
                        [alignment]="element?.tableHeaderAlignment"
                        [isTableHeader]="true"
                        [style.width]="'100%'"
                        [hideEmpty]="false"
                        [active]="selected"
                      ></sti-editable-content-component>
                      <sti-table-column-resizer
                        [resizableItem]="element"
                        [element]="element"
                        [style.height]="'100%'"
                      ></sti-table-column-resizer>
                    </th>
                    <th
                      *ngFor="let column of element.columns; index as idx"
                      [id]="idx + 1"
                      (mousemove)="
                        columnDraggableService.fromTable ? (columnDraggableService.insertIndex = idx + 1) : return
                      "
                      class="drag-item sti-table-th"
                      (click)="model.showColumnPreview(idx)"
                      [style]="element.font.htmlStyle()"
                      [style.justify-content]="getColumnAlignment(column)"
                      (mousedown)="onHeaderClick($event, column)"
                      [style.color]="column?.headerForeColor.toHtmlColor()"
                      [style.background-color]="column?.headerBackColor.toHtmlColor()"
                      [style.width.px]="!isClone ? column?.width : 0"
                      [style.height.px]="
                        isClone && !model.pdfPreviewMode ? element?.element?.nativeElement?.clientHeight : 'auto'
                      "
                      [style.max-height.px]="
                        !isClone && !model.pdfPreviewMode && isInitialized && isOverMaxHeight()
                          ? getMaxHeight()
                          : 'auto'
                      "
                      [style.transition]="columnDraggableService.fromTable ? 'border-width 50ms linear' : ''"
                      [style.border-top]="
                        getBorder(element?.columnHeadersBorder.pen, element?.columnHeadersBorder.drawTop) !=
                        'transparent'
                          ? getBorder(element?.columnHeadersBorder.pen, element?.columnHeadersBorder.drawTop)
                          : getBorder(element?.border.pen, element?.border.drawTop)
                      "
                      [style.border-bottom]="
                        getBorder(element?.columnHeadersBorder.pen, element?.columnHeadersBorder.drawBottom)
                      "
                      [style.border-right]="
                        getBorder(
                          element?.columnHeadersBorder.pen,
                          element?.columnHeadersBorder.drawRight,
                          columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                            ? true
                            : false
                        ) != 'transparent'
                          ? idx == element.columns.length - 1
                            ? getBorder(
                                element?.columnHeadersBorder.pen,
                                element?.columnHeadersBorder.drawRight,
                                columnDraggableService.parentElement == element &&
                                  columnDraggableService.fromTable &&
                                  columnDraggableService.insertIndex == idx + 1
                                  ? true
                                  : false
                              )
                            : getBorder(
                                element?.gridLines.pen,
                                element?.gridLines.drawVertical,
                                columnDraggableService.parentElement == element &&
                                  columnDraggableService.fromTable &&
                                  columnDraggableService.insertIndex == idx + 1
                                  ? true
                                  : false
                              )
                          : idx == element.columns.length - 1
                          ? getBorder(
                              element?.border.pen,
                              element?.border.drawRight,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == idx + 1
                                ? true
                                : false
                            )
                          : getBorder(
                              element?.gridLines.pen,
                              element?.gridLines.drawVertical,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == idx + 1
                                ? true
                                : false
                            )
                      "
                      [style.border-left]="
                        idx == 0
                          ? getBorder(
                              element?.columnHeadersBorder.pen,
                              element?.columnHeadersBorder.drawLeft,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == 0 &&
                                idx == 0
                                ? true
                                : false
                            )
                          : ''
                      "
                      [style.border-left-width]="
                        columnDraggableService.parentElement == element &&
                        columnDraggableService.fromTable &&
                        columnDraggableService.insertIndex == 0 &&
                        idx == 0
                          ? getBorderWidth(element?.columnHeadersBorder.pen, true)
                          : getBorderWidth(element?.columnHeadersBorder.pen, false)
                      "
                      [style.border-right-width]="
                        idx != element.columns.length - 1
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                            ? getBorderWidth(element?.gridLines.pen, true)
                            : getBorderWidth(element?.gridLines.pen, false)
                          : element?.columnHeadersBorder.drawRight
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                            ? getBorderWidth(element?.columnHeadersBorder.pen, true)
                            : getBorderWidth(element?.columnHeadersBorder.pen, false)
                          : columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                          ? getBorderWidth(element?.border.pen, true)
                          : getBorderWidth(element?.border.pen, false)
                      "
                      [style.padding]="'5px 0px 5px 5px'"
                    >
                      <sti-editable-content-component
                        [eParent]="element"
                        [editableContent]="column"
                        [alignment]="column?.headerAlignment"
                        [isTableHeader]="true"
                        [style.width]="'100%'"
                        [hideEmpty]="false"
                        [active]="selected"
                      ></sti-editable-content-component>
                      <sti-table-column-resizer
                        [resizableItem]="column"
                        [element]="element"
                        [index]="idx"
                        *ngIf="idx != element.columns.length - 1"
                        [style.height]="'100%'"
                      ></sti-table-column-resizer>
                    </th>
                  </tr>
                </thead>
                <tbody #tBody>
                  <tr *ngFor="let rowLabel of element.rowLabelsContentEditable; index as i" #tableRow>
                    <td
                      *ngIf="element?.showRowLabels"
                      [attr.data-label]="element.tableHeaderText"
                      [id]="0"
                      (mousemove)="columnDraggableService.fromTable ? (columnDraggableService.insertIndex = 0) : return"
                      [style]="element.font.htmlStyle()"
                      [style.justify-content]="rowAlignment"
                      [style.color]="getColumnForeColor(rowLabel, i)"
                      [style.width.px]="!isClone ? element?.rowLabelsWidth : 0"
                      [style.background-color]="getColumnBackColor(rowLabel, i)"
                      [style.border-left]="
                        getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawLeft) != 'transparent'
                          ? getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawLeft)
                          : getBorder(element?.border.pen, element?.border.drawLeft)
                      "
                      [style.border-bottom]="
                        getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawBottom) != 'transparent'
                          ? i == element.rowLabels.length - 1
                            ? getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawBottom)
                            : getBorder(element?.gridLines.pen, element?.gridLines.drawHorizontal)
                          : i == element.rowLabels.length - 1
                          ? getBorder(element?.border.pen, element?.border.drawBottom)
                          : getBorder(element?.gridLines.pen, element?.gridLines.drawHorizontal)
                      "
                      [style.border-right]="
                        element.columns.length > 0
                          ? ''
                          : getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawRight) !=
                            'transparent'
                          ? getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawRight)
                          : getBorder(element?.border.pen, element?.border.drawRight)
                      "
                    >
                      <sti-editable-content-component
                        [eParent]="element"
                        [editableContent]="rowLabel"
                        [displayContent]="rowLabel?.displayValue"
                        [alignment]="element?.rowLabelsHorizontalAlignment"
                        [style.width]="'100%'"
                        [hideEmpty]="false"
                        [active]="selected"
                      ></sti-editable-content-component>
                    </td>
                    <td
                      *ngFor="let column of element.columns; index as ind"
                      [attr.data-label]="column.label"
                      [id]="ind + 1"
                      (mousedown)="updatePropertyGrid(column, $event)"
                      (mousemove)="
                        columnDraggableService.fromTable ? (columnDraggableService.insertIndex = ind + 1) : return
                      "
                      class="drag-item sti-table-td"
                      [style.justify-content]="getColumnAlignment(column)"
                      [style.color]="getColumnForeColor(column, i)"
                      [style.background-color]="getColumnBackColor(column, i)"
                      [style.width.px]="
                        !isClone ? (ind == element.columns.length - 1 ? column?.width + 0.04 : column?.width) : 0
                      "
                      [style.transition]="columnDraggableService.fromTable ? 'border-width 50ms linear' : ''"
                      [style.border-left]="
                        ind == 0
                          ? getBorder(
                              element?.rowHeadersBorder.pen,
                              element?.rowHeadersBorder.drawRight,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == 0 &&
                                ind == 0
                                ? true
                                : false
                            )
                          : ''
                      "
                      [style.border-bottom]="
                        i == element.rowLabels.length - 1
                          ? getBorder(element?.border.pen, element?.border.drawBottom)
                          : getBorder(element?.gridLines.pen, element?.gridLines.drawHorizontal)
                      "
                      [style.border-right]="
                        ind == element.columns.length - 1
                          ? getBorder(
                              element?.border.pen,
                              element?.border.drawRight,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == ind + 1
                                ? true
                                : false
                            )
                          : getBorder(
                              element?.gridLines.pen,
                              element?.gridLines.drawVertical,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == ind + 1
                                ? true
                                : false
                            )
                      "
                      [style.border-left-width]="
                        columnDraggableService.parentElement == element &&
                        columnDraggableService.fromTable &&
                        columnDraggableService.insertIndex == 0 &&
                        ind == 0
                          ? getBorderWidth(element?.rowHeadersBorder.pen, true)
                          : getBorderWidth(element?.rowHeadersBorder.pen, false)
                      "
                      [style.border-right-width]="
                        ind != element.columns.length - 1
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == ind + 1
                            ? getBorderWidth(element?.gridLines.pen, true)
                            : getBorderWidth(element?.gridLines.pen, false)
                          : element?.columnHeadersBorder.drawRight
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == ind + 1
                            ? getBorderWidth(element?.border.pen, true)
                            : getBorderWidth(element?.border.pen, false)
                          : columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == ind + 1
                          ? getBorderWidth(element?.border.pen, true)
                          : getBorderWidth(element?.border.pen, false)
                      "
                    >
                      <sti-table-column-component
                        [column]="column"
                        [index]="i"
                        [element]="element"
                        [style.width]="'100%'"
                      ></sti-table-column-component>
                    </td>
                  </tr>
                </tbody>
              </table>
              <div
                class="right"
                *ngIf="
                  element == model.selectedComponent?.element &&
                  model.draggingElement != element &&
                  !model.isPreviewMode
                "
              >
                <div class="right-control-panel">
                  <div
                    class="add control-button"
                    [style.margin-bottom.px]="5"
                    [style.background-color]="getPageColor()"
                    (click)="addColumn()"
                  >
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                      <rect class="plus" width="16" height="16" [attr.fill]="getPageColor()" />
                      <path
                        d="M11.5656 8.905H8.97358V11.5656H7.16329V8.905H4.57129V7.23186H7.16329V4.57129H8.97358V7.23186H11.5656V8.905Z"
                        fill="#898989"
                      />
                    </svg>
                  </div>
                  <div
                    class="delete control-button {{ canDeleteColumn() ? '' : 'disabled' }}"
                    [style.background-color]="getPageColor()"
                    (click)="deleteColumn()"
                  >
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                      <path
                        d="M6 8H8H10"
                        stroke="#898989"
                        stroke-width="2"
                        stroke-linecap="square"
                        stroke-linejoin="round"
                      />
                    </svg>
                  </div>
                </div>
              </div>
            </div>
            <div
              class="bottom"
              *ngIf="
                (element == model.selectedComponent?.element &&
                  model.draggingElement != element &&
                  !model.isPreviewMode) ||
                (model.isPreviewMode && !element.readOnly && element.dynamicRows && isActive)
              "
            >
              <div class="bottom-control-panel">
                <div
                  class="add control-button {{ canAddRow ? '' : 'disabled' }}"
                  [style.margin-right.px]="5"
                  [style.background-color]="getPageColor()"
                  (click)="addRow()"
                >
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <rect class="plus" width="16" height="16" [attr.fill]="getPageColor()" />
                    <path
                      d="M11.5656 8.905H8.97358V11.5656H7.16329V8.905H4.57129V7.23186H7.16329V4.57129H8.97358V7.23186H11.5656V8.905Z"
                      fill="#898989"
                    />
                  </svg>
                </div>
                <div
                  class="delete control-button {{ canDeleteRow ? '' : 'disabled' }}"
                  [style.background-color]="getPageColor()"
                  (click)="deleteRow()"
                >
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path
                      d="M6 8H8H10"
                      stroke="#898989"
                      stroke-width="2"
                      stroke-linecap="square"
                      stroke-linejoin="round"
                    />
                  </svg>
                </div>
              </div>
            </div>
          </div>
          <div class="totals" *ngIf="element?.useTotals" #totals>
            <div
              class="totals-header"
              [style.align-items]="totalVerticalAlignment"
              [style.justify-content]="totalHorizontalAlignment"
            >
              <sti-editable-content-component
                [editableContent]="element.totalsRowHeaderEditableContent"
                [hideEmpty]="false"
                [active]="selected"
                [isTableTotalHeader]="true"
              ></sti-editable-content-component>
            </div>
            <div class="totals-fields">
              <sti-table-totals-field-component
                [fields]="element.totalsFields"
                [object]="element"
              ></sti-table-totals-field-component>
            </div>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0" #description>
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, isInline: true, styles: [".outer-table table{border-spacing:0}.outer-table tr{height:max-content;padding:0;margin:0}.outer-table td{height:100%;padding:0;margin:0}.add{border-radius:3px;background-color:transparent;display:flex;border:1px solid lightGray;justify-content:center;align-items:center;z-index:100}.disabled{opacity:.5;pointer-events:none}.right{width:0px;background-color:transparent;position:relative}.right-control-panel{height:55px;width:18px;left:3px;top:calc(50% - 22.5px);position:absolute;display:flex;flex-direction:column}.right-control-panel .control-button{height:25px}.control-button{border-radius:3px;background-color:transparent;display:flex;border:1px solid lightGray;justify-content:center;align-items:center;z-index:100}.control-button:hover{background-color:#d3d3d3!important;cursor:default}.control-button:hover .plus{fill:#d3d3d3!important;cursor:default}.bottom-control-panel{height:18px;width:55px;top:3px;left:calc(50% - 22.5px);position:absolute;display:flex}.bottom-control-panel .control-button{width:25px}.bottom{width:calc(100% - 5px);height:0px;background-color:transparent;position:relative}.table-content{min-width:260px;width:100%;display:inline-block;flex-direction:column;flex:1}table,th,td{border-collapse:collapse}th{position:relative}.sti-table th,.sti-table td{display:flex;flex-direction:row;align-items:center;overflow:hidden;padding:4px;height:auto}.sti-table table{width:100%;margin:0;padding:0;display:inline-table;table-layout:auto;border-collapse:collapse;border-spacing:0;overflow:hidden}.sti-table th{padding:3px}.sti-table tr{display:flex;flex-direction:row;flex:1}.totals{width:100%;display:flex;min-height:5px;margin-top:5px;overflow:hidden}.totals-header{display:flex;flex:1;padding:4px 0}\n"], dependencies: [{ kind: "directive", type: i6.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7.StiComponent, selector: "sti-component", inputs: ["element", "class", "isClone", "borderArea"] }, { kind: "component", type: i8.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }, { kind: "component", type: i9.StiTableTotalsFieldComponent, selector: "sti-table-totals-field-component", inputs: ["fields", "object", "isClone"] }, { kind: "component", type: i10.StiTableColumnResizerComponent, selector: "sti-table-column-resizer", inputs: ["resizableItem", "element", "index"] }, { kind: "component", type: i11.StiTableColumnComponent, selector: "sti-table-column-component", inputs: ["column", "index", "element"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-table-component", template: ` <sti-component
    [element]="element"
    [isClone]="isClone"
    (mouseenter)="model.isPreviewMode ? (isActive = true) : ''"
    (mouseleave)="model.isPreviewMode ? (isActive = false) : ''"
  >
    <sti-editable-content-component
      *ngIf="element?.label.value?.length > 0 && element?.isLabelTopAlignment()"
      [style.align-self]="align"
      [style.text-align]="contentAlign"
      [editableContent]="element.label"
      [style.width]="width"
    ></sti-editable-content-component>
    <table
      class="outer-table"
      [style.width]="'100%'"
      [style.height]="'max-content'"
      [style.margin-top.px]="element?.getTopMargin()"
    >
      <tr>
        <td
          *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"
          [style.display]="'flex'"
          [style.height]="'100%'"
          [style.width]="element?.getLabelWidth()"
          [style.align-items]="element?.getVerticalAlignment()"
          #label
        >
          <sti-editable-content-component
            *ngIf="element?.label.value?.length > 0"
            [editableContent]="element?.label"
            [required]="element.required"
            [style.text-align]="element?.getContentAlign()"
            [style.width]="element?.getLabelWidth()"
            [hideEmpty]="element?.showLabelPlaceholder(model?.selectedComponent?.element == element)"
          ></sti-editable-content-component>
        </td>
        <td [style.width]="'100%'">
          <div class="sti-table" #table>
            <div [style.display]="'flex'">
              <table
                class="column-drop-area"
                [style.background-color]="element?.backgroundColor.toHtmlColor()"
                [style.align-self]="align"
              >
                <thead>
                  <tr #tableTr>
                    <th
                      *ngIf="element?.showRowLabels"
                      [id]="0"
                      (mousemove)="columnDraggableService.fromTable ? (columnDraggableService.insertIndex = 0) : return"
                      [style.justify-content]="headerAlignment"
                      [style.color]="element?.tableHeaderColor.toHtmlColor()"
                      [style.background-color]="element?.tableHeaderBackgroundColor.toHtmlColor()"
                      [style.width.px]="!isClone ? element?.rowLabelsWidth : 0"
                      [style.max-height.px]="
                        !isClone && !model.pdfPreviewMode && isInitialized && isOverMaxHeight()
                          ? getMaxHeight()
                          : 'auto'
                      "
                      [style.border-top]="getBorder(element?.border.pen, element?.border.drawTop)"
                      [style.border-left]="getBorder(element?.border.pen, element?.border.drawLeft)"
                      [style.border-bottom]="
                        getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawTop)
                      "
                      [style.border-right]="
                        element.columns.length > 0 ? '' : getBorder(element?.border.pen, element?.border.drawRight)
                      "
                      [style.padding]="'5px 0px 5px 5px'"
                    >
                      <sti-editable-content-component
                        [editableContent]="element"
                        [alignment]="element?.tableHeaderAlignment"
                        [isTableHeader]="true"
                        [style.width]="'100%'"
                        [hideEmpty]="false"
                        [active]="selected"
                      ></sti-editable-content-component>
                      <sti-table-column-resizer
                        [resizableItem]="element"
                        [element]="element"
                        [style.height]="'100%'"
                      ></sti-table-column-resizer>
                    </th>
                    <th
                      *ngFor="let column of element.columns; index as idx"
                      [id]="idx + 1"
                      (mousemove)="
                        columnDraggableService.fromTable ? (columnDraggableService.insertIndex = idx + 1) : return
                      "
                      class="drag-item sti-table-th"
                      (click)="model.showColumnPreview(idx)"
                      [style]="element.font.htmlStyle()"
                      [style.justify-content]="getColumnAlignment(column)"
                      (mousedown)="onHeaderClick($event, column)"
                      [style.color]="column?.headerForeColor.toHtmlColor()"
                      [style.background-color]="column?.headerBackColor.toHtmlColor()"
                      [style.width.px]="!isClone ? column?.width : 0"
                      [style.height.px]="
                        isClone && !model.pdfPreviewMode ? element?.element?.nativeElement?.clientHeight : 'auto'
                      "
                      [style.max-height.px]="
                        !isClone && !model.pdfPreviewMode && isInitialized && isOverMaxHeight()
                          ? getMaxHeight()
                          : 'auto'
                      "
                      [style.transition]="columnDraggableService.fromTable ? 'border-width 50ms linear' : ''"
                      [style.border-top]="
                        getBorder(element?.columnHeadersBorder.pen, element?.columnHeadersBorder.drawTop) !=
                        'transparent'
                          ? getBorder(element?.columnHeadersBorder.pen, element?.columnHeadersBorder.drawTop)
                          : getBorder(element?.border.pen, element?.border.drawTop)
                      "
                      [style.border-bottom]="
                        getBorder(element?.columnHeadersBorder.pen, element?.columnHeadersBorder.drawBottom)
                      "
                      [style.border-right]="
                        getBorder(
                          element?.columnHeadersBorder.pen,
                          element?.columnHeadersBorder.drawRight,
                          columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                            ? true
                            : false
                        ) != 'transparent'
                          ? idx == element.columns.length - 1
                            ? getBorder(
                                element?.columnHeadersBorder.pen,
                                element?.columnHeadersBorder.drawRight,
                                columnDraggableService.parentElement == element &&
                                  columnDraggableService.fromTable &&
                                  columnDraggableService.insertIndex == idx + 1
                                  ? true
                                  : false
                              )
                            : getBorder(
                                element?.gridLines.pen,
                                element?.gridLines.drawVertical,
                                columnDraggableService.parentElement == element &&
                                  columnDraggableService.fromTable &&
                                  columnDraggableService.insertIndex == idx + 1
                                  ? true
                                  : false
                              )
                          : idx == element.columns.length - 1
                          ? getBorder(
                              element?.border.pen,
                              element?.border.drawRight,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == idx + 1
                                ? true
                                : false
                            )
                          : getBorder(
                              element?.gridLines.pen,
                              element?.gridLines.drawVertical,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == idx + 1
                                ? true
                                : false
                            )
                      "
                      [style.border-left]="
                        idx == 0
                          ? getBorder(
                              element?.columnHeadersBorder.pen,
                              element?.columnHeadersBorder.drawLeft,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == 0 &&
                                idx == 0
                                ? true
                                : false
                            )
                          : ''
                      "
                      [style.border-left-width]="
                        columnDraggableService.parentElement == element &&
                        columnDraggableService.fromTable &&
                        columnDraggableService.insertIndex == 0 &&
                        idx == 0
                          ? getBorderWidth(element?.columnHeadersBorder.pen, true)
                          : getBorderWidth(element?.columnHeadersBorder.pen, false)
                      "
                      [style.border-right-width]="
                        idx != element.columns.length - 1
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                            ? getBorderWidth(element?.gridLines.pen, true)
                            : getBorderWidth(element?.gridLines.pen, false)
                          : element?.columnHeadersBorder.drawRight
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                            ? getBorderWidth(element?.columnHeadersBorder.pen, true)
                            : getBorderWidth(element?.columnHeadersBorder.pen, false)
                          : columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == idx + 1
                          ? getBorderWidth(element?.border.pen, true)
                          : getBorderWidth(element?.border.pen, false)
                      "
                      [style.padding]="'5px 0px 5px 5px'"
                    >
                      <sti-editable-content-component
                        [eParent]="element"
                        [editableContent]="column"
                        [alignment]="column?.headerAlignment"
                        [isTableHeader]="true"
                        [style.width]="'100%'"
                        [hideEmpty]="false"
                        [active]="selected"
                      ></sti-editable-content-component>
                      <sti-table-column-resizer
                        [resizableItem]="column"
                        [element]="element"
                        [index]="idx"
                        *ngIf="idx != element.columns.length - 1"
                        [style.height]="'100%'"
                      ></sti-table-column-resizer>
                    </th>
                  </tr>
                </thead>
                <tbody #tBody>
                  <tr *ngFor="let rowLabel of element.rowLabelsContentEditable; index as i" #tableRow>
                    <td
                      *ngIf="element?.showRowLabels"
                      [attr.data-label]="element.tableHeaderText"
                      [id]="0"
                      (mousemove)="columnDraggableService.fromTable ? (columnDraggableService.insertIndex = 0) : return"
                      [style]="element.font.htmlStyle()"
                      [style.justify-content]="rowAlignment"
                      [style.color]="getColumnForeColor(rowLabel, i)"
                      [style.width.px]="!isClone ? element?.rowLabelsWidth : 0"
                      [style.background-color]="getColumnBackColor(rowLabel, i)"
                      [style.border-left]="
                        getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawLeft) != 'transparent'
                          ? getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawLeft)
                          : getBorder(element?.border.pen, element?.border.drawLeft)
                      "
                      [style.border-bottom]="
                        getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawBottom) != 'transparent'
                          ? i == element.rowLabels.length - 1
                            ? getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawBottom)
                            : getBorder(element?.gridLines.pen, element?.gridLines.drawHorizontal)
                          : i == element.rowLabels.length - 1
                          ? getBorder(element?.border.pen, element?.border.drawBottom)
                          : getBorder(element?.gridLines.pen, element?.gridLines.drawHorizontal)
                      "
                      [style.border-right]="
                        element.columns.length > 0
                          ? ''
                          : getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawRight) !=
                            'transparent'
                          ? getBorder(element?.rowHeadersBorder.pen, element?.rowHeadersBorder.drawRight)
                          : getBorder(element?.border.pen, element?.border.drawRight)
                      "
                    >
                      <sti-editable-content-component
                        [eParent]="element"
                        [editableContent]="rowLabel"
                        [displayContent]="rowLabel?.displayValue"
                        [alignment]="element?.rowLabelsHorizontalAlignment"
                        [style.width]="'100%'"
                        [hideEmpty]="false"
                        [active]="selected"
                      ></sti-editable-content-component>
                    </td>
                    <td
                      *ngFor="let column of element.columns; index as ind"
                      [attr.data-label]="column.label"
                      [id]="ind + 1"
                      (mousedown)="updatePropertyGrid(column, $event)"
                      (mousemove)="
                        columnDraggableService.fromTable ? (columnDraggableService.insertIndex = ind + 1) : return
                      "
                      class="drag-item sti-table-td"
                      [style.justify-content]="getColumnAlignment(column)"
                      [style.color]="getColumnForeColor(column, i)"
                      [style.background-color]="getColumnBackColor(column, i)"
                      [style.width.px]="
                        !isClone ? (ind == element.columns.length - 1 ? column?.width + 0.04 : column?.width) : 0
                      "
                      [style.transition]="columnDraggableService.fromTable ? 'border-width 50ms linear' : ''"
                      [style.border-left]="
                        ind == 0
                          ? getBorder(
                              element?.rowHeadersBorder.pen,
                              element?.rowHeadersBorder.drawRight,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == 0 &&
                                ind == 0
                                ? true
                                : false
                            )
                          : ''
                      "
                      [style.border-bottom]="
                        i == element.rowLabels.length - 1
                          ? getBorder(element?.border.pen, element?.border.drawBottom)
                          : getBorder(element?.gridLines.pen, element?.gridLines.drawHorizontal)
                      "
                      [style.border-right]="
                        ind == element.columns.length - 1
                          ? getBorder(
                              element?.border.pen,
                              element?.border.drawRight,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == ind + 1
                                ? true
                                : false
                            )
                          : getBorder(
                              element?.gridLines.pen,
                              element?.gridLines.drawVertical,
                              columnDraggableService.parentElement == element &&
                                columnDraggableService.fromTable &&
                                columnDraggableService.insertIndex == ind + 1
                                ? true
                                : false
                            )
                      "
                      [style.border-left-width]="
                        columnDraggableService.parentElement == element &&
                        columnDraggableService.fromTable &&
                        columnDraggableService.insertIndex == 0 &&
                        ind == 0
                          ? getBorderWidth(element?.rowHeadersBorder.pen, true)
                          : getBorderWidth(element?.rowHeadersBorder.pen, false)
                      "
                      [style.border-right-width]="
                        ind != element.columns.length - 1
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == ind + 1
                            ? getBorderWidth(element?.gridLines.pen, true)
                            : getBorderWidth(element?.gridLines.pen, false)
                          : element?.columnHeadersBorder.drawRight
                          ? columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == ind + 1
                            ? getBorderWidth(element?.border.pen, true)
                            : getBorderWidth(element?.border.pen, false)
                          : columnDraggableService.parentElement == element &&
                            columnDraggableService.fromTable &&
                            columnDraggableService.insertIndex == ind + 1
                          ? getBorderWidth(element?.border.pen, true)
                          : getBorderWidth(element?.border.pen, false)
                      "
                    >
                      <sti-table-column-component
                        [column]="column"
                        [index]="i"
                        [element]="element"
                        [style.width]="'100%'"
                      ></sti-table-column-component>
                    </td>
                  </tr>
                </tbody>
              </table>
              <div
                class="right"
                *ngIf="
                  element == model.selectedComponent?.element &&
                  model.draggingElement != element &&
                  !model.isPreviewMode
                "
              >
                <div class="right-control-panel">
                  <div
                    class="add control-button"
                    [style.margin-bottom.px]="5"
                    [style.background-color]="getPageColor()"
                    (click)="addColumn()"
                  >
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                      <rect class="plus" width="16" height="16" [attr.fill]="getPageColor()" />
                      <path
                        d="M11.5656 8.905H8.97358V11.5656H7.16329V8.905H4.57129V7.23186H7.16329V4.57129H8.97358V7.23186H11.5656V8.905Z"
                        fill="#898989"
                      />
                    </svg>
                  </div>
                  <div
                    class="delete control-button {{ canDeleteColumn() ? '' : 'disabled' }}"
                    [style.background-color]="getPageColor()"
                    (click)="deleteColumn()"
                  >
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                      <path
                        d="M6 8H8H10"
                        stroke="#898989"
                        stroke-width="2"
                        stroke-linecap="square"
                        stroke-linejoin="round"
                      />
                    </svg>
                  </div>
                </div>
              </div>
            </div>
            <div
              class="bottom"
              *ngIf="
                (element == model.selectedComponent?.element &&
                  model.draggingElement != element &&
                  !model.isPreviewMode) ||
                (model.isPreviewMode && !element.readOnly && element.dynamicRows && isActive)
              "
            >
              <div class="bottom-control-panel">
                <div
                  class="add control-button {{ canAddRow ? '' : 'disabled' }}"
                  [style.margin-right.px]="5"
                  [style.background-color]="getPageColor()"
                  (click)="addRow()"
                >
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <rect class="plus" width="16" height="16" [attr.fill]="getPageColor()" />
                    <path
                      d="M11.5656 8.905H8.97358V11.5656H7.16329V8.905H4.57129V7.23186H7.16329V4.57129H8.97358V7.23186H11.5656V8.905Z"
                      fill="#898989"
                    />
                  </svg>
                </div>
                <div
                  class="delete control-button {{ canDeleteRow ? '' : 'disabled' }}"
                  [style.background-color]="getPageColor()"
                  (click)="deleteRow()"
                >
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                    <path
                      d="M6 8H8H10"
                      stroke="#898989"
                      stroke-width="2"
                      stroke-linecap="square"
                      stroke-linejoin="round"
                    />
                  </svg>
                </div>
              </div>
            </div>
          </div>
          <div class="totals" *ngIf="element?.useTotals" #totals>
            <div
              class="totals-header"
              [style.align-items]="totalVerticalAlignment"
              [style.justify-content]="totalHorizontalAlignment"
            >
              <sti-editable-content-component
                [editableContent]="element.totalsRowHeaderEditableContent"
                [hideEmpty]="false"
                [active]="selected"
                [isTableTotalHeader]="true"
              ></sti-editable-content-component>
            </div>
            <div class="totals-fields">
              <sti-table-totals-field-component
                [fields]="element.totalsFields"
                [object]="element"
              ></sti-table-totals-field-component>
            </div>
          </div>
        </td>
      </tr>
      <tr *ngIf="element?.description.value?.length > 0" #description>
        <td *ngIf="element?.label.value?.length > 0 && !element?.isLabelTopAlignment()"></td>
        <td [style.maxWidth.px]="element.maxWidth + 1">
          <sti-editable-content-component
            *ngIf="element?.description.value?.length > 0"
            [editableContent]="element.description"
          >
          </sti-editable-content-component>
        </td>
      </tr>
    </table>
  </sti-component>`, styles: [".outer-table table{border-spacing:0}.outer-table tr{height:max-content;padding:0;margin:0}.outer-table td{height:100%;padding:0;margin:0}.add{border-radius:3px;background-color:transparent;display:flex;border:1px solid lightGray;justify-content:center;align-items:center;z-index:100}.disabled{opacity:.5;pointer-events:none}.right{width:0px;background-color:transparent;position:relative}.right-control-panel{height:55px;width:18px;left:3px;top:calc(50% - 22.5px);position:absolute;display:flex;flex-direction:column}.right-control-panel .control-button{height:25px}.control-button{border-radius:3px;background-color:transparent;display:flex;border:1px solid lightGray;justify-content:center;align-items:center;z-index:100}.control-button:hover{background-color:#d3d3d3!important;cursor:default}.control-button:hover .plus{fill:#d3d3d3!important;cursor:default}.bottom-control-panel{height:18px;width:55px;top:3px;left:calc(50% - 22.5px);position:absolute;display:flex}.bottom-control-panel .control-button{width:25px}.bottom{width:calc(100% - 5px);height:0px;background-color:transparent;position:relative}.table-content{min-width:260px;width:100%;display:inline-block;flex-direction:column;flex:1}table,th,td{border-collapse:collapse}th{position:relative}.sti-table th,.sti-table td{display:flex;flex-direction:row;align-items:center;overflow:hidden;padding:4px;height:auto}.sti-table table{width:100%;margin:0;padding:0;display:inline-table;table-layout:auto;border-collapse:collapse;border-spacing:0;overflow:hidden}.sti-table th{padding:3px}.sti-table tr{display:flex;flex-direction:row;flex:1}.totals{width:100%;display:flex;min-height:5px;margin-top:5px;overflow:hidden}.totals-header{display:flex;flex:1;padding:4px 0}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiDraggableService }, { type: i3.StiColumnDraggableService }, { type: i4.StiEditableContentService }, { type: i0.ChangeDetectorRef }, { type: i5.StiMouseService }]; }, propDecorators: { element: [{
                type: Input
            }], isClone: [{
                type: Input
            }], tableTr: [{
                type: ViewChild,
                args: ["tableTr"]
            }], tBody: [{
                type: ViewChild,
                args: ["tBody"]
            }], totals: [{
                type: ViewChild,
                args: ["totals"]
            }], table: [{
                type: ViewChild,
                args: ["table"]
            }], tableRow: [{
                type: ViewChild,
                args: ["tableRow"]
            }], componentDescription: [{
                type: ViewChild,
                args: ["description"]
            }], componentLabel: [{
                type: ViewChild,
                args: ["label"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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