import { Component, Input } from "@angular/core";
import { StiHorizontalAlignment, StiLabelAlignment } from "../../../system/enums";
import { StiTableElement } from "../../../elements/StiTableElement";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "../../../services/mouse.service";
import * as i3 from "@angular/common";
import * as i4 from "../../sti-editable-content.component";
export class StiTableTotalsFieldComponent {
    constructor(model, mouseService) {
        this.model = model;
        this.mouseService = mouseService;
        this.isClone = false;
        this.minWidth = 40;
        this.isResizing = false;
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe((event) => {
            this.isResizing = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.resize(event);
        });
    }
    get showResizePreview() {
        return this.object instanceof StiTableElement &&
            !this.object.gridLines.drawVertical &&
            this.model.selectedComponent.element == this.object
            ? true
            : false;
    }
    showPropertyInfo(field) {
        setTimeout(() => {
            if (this.model.selectedComponent?.element instanceof StiTableElement &&
                !this.model.selectedComponent?.element.showTotalsEditor) {
                this.model.selectedComponent.element.showTotalsEditor = true;
                this.model.needToRefresh.next(true);
            }
            setTimeout(() => {
                if (this.model.selectedComponent?.element instanceof StiTableElement) {
                    let index = this.model.selectedComponent.element.totalsFields.findIndex((column) => column == field);
                    this.model.currentContentEditableItem.next(index);
                }
            }, 0);
        }, 0);
    }
    getAlignment(value) {
        if (value == StiHorizontalAlignment.Left) {
            return "flex-start";
        }
        else if (value == StiHorizontalAlignment.Right) {
            return "flex-end";
        }
        else {
            return "center";
        }
    }
    get selected() {
        return this.model.selectedComponent?.element == this.object;
    }
    getValue(field) {
        let value = this.model.getFormattedValue(field, field.value);
        return `${field.prefix}${value != null && value != undefined ? value : ""}${field.suffix}`;
    }
    initResize(event, columnType) {
        event.stopPropagation();
        this.isResizing = true;
        this.startPoint = event.clientX;
        this.currentColumnType = columnType;
        if (columnType == "totalHeader") {
            this.startColumnWidth = this.object.totalsHeadersWidth;
            let tableWidth = this.object.label.alignment == StiLabelAlignment.Top || this.object.label.value.length == 0
                ? this.object.width - this.object.padding.left - this.object.padding.right
                : this.object.width - this.object.padding.left - this.object.padding.right - this.object.label.width;
            this.maxWidth = tableWidth - this.object.totalsValuesWidth;
            this.adjacentColumnWidth = this.maxWidth - this.object.totalsHeadersWidth;
        }
        else {
            this.startColumnWidth = this.object.totalsValuesWidth;
            this.maxWidth = this.object.totalsHeadersWidth + this.object.totalsValuesWidth;
            this.adjacentColumnWidth = this.object.totalsHeadersWidth;
        }
    }
    resize(event) {
        if (this.isResizing) {
            let delta = event.clientX - this.startPoint;
            if (this.startColumnWidth - delta >= this.minWidth && this.adjacentColumnWidth + delta >= this.minWidth) {
                if (this.currentColumnType == "totalHeader") {
                    this.object.totalsHeadersWidth = this.startColumnWidth - delta;
                }
                else {
                    this.object.totalsValuesWidth = this.startColumnWidth - delta;
                    this.object.totalsHeadersWidth = this.adjacentColumnWidth + delta;
                }
            }
            else {
                if (this.currentColumnType == "totalHeader") {
                    if (this.startColumnWidth - delta <= this.minWidth) {
                        this.object.totalsHeadersWidth = this.minWidth;
                    }
                    else if (this.adjacentColumnWidth + delta <= this.minWidth) {
                        this.object.totalsHeadersWidth = this.maxWidth - this.minWidth;
                    }
                }
                else {
                    if (this.startColumnWidth - delta <= this.minWidth) {
                        this.object.totalsValuesWidth = this.minWidth;
                        this.object.totalsHeadersWidth = this.maxWidth - this.minWidth;
                    }
                    else if (this.adjacentColumnWidth + delta <= this.minWidth) {
                        this.object.totalsValuesWidth = this.maxWidth - this.minWidth;
                        this.object.totalsHeadersWidth = this.minWidth;
                    }
                }
            }
        }
    }
    ngOnDestroy() {
        this.mouseUpSubscription?.unsubscribe();
        this.mouseMoveSubscription?.unsubscribe();
    }
    ngOnInit() {
        this.mouseUpSubscription = this.mouseService.getDocumentMouseUp().subscribe((event) => {
            this.isResizing = false;
        });
        this.mouseMoveSubscription = this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.resize(event);
        });
        /*  if (this.object.loadedFromJson) {
          this.object.totalsFields.forEach((totalField) => {
            totalField.calculationAlgorithm.expression = StiAlgorithmExpression.NumberColumnSum;
    
          });
        } */
    }
}
StiTableTotalsFieldComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableTotalsFieldComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }], target: i0.ɵɵFactoryTarget.Component });
StiTableTotalsFieldComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTableTotalsFieldComponent, selector: "sti-table-totals-field-component", inputs: { fields: "fields", object: "object", isClone: "isClone" }, ngImport: i0, template: ` <table>
    <tr *ngFor="let field of fields; index as i">
      <td
        class="field-header"
        [style.border-top]="
          i == 0 && selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-bottom]="
          selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-right]="
          selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-left]="
          selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.width.px]="object.totalsHeadersWidth"
        [style.justify-content]="getAlignment(field.headerAlignment)"
      >
        <div class="total-resizer" *ngIf="selected" (mousedown)="initResize($event, 'totalHeader')"></div>
        <sti-editable-content-component
          [editableContent]="field"
          [eParent]="object"
          [hideEmpty]="false"
          [active]="selected"
        ></sti-editable-content-component>
      </td>
      <td
        class="field-value"
        [style.border-top]="
          i == 0 && selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-bottom]="
          selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-right]="
          selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.width.px]="object.totalsValuesWidth"
        [style.justify-content]="getAlignment(field.valueAlignment)"
      >
        <div class="total-resizer" *ngIf="selected" (mousedown)="initResize($event, 'totalValue')"></div>
        <label
          [style]="object.font.htmlStyle()"
          [style.text-decoration]="'none'"
          [style.color]="field.headerColor.toHtmlColor()"
          (mousedown)="showPropertyInfo(field)"
          >{{ getValue(field) }}
        </label>
      </td>
    </tr>
  </table>`, isInline: true, styles: ["table{border-spacing:0;border-collapse:collapse;overflow:hidden}td{padding:3px 1px;display:flex;position:relative;white-space:nowrap;overflow:hidden}tr{display:flex}label{width:max-content}.total-resizer{height:100%;width:5px;position:absolute;left:0;top:0}.total-resizer:hover{cursor:ew-resize}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.StiEditableContentComponent, selector: "sti-editable-content-component", inputs: ["editableContent", "displayContent", "required", "eParent", "hideEmpty", "active", "alignment", "isTableTotalHeader", "disablePadding", "fromButton", "parentCursor", "isTableHeader"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableTotalsFieldComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-table-totals-field-component", template: ` <table>
    <tr *ngFor="let field of fields; index as i">
      <td
        class="field-header"
        [style.border-top]="
          i == 0 && selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-bottom]="
          selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-right]="
          selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-left]="
          selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.width.px]="object.totalsHeadersWidth"
        [style.justify-content]="getAlignment(field.headerAlignment)"
      >
        <div class="total-resizer" *ngIf="selected" (mousedown)="initResize($event, 'totalHeader')"></div>
        <sti-editable-content-component
          [editableContent]="field"
          [eParent]="object"
          [hideEmpty]="false"
          [active]="selected"
        ></sti-editable-content-component>
      </td>
      <td
        class="field-value"
        [style.border-top]="
          i == 0 && selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-bottom]="
          selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.border-right]="
          selected && !model.isPreviewMode ? '1px solid rgba(218,218,218,0.5)' : '1px solid transparent'
        "
        [style.width.px]="object.totalsValuesWidth"
        [style.justify-content]="getAlignment(field.valueAlignment)"
      >
        <div class="total-resizer" *ngIf="selected" (mousedown)="initResize($event, 'totalValue')"></div>
        <label
          [style]="object.font.htmlStyle()"
          [style.text-decoration]="'none'"
          [style.color]="field.headerColor.toHtmlColor()"
          (mousedown)="showPropertyInfo(field)"
          >{{ getValue(field) }}
        </label>
      </td>
    </tr>
  </table>`, styles: ["table{border-spacing:0;border-collapse:collapse;overflow:hidden}td{padding:3px 1px;display:flex;position:relative;white-space:nowrap;overflow:hidden}tr{display:flex}label{width:max-content}.total-resizer{height:100%;width:5px;position:absolute;left:0;top:0}.total-resizer:hover{cursor:ew-resize}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiMouseService }]; }, propDecorators: { fields: [{
                type: Input
            }], object: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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