import { Component, Input } from "@angular/core";
import { Enum } from "../../../system/Enum";
import { StiHorizontalAlignment } from "../../../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "@angular/forms";
export class StiTableInputTextComponent {
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    getColumnAlignment() {
        return Enum.getName(StiHorizontalAlignment, this.item.cellAlignment);
    }
    get cell() {
        return this.item.cells[this.index] ? this.item.cells[this.index] : null;
    }
    get tabIndex() {
        try {
            let columns = this.object.columns;
            return this.object["tabIndex"] + columns.indexOf(this.item) + columns.length * this.index;
        }
        catch { }
    }
    /* public set cell(value) {
      this.item.cells[this.index] = value;
    } */
    inFocus() { }
    lostFocus() { }
    disableDrag() {
        this.model.canDrag = false;
    }
    enableDrag() {
        this.model.canDrag = true;
    }
    ngOnInit() { }
}
StiTableInputTextComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableInputTextComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiTableInputTextComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTableInputTextComponent, selector: "sti-table-input-text-component", inputs: { item: "item", index: "index", object: "object", disabled: "disabled", isClone: "isClone" }, ngImport: i0, template: `<input
    type="text"
    spellcheck="false"
    [(ngModel)]="cell.text"
    [style]="object.font.htmlStyle()"
    [style.text-decoration]="'none'"
    [style.text-align]="getColumnAlignment()"
    [style.border-color]="item.cellBorderColor.toHtmlColor()"
    [style.color]="item.cellForeColor.toHtmlColor()"
    [style.background-color]="item.cellBackColor.toHtmlColor()"
    [disabled]="disabled"
    [tabIndex]="tabIndex"
    (mousedown)="disableDrag()"
    (mouseup)="enableDrag()"
    (focus)="inFocus()"
    (blur)="lostFocus()"
  />`, isInline: true, styles: ["input{height:-moz-fit-content;height:fit-content;padding:3px 4px;width:99%;border:1px solid rgb(198,198,198)}input:not([disabled]):hover{border-color:#a3bde3!important}input:focus{outline:none;border:1px solid rgb(163,189,227)}\n"], dependencies: [{ kind: "directive", type: i2.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i2.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i2.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableInputTextComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-table-input-text-component", template: `<input
    type="text"
    spellcheck="false"
    [(ngModel)]="cell.text"
    [style]="object.font.htmlStyle()"
    [style.text-decoration]="'none'"
    [style.text-align]="getColumnAlignment()"
    [style.border-color]="item.cellBorderColor.toHtmlColor()"
    [style.color]="item.cellForeColor.toHtmlColor()"
    [style.background-color]="item.cellBackColor.toHtmlColor()"
    [disabled]="disabled"
    [tabIndex]="tabIndex"
    (mousedown)="disableDrag()"
    (mouseup)="enableDrag()"
    (focus)="inFocus()"
    (blur)="lostFocus()"
  />`, styles: ["input{height:-moz-fit-content;height:fit-content;padding:3px 4px;width:99%;border:1px solid rgb(198,198,198)}input:not([disabled]):hover{border-color:#a3bde3!important}input:focus{outline:none;border:1px solid rgb(163,189,227)}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { item: [{
                type: Input
            }], index: [{
                type: Input
            }], object: [{
                type: Input
            }], disabled: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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