import { Component, EventEmitter, Input, Output } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "@angular/common";
export class StiTableRadioButtonComponent {
    constructor(model) {
        this.model = model;
        this.isClone = false;
        this.buttonClick = new EventEmitter();
    }
    get cell() {
        return this.item.cells[this.index];
    }
    changeState() {
        this.buttonClick.emit();
    }
    ngOnInit() { }
    get tabIndex() {
        try {
            let columns = this.object.columns;
            return this.object["tabIndex"] + columns.indexOf(this.item) + columns.length * this.index;
        }
        catch { }
    }
}
StiTableRadioButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableRadioButtonComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiTableRadioButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTableRadioButtonComponent, selector: "sti-table-radio-button-component", inputs: { item: "item", index: "index", disabled: "disabled", isClone: "isClone", object: "object", alignment: "alignment" }, outputs: { buttonClick: "buttonClick" }, ngImport: i0, template: `<div
    class="custom-radio"
    [style.justify-content]="alignment"
    (mousedown)="model.canDrag = false"
    (mouseup)="model.canDrag = true"
  >
    <input type="radio" (click)="changeState()" [disabled]="disabled" [tabIndex]="tabIndex" />
    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
      <circle
        class="box"
        cx="6"
        cy="6"
        r="5.5"
        [attr.fill]="item.cellBackColor.toHtmlColor()"
        [attr.stroke]="item.cellBorderColor.toHtmlColor()"
      />
      <circle
        *ngIf="cell?.isChecked"
        class="check"
        cx="6"
        cy="6"
        r="2.5"
        [attr.fill]="item.cellForeColor.toHtmlColor()"
      />
    </svg>
  </div>`, isInline: true, styles: ["input[type=radio]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=radio]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=radio]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}label,span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-radio{width:-moz-fit-content;width:fit-content;position:relative;align-items:center;display:flex;width:100%}.custom-radio input[type=radio]{position:absolute;width:100%;z-index:10;opacity:0}.other input[type=radio]{position:absolute;width:16px;z-index:10;opacity:0}\n"], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableRadioButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-table-radio-button-component", template: `<div
    class="custom-radio"
    [style.justify-content]="alignment"
    (mousedown)="model.canDrag = false"
    (mouseup)="model.canDrag = true"
  >
    <input type="radio" (click)="changeState()" [disabled]="disabled" [tabIndex]="tabIndex" />
    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
      <circle
        class="box"
        cx="6"
        cy="6"
        r="5.5"
        [attr.fill]="item.cellBackColor.toHtmlColor()"
        [attr.stroke]="item.cellBorderColor.toHtmlColor()"
      />
      <circle
        *ngIf="cell?.isChecked"
        class="check"
        cx="6"
        cy="6"
        r="2.5"
        [attr.fill]="item.cellForeColor.toHtmlColor()"
      />
    </svg>
  </div>`, styles: ["input[type=radio]:hover+svg .box{stroke:#a3bde3!important;fill:#f3f9ff!important}input[type=radio]:active+svg .box{stroke:#3c77dd!important;fill:#d9ecff!important}input[type=radio]:disabled+svg .box{stroke:#bcbcbc!important;fill:#e6e6e6!important}label,span{margin-left:5px}.box:hover:{stroke:#a3bde3!important}.custom-radio{width:-moz-fit-content;width:fit-content;position:relative;align-items:center;display:flex;width:100%}.custom-radio input[type=radio]{position:absolute;width:100%;z-index:10;opacity:0}.other input[type=radio]{position:absolute;width:16px;z-index:10;opacity:0}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { item: [{
                type: Input
            }], index: [{
                type: Input
            }], disabled: [{
                type: Input
            }], isClone: [{
                type: Input
            }], object: [{
                type: Input
            }], alignment: [{
                type: Input
            }], buttonClick: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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