import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
export class StiTableComboboxComponent {
    constructor(model) {
        this.model = model;
        this.isClone = false;
    }
    get cell() {
        return this.item.cells[this.index];
    }
    get selectedIndex() {
        return this.item?.comboBoxOptions[this.cell?.selectedIndex ? this.cell?.selectedIndex : 0];
    }
    set selectedIndex(value) {
        this.item.comboBoxOptions.forEach((option, index) => {
            if (option == value) {
                this.cell.selectedIndex = index;
            }
        });
    }
    get tabIndex() {
        try {
            let columns = this.object.columns;
            return this.object["tabIndex"] + columns.indexOf(this.item) + columns.length * this.index;
        }
        catch { }
    }
    ngOnInit() { }
}
StiTableComboboxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableComboboxComponent, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiTableComboboxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiTableComboboxComponent, selector: "sti-table-combobox-component", inputs: { item: "item", index: "index", object: "object", disabled: "disabled", isClone: "isClone" }, ngImport: i0, template: ` <select
    class="selection"
    name=""
    id=""
    [style]="object.font.htmlStyle()"
    [style.border-color]="item.cellBorderColor.toHtmlColor()"
    [style.text-decoration]="'none'"
    [style.color]="item.cellForeColor.toHtmlColor()"
    [style.background-color]="item.cellBackColor.toHtmlColor()"
    [(ngModel)]="selectedIndex"
    [tabIndex]="tabIndex"
    [disabled]="disabled"
  >
    <option
      *ngFor="let option of item?.comboBoxOptions"
      [style.background-color]="item.cellBackColor.toHtmlColor()"
      [style]="object.font.htmlStyle()"
    >
      {{ option }}
    </option>
  </select>`, isInline: true, styles: [".selection{width:99%;border:1px solid rgb(198,198,198);background:white;height:-moz-fit-content;height:fit-content;padding:3px 4px;-webkit-appearance:none;appearance:none;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA3NpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDA2IDc5LjE2NDc1MywgMjAyMS8wMi8xNS0xMTo1MjoxMyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDphNzFiNTVkYi0wMGZlLTVjNDctYmVkZS1jYTVhNjk0NjdkNjgiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6N0UxNDE5MzBBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6N0UxNDE5MkZBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIyLjMgKFdpbmRvd3MpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6YTcxYjU1ZGItMDBmZS01YzQ3LWJlZGUtY2E1YTY5NDY3ZDY4IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOmE3MWI1NWRiLTAwZmUtNWM0Ny1iZWRlLWNhNWE2OTQ2N2Q2OCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pg8NmFEAAABPSURBVHjaYmxsbGSgBDAxUAiGqQH1eNTXE2NAAw5D6qFyBA1oxGIITDNGnLPgcAEDmm0NSAYTNACbIVg14zMAmwsYSDUAr8bRpIwAAAEGAFUJDal4N9jVAAAAAElFTkSuQmCC);background-repeat:no-repeat;background-position:right 5px top 50%;background-size:14px auto}.selection:not([disabled]):hover{border-color:#a3bde3!important;background-color:#e2effc!important}.selection:focus{outline:none;border-color:#a3bde3!important;background-color:#fff!important}select:focus>option:checked{background-color:#f6f6f6!important}select option:hover{box-shadow:0 0 10px 100px orange inset}\n"], dependencies: [{ kind: "directive", type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgSelectOption, selector: "option", inputs: ["ngValue", "value"] }, { kind: "directive", type: i3.ɵNgSelectMultipleOption, selector: "option", inputs: ["ngValue", "value"] }, { kind: "directive", type: i3.SelectControlValueAccessor, selector: "select:not([multiple])[formControlName],select:not([multiple])[formControl],select:not([multiple])[ngModel]", inputs: ["compareWith"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTableComboboxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-table-combobox-component", template: ` <select
    class="selection"
    name=""
    id=""
    [style]="object.font.htmlStyle()"
    [style.border-color]="item.cellBorderColor.toHtmlColor()"
    [style.text-decoration]="'none'"
    [style.color]="item.cellForeColor.toHtmlColor()"
    [style.background-color]="item.cellBackColor.toHtmlColor()"
    [(ngModel)]="selectedIndex"
    [tabIndex]="tabIndex"
    [disabled]="disabled"
  >
    <option
      *ngFor="let option of item?.comboBoxOptions"
      [style.background-color]="item.cellBackColor.toHtmlColor()"
      [style]="object.font.htmlStyle()"
    >
      {{ option }}
    </option>
  </select>`, styles: [".selection{width:99%;border:1px solid rgb(198,198,198);background:white;height:-moz-fit-content;height:fit-content;padding:3px 4px;-webkit-appearance:none;appearance:none;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA3NpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDYuMC1jMDA2IDc5LjE2NDc1MywgMjAyMS8wMi8xNS0xMTo1MjoxMyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDphNzFiNTVkYi0wMGZlLTVjNDctYmVkZS1jYTVhNjk0NjdkNjgiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6N0UxNDE5MzBBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6N0UxNDE5MkZBNDBDMTFFQkE5MDBCNzU3NjhFQUY2QTQiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIDIyLjMgKFdpbmRvd3MpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6YTcxYjU1ZGItMDBmZS01YzQ3LWJlZGUtY2E1YTY5NDY3ZDY4IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOmE3MWI1NWRiLTAwZmUtNWM0Ny1iZWRlLWNhNWE2OTQ2N2Q2OCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pg8NmFEAAABPSURBVHjaYmxsbGSgBDAxUAiGqQH1eNTXE2NAAw5D6qFyBA1oxGIITDNGnLPgcAEDmm0NSAYTNACbIVg14zMAmwsYSDUAr8bRpIwAAAEGAFUJDal4N9jVAAAAAElFTkSuQmCC);background-repeat:no-repeat;background-position:right 5px top 50%;background-size:14px auto}.selection:not([disabled]):hover{border-color:#a3bde3!important;background-color:#e2effc!important}.selection:focus{outline:none;border-color:#a3bde3!important;background-color:#fff!important}select:focus>option:checked{background-color:#f6f6f6!important}select option:hover{box-shadow:0 0 10px 100px orange inset}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; }, propDecorators: { item: [{
                type: Input
            }], index: [{
                type: Input
            }], object: [{
                type: Input
            }], disabled: [{
                type: Input
            }], isClone: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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